;		              FINAL FANTASY X 4
;			   for AShell/83
;
; By Alex Highsmith
; TI-83 Version By Bill Nagel
;

#include "crash82.inc"  ;edited version for the 83

#DEFINE CALL_Z(ADDR)    call z,ADDR
#DEFINE CALL_(ADDR)     call ADDR
#DEFINE CALL_NZ(ADDR)   call nz,ADDR
#DEFINE CALL_C(ADDR)    call c,ADDR
#DEFINE CALL_NC(ADDR)   call nc,ADDR
#DEFINE JUMP_Z(ADDR)    jp z,ADDR
#DEFINE JUMP_(ADDR)     jp ADDR
#DEFINE JUMP_NZ(ADDR)   jp nz,ADDR
#DEFINE JUMP_C(ADDR)    jp c,ADDR
#DEFINE JUMP_NC(ADDR)   jp nc,ADDR

Save = TEXT_MEM2 	
LEFT = TEXT_MEM2+2 	;\
RIGHT = TEXT_MEM2+3	;| Checks walls to see if spaces
UP1 = TEXT_MEM2+4	;| exist or not
DOWN = TEXT_MEM2+5	;/
COUNTER =TEXT_MEM2+6
WHOATTACK = TEXT_MEM2+7
COUNTER2 = TEXT_MEM2+8

BKX = TEXT_MEM+5	;\   Coordinates for (drawit),
BKY = TEXT_MEM+6	;/   a simple sprite displayer
BKX1 = TEXT_MEM+7
BKY1 = TEXT_MEM+8
OKAY1 = TEXT_MEM+10
OKAY2 = TEXT_MEM+11
NUMBEROFENEMIES = TEXT_MEM+19
ENEMYKILLED = TEXT_MEM+20
ECOUNTER = TEXT_MEM+22
ENEMYCOUNTER = TEXT_MEM+24
ENEMYSPEED = TEXT_MEM+26
ENEMY1STR = TEXT_MEM+27
ENEMY2STR = TEXT_MEM+28
ENEMY1 = TEXT_MEM+29
ENEMY2 = TEXT_MEM+31
WHICHENEMY = TEXT_MEM+32
DISPENEMY = TEXT_MEM+33
STRENGTHPOINTER = TEXT_MEM+35
ENEMYKILLED2 = TEXT_MEM+37
HITBYWHO = TEXT_MEM+39
HIT = TEXT_MEM+41
ENEMY32 = TEXT_MEM+48
MAGIPAGE = TEXT_MEM+56
MAGICHK = TEXT_MEM+58 
DEFENDONI = TEXT_MEM+60
DEFENDOND = TEXT_MEM+61
ENEMYHP = TEXT_MEM+62
ENEMYHP2 = TEXT_MEM+64
LIFEPOINTER = TEXT_MEM+66
LEADERORNO = TEXT_MEM+68

XPCHECK = TEXT_MEM2+45
XPPOINTER = TEXT_MEM2+47
ENEMY1XP = TEXT_MEM2+49
ENEMY2XP = TEXT_MEM2+51
CHKDFD = TEXT_MEM2+53
WHOTOATTACK = TEXT_MEM2+55

ROOM = TEXT_MEM2+61	;<-- Tells what room you are in
DOTY = TEXT_MEM2+63	  
DOTX = TEXT_MEM2+64	  
HPDMAX = TEXT_MEM2+66
GOLD = TEXT_MEM2+68
MEDKITS = TEXT_MEM2+70
MAGIKITS = TEXT_MEM2+72
MPIMAX = TEXT_MEM2+74
MPDMAX = TEXT_MEM2+76
DEFENDD = TEXT_MEM2+78
DEFENDI = TEXT_MEM2+80
SCENARIO = TEXT_MEM2+82
DUNGEON = TEXT_MEM2+84
CHEST1 = TEXT_MEM2+85
CHEST2 = TEXT_MEM2+86
CHEST3 = TEXT_MEM2+87
CHEST4 = TEXT_MEM2+88
ISISLVL = TEXT_MEM2+89
DARQLVL = TEXT_MEM2+91
DARQMP = TEXT_MEM2+93
STRENGTHI = TEXT_MEM2+95
STRENGTHD = TEXT_MEM2+97
HPI = TEXT_MEM2+99
HPD = TEXT_MEM2+101
DARQXP = TEXT_MEM2+103
ISISXP = TEXT_MEM2+105
HPIMAX = TEXT_MEM2+107
ISISMP = TEXT_MEM2+109
;; in general, D=Darq and I=Isis

 nop
 jr      prog_start
 .dw     $0000
 .dw     Description
 .dw     $0000
 .dw     $0000
prog_start:

	CALL_(ERASESCREEN)	
	ld bc,$0724
	ld hl,TITLE1
	CALL_(drawit2)
	ld bc,$072C
	ld hl,TITLE2
	CALL_(drawit2)
	ld bc,$0734
	ld hl,TITLE3
	CALL_(drawit2)
      ld hl,14*256+1
	ld ($8252),hl
	ld hl,credits
     	ROM_CALL(D_ZM_STR)
	set 7,(iy+20)		
	ld hl,0
	ld (ISISXP),hl
	ld (DARQXP),hl
	ld (GOLD),hl
	ld (ENEMY1XP),hl
	ld (ENEMY2XP),hl
	jr STARTUP	
LOOPLOAD:
	call GET_KEY
	cp G_UP
	jr z,STARTUP
 	cp G_DOWN
	jr z,STARTDOWN
	cp G_2nd
	jr z,STARTGAME1
	jr LOOPLOAD
STARTUP:
	ld hl,$0604
	ld ($800C),hl
	ld hl,new
	set 3,(IY+05)
	ROM_CALL(D_ZT_STR)
	ld hl,$0605
	ld ($800C),hl
	ld hl,sload
	res 3,(IY+05)
	ROM_CALL(D_ZT_STR)
	xor a
	ld (DOTX),a
	jr LOOPLOAD
STARTDOWN:
	ld hl,$0604
 	ld ($800C),hl
	ld hl,new
	res 3,(IY+05)
	ROM_CALL(D_ZT_STR)
	ld hl,$0605
	ld ($800C),hl
	ld hl,sload
	set 3,(IY+05)
	ROM_CALL(D_ZT_STR)

	ld a,1
	ld (DOTX),a
	jr LOOPLOAD
STARTGAME1:
	ld a,(DOTX)
	cp 1
	JUMP_Z(LOADGAME)
;---------------
; start of game
;---------------
			
STARTGAME:
	ld a,4
	ld (DOTY),a
	ld (DOTX),a
	ld a,3	
	ld (MEDKITS),a
	ld (MAGIKITS),a
	ld (DEFENDD),a
	ld (DEFENDI),a
	ld a,8
	ld (STRENGTHI),a	
	ld a,12
	ld (STRENGTHD),a
	ld a,30
	ld (HPIMAX),a
	ld (HPI),a
	ld a,40
	ld (HPDMAX),a
	ld (HPD),a
	ld a,1
	ld (ROOM),a
	ld (DARQLVL),a
	ld (ISISLVL),a
	ld a,25
	ld (DARQMP),a
	ld (ISISMP),a
	ld (MPIMAX),a
	ld (MPDMAX),a

	xor a
	ld (SCENARIO),a
	ld (DUNGEON),a
	ld (COUNTER),a
	ld (CHEST1),a	
	ld (CHEST2),a	
	ld (CHEST3),a	
	ld (CHEST4),a	
	
	CALL_(DRAWWALLS)
	CALL_(BORDERUP)
	CALL_(BORDERDOWN)
	CALL_(BORDERRIGHT)
	CALL_(BORDERLEFT)
	CALL_(BUILDINGDRAWS)
	ld hl,RT
	ld (Save),hl
	CALL_(moveit)
	JUMP_(GAMELOOP)	
SWITCHROOM:
	CALL_(DRAWWALLS)
	xor a
	ld (UP1),a
	ld (RIGHT),a
	ld (DOWN),a
	ld (LEFT),a
	ld a,(DUNGEON)
	or a
	JUMP_NZ(DUNGEONSWITCH)
	ld a,(ROOM)
	cp 1
	JUMP_Z(LOOM1)
	cp 2
	JUMP_Z(LOOM2)
	cp 3
	JUMP_Z(LOOMto1)
	cp 4
	JUMP_Z(LOOMto1)
	cp 5
	JUMP_Z(LOOMto1)
	cp 6
	JUMP_Z(LOOM6)
	cp 7
	JUMP_Z(LOOM7)
	cp 8
	JUMP_Z(LOOM8)
	cp 9
	JUMP_Z(LOOM9)
	cp 10
	JUMP_Z(LOOM10)
	cp 11
	JUMP_Z(LOOM11)
	cp 12
	JUMP_Z(LOOM12)
	cp 13
	JUMP_Z(LOOM13)
	cp 14
	JUMP_Z(LOOMto11)
	cp 15
	JUMP_Z(LOOMto11)
	cp 25
	JUMP_Z(LOOM25)
	cp 26
	JUMP_Z(LOOMto25)
	cp 27
	JUMP_Z(LOOMto25)
	cp 28
	JUMP_Z(LOOM28)
	cp 29
	JUMP_Z(LOOM29)
	cp 30
	JUMP_Z(LOOM30)
	cp 31
	JUMP_Z(LOOM31)
	cp 32
	JUMP_Z(LOOMto25)
	cp 33
	JUMP_Z(loom30rt)
	cp 40
	JUMP_Z(LOOM40)
	cp 41
	JUMP_Z(LOOM41)
	cp 42
	JUMP_Z(LOOM42)
	cp 43
	JUMP_Z(LOOM43)
	cp 44
	JUMP_Z(loom42lt)
DUNGEONSWITCH:
	ld a,(ROOM)	
	cp 100
	JUMP_Z(LOOM100)
	cp 101
	JUMP_Z(LOOM101)
	cp 102
	JUMP_Z(LOOM102)
	cp 103
	JUMP_Z(LOOM103)
	cp 104
	JUMP_Z(loom102rt)
	cp 105
	JUMP_Z(LOOM105)
	cp 106
	JUMP_Z(LOOM106)
	cp 107
	JUMP_Z(LOOM107)
	cp 108
	JUMP_Z(loom106dn)
	cp 109
	JUMP_Z(LOOM109)
	cp 110
	JUMP_Z(loom106rt)
	cp 111
	JUMP_Z(LOOM111)
	cp 112
	JUMP_Z(loom106up)
	cp 113
	JUMP_Z(LOOM113)
	cp 114
	JUMP_Z(loom106lt)
	cp 115
	JUMP_Z(LOOM115)
	cp 116
	JUMP_Z(LOOM116)
	cp 117
	JUMP_Z(LOOM117)
	cp 118
	JUMP_Z(LOOM118)
	cp 119
	JUMP_Z(LOOM119)
	cp 120
	JUMP_Z(loom118lt)	
	cp 121
	JUMP_Z(loom125lt)
	cp 122
	JUMP_Z(LOOM122)
	cp 123
	JUMP_Z(loom125lt)
	cp 124
	JUMP_Z(LOOM124)
	cp 125
	JUMP_Z(LOOM125)
	cp 126
	JUMP_Z(loom124up)
	cp 128
	JUMP_Z(LOOMto129)
	cp 129
	JUMP_Z(LOOM129)
	cp 130
	JUMP_Z(LOOMto129)
	cp 131
	JUMP_Z(LOOM131)
	cp 132
	JUMP_Z(LOOMto131)
	cp 133
	JUMP_Z(LOOMto131)
	cp 136
	JUMP_Z(LOOMto138)
	cp 137
	JUMP_Z(LOOMto138)
	cp 138
	JUMP_Z(LOOM138)
	cp 139
	JUMP_Z(LOOMto138)
	cp 140
	JUMP_Z(LOOMto144)
	cp 141
	JUMP_Z(LOOMto144)
	cp 142
	JUMP_Z(LOOMto144)
	cp 143
	JUMP_Z(LOOMto144)
	cp 144
	JUMP_Z(LOOM144)
	cp 145
	JUMP_Z(LOOMto149)
	cp 146
	JUMP_Z(LOOMto149)
	cp 147
	JUMP_Z(LOOMto149)
	cp 148
	JUMP_Z(LOOMto149)
	cp 149
	JUMP_Z(LOOM149)
	cp 150
	JUMP_Z(LOOMto154)
	cp 151
	JUMP_Z(LOOMto154)
	cp 152
	JUMP_Z(LOOMto154)
	cp 153
	JUMP_Z(LOOMto154)
	cp 154
	JUMP_Z(LOOM154)
	cp 155
	JUMP_Z(LOOM155)
	cp 156
	JUMP_Z(LOOM156)
	cp 160
	JUMP_Z(LOOM160)
	cp 161
	JUMP_Z(LOOM161)
	cp 162
	JUMP_Z(LOOM162)
	cp 163
	JUMP_Z(LOOM163)
	cp 164
	JUMP_Z(LOOM164)
	cp 165
	JUMP_Z(LOOM165)
RELOADROOM:
	CALL_(BUILDINGDRAWS)
	ld a,(DUNGEON)
	or a
	JUMP_NZ(RELOADDUNGEON)
	ld a,(ROOM)
	cp 1	
	JUMP_Z(ROOM1)
	cp 2	
	JUMP_Z(ROOM2)
	cp 3	
	JUMP_Z(ROOM3)
	cp 4	
	JUMP_Z(ROOM4)
	cp 5	
	JUMP_Z(ROOM5)
	cp 6	
	JUMP_Z(ROOM6)
	cp 7	
	JUMP_Z(ROOM7)
	cp 8	
	JUMP_Z(ROOM8)
	cp 9	
	JUMP_Z(ROOM9)
	cp 10	
	JUMP_Z(ROOM4)
	cp 11	
	JUMP_Z(ROOM1)
	cp 12	
	JUMP_Z(ROOM12)
	cp 13	
	JUMP_Z(ROOM7)
	cp 14	
	JUMP_Z(ROOM7)
	cp 15	
	JUMP_Z(ROOM5)
	cp 25	
	JUMP_Z(ROOM1)
	cp 26	
	JUMP_Z(ROOM7)
	cp 27
	JUMP_Z(ROOM5)
	cp 28	
	JUMP_Z(ROOM119)
	cp 29	
	JUMP_Z(ROOM103)
	cp 30	
	JUMP_Z(ROOM119)
	cp 31	
	JUMP_Z(ROOM103)
	cp 32	
	JUMP_Z(ROOM3)
	cp 33	
	JUMP_Z(ROOM4)
	cp 40	
	JUMP_Z(ROOM4)
	cp 41	
	JUMP_Z(ROOM103)
	cp 42	
	JUMP_Z(ROOM8)
	cp 43	
	JUMP_Z(ROOM8)
	cp 44	
	JUMP_Z(ROOM5)
RELOADDUNGEON:
	ld a,(ROOM)
	cp 100	
	JUMP_Z(ROOM2)
	cp 101	
	JUMP_Z(ROOM2)
	cp 102	
	JUMP_Z(ROOM102)
	cp 103	
	JUMP_Z(ROOM103)
	cp 104	
	JUMP_Z(ROOM4)
	cp 105	
	JUMP_Z(ROOM5)
	cp 106	
	JUMP_Z(ROOM1)
	cp 107	
	JUMP_Z(ROOM2)
	cp 108	
	JUMP_Z(ROOM4)
	cp 109	
	JUMP_Z(ROOM8)
	cp 110	
	JUMP_Z(ROOM3)
	cp 111	
	JUMP_Z(ROOM2)
	cp 112	
	JUMP_Z(ROOM7)
	cp 113	
	JUMP_Z(ROOM8)
	cp 114	
	JUMP_Z(ROOM5)
	cp 115	
	JUMP_Z(ROOM3)
	cp 116	
	JUMP_Z(ROOM119)
	cp 117	
	JUMP_Z(ROOM2)
	cp 118	
	JUMP_Z(ROOM103)
	cp 119	
	JUMP_Z(ROOM119)
	cp 120	
	JUMP_Z(ROOM7)
	cp 121	
	JUMP_Z(ROOM4)
	cp 122	
	JUMP_Z(ROOM102)
	cp 123	
	JUMP_Z(ROOM5)
	cp 124	
	JUMP_Z(ROOM2)
	cp 125	
	JUMP_Z(ROOM102)
	cp 126	
	JUMP_Z(ROOM3)
	cp 128	
	JUMP_Z(ROOM3)
	cp 129	
	JUMP_Z(ROOM129)
	cp 130	
	JUMP_Z(ROOM4)
	cp 131	
	JUMP_Z(ROOM129)
	cp 132	
	JUMP_Z(ROOM4)
	cp 133	
	JUMP_Z(ROOM3)
	cp 136	
	JUMP_Z(ROOM7)
	cp 137	
	JUMP_Z(ROOM5)
	cp 138	
	JUMP_Z(ROOM1)
	cp 139	
	JUMP_Z(ROOM3)
	cp 140	
	JUMP_Z(ROOM7)
	cp 141	
	JUMP_Z(ROOM3)
	cp 142	
	JUMP_Z(ROOM4)
	cp 143	
	JUMP_Z(ROOM5)
	cp 144	
	JUMP_Z(ROOM1)
	cp 145	
	JUMP_Z(ROOM7)
	cp 146	
	JUMP_Z(ROOM3)
	cp 147	
	JUMP_Z(ROOM4)
	cp 148	
	JUMP_Z(ROOM5)
	cp 149	
	JUMP_Z(ROOM1)
	cp 150	
	JUMP_Z(ROOM7)
	cp 151	
	JUMP_Z(ROOM3)
	cp 152	
	JUMP_Z(ROOM4)
	cp 153	
	JUMP_Z(ROOM5)
	cp 154	
	JUMP_Z(ROOM1)
	cp 155	
	JUMP_Z(ROOM5)
	cp 156	
	JUMP_Z(ROOM3)
	cp 160	
	JUMP_Z(ROOM2)
	cp 161	
	JUMP_Z(ROOM2)
	cp 162	
	JUMP_Z(ROOM2)
	cp 163	
	JUMP_Z(ROOM2)
	cp 164	
	JUMP_Z(ROOM2)
	cp 165	
	JUMP_Z(ROOM129)
GAMELOOP2:
	ld a,(COUNTER)
	inc a
	cp 20
	JUMP_Z(STARTBATTLE)
	ld (COUNTER),a
GAMELOOP:	
	call GET_KEY
	cp G_CLEAR
	JUMP_Z(EXIT)
	cp G_MODE
	JUMP_Z(BUILDINGCHK)
	cp G_2nd
	JUMP_Z(STATUSSCREEN)
	cp G_UP
	jr z,MOVEUP
 	cp G_DOWN
	JUMP_Z(MOVEDOWN)
        	cp G_LEFT
	JUMP_Z(MOVELEFT)
        	cp G_RIGHT
	JUMP_Z(MOVERIGHT)
	jr GAMELOOP
MOVEUP:
	ld a,(DOTY)		
	cp 4
	jr z,CHKVT
	ld HL,(Save)
	CALL_(moveit)
	LD HL,UP
	ld a,(DOTY)		
	sub 8
	ld (DOTY),a
	CALL_(moveit)
	jr GAMELOOP2
CHKVT:
	ld a,(UP1)
	or a
	jr z,GAMELOOP
	ld a,(DOTX)
	cp 44
	JUMP_Z(SWITCHROOM)
	jr GAMELOOP	
CHKVT2:
	ld a,(DOWN)
	or a
	JUMP_Z(GAMELOOP)
	ld a,(DOTX)
	cp 44
	JUMP_Z(SWITCHROOM)
	jr GAMELOOP	
CHKHZ:
	ld a,(RIGHT)
	or a
	JUMP_Z(GAMELOOP)
	ld a,(DOTY)
	cp 28
	JUMP_Z(SWITCHROOM)
	JUMP_(GAMELOOP)	
CHKHZ2:
	ld a,(LEFT)
	or a
	JUMP_Z(GAMELOOP)
	ld a,(DOTY)
	cp 28
	JUMP_Z(SWITCHROOM)
	JUMP_(GAMELOOP)
MOVEDOWN:
	ld a,(DOTY)		
	cp 52
	jr z,CHKVT2
	ld HL,(Save)
	CALL_(moveit)
	LD HL,DN
	ld a,(DOTY)		
	add a,8
	ld (DOTY),a
	CALL_(moveit)
	JUMP_(GAMELOOP2)
MOVELEFT:
	ld a,(DOTX)		
	cp 4
	jr z,CHKHZ2
	ld HL,(Save)
	CALL_(moveit)
	LD HL,LT
	ld a,(DOTX)		
	sub 8
	ld (DOTX),a
	CALL_(moveit)
	JUMP_(GAMELOOP2)
MOVERIGHT:
	ld a,(DOTX)		
	cp 84
	JUMP_Z(CHKHZ)
	ld HL,(Save)
	CALL_(moveit)
	LD HL,RT
	ld a,(DOTX)		
	add a,8
	ld (DOTX),a
	CALL_(moveit)
	JUMP_(GAMELOOP2)
ERASESCREEN:
	push hl
	ld hl,GRAPH_MEM
	ld de,GRAPH_MEM+1
	ld bc,$2FF
	xor a
 	ld (hl),a	
	ldir                     ; Simple - fill the GRAPH_MEM with one value
       	call CR_GRBCopy	
	pop hl
	RET


;-----------------------------------
;BATTLE!!!!!!!
;-----------------------------------

STARTBATTLE:
	xor a	
	res 3,(IY+05)
	ld b,3
SCRAMBLE:
	push bc
	CALL_(ERASESCREEN)
	CALL_(DELAY3)
	ld hl,$AFAF			;load battle screen
	CALL_(BG)
	CALL_(DELAY3)
	pop bc
	djnz SCRAMBLE

BATTLE:

RANDOMENEMY:
  ld a,r
  srl a
  and 3          ; between 0-3
  jr z,RANDOMENEMY
  cp 3
  jr z,RANDOMENEMY
  ld (NUMBEROFENEMIES),a

	ld hl,0	
	ld (ENEMYHP),hl
	ld (ENEMYHP2),hl
	xor a
	ld (LEADERORNO),a
	ld (DEFENDONI),a
	ld (DEFENDOND),a
	ld (ENEMY2XP),a
	ld (MAGICHK),a
	ld (WHOATTACK),a
	ld (WHOTOATTACK),a
	ld (OKAY1),a
	ld (OKAY2),a
	ld (ENEMYCOUNTER),a
	ld (ENEMY32),a	
	ld a,1
	ld (HITBYWHO),a
	ld a,21
	ld (COUNTER),a
	ld a,41
	ld (COUNTER2),a
	ld a,13
	ld (ECOUNTER),a
	ld hl,BATTLEPIC			;load battle screen
	CALL_(BG)

	ld a,(HPI)
	or a
	jr z,ISISDEADSTART
	ld a,(HPD)
	or a
	CALL_Z(ERASEDARQ)
	jr NOBODYDEAD
ISISDEADSTART:
	CALL_(ERASEISIS)
	ld bc,$1C55	
	ld hl,CURSOR	
	CALL_(drawit2)
	ld a,1
	ld (WHOATTACK),a
	jr SOMEBDYWASDED
NOBODYDEAD:
	ld bc,$0655	
	ld hl,CURSOR	
	CALL_(drawit2)
SOMEBDYWASDED:
	ld a,(CHKDFD)
	cp 99
	JUMP_Z(LEADERS)
	CALL_(PUTENEMY)	
RETFROMLEADER:
	LD DE,$381A		;\
	ld a,(HPI)		; \
	CALL_(DISPHL)		;/
	LD DE,$382E		;\
	ld a,(HPD)		; \
	CALL_(DISPHL)		;/
	ld bc,$2E01	
	ld hl,ICONRING	
	CALL_(drawit2)
SPEEDLOOP:
 	ld a,$3E
 	out (1),a
 	in a,(1)
	bit 5,a
 	JUMP_Z(IPRESS)
 	bit 7,a
 	JUMP_Z(SWITCH)
	bit 3,a
 	JUMP_Z(IUP)
 	bit 0,a
 	JUMP_Z(IDOWN)
        	bit 1,a
        	JUMP_Z(ILEFT)
        	bit 2,a
        	JUMP_Z(IRIGHT)
	ld a,(OKAY1)
	cp 1
	jr nz,ISISCOUNTER
	ld a,(OKAY2)
	cp 1
	jr nz,DARQCOUNTER
	jr SPEEDLOOP
ISISCOUNTER:
	ld a,(COUNTER)
	ld b,a
	ld c,10
	CALL_(PutPixel)
	ld a,(COUNTER)
	ld b,a
	ld c,9
	CALL_(PutPixel)	
	ld a,(ENEMYSPEED)
	ld c,a
	ld a,(ENEMYCOUNTER)
	inc a
	ld (ENEMYCOUNTER),a
	cp c
	JUMP_Z(ENEMYATTACK)
RETURNATTK:	
	ld a,(COUNTER)
	inc a
	ld (COUNTER),a
	cp 35
	jr z,OK1	
	ld a,(OKAY2)	
	cp 1
	jr z,SPEEDLOOP
DARQCOUNTER:
	ld a,(ENEMYSPEED)
	ld c,a
	ld a,(ENEMYCOUNTER)
	inc a
	ld (ENEMYCOUNTER),a
	cp c
	JUMP_Z(ENEMYATTACK)
	ld a,(COUNTER2)
	ld b,a
	ld c,10
	CALL_(PutPixel)
	ld a,(COUNTER2)
	ld b,a
	ld c,9
	CALL_(PutPixel)
	ld a,(COUNTER2)
	inc a
	ld (COUNTER2),a	
	cp 56
	jr z,OK2 
	JUMP_(SPEEDLOOP)
OK1:	
	ld a,1
	ld (OKAY1),a
	JUMP_(SPEEDLOOP)
OK2:
	ld a,1
	ld (OKAY2),a
	JUMP_(SPEEDLOOP)
IDOWN:
	ld hl,ICONRING
	CALL_(drawit)
	ld a,55
	ld (BKY),a
	ld hl,ICONRING
	CALL_(drawit)
	JUMP_(SPEEDLOOP)
ILEFT:
	ld hl,ICONRING
	CALL_(drawit)
	ld a,1		
	ld (BKX),a
	ld hl,ICONRING
	CALL_(drawit)
	JUMP_(SPEEDLOOP)
IRIGHT:
	ld hl,ICONRING
	CALL_(drawit)
	ld a,10	
	ld (BKX),a
	ld hl,ICONRING
	CALL_(drawit)
	JUMP_(SPEEDLOOP)
IUP:
	ld hl,ICONRING
	CALL_(drawit)
	ld a,46	
	ld (BKY),a
	ld hl,ICONRING
	CALL_(drawit)
	JUMP_(SPEEDLOOP)
IPRESS:
	ld a,(WHOATTACK)	
	cp 1
	jr z,DARQ
ISIS:
	ld a,(OKAY1)
	or a
	jr z,NOTOK
	jr REUPORDOWN
DARQ:
	ld a,(OKAY2)
	or a
	JUMP_Z(NOTOK)
	jr REUPORDOWN
NOTOK:
	ld de, $0103                    
             ld hl,NOTTURN
             call DISPSTRING     
	CALL_(DELAY)
	CALL_(ERASETEXT)
	JUMP_(SPEEDLOOP)
REUPORDOWN:
	ld a,(BKX)
	cp 1
	jr z,UPORDOWN
	cp 10
	jr z,UPORDOWNRT
UPORDOWN:
	ld a,(BKY)
	cp 46
	JUMP_Z(FIGHT)
	cp 55
	JUMP_Z(ITEM)
UPORDOWNRT:
	ld a,(BKY)
	cp 46
	JUMP_Z(MAGIC)
	cp 55
	JUMP_Z(DEFEND)
SWITCH:
	ld a,(HPD)	
	or a
	JUMP_Z(SPEEDLOOP)
	ld a,(HPI)	
	or a
	JUMP_Z(SPEEDLOOP)
	CALL_(REVERSAL)
	ld a,(WHOATTACK)
	or a
	jr z,DARQSWITCH
	ld bc,$1C55	
	ld hl,CURSOR	
	CALL_(drawit2)
	ld bc,$0655	
	xor a
	ld (WHOATTACK),a
	jr SWITCHEND
DARQSWITCH:
	ld bc,$0655	
	ld hl,CURSOR	
	CALL_(drawit2)
	ld bc,$1C55	
	ld a,1
	ld (WHOATTACK),a
SWITCHEND:
	ld hl,CURSOR	
	CALL_(drawit2) 
	CALL_(ENDREVERSAL)
	CALL_(DELAY)
	JUMP_(SPEEDLOOP)
FIGHT:
	ld a,(NUMBEROFENEMIES)
	cp 1
	JUMP_Z(WHOISDEAD)
	jr NOONEIS	
WHOISDEAD:
	ld hl,(ENEMYHP2)
	ld de, 0
	and a
	sbc hl,de
	jr z,ENEMY2DEAD
ENEMY1DEAD:	
	ld a,2
	ld (WHOTOATTACK),a
	JUMP_(ACTUALATTACK)	
ENEMY2DEAD:
	ld a,1
	ld (WHOTOATTACK),a
	JUMP_(ACTUALATTACK)
NOONEIS:
	CALL_(REVERSAL)	
	ld bc,$0D04	
	ld hl,CURSOR2	
	CALL_(drawit2)
	ld a,1
	ld (WHOTOATTACK),a
	CALL_(DELAY)
CURSLOOP:	
	ld a,$3E
 	out (1),a
 	in a,(1)
 	bit 5,a
 	JUMP_Z(CURSPRESS)
	bit 3,a
 	JUMP_Z(CURSUP)
 	bit 0,a
 	JUMP_Z(CURSDOWN)
	bit 1,a
        	JUMP_Z(CURSUP)
	bit 2,a
        	JUMP_Z(CURSDOWN)
	jr CURSLOOP
CURSUP:
	ld hl,CURSOR2	
	CALL_(drawit)
	ld bc,$0D04	
	ld hl,CURSOR2	
	CALL_(drawit2)
	CALL_(DELAY)
	ld a,1
	ld (WHOTOATTACK),a
	jr CURSLOOP
CURSDOWN:
	ld hl,CURSOR2	
	CALL_(drawit)
	ld bc,$1A0D	
	ld hl,CURSOR2	
	CALL_(drawit2)
	CALL_(DELAY)
	ld a,2
	ld (WHOTOATTACK),a
	jr CURSLOOP
CURSPRESS:
	ld hl,CURSOR2	
	CALL_(drawit)
	CALL_(ENDREVERSAL)
ACTUALATTACK:
	ld a,(WHOATTACK)
	or a
	JUMP_Z(ISISATTACKS)
DARQATTACKS:
	;; here are Darq's attacks
	CALL_(DRAWDATTACK)	
	CALL_(REVERSAL)
DARQRLOOP:
	ld a,r
  	srl a
  	and 3          ; between 1-2
	jr z,DARQRLOOP
  	sub 1
  	jr z,DARQRLOOP
	cp 1  	
	JUMP_Z(ATTACK1FORDARQ)
ATTACK2FORDARQ:
	ld a,54	
	ld (CHKDFD),a
REPEATDATTACK2:
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,32
	ld (BKY),a
	ld hl,ATTACKDNUMBER3	
	CALL_(drawit)
	ld a,(CHKDFD)
	add a,3
	ld (BKX),a
	ld a,27
	ld (BKY),a
	ld hl,ATTACKDNUMBER3	
	CALL_(drawit)
	ld a,(CHKDFD)
	sub 5
	ld (BKX),a
	ld a,28
	ld (BKY),a
	ld hl,ATTACKDNUMBER3	
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,32
	ld (BKY),a
	ld hl,ATTACKDNUMBER3	
	CALL_(drawit)
	ld a,(CHKDFD)
	add a,3
	ld (BKX),a
	ld a,27
	ld (BKY),a
	ld hl,ATTACKDNUMBER3	
	CALL_(drawit)
	ld a,(CHKDFD)
	sub 5
	ld (BKX),a
	ld a,28
	ld (BKY),a
	ld hl,ATTACKDNUMBER3	
	CALL_(drawit)
	ld a,(CHKDFD)
	sub 4
	ld (CHKDFD),a
	cp 30
	JUMP_NZ(REPEATDATTACK2)
	CALL_(ENDREVERSAL)
	CALL_(DRAWDATTACK)
	ld a,(STRENGTHD)
	ld c,a
	JUMP_(DARQGOHERE)
ATTACK1FORDARQ:
	ld a,57
	ld (CHKDFD),a
REPEATDARQATTACK:
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,27
	ld (BKY),a
	ld hl,ATTACKDNUMBER1	
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,27
	ld (BKY),a
	ld hl,ATTACKDNUMBER1	
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,27
	ld (BKY),a
	ld hl,ATTACKDNUMBER2	
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,27
	ld (BKY),a
	ld hl,ATTACKDNUMBER2	
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)
	dec a
	dec a
	dec a
	ld (CHKDFD),a
	cp 42
	jr nz, REPEATDARQATTACK
	CALL_(ENDREVERSAL)
	CALL_(DRAWDATTACK)
	ld a,(STRENGTHD)
	ld c,a
	JUMP_(DARQGOHERE)
ISISATTACKS:
	ld a,r
  	srl a
  	and 3          ; between 1-2
	jr z,ISISATTACKS
  	sub 1
  	jr z,ISISATTACKS
	cp 1  	
	JUMP_Z(ATTACK1FORISIS)
ATTACK2FORISIS:
	CALL_(REVERSAL)
	CALL_(DRAWIATTACK2)
REPEATATTACK2:
	ld (CHKDFD),a
	ld bc,$053B	
	ld hl,ATTACKINUMBER3	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$053B	
	ld hl,ATTACKINUMBER3	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$053B	
	ld hl,ATTACKINUMBER4	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$053B	
	ld hl,ATTACKINUMBER4	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$053B	
	ld hl,ATTACKINUMBER5	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$053B	
	ld hl,ATTACKINUMBER5	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$053B	
	ld hl,ATTACKINUMBER6	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$053B	
	ld hl,ATTACKINUMBER6	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld a,(CHKDFD)
	inc a
	cp 2
	JUMP_NZ(REPEATATTACK2)
	CALL_(ENDREVERSAL)
	CALL_(DRAWIATTACK2)
	JUMP_(ISISDONE)
ATTACK1FORISIS:
	CALL_(DRAWIATTACK)
	CALL_(REVERSAL)
	ld b,4
REPEATISISATTACK:
	push bc
	ld bc,$132D	
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)
	ld bc,$0A28
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)	
	ld bc,$0420	
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)
	ld bc,$0117	
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)
	ld bc,$040E
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)
	ld bc,$0A06
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)
	ld bc,$1301
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)
	ld bc,$1C06
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)
	ld bc,$230E
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)
	ld bc,$2617
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)
	ld bc,$2320
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)
	ld bc,$1C28
	ld hl,ATTACKINUMBER1
	CALL_(drawit2)
	pop bc	
	djnz REPEATISISATTK2
	CALL_(ENDREVERSAL)
	CALL_(DRAWIATTACK)
	jr ISISDONE
REPEATISISATTK2:
	JUMP_(REPEATISISATTACK)
ISISDONE:
	ld a,(STRENGTHI)
	ld c,a
DARQGOHERE:	
	CALL_(RAND2)	
	CALL_(DISPDAMAGE)
	ld a,(WHOTOATTACK)
	cp 1
	jr z,ATTACKENEMY1
ATTACKENEMY2:
	ld a,(CHKDFD)
	ld c,a
	ld b,0
	ld hl,(ENEMYHP2)
	and a
	sbc hl,bc
	ld (ENEMYHP2),hl
	JUMP_Z(ENEMYDEAD2)
	JUMP_C(ENEMYDEAD2)
	JUMP_(ACTIONEND)
ATTACKENEMY1:	
	ld a,(CHKDFD)
	ld c,a
	ld b,0
	ld hl,(ENEMYHP)
	and a
	sbc hl,bc	
	ld (ENEMYHP),hl
	JUMP_Z(ENEMYDEAD1)
	JUMP_C(ENEMYDEAD1)
	JUMP_(ACTIONEND)
ENEMYDEAD2:
	ld hl,0
	ld (ENEMYHP2),hl
	jr ENEMYDEAD
ENEMYDEAD1:
	ld a,(LEADERORNO)
	or a
	JUMP_NZ(ERASELEADER)
	ld hl,0
	ld (ENEMYHP),hl
ENEMYDEAD:
	ld a,(ENEMY32)	
	or a
	JUMP_NZ(BIGERASE)
	CALL_(ERASEENEMY)		
BIGERASEDONE:
	ld a,(NUMBEROFENEMIES)
	dec a	
	ld (NUMBEROFENEMIES),a
	or a
	jr z,ALLENEMYDEAD
	JUMP_(ACTIONEND)
ALLENEMYDEAD:
	CALL_(ERASEOF)
	ld de,$0103
   	ld hl,YOUWIN
        	call DISPSTRING
	;; Display XP earned and add it up
	ld de,(ENEMY1XP)
	ld hl,(ENEMY2XP)
	add hl,de
	ld (CHKDFD),hl
RANDGOLD:
	ld a,r
  	srl a
  	and 7          ; between 1-9
	ld c,a
	ld b,0
	ld hl,(CHKDFD)
	and a
	sbc hl,bc
	ld (WHOTOATTACK),hl

	ld hl,(GOLD)
	ld de,(WHOTOATTACK)
	add hl,de
	ld (GOLD),hl
	
	ld a,(HPI)
	or a
	jr z,DARQXPADD
	
	ld de,(CHKDFD)
	ld hl,(ISISXP)
	add hl,de
	ld (ISISXP),hl
DARQXPADD:
	ld a,(HPD)
	or a
	jr z,ENDOFADD
	ld de,(CHKDFD)
	ld hl,(DARQXP)
	add hl,de
	ld (DARQXP),hl
ENDOFADD:
	ld bc,$0A1E
	ld hl,BLANK	
	CALL_(drawit2)
	ld bc,$0A26
	ld hl,BLANK	
	CALL_(drawit2)
	ld bc,$0A2E
	ld hl,BLANK	
	CALL_(drawit2)
	ld bc,$0A36
	ld hl,BLANK	
	CALL_(drawit2)
	ld bc,$0C18
	ld hl,BLANK2	
	CALL_(drawit2)
	ld bc,$1418
	ld hl,BLANK2	
	CALL_(drawit2)
	ld bc,$1C18
	ld hl,BLANK2
	CALL_(drawit2)
	ld bc,$0C36
	ld hl,BLANK2	
	CALL_(drawit2)
	ld bc,$1436
	ld hl,BLANK2	
	CALL_(drawit2)
	ld bc,$1C36
	ld hl,BLANK2
	CALL_(drawit2)
	ld bc,$241E
	ld hl,BLANK	
	CALL_(drawit2)
	ld bc,$2426
	ld hl,BLANK	
	CALL_(drawit2)
	ld bc,$242E
	ld hl,BLANK	
	CALL_(drawit2)
	ld bc,$2436
	ld hl,BLANK	
	CALL_(drawit2)
	ld de,$0C27                   
            	ld hl,GAIN
            	call DISPSTRING
	ld de,$1523                   
            	ld hl,EXP
            	call DISPSTRING
	ld de,$1C25                   
            	ld hl,GOLDSTR
            	call DISPSTRING
	LD DE,$152E	
	ld a,(CHKDFD)	
	CALL_(DISPHL)	
	LD DE,$1C2E	
	ld a,(WHOTOATTACK)
	CALL_(DISPHL)	
	call WaitKey
	CALL_(LEVELUPORNOT)
ENDBATTLE:
	ld a,(LEADERORNO)
	or a
	JUMP_NZ(AFTERLEADER)
RETFROMLDR2:
	xor a
	ld (COUNTER),a
	CALL_(ERASESCREEN)		;return to map, battle over
	CALL_(DRAWWALLS)
	ld a,(DOTY)
	ld (BKY),a
	ld a,(DOTX)
	ld (BKX),a
	ld hl,(Save)
	CALL_(drawit)	
	JUMP_(RELOADROOM)

;-----------------
; -----Magic-----
;-----------------
MAGIC:
	CALL_(REVERSAL)
	CALL_(ERASEOF)
	ld a,(WHOATTACK)
	or a
	jr z,ISISCHKDFD
DARQCHKDFD:
	ld a,(DARQLVL)
	ld (CHKDFD),a
	jr CHKINGDONE
ISISCHKDFD:
	ld a,(ISISLVL)
	ld (CHKDFD),a
CHKINGDONE:
	ld a,(CHKDFD)
	cp 3
	JUMP_C(MAGIPAGE1)
	ld bc,$3656	
	ld hl,CURSORDN	
	CALL_(drawit2)
MAGIPAGE1:
	xor a
	ld (MAGIPAGE),a
	ld a,(WHOATTACK)
	or a
	jr z,ISISSPELL
DARQSPELL:
	ld de,$2D48		
             ld hl,Flee
             call DISPSTRING     
	ld a,(CHKDFD)
	cp 2
	jr c,MAGICSTART	
	ld de,$3448		
             ld hl,Drain
             call DISPSTRING     
	jr MAGICSTART
ISISSPELL:
	ld de,$2D48		
             ld hl,Cure
             call DISPSTRING     
	ld a,(CHKDFD)
	cp 2
	jr c,MAGICSTART
	ld de,$3448		
             ld hl,Fire
             call DISPSTRING     
	
MAGICSTART:
	ld bc,$2D3F	
	ld hl,CURSOR2	
	CALL_(drawit2)
	CALL_(DELAY)
MAGICLOOP:
	ld a,$3E
 	out (1),a
 	in a,(1)
 	bit 6,a
 	JUMP_Z(CANCELSPELL)
 	bit 5,a
 	JUMP_Z(MAGIPRESS)
 	bit 0,a
 	jr z,MAGIDOWN
	bit 3,a
	jr nz,MAGICLOOP
MAGIUP:
	ld a,(BKY)
	cp 45
	jr z,MAGICLOOP	
	ld bc,$343F	
	ld hl,CURSOR2	
	CALL_(drawit2)
	ld bc,$2D3F	
	ld hl,CURSOR2	
	CALL_(drawit2)
	CALL_(DELAY)
	JUMP_(MAGICLOOP)
MAGIDOWN:
	ld a,(CHKDFD)
	cp 3
	jr WHICHSPELL
RESUME:	
	ld a,(BKY)
	cp 52
	jr z,MAGICLOOP	
	ld bc,$2D3F	
	ld hl,CURSOR2	
	CALL_(drawit2)
	ld bc,$343F	
	ld hl,CURSOR2	
	CALL_(drawit2)
	CALL_(DELAY)
	JUMP_(MAGICLOOP)
WHICHSPELL:
	ld a,(BKY)
	cp 45
	jr z,RESUME
	ld a,(CHKDFD)
	cp 3
	jr c,RESUME	
	ld de,$2D48		
	ld hl,BLANKTEXT
             	call DISPSTRING     
	ld de,$3448		
       	ld hl,BLANKTEXT
        	call DISPSTRING     
	ld a,(MAGIPAGE)
	cp 1
	JUMP_Z(RETURNTOPAGE1)
	cp 2
	JUMP_Z(RETURNTOPAGE2)
	cp 3
	JUMP_Z(JUSTRETURN)
	ld a,(WHOATTACK)
	or a
	JUMP_Z(SPELLSOFISIS)
SPELLSOFDARQ:
	ld a,1
	ld (MAGIPAGE),a
	ld de,$2D48		
             ld hl,Siphon
             call DISPSTRING     
	ld a,(CHKDFD)
	cp 9
	JUMP_C(MAGIUP)
	ld de,$3448		
             ld hl,Nuke
             call DISPSTRING     
	JUMP_(MAGIUP)
SPELLSOFISIS:
	ld a,1
	ld (MAGIPAGE),a
	ld de,$2D48		
             ld hl,Wrath
             call DISPSTRING     
	ld a,(CHKDFD)
	cp 5
	JUMP_C(MAGIUP)
	ld de,$3448		
             ld hl,Cure2
             call DISPSTRING     
	JUMP_(MAGIUP)
SPELLSOFISIS2:
	ld a,2
	ld (MAGIPAGE),a
	ld de,$2D48		
        	ld hl,Life
           	call DISPSTRING     
	ld a,(CHKDFD) 
	cp 10
	JUMP_C(MAGIUP)
	ld de,$3448		
            	ld hl,Cure3
            	call DISPSTRING     
	JUMP_(MAGIUP)
SPELLSOFISIS3:
	ld a,3
	ld (MAGIPAGE),a
	ld de,$2D48		
        	ld hl,Death
           	call DISPSTRING     
	ld a,(CHKDFD)
	JUMP_(MAGIUP)
SPELLS3:
	ld a,(WHOATTACK)
	or a
	JUMP_Z(SPELLSOFISIS3)
	JUMP_(SPELLSOFDARQ)
SPELLS2:
	ld a,(WHOATTACK)
	or a
	JUMP_Z(SPELLSOFISIS2)
	JUMP_(SPELLSOFDARQ)
RETURNTOPAGE2:
	ld a,(CHKDFD)
	cp 10
	JUMP_NC(SPELLS3)
	jr JUSTRETURN
RETURNTOPAGE1:
	ld a,(CHKDFD)
	cp 7
	JUMP_NC(SPELLS2)
JUSTRETURN:
	ld bc,$343F	
	ld hl,CURSOR2	
	CALL_(drawit2)
	JUMP_(MAGIPAGE1)
MAGIPRESS:
	ld a,(WHOATTACK)
	or a
	JUMP_Z(ISISSELECT)
DARQSELECT:
	ld a,(MAGIPAGE)
	or a
	jr z,DARQCMP0
	cp 1
	jr z,DARQCMP1
DARQCMP0:
	ld a,(BKY)
	cp 45
	JUMP_Z(FLEESPELL)
	ld a,(DARQLVL)
	cp 2
	JUMP_C(MAGICLOOP)
	JUMP_(DRAINSPELL)
DARQCMP1:
	ld a,(BKY)
	cp 45
	JUMP_Z(SUCKSPELL)
	ld a,(DARQLVL)
	cp 9
	JUMP_C(MAGICLOOP)
	JUMP_(NUKESPELL)
ISISSELECT:
	ld a,(MAGIPAGE)
	or a
	jr z,ISISCMP0
	cp 1
	jr z,ISISCMP1
	cp 2
	jr z,ISISCMP2
	JUMP_(DEATHSPELL)
ISISCMP0:
	ld a,(BKY)
	cp 45
	JUMP_Z(CURESPELL)
	ld a,(ISISLVL)
	cp 2
	JUMP_C(MAGICLOOP)
	JUMP_(FIRESPELL)
ISISCMP1:
	ld a,(BKY)
	cp 45
	JUMP_Z(HATESPELL)
	ld a,(ISISLVL)
	cp 5
	JUMP_C(MAGICLOOP)
	JUMP_(CURESPELL2)
ISISCMP2:
	ld a,(BKY)
	cp 45
	JUMP_Z(LIFESPELL)
	ld a,(ISISLVL)
	cp 10
	JUMP_C(MAGICLOOP)
	JUMP_(CURESPELL3)
SPELLEND:	
	xor a
	ld (MAGICHK),a
	ld bc,$2E0A	
	ld (BKX),bc
	CALL_(ERASEOF)
	CALL_(PUTNAME)
	JUMP_(ACTIONEND)
PUTNAME:
	ld hl,(ENEMYHP)
	ld de,0
	and a
	sbc hl,de
	jr z,NEXT2
	ld de,$2C40
   	ld hl,(ENEMY1)
             call DISPSTRING
NEXT2:
	ld hl,(ENEMYHP2)
	ld de,0
	and a
	sbc hl,de
	RET Z
	ld de, $3340
   	ld hl,(ENEMY2)
             call DISPSTRING
	RET

ERASEOF:	
	ld de,$2D3F		
             ld hl,BLANKTEXT
             call DISPSTRING     
	ld de,$333F		
             ld hl,BLANKTEXT
             call DISPSTRING     
	ld de,$3942		
             ld hl,BLANKTEXT
             call DISPSTRING     
	RET

FLEESPELL:
	ld a,(DARQMP)   ;; have enough MP?
	cp 1
	JUMP_C(NEEDMOREMP)		
	ld a,(LEADERORNO)
	or a
	JUMP_NZ(MAGICLOOP)
	ld de,$0103                    
            	ld hl,Fleetext
            	call DISPSTRING     
	CALL_(DRAWDATTACK)
	ld a,4
	ld (CHKDFD),a
FLEEOVER: ;; spell graphics -- "the winds of change..."
	ld a,(CHKDFD)	
	ld (BKX),a
	ld a,8
	ld (BKY),a
	ld hl,FLEE	
	CALL_(drawit)
	ld a,(CHKDFD)	
	ld (BKX),a
	ld a,17
	ld (BKY),a
	ld hl,FLEE	
	CALL_(drawit)
	ld a,(CHKDFD)	
	ld (BKX),a
	ld a,26
	ld (BKY),a
	ld hl,FLEE	
	CALL_(drawit)
	ld a,(CHKDFD)	 
	ld (BKX),a
	ld a,35
	ld (BKY),a
	ld hl,FLEE	
	CALL_(drawit)
	ld a,(CHKDFD)	
	add a,8
	ld (CHKDFD),a
	cp 85
	JUMP_C(FLEEOVER)
	ld a,(DARQMP)  ;; subtract that used MP
	dec a
	ld (DARQMP),a
	JUMP_(ENDBATTLE)	;;spell effect -- exits battle (like a charm, baby)

SUCKSPELL:
	ld a,(DARQMP)
	cp 24
	JUMP_C(NEEDMOREMP)		
	ld a,66	
	ld (WHOTOATTACK),a
	jr RETSPELLD
DRAINSPELL:
	ld a,(DARQMP)
	cp 7
	JUMP_C(NEEDMOREMP)		
RETSPELLD:
	CALL_(DRAWDATTACK)
	ld a,63
	ld (CHKDFD),a
DRAINLOOP:
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,20
	ld (BKY),a
	ld hl,SPELLDRAIN
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)	
	ld (BKX),a
	ld a,20
	ld (BKY),a
	ld hl,SPELLDRAIN
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)	
	ld (BKX),a
	ld a,20
	ld (BKY),a
	ld hl,SPELLDRAIN2
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)	
	ld (BKX),a
	ld a,20
	ld (BKY),a
	ld hl,SPELLDRAIN2
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)
	sub 8
	ld (CHKDFD),a
	cp 23
	jr nz,DRAINLOOP
DRAINLOOP2:
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,20
	ld (BKY),a
	ld hl,SPELLDRAIN3
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)	
	ld (BKX),a
	ld a,20
	ld (BKY),a
	ld hl,SPELLDRAIN3
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)	
	ld (BKX),a
	ld a,20
	ld (BKY),a
	ld hl,SPELLDRAIN4
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)	
	ld (BKX),a
	ld a,20
	ld (BKY),a
	ld hl,SPELLDRAIN4
	CALL_(drawit) 
	CALL_(DELAY2)
	ld a,(CHKDFD)
	add a,8
	ld (CHKDFD),a
	cp 63
	jr nz,DRAINLOOP2
	CALL_(DRAWDATTACK)
	ld a,(WHOTOATTACK)
	cp 66
	jr z,SUCKSPELLEND	
	ld a,(DARQMP)  ;; subtract that used MP
	sub 7
	ld (DARQMP),a
	ld a,(HPD)
	add a,20
	ld (HPD),a
	CALL_(HPOVERMAXD)
	CALL_(DISPALLHP)
	ld c,20		;; damage = 15 +/- RAND	
	JUMP_(MAGICERASE)	
SUCKSPELLEND:
	ld a,(DARQMP)  ;; subtract that used MP
	sub 24
	ld (DARQMP),a
	ld a,(HPD)
	add a,60
	ld (HPD),a
	CALL_(HPOVERMAXD)
	CALL_(DISPALLHP)
	ld c,60		;; damage = 60 +/- RAND	
	JUMP_(MAGICERASE)	
NUKESPELL:
	ld a,(DARQMP)
	cp 36
	JUMP_C(NEEDMOREMP)		
	CALL_(DRAWDATTACK)
	ld a,51
	ld (CHKDFD),a
	ld b,2
NUKELOOP:	
	push bc
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,15
	ld (BKY),a
	ld hl,SPELLNUKE	
	ld c,16
	CALL_(drawbig)
	ld a,15
	ld (BKY),a
	ld a,(CHKDFD)
	add a,8
	ld (BKX),a
	ld hl,SPELLNUKE2	
	ld c,16
	CALL_(drawbig)
	ld a,15
	ld (BKY),a
	ld a,(CHKDFD)
	add a,16
	ld (BKX),a
	ld hl,SPELLNUKE3	
	ld c,16
	CALL_(drawbig)

	pop bc
	djnz NUKELOOP	
	ld b,2
	ld a,(CHKDFD)	
	sub 3
	ld (CHKDFD),a
	cp 15
	jr nz,NUKELOOP
	ld b,6
NUKELOOP2:
	push bc
	ld bc,$1A1A	
	ld hl,SPELLFIRE	
	CALL_(drawit2)
	ld bc,$0D0D	
	ld hl,SPELLFIRE
	CALL_(drawit2)
	CALL_(DELAY2)
	pop bc
	djnz NUKELOOP2
	ld a,(DARQMP)  ;; subtract that used MP
	sub 23
	ld (DARQMP),a
	CALL_(DRAWDATTACK)
	ld c,230		;; damage = 230 +/- RAND	
	JUMP_(MAGICERASE)	
	
;;Begin Isis' Spells
CURESPELL:
	ld a,3
	ld (MAGIPAGE),a
	ld a,30
	ld (MAGICHK),a
	jr CURECURE
CURESPELL2:
	ld a,9
	ld (MAGIPAGE),a
	ld a,110
	ld (MAGICHK),a
	jr CURECURE
CURESPELL3:
	ld a,20
	ld (MAGIPAGE),a
	ld a,255
	ld (MAGICHK),a
	jr CURECURE
CURECURE:
	
	ld de,$0109                    
             ld hl,Curetext
             call DISPSTRING     
	ld a,(MAGIPAGE)
	ld b,a	
	ld a,(ISISMP)   ;; have enough MP?
	cp b
	JUMP_C(NEEDMOREMP)		
	CALL_(DRAWIATTACK)
	ld b,4
	CALL_(CURELOOP)
	ld a,(MAGIPAGE)
	ld b,a
	ld a,(ISISMP)  ;; subtract that used MP
	sub b
	ld (ISISMP),a
	CALL_(DRAWIATTACK)
	ld a,(MAGICHK)		
	ld b,a
	ld a,(HPD)
	or a
	jr z,ISISCURE
	add a,b
	ld (HPD),a
	CALL_(HPOVERMAXD)
ISISCURE:
	ld a,(HPI)
	add a,b
	ld (HPI),a
	CALL_(HPOVERMAXI)
	CALL_(DISPALLHP)
	CALL_(ERASETEXT)
	JUMP_(SPELLEND)
CURELOOP:
	ld b,8
LOOPOFCURE:
	push bc
	ld de,$1032	
	ld hl,SPELLCURE	
	ld c,11
	CALL_(drawbig2)
	ld de,$103A	
	ld hl,SPELLCURE2	
	ld c,11
	CALL_(drawbig2)
	CALL_(DELAY3)
	pop bc
	djnz LOOPOFCURE
	RET

FIRESPELL:
	ld a,(ISISMP)
	cp 9
	JUMP_C(NEEDMOREMP)		
	CALL_(DRAWIATTACK)
	ld b,6
FIRELOOP:
	push bc
	ld bc,$0D0D
	ld hl,SPELLFIRE
	CALL_(drawit2)
	ld bc,$1A0E
	ld hl,SPELLFIRE
	CALL_(drawit2)
	ld bc,$0D18
	ld hl,SPELLFIRE
	CALL_(drawit2)
	ld bc,$1A1A
	ld hl,SPELLFIRE
	CALL_(drawit2)
	CALL_(DELAY3)
	pop bc
	djnz FIRELOOP
	ld a,(ISISMP)  ;; subtract that used MP
	sub 9
	ld (ISISMP),a
	CALL_(DRAWIATTACK)
	ld c,30		;; damage = 15 +/- RAND	
	JUMP_(MAGICERASE)
HATESPELL:
	ld a,(ISISMP)
	cp 16
	JUMP_C(NEEDMOREMP)		
	CALL_(DRAWIATTACK)
	ld b,8
HATENOLOOP:	
	push bc	
	ld de,$0E06	
	ld hl,SPELLHATE	
	ld c,14
	CALL_(drawbig2)
	CALL_(DELAY2)
	ld de,$071C	
	ld hl,SPELLHATE	
	ld c,14
	CALL_(drawbig2)
	CALL_(DELAY2)
	ld de,$1812	
	ld hl,SPELLHATE	
	ld c,14
	CALL_(drawbig2)
	CALL_(DELAY2)
	pop bc
	djnz HATENOLOOP
	CALL_(DRAWIATTACK)
	ld a,(ISISMP)  ;; subtract that used MP
	sub 16
	ld (ISISMP),a
	ld c,80		;; damage = 15 +/- RAND	
	JUMP_(MAGICERASE)
LIFESPELL:
	ld a,(HPD)
	or a
	JUMP_NZ(MAGICLOOP)
	ld a,(ISISMP)
	cp 24
	JUMP_C(NEEDMOREMP)		
	CALL_(DRAWIATTACK)
	CALL_(DRAWANGEL)
	ld bc,$0635	
	ld hl,LIFESTAR	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$0635	
	ld hl,LIFESTAR	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$0536	
	ld hl,LIFESTAR	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$0536	
	ld hl,LIFESTAR	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$0438	
	ld hl,LIFESTAR	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$0438	
	ld hl,LIFESTAR	
	CALL_(drawit2)
	CALL_(DELAY)
	CALL_(DRAWANGEL)
	CALL_(DRAWIATTACK)
	ld a,(ISISMP)  ;; subtract that used MP
	sub 24
	ld (ISISMP),a
	ld a,100
	ld (HPD),a
	CALL_(ERASEDARQ)
	CALL_(DISPALLHP)
	JUMP_(SPELLEND)
ATTKSPELL:

DEATHSPELL:
	ld a,(ISISMP)
	cp 45
	JUMP_C(NEEDMOREMP)		
	CALL_(DRAWIATTACK)
	ld de, $0103                    
             ld hl,Deathtext
             call DISPSTRING     
	CALL_(DEATHGRAP)
	CALL_(DELAY)
	ld b,30 
INVERTNOLOOP:
	push bc
	CALL_(INVERTSCREEN)
	pop bc
	djnz INVERTNOLOOP
	CALL_(ERASETEXT)
	CALL_(DEATHGRAP)	
	CALL_(DRAWIATTACK)
	ld a,(ISISMP)  ;; subtract that used MP
	sub 45
	ld (ISISMP),a
	ld c,229		;; damage = 15 +/- RAND	
	JUMP_(MAGICERASE)

MAGICERASE:
	CALL_(RAND2)	
	CALL_(DISPDAMAGE)
	ld hl,(ENEMYHP)
	ld de,0
	and a
	sbc hl,de
	jr z,MAGICHIT2
MAGICHIT:
	ld a,3
	ld (MAGICHK),a
	ld a,1
	ld (WHOTOATTACK),a
	ld a,(CHKDFD)
	ld c,a
	ld b,0
	ld hl,(ENEMYHP)
	and a
	sbc hl, bc
	ld (ENEMYHP),hl
	JUMP_Z(ENEMYDEAD1M)
	JUMP_C(ENEMYDEAD1M)
MAGICHIT2:
	ld a,1
	ld (MAGICHK),a
	ld hl,(ENEMYHP2)
	ld de,0
	and a
	sbc hl, de
	JUMP_Z(SPELLEND)
	ld a,2
	ld (WHOTOATTACK),a
	ld a,(CHKDFD)
	ld c,a
	ld b,0
	ld hl,(ENEMYHP2)
	and a
	sbc hl,bc
	ld (ENEMYHP2),hl
	JUMP_Z(ENEMYDEAD2M)
	JUMP_C(ENEMYDEAD2M)
	JUMP_(SPELLEND)
ENEMYDEAD2M:
	ld hl,0
	ld (ENEMYHP2),hl
	jr ENEMYDEADM
ENEMYDEAD1M:
	ld a,(LEADERORNO)
	or a
	JUMP_NZ(ERASELEADER)
	ld hl,0
	ld (ENEMYHP),hl
ENEMYDEADM:
	ld a,(ENEMY32)	
	or a
	JUMP_NZ(BIGERASE)
	CALL_(ERASEENEMY)		
BIGERASEDONEM:
	ld a,(NUMBEROFENEMIES)
	dec a	
	ld (NUMBEROFENEMIES),a
	or a
	JUMP_Z(ALLENEMYDEAD)
	ld a,(MAGICHK)
	cp 3
	jr z,(MAGICHIT2)
	JUMP_(SPELLEND)		
NEEDMOREMP:
	ld de,$0103                    
             ld hl,YOUNEEDMP
             call DISPSTRING     
	CALL_(DELAY3)
CANCELSPELL:
	CALL_(ENDREVERSAL)
	CALL_(ERASETEXT)
	CALL_(ERASEOF)
	CALL_(PUTNAME)
	JUMP_(SPEEDLOOP)
;---------------------
;---Magic END--
;---------------------

;--------------------
;Item BEGIN---
;--------------------
ITEM:
	CALL_(REVERSAL)
	CALL_(ERASEOF)
	ld bc,$2D3F	
	ld hl,CURSOR2	
	CALL_(drawit2)
	ld a,(MEDKITS)
	or a
	jr z,NEXTITEM		
	ld de,$2D48		
             ld hl,itemmedkit
             call DISPSTRING
	LD DE,$2D59		
	ld a,(MEDKITS)	
	CALL_(DISPHL)		

NEXTITEM:	
	ld a,(MAGIKITS)
	or a
	jr z,ITEMLOOP
	ld de,$3448		
             ld hl,itemmagkit
             call DISPSTRING    
	LD DE,$3459		
	ld a,(MAGIKITS)	
	CALL_(DISPHL)		
	CALL_(DELAY)
ITEMLOOP:
	ld a,$3E
 	out (1),a
 	in a,(1)
 	bit 6,a
 	JUMP_Z(CANCELSPELL)
 	bit 5,a
 	JUMP_Z(ITEMPRESS)
	bit 3,a
 	JUMP_Z(ITEMUP)
 	bit 0,a
 	JUMP_Z(ITEMDOWN)
	jr ITEMLOOP
ITEMUP:
	ld a,(BKY)
	cp 45
	jr z,ITEMLOOP	
	ld bc,$343F	
	ld hl,CURSOR2	
	CALL_(drawit2)
	ld bc,$2D3F	
	ld hl,CURSOR2	
	CALL_(drawit2)
	CALL_(DELAY)
	jr ITEMLOOP
ITEMDOWN:
	ld a,(BKY)
	cp 52
	jr z,ITEMLOOP	
	ld bc,$2D3F	
	ld hl,CURSOR2	
	CALL_(drawit2)
	ld bc,$343F	
	ld hl,CURSOR2	
	CALL_(drawit2)
	CALL_(DELAY)
	JUMP_(ITEMLOOP)
ITEMPRESS:
	ld a,(BKY)
	cp 52
	JUMP_Z(USEMAGIKIT)
USEMEDIKIT:
	ld a,(MEDKITS)
	or a
	JUMP_Z(ITEMLOOP)
	dec a
	ld (MEDKITS),a	
	ld b,3
MEDKITLOOP:
	push bc
	ld bc,$1432	
	ld hl,ITEMMEDKIT	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$1432	
	ld hl,ITEMMEDKIT	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$1432	
	ld hl,ITEMMEDKIT2	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$1432	
	ld hl,ITEMMEDKIT2	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$1432	
	ld hl,ITEMMEDKIT3	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$1432	
	ld hl,ITEMMEDKIT3	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$1432	
	ld hl,ITEMMEDKIT4	
	CALL_(drawit2)
	CALL_(DELAY3)
	ld bc,$1432	
	ld hl,ITEMMEDKIT4	
	CALL_(drawit2)
	pop bc
	djnz MEDKITLOOP1

	ld b,45
	ld a,(HPD)
	or a
	jr z,(ISISMED)
	add a,b
	ld (HPD),a
	CALL_(HPOVERMAXD)
ISISMED:
	ld b,45
	ld a,(HPI)
	or a
	jr z,ENDMED
	add a,b
	ld (HPI),a
	CALL_(HPOVERMAXI)
ENDMED:
	CALL_(DISPALLHP)
	JUMP_(ITEMEND)	
MEDKITLOOP1:
	JUMP_(MEDKITLOOP)
USEMAGIKIT:	
	ld a,(MAGIKITS)
	or a
	JUMP_Z(ITEMLOOP)
	dec a
	ld (MAGIKITS),a	
	ld b,14
MAGIKITLOOP:
	push bc
	ld bc,$1432	
	ld hl,ITEMMAGIKIT	
	CALL_(drawit2)	
	ld bc,$0C2A	
	ld hl,ITEMMAGIKIT	
	CALL_(drawit2)	
	ld bc,$0C3A	
	ld hl,ITEMMAGIKIT	
	CALL_(drawit2)	
	ld bc,$1C3A	
	ld hl,ITEMMAGIKIT	
	CALL_(drawit2)	
	ld bc,$1C2A	
	ld hl,ITEMMAGIKIT	
	CALL_(drawit2)	
	pop bc
	djnz MAGIKITLOOP
	ld b,30
	ld a,(DARQMP)
	add a,b
	ld (DARQMP),a
	CALL_(MPOVERMAXD)
	ld b,30
	ld a,(ISISMP)
	add a,b
	ld (ISISMP),a
	CALL_(MPOVERMAXI)
ITEMEND:
	ld bc,$3701	
	ld (BKX),bc
	CALL_(ERASEOF)
	CALL_(PUTNAME)
	JUMP_(ACTIONEND)

;--------------------
;---Item END---
;--------------------

DEFEND:
	ld de,$0103                    
	ld a,(WHOATTACK)
	or a
	jr z,ISISDEFENDS

	ld a,99
	ld (DEFENDOND),a
   	ld hl,DARQDEFEND
             call DISPSTRING
  	jr DFDCHOSEN
ISISDEFENDS:
	ld a,99
	ld (DEFENDONI),a
             ld hl,ISISDEFEND
             call DISPSTRING     
DFDCHOSEN:
	xor a
	ld (CHKDFD),a
	CALL_(REVERSAL)
REPLAY:
	ld a,(CHKDFD)	
	inc a
	ld (CHKDFD),a
	ld bc,$0528	
	ld hl,SHIELD1	
	CALL_(drawit2)
	ld bc,$0530	
	ld hl,SHIELD2	
	CALL_(drawit2)
	ld bc,$0538	
	ld hl,SHIELD3	
	CALL_(drawit2)
	ld bc,$0D28	
	ld hl,SHIELD4	
	CALL_(drawit2)
	ld bc,$0D30	
	ld hl,SHIELD5	
	CALL_(drawit2)
	ld bc,$0D38	
	ld hl,SHIELD6	
	CALL_(drawit2)
	ld bc,$1528	
	ld hl,SHIELD7	
	CALL_(drawit2)
	ld bc,$1530	
	ld hl,SHIELD8	
	CALL_(drawit2)
	ld bc,$1538	
	ld hl,SHIELD9	
	CALL_(drawit2)
	ld bc,$1D28	
	ld hl,SHIELD10	
	CALL_(drawit2)
	ld bc,$1D30	
	ld hl,SHIELD11	
	CALL_(drawit2)
	ld bc,$1D38	
	ld hl,SHIELD12	
	CALL_(drawit2)
	ld bc,$2530	
	ld hl,SHIELD13	
	CALL_(drawit2)
	CALL_(ENDREVERSAL)
	ld a,(CHKDFD)
	cp 2
	JUMP_Z(DEFENDEND)
	CALL_(DELAY)
	JUMP_(REPLAY)
DEFENDEND:
	CALL_(ERASETEXT)
ACTIONEND:
	CALL_(REVERSAL)
	ld a,(WHOATTACK)
	cp 1
	jr z,DARQEND
ISISEND:
	ld bc,$2F14
	ld hl,ERASURE	
	CALL_(drawit2)
	ld bc,$2F1B
	ld hl,ERASURE	
	CALL_(drawit2)
	ld a,21
	ld (COUNTER),a
	xor a
	ld (OKAY1),a
	CALL_(ENDREVERSAL)
	JUMP_(SWITCH)
DARQEND:
	ld bc,$2F28
	ld hl,ERASURE	
	CALL_(drawit2)
	ld bc,$2F2F	
	ld hl,ERASURE	
	CALL_(drawit2)
	ld a,41
	ld (COUNTER2),a
	xor a
	ld (OKAY2),a
	CALL_(ENDREVERSAL)
	JUMP_(SWITCH)
DELAY:
        ld a,$FF
        ld b,$FF
dloop:
        dec a
        jr nz,dloop
        dec b
        jr nz,dloop
        ret
DELAY2:
        ld a,$44
        ld b,$44
        jr dloop
DELAY3:
        ld a,$8F
        ld b,$8F
        jr dloop
DELAY4:
        ld a,$9F
        ld b,$9F
        jr dloop
ENDREVERSAL:
	ld a,(BKX1)
	ld (BKX),a
	ld a,(BKY1)	 
	ld (BKY),a
	RET
REVERSAL:
	ld a,(BKX)
	ld (BKX1),a
	ld a,(BKY)	
	ld (BKY1),a
	RET
ENEMYATTACK:
	ld hl,(ENEMYHP)
	ld de,0
	and a
	sbc hl,de
	jr z,ATTACKW2
	ld a,(ENEMYHP2)
	or a
	jr z,ATTACKW1

	ld a,(HITBYWHO)
	cp 1
	jr z,ATTACKW1
ATTACKW2:
	ld a,2
	ld (HITBYWHO),a
	ld a,(ENEMY2STR)
	ld (HIT),a
	jr REGO
ATTACKW1:
	ld a,1
	ld (HITBYWHO),a
	ld a,(ENEMY1STR)
	ld (HIT),a
REGO:	
	ld de,$0103                     
             ld hl,ENEMYATTACKS
            	call DISPSTRING     
	LD DE,$011A		
	ld a,(HITBYWHO)	
	CALL_(DISPHL)		
	xor a
	ld (ENEMYCOUNTER),a
	ld a,2
	ld a,(HITBYWHO)
	cp 1
	jr z,HITBY1
HITBY2:
	ld a,1
	ld (HITBYWHO),a
	jr GOON
HITBY1:
	ld a,2
	ld (HITBYWHO),a
GOON:
	call CR_GRBCopy
	CALL_(DELAY)
	CALL_(INVERTSCREEN)	
	CALL_(shake)
	CALL_(INVERTSCREEN)
	CALL_(ERASETEXT)
	ld a,(HPI)
	or a
	jr z,DARQHIT
	ld a,(HPD)
	or a
	jr z,ISISHIT
RANDX:		
	ld a,r
  	srl a
  	and 3          ; between 1-2
 	jr z,RANDX
  	sub 1
	jr z,RANDX
	cp 2		
	jr z,(ISISHIT)
DARQHIT:

	ld a,(DEFENDD)
	ld b,a
	ld a,(DEFENDOND)
	cp 99
	jr nz,DEFENDNTD
	xor a	
	ld (DEFENDOND),a
	ld a,b
	add a,a
	ld b,a
DEFENDNTD:
	ld a,(HIT)	
	sub b
	ld (HIT),a
	jr c,SETTO1
	jr z,SETTO1
	jr DARQHIT1
SETTO1:
	ld a,1
DARQHIT1:
	ld b,a
	ld a,(HPD)
	sub b
	ld (HPD),a
	JUMP_C(DARQDEAD)
	JUMP_Z(DARQDEAD)
	CALL_(DISPALLHP)
	JUMP_(RETURNATTK)
ISISHIT:
	ld a,(DEFENDI)
	ld b,a
	ld a,(DEFENDONI)
	cp 99
	jr nz,DEFENDNTI   ;;DEFEND N-ot T-rue (for) I-sis
	xor a	
	ld (DEFENDONI),a
	ld a,b
	add a,a
	ld b,a
DEFENDNTI:
	ld a,(HIT)	
	sub b
	ld (HIT),a
	jr c,SETTO11
	jr z,SETTO11
	jr ISISHIT1
SETTO11:
	ld a,1
ISISHIT1:	
	ld b,a
	ld a,(HPI)
	sub b
	ld (HPI),a
	JUMP_C(ISISDEAD)
	JUMP_Z(ISISDEAD)
	CALL_(DISPALLHP)
	JUMP_(RETURNATTK)
ISISDEAD:
	xor a
	ld (HPI),a
	CALL_(DISPALLHP)	
	ld de,$0103                    
            	ld hl,ISISFALLS
            	call DISPSTRING     
	xor a
	ld (ENEMYCOUNTER),a
	call CR_GRBCopy
	CALL_(DELAY)
	CALL_(DELAY)
	CALL_(ERASEISIS)
	CALL_(ERASETEXT)
	ld a,(HPD)
	or a
	JUMP_Z(GAMEOVER)
	ld de,$0754                   
            	ld hl,BLANKLIFE
            	call DISPSTRING
	ld b,88
	ld c,57
	CALL_(RemovePixel)
	CALL_(REVERSAL)
	ld a,(WHOATTACK)
	cp 1
	JUMP_Z(RETURNATTK)
	ld bc,$1C55	
	ld hl,CURSOR	
	CALL_(drawit2)
	CALL_(ENDREVERSAL)
	ld a,1
	ld (WHOATTACK),a
	JUMP_(RETURNATTK)
DARQDEAD:	
	xor a
	ld (HPD),a
	CALL_(DISPALLHP)	
	ld de,$0103                    
             ld hl,DARQFALLS
             call DISPSTRING     
	xor a
	ld (ENEMYCOUNTER),a
	call CR_GRBCopy
	CALL_(DELAY) 
	CALL_(DELAY)
	CALL_(ERASEDARQ)
	CALL_(ERASETEXT)
	ld a,(HPI)
	or a
	JUMP_Z(GAMEOVER)
	ld de,$1D54                   
             ld hl,BLANKLIFE
             call DISPSTRING
	ld a,(WHOATTACK)
	or a
	JUMP_Z(RETURNATTK)
	ld b,88
	ld c,35
	CALL_(RemovePixel)
	CALL_(REVERSAL)
	ld bc,$0655	
	ld hl,CURSOR	
	CALL_(drawit2)
	CALL_(ENDREVERSAL)
	xor a
	ld (WHOATTACK),a
	JUMP_(RETURNATTK)
RAND2: ;; Random Damage
	ld a,r
  	srl a
  	and 3          ; between 1-2
	add a,c  	  	
	ld (CHKDFD),a  ;dummy variable
	RET
PUTENEMY:

RANDFORPUTENEMY:
  ld a,r
  srl a
  and 7   
  or a
  jr z,RANDFORPUTENEMY       
  cp 7
  jr z,RANDFORPUTENEMY       
  ld (WHICHENEMY),a
ROOMLESS8:
	ld a,(DUNGEON)
	cp 100
	JUMP_Z(DUNGEON1ENEMY)
	cp 124
	JUMP_Z(DUNGEON2ENEMY)
	cp 138
	JUMP_Z(DUNGEON3ENEMY)
	ld a,(ROOM)
	cp 24	
	JUMP_NC(ROOMGREATER24)
	ld a,34			;;Sets enemy speed for BOTH
	ld (ENEMYSPEED),a		;;enemies  	
	ld a,8
	ld (XPPOINTER),a

	ld hl,15
	ld (LIFEPOINTER),hl
	ld a,(WHICHENEMY)
	cp 1
	jr z,SLime
	cp 2
	jr z,CLown
	cp 3
	jr z,RObo
	cp 4
	jr z,WIsp
	ld a,(ENEMYHP)
	or a
	JUMP_NZ(RANDFORPUTENEMY)
	ld hl,32
	ld (LIFEPOINTER),hl
	ld a,(WHICHENEMY)
  	cp 5
	JUMP_Z(Big1)
	cp 6
	JUMP_Z(Big2)
CLown:
	ld a,8
	ld (STRENGTHPOINTER),a
	ld hl,ENEMY1AREA1
	ld (DISPENEMY),hl
	ld hl,Clown	
	JUMP_(STARTENEMY)
RObo:	
	ld a,9
	ld (STRENGTHPOINTER),a
	ld hl,ENEMY2AREA1
	ld (DISPENEMY),hl
	ld hl,Robo
	JUMP_(STARTENEMY)
SLime:
	ld a,10
	ld (STRENGTHPOINTER),a
	ld hl,ENEMY4AREA1
	ld (DISPENEMY),hl
	ld hl,Slime
	JUMP_(STARTENEMY)
WIsp:
	ld a,21		
	ld (ENEMYSPEED),a	
	ld a,7
	ld (STRENGTHPOINTER),a
	ld hl,ENEMY5AREA1
	ld (DISPENEMY),hl
	ld hl,Wisp
	JUMP_(STARTENEMY)
Big1:
	ld a,14
	ld (STRENGTHPOINTER),a
	ld hl,ENEMY3AREA1
	ld (DISPENEMY),hl
	ld hl,ENEMY3AREA1p2
	ld (ENEMY32),hl
	ld hl,Stinger
	JUMP_(BIGENEMY)
Big2:
	ld a,19
	ld (STRENGTHPOINTER),a
	ld hl,ENEMY6AREA1
	ld (DISPENEMY),hl
	ld hl,ENEMY6AREA1p2
	ld (ENEMY32),hl
	ld hl,Skeleton
	JUMP_(BIGENEMY)
	
KNight:
	ld hl,ENEMY1AREA2
	ld (DISPENEMY),hl
	ld hl,Knight
	JUMP_(STARTENEMY)
EYe:
	ld hl,ENEMY2AREA2
	ld (DISPENEMY),hl
	ld hl,Eye
	JUMP_(STARTENEMY)
HAwk:
	ld hl,ENEMY3AREA2
	ld (DISPENEMY),hl
	ld hl,Hawk
	JUMP_(STARTENEMY)
FLame:
	ld hl,ENEMY4AREA2
	ld (DISPENEMY),hl
	ld hl,Flame
	JUMP_(STARTENEMY)
DUNGEON1ENEMY:
	ld a,29			;;Sets enemy speed for BOTH
	ld (ENEMYSPEED),a		;;enemies  	
	ld a,17
	ld (XPPOINTER),a
	ld hl,60
	ld (LIFEPOINTER),hl
	ld a,20
	ld (STRENGTHPOINTER),a
	ld a,(WHICHENEMY)
	cp 1
	jr z,KNight
	cp 2
	jr z,EYe
	cp 3
	jr z,HAwk
	cp 4
	jr z,FLame
	ld a,(ENEMYHP)
	or a
	JUMP_NZ(RANDFORPUTENEMY)
	ld hl,32
	ld (LIFEPOINTER),hl
	ld a,(WHICHENEMY)
  	cp 5
	JUMP_Z(Big1)
	cp 6
	JUMP_Z(Big2)
ROOMGREATER24:
	ld a,(ROOM)
	cp 39	
	JUMP_NC(ROOMGREATER39)
	ld a,24			;;Sets enemy speed for BOTH
	ld (ENEMYSPEED),a		;;enemies  	
	ld a,27
	ld (XPPOINTER),a
	ld hl,125
	ld (LIFEPOINTER),hl
	ld a,38
	ld (STRENGTHPOINTER),a
	ld a,(WHICHENEMY)
	cp 1
	jr z,BEe
	cp 2
	jr z,MAsk
	cp 3
	jr z,TOrch
	cp 4
	jr z,SPider
BEe:
	ld hl,ENEMY1AREA3
	ld (DISPENEMY),hl
	ld hl,Bee
	JUMP_(STARTENEMY)
MAsk:
	ld hl,ENEMY2AREA3
	ld (DISPENEMY),hl
	ld hl,Mask
	JUMP_(STARTENEMY)
TOrch:
	ld hl,ENEMY3AREA3
	ld (DISPENEMY),hl
	ld hl,Torch
	JUMP_(STARTENEMY)
SPider:
	ld hl,ENEMY4AREA3
	ld (DISPENEMY),hl
	ld hl,Spider
	JUMP_(STARTENEMY)
DUNGEON2ENEMY:
	ld a,28			;;Sets enemy speed for BOTH
	ld (ENEMYSPEED),a		;;enemies  	
	ld a,35
	ld (XPPOINTER),a
	ld hl,145
	ld (LIFEPOINTER),hl
	ld a,47
	ld (STRENGTHPOINTER),a
	ld a,(WHICHENEMY)
	cp 1
	jr z,MAge
	cp 2
	jr z,MAsk
	cp 3
	jr z,TOrch
	cp 4
	jr z,KIss
	ld a,(ENEMYHP)
	or a
	JUMP_NZ(RANDFORPUTENEMY)
	ld a,(WHICHENEMY)
	cp 5
	jr z,Big3
	cp 6
	jr z,Big4
MAge:
	ld hl,ENEMY2AREA4
	ld (DISPENEMY),hl
	ld hl,Mage
	JUMP_(STARTENEMY)
KIss:
	ld hl,ENEMY1AREA4
	ld (DISPENEMY),hl
	ld hl,Kiss
	JUMP_(STARTENEMY)	
Big3:
	ld hl,ENEMY3AREA4
	ld (DISPENEMY),hl
	ld hl,ENEMY3AREA4p2
	ld (ENEMY32),hl
	ld hl,Head
	JUMP_(BIGENEMY)
Big4:
	ld hl,ENEMY4AREA4
	ld (DISPENEMY),hl
	ld hl,ENEMY4AREA4p2
	ld (ENEMY32),hl
	ld hl,Sun
	JUMP_(BIGENEMY)
JUnk:
	ld hl,ENEMY1AREA5
	ld (DISPENEMY),hl
	ld hl,Junk
	JUMP_(STARTENEMY)
ZOrg:
	ld hl,ENEMY2AREA5
	ld (DISPENEMY),hl
	ld hl,Zorg
	JUMP_(STARTENEMY)	

ROOMGREATER39:
DUNGEON3ENEMY:
	ld a,26			;;Sets enemy speed for BOTH
	ld (ENEMYSPEED),a		;;enemies  	
	ld a,60
	ld (XPPOINTER),a
	ld hl,210
	ld (LIFEPOINTER),hl
	ld a,100
	ld (STRENGTHPOINTER),a
	ld a,(WHICHENEMY)
	cp 1
	jr z,MAge
	cp 2
	jr z,KIss
	cp 3
	jr z,JUnk
	cp 4
	jr z,ZOrg
	ld a,(ENEMYHP)
	or a
	JUMP_NZ(RANDFORPUTENEMY)
	ld a,(WHICHENEMY)
	cp 5
	jr z,Big3
	cp 6
	jr z,Big4
BIGENEMY:
	ld (ENEMY1),hl
	ld hl,(LIFEPOINTER)
	ld (ENEMYHP),hl		;load enemy 1's life
	ld a,(STRENGTHPOINTER)
	ld (ENEMY1STR),a	;load enemy 1's strength
	ld a,(XPPOINTER)
	ld (ENEMY1XP),a
	ld de,$0D0D	
	ld hl,(DISPENEMY)	
	ld c,16
	CALL_(drawbig2)
	ld de,$0D15	
	ld hl,(ENEMY32)	
	ld c,16
	CALL_(drawbig2)
	ld de,$2C40
   	ld hl,(ENEMY1)         
             call DISPSTRING     
	ld a,1
	ld (NUMBEROFENEMIES),a
	RET
STARTENEMY:	
	ld a,(ECOUNTER)		;;Displays ENEMY2 after ENEMY1
	cp 26				;;is drawn.
	JUMP_Z(ENEMYNUMBER2)	
	ld (ENEMY1),hl
	ld a,(ECOUNTER)		;; draws the enemy	
	ld (BKX),a
	ld a,(ECOUNTER)		
	ld (BKY),a
	ld hl,(DISPENEMY)	;;ENEMY X AREA X (based on ROOM var)
	ld (ENEMYKILLED),hl	;; loads enemy into ENEMYKILLED
	CALL_(drawit)		;; so he can be erased easily
	ld hl,(LIFEPOINTER)
	ld (ENEMYHP),hl		;load enemy 1's life
	ld a,(STRENGTHPOINTER)
	ld (ENEMY1STR),a	;load enemy 1's strength
	ld a,(XPPOINTER) 
	ld (ENEMY1XP),a
	ld de,$2C40
   	ld   hl,(ENEMY1)         
             call DISPSTRING     
	ld a,(NUMBEROFENEMIES)  ;;Is there more than one ENEMY?
	cp 1			;;If so, continue...if not, RETURN
	RET Z
	ld a,26
	ld (ECOUNTER),a		
	JUMP_(RANDFORPUTENEMY)
ENEMYNUMBER2:	
	ld (ENEMY2),hl
	ld a,(ECOUNTER)		;; draws the enemy	
	ld (BKX),a
	ld a,(ECOUNTER)		
	ld (BKY),a
	ld hl,(DISPENEMY)	;;ENEMY X AREA X (based on ROOM var)
	ld (ENEMYKILLED2),hl	;; loads enemy into ENEMYKILLED
	CALL_(drawit)		;; so he can be erased easily
	ld hl,(LIFEPOINTER)
	ld (ENEMYHP2),hl		;; loads ENEMY 2's life
	ld a,(STRENGTHPOINTER)
	ld (ENEMY2STR),a	;; loads ENEMY 2's strength
	ld a,(XPPOINTER)
	ld (ENEMY2XP),a
	ld de,$3340
   	ld hl,(ENEMY2)      	
             call DISPSTRING     
	RET

BIGERASE:
	ld de,$2C40		
             ld hl,BLANKTEXT
             call DISPSTRING     
	LD de,$0D0D		
             ld hl,BLANKTEXT
             call DISPSTRING     
	LD de,$130D		
            	ld hl,BLANKTEXT
            	call DISPSTRING     
	LD de,$190D		
            	ld hl,BLANKTEXT
            	call DISPSTRING     
	LD de,$1F0D
            	ld hl,BLANKTEXT
           	call DISPSTRING     
	ld a,(MAGICHK)
	cp 3
	JUMP_Z(BIGERASEDONEM)
	JUMP_(BIGERASEDONE)
ERASEENEMY:
	CALL_(REVERSAL)
	ld a,(WHOTOATTACK)
	cp 1
	jr z,ERASE1	
	ld hl,(ENEMYKILLED2) 
	ld bc,$1A1A	
	CALL_(drawit2)
	ld de,$3340		
            	ld hl,BLANKTEXT
            	call DISPSTRING     
	CALL_(ENDREVERSAL)
	RET
ERASE1:
	ld hl,(ENEMYKILLED)
	ld bc,$0D0D	
	CALL_(drawit2)
	ld de,$2C40		
            	ld hl,BLANKTEXT
            	call DISPSTRING     
	CALL_(ENDREVERSAL)
	RET
ERASELEADER:
	ld a,9
	ld (CHKDFD),a
ERASELDRLOOP:
	ld l,9
	ld a,(CHKDFD)
	ld h,a
	ld ($8252),hl
           	ld hl,BLANKTEXT
            	ROM_CALL(D_ZM_STR)
	call CR_GRBCopy
	ld l,23
	ld a,(CHKDFD)
	ld h,a
	ld ($8252),hl
           	ld hl,BLANKTEXT
            	ROM_CALL(D_ZM_STR)
	call CR_GRBCopy
	ld a,(CHKDFD)
	inc a
	inc a
	ld (CHKDFD),a
	cp 39
	jr nz,ERASELDRLOOP
	JUMP_(ALLENEMYDEAD)

DISPALLHP:
	ld de,$3819                    
            	ld hl,BLANKLIFE
            	call DISPSTRING
	LD DE,$381A		
	ld a,(HPI)		
	CALL_(DISPHL)		
	ld de,$382D
           	ld hl,BLANKLIFE
            	call DISPSTRING
	LD DE,$382E
	ld a,(HPD)	
	CALL_(DISPHL)
	RET
ERASEDARQ:
	CALL_(REVERSAL)
	ld bc,$174A	
	ld hl,DARQ1	
	CALL_(drawit2)
	ld bc,$1F4A	
	ld hl,DARQ2
	CALL_(drawit2)
	ld bc,$1D52	
	ld hl,DARQ3
	CALL_(drawit2)
	ld b,73
	ld c,26
	CALL_(ChangePixel)
	ld b,82
	ld c,26
	CALL_(ChangePixel)
	CALL_(ENDREVERSAL)
	RET
ERASEISIS:
	CALL_(REVERSAL)
	ld bc,$044A	
	ld hl,ISIS1	
	CALL_(drawit2)
	ld bc,$0C4A	
	ld hl,ISIS2
	CALL_(drawit2)
	ld bc,$0952	
	ld hl,ISIS3
	CALL_(drawit2)
	CALL_(ENDREVERSAL)
	RET
GAMEOVER:
	ld a,(SCENARIO)
	cp 4
	jr z,NEWWORLD
	ld de,$0103
   	ld hl,YOULOSE         
          	call DISPSTRING     
	call WaitKey
	JUMP_(EXIT)	
NEWWORLD:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,weaklings
	ROM_CALL(D_ZT_STR)
	call WaitKey	
	ld hl,3
	ld ($800C),hl
	ld hl,thanx
	ROM_CALL(D_ZT_STR)
	call WaitKey
	ROM_CALL(CLEARLCD)
	ld a,31
	ld (ROOM),a	
	ld a,5
	ld (SCENARIO),a
SWITCHWORLDS:	
	CALL_(TIMEDISTORT)
	CALL_(DRAWWALLS)
	ld a,(HPIMAX)
	ld (HPI),a
	ld a,(HPDMAX)
	ld (HPD),a
	ld a,12
	ld (DOTY),a
	ld (COUNTER),a
	ld a,36
	ld (DOTX),a	
	ld hl,UP
	ld (Save),hl
	CALL_(moveit)
	CALL_(CHESTRESET)
	JUMP_(RELOADROOM)
TIMEDISTORT:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,time
	ROM_CALL(D_ZT_STR)
	CALL_(DELAY)
	CALL_(DELAY)	
	ld hl,$AFAF			;load battle screen
	CALL_(BG)
	CALL_(INVERTSCREEN)	
	CALL_(shake)
	CALL_(shake)
	RET
CHESTRESET:
	xor a
	ld (CHEST1),a
	ld (CHEST2),a
	ld (CHEST3),a
	ld (CHEST4),a	
	RET
DRAWIATTACK2:
	CALL_(REVERSAL)
	ld bc,$0547	
	ld hl,ATTACKINUMBER2	
	CALL_(drawit2)
	ld b,83
	ld c,48
	CALL_(ChangePixel)
	ld b,82
	ld c,49
	CALL_(ChangePixel)
	CALL_(ENDREVERSAL)
	xor a
	RET
DRAWIATTACK:
	CALL_(REVERSAL)
	ld bc,$0745	
	ld hl,ISISATTACK	
	CALL_(drawit2)
	CALL_(ENDREVERSAL)
	RET
DRAWDATTACK:
	CALL_(REVERSAL)
	ld bc,$1B41	
	ld hl,DARQATTACK	
	CALL_(drawit2)
	ld bc,$1C49	
	ld hl,DARQATTACK2	
	CALL_(drawit2)
	ld b,82
	ld c,27
	CALL_(ChangePixel)
	ld b,82
	ld c,26
	CALL_(ChangePixel)
	ld b,81
	ld c,26
	CALL_(ChangePixel)
	CALL_(ENDREVERSAL)
	RET
INVERTSCREEN:
	xor a
	ld (CHKDFD),a
	ld      bc,768
	ld      hl,GRAPH_MEM
invloop:
	ld      a,(hl)
	cpl
	ld      (hl),a
	inc     hl
	dec     bc
	ld      a,b
	or      c
	jr      NZ,invloop
	call CR_GRBCopy
	RET
DISPDAMAGE:
	ld a,(CHKDFD)
	ld DE,$0103
	CALL_(DISPHL)		
	ld de,$0110
   	ld hl,DAMAGE         
             call DISPSTRING     
	CALL_(DELAY)	
	CALL_(ERASETEXT)
	RET
HPOVERMAXD:
	ld a,(HPDMAX)
	ld c,a
	ld a,(HPD)
	sub c
	jr nc,HAIDESUNE
	RET
HAIDESUNE:
	ld a,(HPDMAX)
	ld (HPD),a
	RET
MPOVERMAXD:
	ld a,(MPDMAX)
	ld c,a
	ld a,(DARQMP)
	sub c
	jr nc,MAIDESUNE
	RET
MAIDESUNE:
	ld a,(MPDMAX)
	ld (DARQMP),a
	RET

HPOVERMAXI:
	ld a,(HPIMAX)
	ld c,a
	ld a,(HPI)
	sub c
	jr nc,HAIIDESUNE
	RET
HAIIDESUNE:
	ld a,(HPIMAX)
	ld (HPI),a
	RET

MPOVERMAXI:
	ld a,(MPIMAX)
	ld c,a
	ld a,(ISISMP)
	sub c
	jr nc,MAIIDESUNE
	RET
MAIIDESUNE:
	ld a,(MPIMAX)
	ld (ISISMP),a
	RET

shake:
	ld      b,3
shakeloop:
	push    bc
	ld      a,42h
	out     (10h),a
	CALL_(DELAY4)
	ld      a,40h
	out     (10h),a
	CALL_(DELAY4)
	pop     bc
	djnz    shakeloop
	RET
LEVELUPORNOT:
	ld a,1
	ld (WHOTOATTACK),a
	ld hl,(DARQXP)
	ld (XPCHECK),hl
	ld a,(DARQLVL)
	jr LVLCHK
ISISLVLCHK:
	xor a
	ld (WHOTOATTACK),a
	ld hl,(ISISXP)
	ld (XPCHECK),hl
	ld a,(ISISLVL)
LVLCHK:
	cp 1
	jr z,LEVEL1CHK
	cp 2
	jr z,LEVEL2CHK
	cp 3
	JUMP_Z(LEVEL3CHK)
	cp 4
	JUMP_Z(LEVEL4CHK)
	cp 5
	JUMP_Z(LEVEL5CHK)
	cp 6
	JUMP_Z(LEVEL6CHK)
	cp 7
	JUMP_Z(LEVEL7CHK)
	cp 8
	JUMP_Z(LEVEL8CHK)
	cp 9
	JUMP_Z(LEVEL9CHK)
	cp 10
	JUMP_Z(LEVEL10CHK)
	cp 11
	JUMP_Z(LEVEL10CHK)
	cp 12
	JUMP_Z(LEVEL10CHK)
	cp 13
	JUMP_Z(LEVEL10CHK)
	cp 14
	JUMP_Z(LEVEL10CHK)
	RET
LEVEL1CHK:
	ld hl,(XPCHECK)
	ld de,80
	and a
	sbc hl,de
	jp nc,ENDLVL
	JUMP_(NOLEVEL)
LEVEL2CHK:
	ld hl, (XPCHECK)
	ld de,300
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL3CHK:
	ld hl, (XPCHECK)
	ld de,650
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL4CHK:
	ld hl,(XPCHECK)
	ld de,1600
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL5CHK:
	ld hl,(XPCHECK)
	ld de,2450
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL6CHK:
	ld hl,(XPCHECK)
	ld de,3800
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL7CHK:
	ld hl,(XPCHECK)
	ld de,6000
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL8CHK:
	ld hl,(XPCHECK)
	ld de,10000
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL9CHK:
	ld hl,(XPCHECK)
	ld de,14000
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL10CHK:
	ld hl,(XPCHECK)
	ld de,20000
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL11CHK:
	ld hl,(XPCHECK)
	ld de,24000
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL12CHK:
	ld hl,(XPCHECK)
	ld de,30000
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL13CHK:
	ld hl,(XPCHECK)
	ld de,35000
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
LEVEL14CHK:
	ld hl,(XPCHECK)
	ld de,40000
	and a
	sbc hl,de
	JUMP_NC(ENDLVL)
	JUMP_(NOLEVEL)
ENDLVL:
	ROM_CALL(CLEARLCD)
	ld a,(WHOTOATTACK)
	or a
	jr z,ISISUP
DARQUP:
	ld a,(DARQLVL)
	add a,6
	ld (CHKDFD),a
	ld c,a
	ld a,(HPDMAX)
	add a,c
	ld (HPDMAX),a
	ld (HPD),a
	ld a,(CHKDFD)
	ld c,a
	ld a,(MPDMAX)
	add a,c
	ld (MPDMAX),a
	ld (DARQMP),a
	ld a,(STRENGTHD)
	inc a
	inc a
	ld (STRENGTHD),a
	ld a,(DEFENDD)
	inc a
	inc a
	ld (DEFENDD),a
	ld a,(DARQLVL)
	inc a
	ld (DARQLVL),a
	ld hl,0
	ld ($800C),hl
	ld hl,darq
	ROM_CALL(D_ZT_STR)
	jr OKLVLUP
ISISUP:
	ld a,(ISISLVL)
	add a,6
	ld (CHKDFD),a
	ld c,a
	ld a,(HPIMAX)
	add a,c
	ld (HPIMAX),a
	ld (HPI),a
	ld a,(CHKDFD)
	ld c,a
	ld a,(MPIMAX)
	add a,c
	ld (MPIMAX),a
	ld (ISISMP),a
	ld a,(STRENGTHI)
	inc a
	inc a
	ld (STRENGTHI),a
	ld a,(DEFENDI)
	inc a
	inc a
	ld (DEFENDI),a
	ld a,(ISISLVL)
	inc a
	ld (ISISLVL),a
	ld hl,0
	ld ($800C),hl
	ld hl,isis
	ROM_CALL(D_ZT_STR)
OKLVLUP:
	ld hl,$0001
	ld ($800C),hl
	ld hl,hasgainedlvl
	ROM_CALL(D_ZT_STR)
             call WaitKey
NOLEVEL:
	ld a,(WHOTOATTACK)
	or a
	jp nz,ISISLVLCHK
	RET
DEATHGRAP:
	ld de,$1128	
	ld hl,SPELLDEATH	
	ld c,14
	CALL_(drawbig2)
	ld de,$1130	
	ld hl,SPELLDEATH2	
	ld c,14
	CALL_(drawbig2)
	RET
DRAWANGEL:
	ld de,$0F26
	ld hl,SPELLLIFE	
	ld c,23
	CALL_(drawbig2)	
	ld de,$0F2E	
	ld hl,SPELLLIFE2	
	ld c,23
	CALL_(drawbig2)
	ld de,$0F36	
	ld hl,SPELLLIFE3	
	ld c,23
	CALL_(drawbig2)
	RET

;------------------------------------
;Building Check (Press Mode to Enter)
;------------------------------------


BUILDINGCHK:
	ld a,(DUNGEON)
	or a
	JUMP_NZ(DUNGEONCHK)
	ld a,(ROOM)
	cp 1
	JUMP_Z(KING)
	cp 5
	JUMP_Z(TOWN)
	cp 33
	JUMP_Z(TOWN)	
	cp 41
	JUMP_Z(TOWN)	
	cp 3
	jr z,WEAPONS
	cp 30
	jr z,WEAPONS
	cp 40
	jr z,WEAPONS
	cp 7
	JUMP_Z(CAVE1)
	cp 43
	JUMP_Z(CAVE1)
	cp 44
	JUMP_Z(PORTALX)
	cp 32
	JUMP_Z(PORTALX)
	cp 26
	JUMP_Z(TOWERX)
	cp 159
	jr z,SWITCH159
	JUMP_(GAMELOOP)
SWITCH159:
	ld a,(DOTX)
	cp 68
	JUMP_Z(KING)
	JUMP_(TOWN)
WEAPONS:
	ld a,(DOTX)
	cp 20
	JUMP_NZ(GAMELOOP)
	ld a,(DOTY)
	cp 12
	JUMP_NZ(GAMELOOP)	
BEGINWPNARMR:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,wpnshoptext
	set 3,(IY+05)
	ROM_CALL(D_ZT_STR)
	ld hl,2
	ld ($800C),hl
	ld hl,wpnshoptext2
	res 3,(IY+05)
	ROM_CALL(D_ZT_STR)
WPNSHOPLOOP:
	call GET_KEY
                    cp G_2
                    JUMP_Z(BUYARMOR)
                    cp G_1
                    JUMP_Z(BUYWEAPON)
                    cp G_3
                    JUMP_Z(DONEBUILD)
                    jr WPNSHOPLOOP
BUYARMOR:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,uparmor
	ROM_CALL(D_ZT_STR)
	ld a,2 ;; 2==Player is buying Armor
	ld (CHKDFD),a	
	jr BUYDONE
BUYWEAPON:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,upweapon
	ROM_CALL(D_ZT_STR)
	ld a,1 ;; 1==Player is buying Weapon
	ld (CHKDFD),a	
BUYDONE:
	CALL_(YOURGOLD)
	ld hl,2
	ld ($800C),hl
	ld hl,wpnshoptext4
	ROM_CALL(D_ZT_STR)
WPNSHOPLOOP2:
	call GET_KEY
             cp G_2
             JUMP_Z(WAFORDARQ)
             cp G_1
             JUMP_Z(WAFORISIS)
             cp G_3
             JUMP_Z(BEGINWPNARMR)
             jr WPNSHOPLOOP2
WAFORDARQ:
	ld hl,(GOLD)
	ld de, 60
	and a
	sbc hl, de
	JUMP_C(NEEDGOLD)	
	ld (GOLD),hl
	CALL_(THANKYOU)
	ld a,(CHKDFD)
	cp 1
	jr z,WEAPONBOUGHTD
	ld a,(DEFENDD)
	add a,3		
	ld (DEFENDD),a
	JUMP_(BEGINWPNARMR)
WEAPONBOUGHTD:
	ld a,(STRENGTHD)	
	add a,3		
	ld (STRENGTHD),a	
	JUMP_(BEGINWPNARMR)
WAFORISIS:
	ld hl,(GOLD)
	ld de, 60
	and a
	sbc hl, de
	JUMP_C(NEEDGOLD)	
	ld (GOLD),hl
	CALL_(THANKYOU)
	ld a,(CHKDFD)
	cp 1
	jr z,WEAPONBOUGHTI
	ld a,(DEFENDI)
	add a,3		
	ld (DEFENDI),a
	JUMP_(BEGINWPNARMR)
WEAPONBOUGHTI:
	ld a,(STRENGTHI)	
	add a,3		
	ld (STRENGTHI),a	
	JUMP_(BEGINWPNARMR)
NEEDGOLD:
	ld hl,0
	ld ($800C),hl
	ld hl,youneedg
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	JUMP_(BEGINWPNARMR)
THANKYOU:
	ROM_CALL(CLEARLCD)
	ld hl,3
	ld ($800C),hl
	ld hl,thankmessage
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	RET
KING:
	ld a,(DOTX)
	cp 68
	JUMP_NZ(GAMELOOP)
	ld a,(DOTY)
	cp 36
	JUMP_NZ(GAMELOOP)	
	ld a,(ROOM)
	cp 159
	jr nz,NOTENDOFGAME
	ld a,160
	JUMP_(DUNGEONJUMP)
NOTENDOFGAME:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,throne
	set 3,(IY+05)
	ROM_CALL(D_ZT_STR)
	res 3,(IY+05)
	ld a,(SCENARIO)
	cp 3
	jr z,(MIDGAMECHANGE)
	ld hl,$0002
	ld ($800C),hl
	ld hl,kingsays
	ROM_CALL(D_ZT_STR)
             call WaitKey
DONEBUILD:
	call CR_GRBCopy	
	jp MOVELEFT
MIDGAMECHANGE:
	ld hl,$0002
	ld ($800C),hl
	ld hl,kingsays1
	ROM_CALL(D_ZT_STR)
             call WaitKey
	CALL_(DRAWWALLS)
	ld bc,$1E02
	ld hl,HANDp1
	CALL_(drawit2)
	ld de,$1C0A
	ld hl,HANDp2
	ld c,11
	CALL_(drawbig2)
	ld de,$1C12
	ld hl,HANDp3
	ld c,11
	CALL_(drawbig2)
	ld de,$1922
	ld hl,CRYSTAL
	ld c,18
	CALL_(drawbig2)
	ld de,$0608
   	ld hl,kingattacks         
             call DISPSTRING     
	call WaitKey
	ld de,$0E0B
   	ld hl,kingattacks2         
             call DISPSTRING     
	call WaitKey
	ld a,99
	ld (CHKDFD),a
	JUMP_(STARTBATTLE)
TOWN:
	ld a,(DOTX)
	cp 52
	JUMP_NZ(GAMELOOP)
	ld a,(DOTY)
	cp 28
	JUMP_NZ(GAMELOOP)
TOWNSTART:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	set 3,(IY+05)
	ld a,(ROOM)
	cp 33
	jr z,(TOWN2NAME)
	cp 41
	jr z,(TOWN3NAME)
	cp 159
	jr z,(TOWN4NAME)
	ld hl,nameoftown1
	jr NAMEDONE
TOWN2NAME:
	ld hl,nameoftown2
	jr NAMEDONE
TOWN3NAME:
	ld hl,nameoftown3
	jr NAMEDONE
TOWN4NAME:
	ld hl,nameoftown4
NAMEDONE:
	ROM_CALL(D_ZT_STR)
	ld hl,2
	ld ($800C),hl
	ld hl,towntext1
	res 3,(IY+05)
	ROM_CALL(D_ZT_STR)
	CALL_(YOURGOLD)
TOWNLOOP:
	call GET_KEY
             cp G_1
             jr z,INN
             cp G_2
             jr z,ITEMSHOP
             cp G_3
             JUMP_Z(TALK)
	cp G_4 
             JUMP_Z(DONEBUILD)
	jr TOWNLOOP
INN:
	ld hl,(GOLD)
	ld de, 50
	and a
	sbc hl, de
	JUMP_C(NEEDGOLD2)	
	ld (GOLD),hl
	ROM_CALL(CLEARLCD)
	ld hl,3
	ld ($800C),hl
	ld hl,restored
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	ld a,(HPIMAX)
	ld (HPI),a
	ld a,(MPIMAX)
	ld (ISISMP),a
	ld a,(HPDMAX)
	ld (HPD),a
	ld a,(MPDMAX)
	ld (DARQMP),a
	JUMP_(TOWNSTART)	
ITEMSHOP:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,towntext3
	set 3,(IY+05)
	ROM_CALL(D_ZT_STR)	
	ld hl,2
	ld ($800C),hl
	ld hl,towntext2
	res 3,(IY+05)
	ROM_CALL(D_ZT_STR)
	CALL_(YOURGOLD)
TOWNLOOP2:
	call GET_KEY
                    cp G_2
                    jr z,(BUYMAGKIT)
                    cp G_1
                    jr z,BUYMEDKIT
                    cp G_3
                    JUMP_Z(TOWNSTART)
	jr TOWNLOOP2
BUYMAGKIT:
	ld hl,(GOLD)
	ld de, 30
	and a
	sbc hl, de
	jr c,NEEDGOLD2	
	ld (GOLD),hl
	ld a,(MAGIKITS)
	inc a
	ld (MAGIKITS),a
	CALL_(THANKYOU)
	JUMP_(ITEMSHOP)	
BUYMEDKIT:
	ld hl,(GOLD)
	ld de, 30
	and a
	sbc hl, de
	jr c,NEEDGOLD2	
	ld (GOLD),hl
	ld a,(MEDKITS)
	inc a
	ld (MEDKITS),a
	CALL_(THANKYOU)
	JUMP_(ITEMSHOP)	
TALK:	
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld a,(ROOM)
	cp 33
	jr z,TALK2
	cp 41
	jr z,TALK3
	cp 159
	jr z,TALK4
	ld hl,cave1
	jr TALKDONE
TALK2:
	ld hl,towntalk2
	jr TALKDONE
TALK3:
	ld hl,towntalk3
	jr TALKDONE
TALK4:
	ld hl,towntalk4
TALKDONE:
	ROM_CALL(D_ZT_STR)
	call WaitKey
	JUMP_(TOWNSTART)
NEEDGOLD2:
	ld hl,0
	ld ($800C),hl
	ld hl,youneedg
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	JUMP_(TOWNSTART)	
YOURGOLD:
	ld h,9
	ld l,7
	ld ($800C),hl
	ld hl,(GOLD)
	ROM_CALL(D_HL_DECI)
	ld hl,7
	ld ($800C),hl
	ld hl,yourg
	ROM_CALL(D_ZT_STR)
	RET
CAVE1:
	ld a,(ROOM)
	cp 43
	jr z,DUNGEON3
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,cave1
	ROM_CALL(D_ZT_STR)
	call WaitKey
	ld a,100
	jr DUNGEONJUMP
DUNGEON3:
	ld a,138
	ld (ROOM),a
	jr DUNGEONJUMP
DUNGEONJUMP:
	ld (ROOM),a	
	ld (DUNGEON),a
	CALL_(DRAWWALLS)
	ld a,52
	ld (DOTY),a
	ld (BKY),a
	ld a,44
	ld (DOTX),a	
	ld (BKX),a
	ld hl,UP
	ld (Save),hl
	CALL_(drawit)
	JUMP_(RELOADROOM)
PORTALX:
	ld a,(DOTX)
	cp 68
	JUMP_NZ(GAMELOOP)
	ld a,(DOTY)
	cp 36
	JUMP_NZ(GAMELOOP)	
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld a,(SCENARIO)
	cp 8
	jr z,PORTALX2
	cp 9
	jr z,PORTALX3
	ld hl,portal
	ROM_CALL(D_ZT_STR)
	call WaitKey
	JUMP_(DONEBUILD)		
PORTALX2: ;; warp to diff world
	ld hl,runetext5
	ROM_CALL(D_ZT_STR)
	call WaitKey
	ld a,40
	ld (ROOM),a
	JUMP_(SWITCHWORLDS)
PORTALX3: ;; warp to diff world
	ld hl,lastcrystal
	ROM_CALL(D_ZT_STR)
	call WaitKey
	ld hl,1
	ld ($800C),hl
	ld hl,thewayhome
	ROM_CALL(D_ZT_STR)
	call WaitKey
	ld a,159
	ld (ROOM),a
	CALL_(SWITCHWORLDS)
TOWERX:
	ld a,(DOTX)
	cp 20
	JUMP_NZ(GAMELOOP)
	ld a,(DOTY)
	cp 12
	JUMP_NZ(GAMELOOP)	
	ld a,(SCENARIO)
	cp 5
	JUMP_NZ(TOWERSTART)
TALKRUNE:
	ld a,6
	ld (SCENARIO),a	
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,runetext
	ROM_CALL(D_ZT_STR)
	call WaitKey	
	ld hl,3
	ld ($800C),hl
	ld hl,runetext2
	ROM_CALL(D_ZT_STR)
	call WaitKey	
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,runetext3
	ROM_CALL(D_ZT_STR)
	call WaitKey	
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,runetext4
	ROM_CALL(D_ZT_STR)
	call WaitKey	
TOWERSTART:
	ld a,124
	JUMP_(DUNGEONJUMP)
DUNGEONCHK:
	ld a,(ROOM)
	cp 112
	JUMP_Z(CHESTX)	
	cp 110
	JUMP_Z(CHESTX)	
	cp 108
	JUMP_Z(CHESTX)	
	cp 114
	JUMP_Z(CHESTX)	
	cp 121
	JUMP_Z(CHESTX)	
	cp 128
	JUMP_Z(CHESTX)	
	cp 130
	JUMP_Z(CHESTX)	
	cp 132
	JUMP_Z(CHESTX)	
	cp 140
	JUMP_Z(CHESTX)	
	cp 145
	JUMP_Z(CHESTX)	
	cp 153
	JUMP_Z(CHESTX)	
STAIRWAY:
	ld a,(DOTX)
	cp 52
	JUMP_NZ(GAMELOOP)
	ld a,(DOTY)
	cp 28
	JUMP_NZ(GAMELOOP)
	ld a,(ROOM)
	cp 105
	jr z,(switch105)
	cp 104
	jr z,(switch104)
	cp 106
	jr z,(switch106)
	cp 115
	jr z,(switch115)
	cp 126
	jr z,(switch126)
	cp 123
	jr z,(switch123)
	cp 129
	jr z,(switch129)
	cp 131
	jr z,(switch131)
	cp 136
	jr z,(switch136)
	cp 137
	jr z,(switch137)
	cp 139
	jr z,(switch139)
	cp 143
	jr z,(switch143)
	cp 152
	jr z,(switch152)
	cp 148
	jr z,(switch148)
	cp 151
	jr z,(switch151)
	cp 155
	jr z,(switch155)
	JUMP_(GAMELOOP)
switch104:
	ld a,115
	jr STAIREND
switch105:
	ld a,106
	jr STAIREND
switch106:
	ld a,105
	jr STAIREND
switch115:
	ld a,104
	jr STAIREND
switch126:
	ld a,129
	jr STAIREND
switch123:
	ld a,131
	jr STAIREND
switch129:
	ld a,126
	jr STAIREND
switch131:
	ld a,123
	jr STAIREND
switch136:
	ld a,143
	jr STAIREND
switch137:
	ld a,152
	jr STAIREND
switch139:
	ld a,148
	jr STAIREND
switch143:
	ld a,136
	jr STAIREND
switch148:
	ld a,139
	jr STAIREND
switch152:
	ld a,137
	jr STAIREND
switch151:
	ld a,155
	jr STAIREND
switch155:
	ld a,151
	jr STAIREND
STAIREND:
	ld (ROOM),a
	CALL_(DRAWWALLS)
	ld a,28
	ld (DOTY),a
	ld (BKY),a
	ld a,44
	ld (DOTX),a	
	ld (BKX),a
	ld hl,UP
	ld (Save),hl
	CALL_(drawit)
	JUMP_(RELOADROOM)
CHESTX:
	ld a,(DOTX)
	cp 68
	JUMP_NZ(GAMELOOP)
	ld a,(DOTY)
	cp 20
	JUMP_NZ(GAMELOOP)
	ld a,(ROOM)
	cp 112	
	jr z,chest1x
	cp 110
	jr z,chest2x
	cp 108
	jr z,chest3x
	cp 114
	jr z,chest4x
	cp 121
	jr z,chest1x
	cp 128
	jr z,chest2x 
	cp 130
	jr z,chest3x
	cp 132
	jr z,chest4x	
	cp 140
	jr z,chest1x
	cp 145
	jr z,chest2x 
	cp 153
	jr z,chest3x
chest1x:
	ld a,(CHEST1)
	or a
	JUMP_NZ(GAMELOOP)
	ld a,1
	ld (CHEST1),a
	JUMP_(CHESTFOUND)
chest2x:
	ld a,(CHEST2)
	or a
	JUMP_NZ(GAMELOOP)
	ld a,1
	ld (CHEST2),a
	JUMP_(CHESTFOUND)
chest3x:
	ld a,(CHEST3)
	or a
	JUMP_NZ(GAMELOOP)
	ld a,1
	ld (CHEST3),a
	JUMP_(CHESTFOUND)
chest4x:
	ld a,(CHEST4)
	or a				
	JUMP_NZ(GAMELOOP)
	ld a,1
	ld (CHEST4),a
	ld a,(SCENARIO)
	inc a
	ld (SCENARIO),a
CHESTKEY:	
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,youfind
	ROM_CALL(D_ZT_STR)
	ld hl,1
	ld ($800C),hl
	ld hl,BLANKKEY
	ROM_CALL(D_ZT_STR)
	JUMP_(ITSFOUND)

CHESTFOUND:	
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,youfind
	ROM_CALL(D_ZT_STR)
RANDTREASURE:
  ld a,r
  srl a
  and 3   
  or a
  jr z,RANDTREASURE	
	cp 1
	jr z,FGOLD
	cp 2
	jr z,FITEM
	cp 3
	jr z,FSCROLL
FSCROLL
	ld hl,1
	ld ($800C),hl
	ld hl,BLANKSCROLL
	ROM_CALL(D_ZT_STR)
	ld a,(ISISLVL)
	ld b,a
	ld hl,0
	ld de,30
MULTLOOPXP:
	add hl,de	
	djnz MULTLOOPXP
	push hl
	ld bc,(DARQXP)
	add hl,bc
	ld (DARQXP),hl
	pop hl
	ld bc,(ISISXP)
	add hl,bc
	ld (ISISXP),hl
	JUMP_(ITSFOUND)
FITEM:
	ld hl,1
	ld ($800C),hl
	ld hl,BLANKITEM
	ROM_CALL(D_ZT_STR)
	ld a,(MEDKITS)
	inc a
	ld (MEDKITS),a
  ld a,r
  srl a
  and 3   
  cp 2
  jr nz,(ITSFOUND)
	ld a,(MAGIKITS)
	inc a
	ld (MAGIKITS),a
	ld hl,2
	ld ($800C),hl
	ld hl,BLANKITEM2
	ROM_CALL(D_ZT_STR)
	jr ITSFOUND
FGOLD:
	ld hl,1
	ld ($800C),hl
	ld hl,BLANKGOLD
	ROM_CALL(D_ZT_STR)
	ld a,(ISISLVL)
	ld b,a
	ld hl,0
	ld de,30
MULTLOOPGOLD:
	add hl,de	
	djnz MULTLOOPGOLD
	ld bc,(GOLD)
	add hl,bc
	ld (GOLD),hl
	CALL_(YOURGOLD)
ITSFOUND:
	call WaitKey	
	CALL_(DRAWWALLS)
	ld a,20
	ld (DOTY),a
	ld (BKY),a
	ld a,68
	ld (DOTX),a	
	ld (BKX),a
	ld hl,UP
	ld (Save),hl
	CALL_(drawit)
	JUMP_(RELOADROOM)

;------------------
; Sprite Stuff....
;------------------

moveit:
	ld (Save), HL
        ld 	a,(DOTY)
	ld      e,a       	 ; Load the y-coordinate in e
	ld      a,(DOTX)	 ; Load the x-coordinate in a

DRWSPR:
        push    hl              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
        add     hl,de
        add     hl,de
        add     hl,de
        add     hl,hl
        add     hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,GRAPH_MEM
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp      0               ; Is this sprite aligned to 8*n,y?
        jr      z,ALIGN

;   Non aligned sprite blit starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,8             ; Line loop
LILOP:  ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP:  srl     b
        rr      c
        dec     d
        jr      nz,SHLOP
        pop     de

	ld      a,b             ; Write line to graphbuf
        xor      (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        xor       (hl)
        ld      (hl),a
        ld      bc,11           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jr      nz,LILOP        ; Next line
        jr DONE5

;   Aligned sprite blit starts here   

ALIGN:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP1:  

	ld      a,(de)
	xor      (hl)
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,12
        add     hl,bc
        pop     bc
        djnz    ALOP1
DONE5:
	ld	c,a
	ld	a,e
	add	a,1
	ld	e,a
	ld	a,c
	add	a,1
        call CR_GRBCopy
	RET
drawit2:
	ld (BKX),bc
drawit:
        ld a,(BKY)
	ld      e,a       	 ; Load the y-coordinate in e
	ld      a,(BKX)	 ; Load the x-coordinate in a
    	push	af
	push	bc
	push	de
	push	hl

DRWSPR2:
        push    hl              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
        add     hl,de
        add     hl,de
        add     hl,de
        add     hl,hl
        add     hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,GRAPH_MEM
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp      0               ; Is this sprite aligned to 8*n,y?
        jr      z,ALIGN2


;   Non aligned sprite blit starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,8             ; Line loop
LILOP2:  ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP2:  srl     b
        rr      c
        dec     d
        jr      nz,SHLOP2
        pop     de
	ld      a,b             ; Write line to graphbuf
        xor      (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        xor      (hl)
        ld      (hl),a
        ld      bc,11           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jr      nz,LILOP2        ; Next line
	jr      DONE2

;   Aligned sprite blit starts here   

ALIGN2:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP2:  
	ld      a,(de)
	xor      (hl)
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,12
        add     hl,bc
        pop     bc
        djnz    ALOP2
DONE2:
	pop	de
	pop	bc
	pop	af
	pop 	hl
	ld	c,a
	ld	a,e
	add	a,1
	ld	e,a
	ld	a,c
	add	a,1
        call CR_GRBCopy
	RET

PutPixel:		;changes the pixel at b, c
	call FIND_PIXEL
	ld de, GRAPH_MEM
	add hl, de
	or (hl)
	ld (hl), a
        	call CR_GRBCopy
	RET

RemovePixel:		;Removes the pixel at b, c
	call FIND_PIXEL
	ld de, GRAPH_MEM
	add hl, de
	cpl
	and (hl)
	ld (hl), a
                    call CR_GRBCopy
	RET
ChangePixel:
	call FIND_PIXEL
	ld de, GRAPH_MEM
	add hl, de
	xor (hl)
	ld (hl), a
                    call CR_GRBCopy
	RET
DISPHL:
	ld l,a
	ld h,0
DM_HL_DECI:
  ld   ($8252),de          ;Since DE is a word, it overlaps into 8216
  ld b,48                  ; 48 -> b
  ld c,4                   ; 4 -> c
  ld a,h                   ; h -> a
  or l                     ; If a=0 and l=0, then return zero
  jr z,DM_HL_3             ; If zero, then jump to DM_HL_3
  ld c,-1                  ; -1 -> c
  ld b,46                  ; 46 -> b
  jr DM_HL_NEXT2           ; Jump to DM_HL_NEXT2
DM_HL_INIT:
  call CP_HL_DE            ; cp hl,de
  jr c,DM_HL_NEXT2         ; If carry, then jump to DM_HL_NEXT2
  dec c                    ; c = c - 1
DM_HL_NEXT:
  ld b,47                  ; 47 -> b
DM_HL_NEXT2:
  inc c                    ; c = c + 1
  ld a,c                   ; c -> a
  or a                     ; If a=0, then return zero
  ld de,10000              ; 10000 -> de
  jr z,DM_HL_2a            ; If zero, then jump to DM_HL_2a
  cp 1                     ; If a=1, then return zero
  ld de,1000               ; 1000 -> de
  jr z,DM_HL_2a            ; If zero, then jump to DM_HL_2a
  cp 2                     ; If a=2, then return zero
  ld de,100                ; 100 -> de
  jr z,DM_HL_2a            ; If zero, then jump to DM_HL_2a
  cp 3                     ; If a=3, then return zero
  ld de,10                 ; 10 -> de
  jr z,DM_HL_2a            ; If zero, then jump to DM_HL_2a
  ld de,1                  ; 1 -> de
DM_HL_2a:
  ld a,b                   ; b -> a
  cp 46                    ; If a=46, then return zero
  jr z,DM_HL_INIT          ; If zero, then jump to DM_HL_INIT
DM_HL_2b:
  inc b                    ; b = b + 1
  call CP_HL_DE            ; cp hl,de
  jr c,DM_HL_3             ; If carry, then jump to DM_HL_3
  or a                     ; Reset carry flag
  sbc hl,de                ; hl = hl - de
  jr DM_HL_2b              ; Jump to DM_HL_2b
DM_HL_3:
  ld a,b                   ; b -> a
  ROM_CALL(M_CHARPUT)      ; Display the character
  ld a,c                   ; c -> a
  cp 4                     ; If a=4, then return zero
  jr nz,DM_HL_NEXT         ; If not zero, then jump to DM_HL_NEXT
  call CR_GRBCopy
  ret                      ; return to caller


;-----------------------
;load spaces in walls
;-----------------------

BORDERUP:
	ld a,1
	ld (UP1),a	
	ld bc,$002C
	ld hl,BLANK
	CALL_(drawit2)
	RET
BORDERDOWN:
	ld a,1
	ld (DOWN),a
	ld bc,$3E2C
	ld hl,BLANK
	CALL_(drawit2)
	RET
BORDERLEFT:
	ld a,1
	ld (LEFT),a
	ld bc,$1C00		
	ld hl,BLANK3
	CALL_(drawit2)
	RET
BORDERRIGHT:
	ld a,1
	ld (RIGHT),a
	ld bc,$1C58
	ld hl,BLANK2
	CALL_(drawit2)
	RET
drawbig2:
	ld (BKX),de
drawbig:
	ld a,(BKY)
	ld      e,a
	ld      a,(BKX)
	push	af
	push	bc
	push	de
	push	hl
DRWSPRX:
        	push    hl              ; Save sprite address
        	ld      hl,0            ; Do y*12
       	ld      d,0
        	add     hl,de
        	add     hl,de
        	add     hl,de
       	add     hl,hl
       	add     hl,hl
       	ld      d,0             ; Do x/8
       	ld      e,a
        	srl     e
        	srl     e
        	srl     e
        	add     hl,de
       	ld      de,GRAPH_MEM
        	add     hl,de           ; Add address to graphbuf
        	ld      b,00000111b     ; Get the remainder of x/8
        	and     b
        	cp      0               ; Is this sprite aligned to 8*n,y?
        	jr      z,ALIGNX
        	pop     ix              ; ix->sprite
        	ld      d,a             ; d=how many bits to shift each line
        	ld      e,c             ; Line loop
LILOPX:  	
	ld      b,(ix+0)        ; Get sprite data
        	ld      c,0             ; Shift loop
        	push    de
SHLOPX:  
	srl     b
        	rr      c
        	dec     d
        	jr      nz,SHLOPX
        	pop     de
	ld      a,b             ; Write line to graphbuf
       	xor      (hl)
        	ld      (hl),a
        	inc     hl
        	ld      a,c
        	xor      (hl)
        	ld      (hl),a
        	ld      bc,11           ; Calculate next line address
        	add     hl,bc
        	inc     ix              ; Inc spritepointer
        	dec     e
        	jr      nz,LILOPX        ; Next line
        	jr      DONEX
ALIGNX:                          ; Blit an aligned sprite to graphbuf
        	pop     de              ; de->sprite
        	ld      b,c
ALOPX:
	ld      a,(de)
	xor      (hl)
        	ld      (hl),a
        	inc     de
        	push    bc
        	ld      bc,12
        	add     hl,bc
        	pop     bc
        	djnz    ALOPX
DONEX: 
        	pop	de
        	pop	bc
        	pop	af
        	pop 	hl
       	ld	c,a
        	ld	a,e
        	add	a,1
        	ld	e,a
        	ld	a,c
        	add	a,1
       	call CR_GRBCopy
        	RET
ERASETEXT:
            	LD de,$0103		
            	ld hl,BLANKTEXT
            	call DISPSTRING    
	LD de,$011E		
            	ld hl,BLANKTEXT 
            	call DISPSTRING
	RET

EXIT:
      res     4,(IY+9)
      res     2,(iy+2)
	RET
BG:
	ld	de,GRAPH_MEM
	ld	bc,768
	ldir
	call CR_GRBCopy 		; Copy graphbuf to LCD
	ret
;---------------------
;Building Draws
;---------------------
BUILDINGDRAWS:
	ld a,(DUNGEON)
	or a
	JUMP_NZ(DUNGEONDRAWS)
	ld a,(ROOM)
	cp 7
	jr z,DRAWCAVE
	cp 43
	jr z,DRAWCAVE
	cp 3
	jr z,DRAWWPNSHOP
	cp 30
	jr z,DRAWWPNSHOP
	cp 40
	jr z,DRAWWPNSHOP
	cp 5
	jr z,DRAWTOWN
	cp 33
	jr z,DRAWTOWN
	cp 41 
	jr z,DRAWTOWN
	cp 1
	jr z,DRAWCASTLE
	cp 159
	jr z,DRAW159
	cp 32
	jr z,DRAWPORTAL
	cp 44
	jr z,DRAWPORTAL
	cp 26
	jr z,DRAWTOWER
	RET
DRAWCASTLE:
	ld bc,$2444
	ld hl,CASTLE
	CALL_(drawit2)	
	RET
DRAWWPNSHOP:
	ld bc,$0C14
	ld hl,WPNSHOP
	CALL_(drawit2)	
	RET
DRAWTOWN:
	ld bc,$1C34
	ld hl,TOWNPIC
	CALL_(drawit2)	
	RET
DRAWCAVE:
	ld bc,$040C
	ld hl,CAVE
	CALL_(drawit2)	
	RET
DRAWPORTAL:
	ld bc,$2444
	ld hl,PORTAL
	CALL_(drawit2)	
	RET
DRAWTOWER:
	ld bc,$0C14
	ld hl,TOWER
	CALL_(drawit2)	
	RET
DRAW159:
	CALL_(DRAWCASTLE)
	CALL_(DRAWTOWN)
	RET
DUNGEONDRAWS:
	ld a,(ROOM)	
	cp 105
	jr z,STAIRS	
	cp 106
	jr z,STAIRS	
	cp 104
	jr z,STAIRS	
	cp 115
	jr z,STAIRS	
	cp 126
	jr z,STAIRS	
	cp 123
	jr z,STAIRS	
	cp 129
	jr z,STAIRS	
	cp 131
	jr z,STAIRS	
	cp 136
	jr z,STAIRS	
	cp 137
	jr z,STAIRS	
	cp 139
	jr z,STAIRS	
	cp 143
	jr z,STAIRS	
	cp 148
	jr z,STAIRS	
	cp 152
	jr z,STAIRS	
	cp 155
	jr z,STAIRS	
	cp 151
	jr z,STAIRS	
	jr nostairs
STAIRS:
	ld bc,$1C34
	ld hl,STAIRZ
	CALL_(drawit2)	
	RET		
nostairs:
	cp 112
	jr z,CHESTZ112	
	cp 110
	jr z,CHESTZ110	
	cp 108
	jr z,CHESTZ108	
	cp 114
	jr z,CHESTZ114	
	cp 121
	jr z,CHESTZ112	
	cp 128
	jr z,CHESTZ110	
	cp 130
	jr z,CHESTZ108	
	cp 132
	jr z,CHESTZ114	
	cp 140
	jr z,CHESTZ112	
	cp 145
	jr z,CHESTZ110	
	cp 153
	jr z,CHESTZ108	
	RET
CHESTZ112:	
	ld a,(CHEST1)
	cp 1
	RET Z
	jr CHESTZ
CHESTZ110:	
	ld a,(CHEST2)
	cp 1
	RET Z
	jr CHESTZ
CHESTZ108:	
	ld a,(CHEST3)
	cp 1
	RET Z
	jr CHESTZ
CHESTZ114:	
	ld a,(CHEST4)
	cp 1
	RET Z
	jr CHESTZ
CHESTZ:
	ld bc,$1444
	ld hl,CHEST
	CALL_(drawit2)	
	RET		

;------------
; ROOM DRAWS
;------------

ROOM1:
	CALL_(BORDERUP)
	CALL_(BORDERDOWN)
	CALL_(BORDERRIGHT)
	CALL_(BORDERLEFT)
	JUMP_(GAMELOOP)
ROOM2:
	CALL_(BORDERUP)
	CALL_(BORDERDOWN)
	JUMP_(GAMELOOP)
ROOM3:
	CALL_(BORDERLEFT)
	JUMP_(GAMELOOP)
ROOM4:
	CALL_(BORDERUP)
	JUMP_(GAMELOOP)
ROOM5:
	CALL_(BORDERRIGHT)
	JUMP_(GAMELOOP)
ROOM6:
	CALL_(BORDERUP)
	CALL_(BORDERDOWN)
	CALL_(BORDERLEFT)
	JUMP_(GAMELOOP)	
ROOM7:
	CALL_(BORDERDOWN)
	JUMP_(GAMELOOP)
ROOM8:
	CALL_(BORDERLEFT)
	CALL_(BORDERRIGHT)
	JUMP_(GAMELOOP)
ROOM9:
	CALL_(BORDERUP)
	CALL_(BORDERDOWN)
	CALL_(BORDERRIGHT)
	JUMP_(GAMELOOP)	
ROOM12:
	CALL_(BORDERUP)
	CALL_(BORDERLEFT)
	JUMP_(GAMELOOP)	
ROOM102:
	CALL_(BORDERDOWN)
	CALL_(BORDERLEFT)
	CALL_(BORDERRIGHT)
	JUMP_(GAMELOOP)	
ROOM103:
	CALL_(BORDERDOWN)
	CALL_(BORDERLEFT)
	JUMP_(GAMELOOP)	
ROOM119:
	CALL_(BORDERUP)
	CALL_(BORDERRIGHT)
	JUMP_(GAMELOOP)	
ROOM129:
	CALL_(BORDERDOWN)
	CALL_(BORDERRIGHT)
	JUMP_(GAMELOOP)	

;-------------end of room draws----------------------

LOOM1:
	ld a,(DOTX)
	cp 84
	jr z,loom1rt
	cp 4	
	jr z,loom1lt
	ld a,(DOTY)
	cp 4
	jr z,loom1up
loom1dn:
	ld a,4
	JUMP_(LOOMTOROOM)
loom1up:
	ld a,2
	JUMP_(LOOMTOROOM)
loom1lt:
	ld a,5
	JUMP_(LOOMTOROOM)
loom1rt:
	ld a,3
	JUMP_(LOOMTOROOM)
LOOMto1:
	ld a,1
	JUMP_(LOOMTOROOM)
LOOM2:
	ld a,(DOTY)
	cp 4
	jr z,loom2up
	ld a,1
	JUMP_(LOOMTOROOM)
loom2up:
	ld a,6
	JUMP_(LOOMTOROOM)
LOOM6:
	ld a,(DOTX)
	cp 4	
	jr z,loom6lt
	ld a,(DOTY)
	cp 4
	jr z,loom6up
	ld a,2
	JUMP_(LOOMTOROOM)
loom6up:
	ld a,(SCENARIO)
	or a
	JUMP_Z(SCENARIO1)
	ld a,7
	JUMP_(LOOMTOROOM)
loom6lt:
	ld a,8
	JUMP_(LOOMTOROOM)
LOOM7:
	ld a,6
	JUMP_(LOOMTOROOM)
LOOM8:
	ld a,(DOTX)
	cp 84
	jr z,loom8rt
	ld a,9
	JUMP_(LOOMTOROOM)
loom8rt:
	ld a,6
	JUMP_(LOOMTOROOM)

LOOM9:
	ld a,(DOTY)
	cp 4
	jr z,loom9up
	cp 52
	jr z,loom9dn
	ld a,8
	JUMP_(LOOMTOROOM)
loom9up:
	ld a,11
	JUMP_(LOOMTOROOM)
loom9dn:
	ld a,10
	JUMP_(LOOMTOROOM)
		
LOOM10:
	ld a,9
	JUMP_(LOOMTOROOM)
LOOM11:
	ld a,(DOTX)
	cp 84
	jr z,loom11rt
	cp 4	
	jr z,loom11lt
	ld a,(DOTY)
	cp 4
	jr z,loom11up
	ld a,9
	JUMP_(LOOMTOROOM)
loom11up:
	ld a,14
	JUMP_(LOOMTOROOM)
loom11lt:
	ld a,15
	JUMP_(LOOMTOROOM)
loom11rt:
	ld a,12
	JUMP_(LOOMTOROOM)
LOOM12:
	ld a,(DOTX)
	cp 4
	jr z,loom12lt
	ld a,13
	JUMP_(LOOMTOROOM)
loom12lt:
	ld a,11
	JUMP_(LOOMTOROOM)
LOOM13:
	ld a,12
	JUMP_(LOOMTOROOM)
LOOMto11:
	ld a,11
	JUMP_(LOOMTOROOM)

LOOM25:
	ld a,(DOTX)
	cp 84
	jr z,loom25rt
	cp 4	
	jr z,loom25lt
	ld a,(DOTY)
	cp 4
	jr z,loom25up
loom25dn:
	ld a,28
	JUMP_(LOOMTOROOM)
loom25rt:
	ld a,32
	JUMP_(LOOMTOROOM)
loom25lt:
	ld a,27
	JUMP_(LOOMTOROOM)
loom25up:
	ld a,26
	JUMP_(LOOMTOROOM)
LOOMto25:
	ld a,25
	JUMP_(LOOMTOROOM)
LOOM28:
	ld a,(DOTY)
	cp 4
	jr z,LOOMto25
loom28rt:	
	ld a,29
	JUMP_(LOOMTOROOM)
LOOM29:
	ld a,(DOTX)
	cp 4	
	jr z,loom25dn
loom29dn:	
	ld a,30
	JUMP_(LOOMTOROOM)
LOOM30:
	ld a,(DOTY)
	cp 4
	jr z,loom28rt
loom30rt:	
	ld a,31
	JUMP_(LOOMTOROOM)
LOOM31:
	ld a,(DOTX)
	cp 4	
	jr z,loom29dn
loom31dn:	
	ld a,33
	JUMP_(LOOMTOROOM)
LOOM40:
	ld a,41
	JUMP_(LOOMTOROOM)
LOOM41:
	ld a,(DOTY)
	cp 52	
	jr z,loom41dn
loom41lt:
	ld a,42	
	JUMP_(LOOMTOROOM)
loom41dn:
	ld a,40	
	JUMP_(LOOMTOROOM)
LOOM42:
	ld a,(DOTX)
	cp 84
	jr z,LOOM40
loom42lt:
	ld a,43	
	JUMP_(LOOMTOROOM)
LOOM43:
	ld a,(DOTX)
	cp 84
	jr z,loom41lt
loom43lt:
	ld a,44	
	JUMP_(LOOMTOROOM)

LOOM100:	;; 100-120 are dungeon vars
	ld a,(DOTY)
	cp 52
	jr z,loom100dn
	ld a,101
	JUMP_(LOOMTOROOM)
loom100dn:
	ld a,7
	ld (ROOM),a
DUNGEONEXIT:
	CALL_(DRAWWALLS)
	ld a,12
	ld (DOTY),a
	ld (BKY),a
	ld a,4
	ld (BKX),a
	ld (DOTX),a
	ld hl,LT
	ld (Save),hl
	CALL_(drawit)	
	xor a
	ld (DUNGEON),a
	JUMP_(RELOADROOM)
LOOM101:
	ld a,(DOTY)
	cp 52
	jr z,loom101dn
loom101up:
	ld a,102
	JUMP_(LOOMTOROOM)
loom101dn:	
	ld a,100
	JUMP_(LOOMTOROOM)
LOOM102:
	ld a,(DOTX)
	cp 84
	jr z,loom102rt
	cp 4	
	jr z,loom102lt
	ld a,101
	JUMP_(LOOMTOROOM)
loom102lt:	
	ld a,105
	JUMP_(LOOMTOROOM)
loom102rt:
	ld a,103
	JUMP_(LOOMTOROOM)
LOOM103:
	ld a,(DOTX)
	cp 4	
	jr z,loom101up
	ld a,104
	JUMP_(LOOMTOROOM)
LOOM105:
	ld a,102
	JUMP_(LOOMTOROOM)
LOOM106:
	ld a,(DOTX)
	cp 84
	jr z,loom106rt
	cp 4	
	jr z,loom106lt
	ld a,(DOTY)
	cp 4
	jr z,loom106up
loom106dn:
	ld a,107
	JUMP_(LOOMTOROOM)
loom106up:
	ld a,111
	JUMP_(LOOMTOROOM)
loom106lt:
	ld a,113
	JUMP_(LOOMTOROOM)
loom106rt:
	ld a,109
	JUMP_(LOOMTOROOM)
LOOM109:
	ld a,(DOTX)
	cp 4
	jr z,loom109lt
	ld a,110
	JUMP_(LOOMTOROOM)
loom109lt:
	ld a,106
	JUMP_(LOOMTOROOM)
LOOM113:
	ld a,(DOTX)
	cp 84
	jr z,loom109lt
	ld a,114
	JUMP_(LOOMTOROOM)
LOOM111:
	ld a,(DOTY)
	cp 52
	jr z,loom109lt
	ld a,112
	JUMP_(LOOMTOROOM)
LOOM107:
	ld a,(DOTY)
	cp 4
	jr z,loom109lt
	ld a,108
	JUMP_(LOOMTOROOM)
LOOM115:
	ld a,116
	JUMP_(LOOMTOROOM)
LOOM116:
	ld a,(DOTY)
	cp 4
	jr z,loom116up
	ld a,115
	JUMP_(LOOMTOROOM)
loom116up:	
	ld a,117
	JUMP_(LOOMTOROOM)
LOOM117:
	ld a,(DOTY)
	cp 52
	jr z,LOOM115
loom117up:	
	ld a,118
	JUMP_(LOOMTOROOM)
LOOM118:
	ld a,(DOTY)
	cp 52
	jr z,loom116up
loom118lt:	
	ld a,119
	JUMP_(LOOMTOROOM)
LOOM119:
	ld a,(DOTX)
	cp 84
	jr z,loom117up
	ld a,(SCENARIO)
	cp 3	
	JUMP_C(SCENARIO2)	
	ld a,120
	JUMP_(LOOMTOROOM)	

LOOM124:
	ld a,(DOTY)
	cp 52
	jr z,loom124dn
loom124up:
	ld a,125
	JUMP_(LOOMTOROOM)
loom124dn:
	ld a,26
	ld (ROOM),a
	JUMP_(DUNGEONEXIT)
LOOM125:
	ld a,(DOTX)
	cp 84
	jr z,loom125rt
	cp 4	
	jr z,loom125lt
loom125dn:
	ld a,124
	JUMP_(LOOMTOROOM)
loom125rt:
	ld a,126
	JUMP_(LOOMTOROOM)
loom125lt:
	ld a,122
	JUMP_(LOOMTOROOM)
LOOM122:
	ld a,(DOTX)
	cp 84
	jr z,loom124up
	cp 4	
	jr z,loom122lt
	ld a,121
	JUMP_(LOOMTOROOM)
loom122lt:
	ld a,123
	JUMP_(LOOMTOROOM)

LOOM129:
	ld a,(DOTX)
	cp 84
	jr z,loom129rt
	ld a,130
	JUMP_(LOOMTOROOM)
loom129rt:
	ld a,128
	JUMP_(LOOMTOROOM)
LOOM131:
	ld a,(DOTX)
	cp 84
	jr z,loom131rt
	ld a,132
	JUMP_(LOOMTOROOM)
loom131rt:
	ld a,(SCENARIO)
	cp 8	
	JUMP_C(SCENARIO2)
	ld a,133
	JUMP_(LOOMTOROOM)
LOOMto129:
	ld a,129
	JUMP_(LOOMTOROOM)
LOOMto131:
	ld a,131
	JUMP_(LOOMTOROOM)
LOOM138:
	ld a,(DOTX)
	cp 84
	jr z,loom138rt
	cp 4	
	jr z,loom138lt
	ld a,(DOTY)
	cp 4
	jr z,loom138up
loom138dn:
	ld a,43
	ld (ROOM),a
	JUMP_(DUNGEONEXIT)
loom138up:
	ld a,136
	JUMP_(LOOMTOROOM)
loom138lt:
	ld a,137
	JUMP_(LOOMTOROOM)
loom138rt:
	ld a,139
	JUMP_(LOOMTOROOM)
LOOMto138:
	ld a,138
	JUMP_(LOOMTOROOM)
LOOM154:
	ld a,(DOTX)
	cp 84
	jr z,loom154rt
	cp 4	
	jr z,loom154lt
	ld a,(DOTY)
	cp 4
	jr z,loom154up
loom154dn:
	ld a,152
	JUMP_(LOOMTOROOM)
loom154up:
	ld a,150
	JUMP_(LOOMTOROOM)
loom154lt:
	ld a,153
	JUMP_(LOOMTOROOM)
loom154rt:
	ld a,151
	JUMP_(LOOMTOROOM)
LOOMto154:
	ld a,154
	JUMP_(LOOMTOROOM)
LOOM144:
	ld a,(DOTX)
	cp 84
	jr z,loom144rt
	cp 4	
	jr z,loom144lt
	ld a,(DOTY)
	cp 4
	jr z,loom144up
loom144dn:
	ld a,142
	JUMP_(LOOMTOROOM)
loom144up:
	ld a,140
	JUMP_(LOOMTOROOM)
loom144lt:
	ld a,143
	JUMP_(LOOMTOROOM)
loom144rt:
	ld a,141
	JUMP_(LOOMTOROOM)
LOOMto144:
	ld a,144
	JUMP_(LOOMTOROOM)
LOOM149:
	ld a,(DOTX)
	cp 84
	jr z,loom149rt
	cp 4	
	jr z,loom149lt
	ld a,(DOTY)
	cp 4
	jr z,loom149up
loom149dn:
	ld a,147
	JUMP_(LOOMTOROOM)
loom149up:
	ld a,145
	JUMP_(LOOMTOROOM)
loom149lt:
	ld a,148
	JUMP_(LOOMTOROOM)
loom149rt:
	ld a,146
	JUMP_(LOOMTOROOM)
LOOMto149:
	ld a,149
	JUMP_(LOOMTOROOM)
LOOM155:
	ld a,(SCENARIO)
	cp 8	
	JUMP_Z(SCENARIO2)
	ld a,156
	JUMP_(LOOMTOROOM)
LOOM156:
	ld a,155
	JUMP_(LOOMTOROOM)

LOOM160:
	ld a,(DOTY)
	cp 4
	jr z,loom160up
loom160dn:
	ld a,159
	ld (ROOM),a
	JUMP_(DUNGEONEXIT)
loom160up:
	ld a,161
	JUMP_(LOOMTOROOM)
LOOM161:
	ld a,(DOTY)
	cp 4
	jr z,loom161up
loom161dn:
	ld a,160
	JUMP_(LOOMTOROOM)
loom161up:
	ld a,162
	JUMP_(LOOMTOROOM)
LOOM162:
	ld a,(DOTY)
	cp 4
	jr z,loom162up
	jr loom160up
loom162up:
	ld a,163
	JUMP_(LOOMTOROOM)
LOOM163:
	ld a,(DOTY)
	cp 4
	jr z,loom163up
	jr loom161up
loom163up:
	ld a,164
	JUMP_(LOOMTOROOM)
LOOM164:
	ld a,(DOTY)
	cp 4
	jr z,loom164up
	jr loom162up
loom164up:
	ld a,165
	JUMP_(LOOMTOROOM)
LOOM165:
	ld a,(DOTY)
	cp 52
	jr z,loom163up
	JUMP_(SCENARIOEND)

LOOMTOROOM:
	ld (ROOM),a
	ld a,(DOTX)
	cp 4
	jr z,RDRRT	
	cp 84
	jr z,RDRLT
	ld a,(DOTY)
	cp 60
	jr z,RDRUP
	cp 4
	jr z,RDRDN
RDRUP:
	ld a,4
	ld (DOTY),a
	ld (BKY),a
	ld a,44
	ld (BKX),a
	ld hl,DN
	ld (Save),hl
	CALL_(drawit)	
	JUMP_(RELOADROOM)
RDRDN:
	ld a,52
	ld (DOTY),a
	ld (BKY),a
	ld a,44
	ld (BKX),a
	ld hl,UP
	ld (Save),hl
	CALL_(drawit)	
	JUMP_(RELOADROOM)
RDRLT:
	ld a,4
	ld (DOTX),a
	ld (BKX),a
	ld a,28
	ld (BKY),a
	ld hl,RT
	ld (Save),hl
	CALL_(drawit)	
	JUMP_(RELOADROOM)
RDRRT:
	ld a,84
	ld (DOTX),a
	ld (BKX),a
	ld a,28
	ld (BKY),a
	ld hl,LT
	ld (Save),hl
	CALL_(drawit)	
	JUMP_(RELOADROOM)

DRAWWALLS:
	CALL_(ERASESCREEN)
	LD HL,GRAPH_MEM
	LD DE,GRAPH_MEM+1
           	LD BC,23
           	LD A,$FF
           	LD (HL),A
           	LDIR
	LD HL,GRAPH_MEM+744
	LD DE,GRAPH_MEM+745
           	LD BC,23
           	LD A,$FF
           	LD (HL),A
           	LDIR
           	
	LD B,60
           	LD HL,GRAPH_MEM+24
           	LD DE,11
SIDELINELOOP:
           	LD A,$C0
           	LD (HL),A
           	ADD HL,DE
           	LD A,3
           	LD (HL),A
           	INC HL
           	DJNZ SIDELINELOOP
	RET
	
;-----------------end of room addys-----------------

SCENARIO1:
	CALL_(ERASESCREEN)
	ld a,-8
	ld (CHKDFD),a
	ld b,12
SANDDRAW:
	push bc
	ld a,(CHKDFD)
	add a,8
	ld (CHKDFD),a
	ld (BKX),a
	ld a,55
	ld (BKY),a
	ld hl,SAND
	CALL_(drawit)
	pop bc
	djnz SANDDRAW	
	
	ld a,-8
	ld (CHKDFD),a
	ld b,12
MNTNDRAW:
	push bc
	ld a,(CHKDFD)
	add a,8
	ld (CHKDFD),a
	ld (BKX),a
	ld a,10
	ld (BKY),a
	ld hl,MOUNTAIN
	CALL_(drawit)
	pop bc
	djnz MNTNDRAW	

	ld a,74
	ld (CHKDFD),a
	ld (WHOTOATTACK),a
CINEMALOOP:
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,42
	ld (BKY),a
	ld hl,ISIS1	
	CALL_(drawit)
	ld a,(WHOTOATTACK)
	dec a
	jr z,FOOT1
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,50
	ld (BKY),a
	ld hl,ISIS4
	CALL_(drawit)
	jr FOOTGO
FOOT1:
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,50
	ld (BKY),a
	ld hl,ISIS5
	CALL_(drawit)
FOOTGO:
	ld a,(CHKDFD)
	add a,8
	ld (BKX),a
	ld a,47
	ld (BKY),a
	ld hl,ISIS3
	CALL_(drawit)

	ld a,(CHKDFD)
	cp 42
	jr z,ITSDONE

	CALL_(DELAY3)
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,42
	ld (BKY),a
	ld hl,ISIS1	
	CALL_(drawit)
	ld a,(WHOTOATTACK)
	dec a
	jr z,FOOT1ERASE
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,50
	ld (BKY),a
	ld hl,ISIS4
	CALL_(drawit)
	ld a,1
	ld (WHOTOATTACK),a
	jr FOOTGOERASE
FOOT1ERASE:
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,50
	ld (BKY),a
	ld hl,ISIS5
	CALL_(drawit)
	ld a,2
	ld (WHOTOATTACK),a
FOOTGOERASE:
	ld a,(CHKDFD)
	add a,8
	ld (BKX),a
	ld a,47
	ld (BKY),a
	ld hl,ISIS3
	CALL_(drawit)
	CALL_(DELAY2)
	ld a,(CHKDFD)
	sub 4
	ld (CHKDFD),a
	JUMP_NZ(CINEMALOOP)
ITSDONE:
	xor a
	ld (CHKDFD),a
	ld b,45
LOOPMOVE:
	push bc
	ld bc,$322A
	ld hl,ISIS6
	CALL_(drawit2)
	CALL_(DELAY2)
	CALL_(CLOUDS)
	pop bc
	djnz LOOPMOVE	
	
	ld bc,$322A
	ld hl,ISIS4
	CALL_(drawit2)
	ld bc,$322A
	ld hl,ISIS2
	CALL_(drawit2)
	ld de,$2400
	ld hl,SPACESHIP1	
	ld c,19
	CALL_(drawbig2)
	ld de,$2408	
	ld hl,SPACESHIP2	
	ld c,19
	CALL_(drawbig2)
	ld de,$2410	
	ld hl,SPACESHIP3	
	ld c,19
	CALL_(drawbig2)
	ld de,$2A18	
	ld hl,SPACESHIP4	
	ld c,13
	CALL_(drawbig2)
	ld de,$171A                    
            	ld hl,ufotext
            	call DISPSTRING     
	call WaitKey
	ld a,99
	ld (CHKDFD),a
	JUMP_(STARTBATTLE)	
CLOUDS:
	ld a,(CHKDFD)
	add a,3
	ld (CHKDFD),a
	ld (BKX),a
	xor a
	ld (BKY),a
	ld hl,CLOUD
	CALL_(drawit)
	ld a,(CHKDFD)
	add a,40
	ld (BKX),a
	xor a
	ld (BKY),a
	ld hl,CLOUD
	CALL_(drawit)
	CALL_(DELAY)
	ld a,(CHKDFD)
	ld (BKX),a
	xor a
	ld (BKY),a
	ld hl,CLOUD
	CALL_(drawit)
	ld a,(CHKDFD)
	add a,40
	ld (BKX),a
	xor a
	ld (BKY),a
	ld hl,CLOUD
	CALL_(drawit)
	RET
SCENARIOEND:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,DarkKing
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	ld hl,2
	ld ($800C),hl
	ld hl,finalboss
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,throws
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	ld hl,2
	ld ($800C),hl
	ld hl,endtext
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	ld a,99
	ld (CHKDFD),a
	JUMP_(STARTBATTLE)	
SCENARIO2:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld a,(SCENARIO)
	cp 1
	jr z,(NOKEY)
	cp 6
	jr z,(NOKEY)
	cp 7
	jr z,(LEADER4)
	cp 8
	jr z,(LEADER5)
	ld hl,darkcrystal
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	ld a,99
	ld (CHKDFD),a
	JUMP_(STARTBATTLE)		
LEADER4:
	ld hl,crystal1
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	ld a,99
	ld (CHKDFD),a
	JUMP_(STARTBATTLE)
LEADER5:
	ld hl,crystal2
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	ld a,99
	ld (CHKDFD),a
	JUMP_(STARTBATTLE)
NOKEY:
	ld hl,needkey
	ROM_CALL(D_ZT_STR)
	call WaitKey		
	CALL_(DRAWWALLS)
	ld a,(DOTY)
	ld (BKY),a
	ld a,(DOTX)
	ld (BKX),a
	ld hl,(Save)
	CALL_(drawit)	
	JUMP_(RELOADROOM)
LEADERS:
	ld a,1
	ld (NUMBEROFENEMIES),a
	ld a,(SCENARIO)
	or a
	jr z,LEADEREYE
	cp 2
	JUMP_Z(LEADERELF)
	cp 3
	JUMP_Z(LEADERDRAGON)
	cp 7
	JUMP_Z(LEADERDRAKES)
	cp 8
	JUMP_Z(LEADEREVIL)
	cp 9
	JUMP_Z(LEADERDRAGON)
LEADEREYE:
	ld de,$090D
	ld hl,LEADER1p1
	ld c,33
	CALL_(drawbig2)	
	ld de,$0915
	ld hl,LEADER1p2
	ld c,33
	CALL_(drawbig2)	
	ld de,$091D
	ld hl,LEADER1p3
	ld c,33
	CALL_(drawbig2)	
	ld de,$0925
	ld hl,LEADER1p4
	ld c,33
	CALL_(drawbig2)	
	ld de,$122D
	ld hl,LEADER1p5
	ld c,22
	CALL_(drawbig2)	
	ld a,1
	ld (SCENARIO),a
	ld (LEADERORNO),a
	ld hl,25
	ld (ENEMYSPEED),hl
	ld hl,120
	ld (ENEMYHP),hl
	ld a,23
	ld (ENEMY1STR),a	;load enemy 1's strength
	ld a,80
	ld (ENEMY1XP),a
	ld hl,leadername1
	ld (ENEMY1),hl
	CALL_(PUTNAME)
	JUMP_(RETFROMLEADER)
LEADERELF:
	ld de,$1F02
	ld hl,LEADER2p8
	ld c,11
	CALL_(drawbig2)	
	ld de,$040A
	ld hl,LEADER2p1
	ld c,41
	CALL_(drawbig2)	
	ld de,$0412
	ld hl,LEADER2p2
	ld c,41
	CALL_(drawbig2)	
	ld de,$041A
	ld hl,LEADER2p3
	ld c,41
	CALL_(drawbig2)	
	ld de,$0422
	ld hl,LEADER2p4
	ld c,41
	CALL_(drawbig2)	
	ld de,$042A
	ld hl,LEADER2p5
	ld c,41
	CALL_(drawbig2)	
	ld bc,$2032
	ld hl,LEADER2p6
	CALL_(drawit2)	
	ld bc,$203A
	ld hl,LEADER2p7
	CALL_(drawit2)	
	ld a,3
	ld (SCENARIO),a
	ld (LEADERORNO),a
	ld hl,420
	ld (ENEMYHP),hl
	ld a,45
	ld (ENEMY1STR),a	;load enemy 1's strength
	ld a,170
	ld (ENEMY1XP),a
	ld hl,leadername2
	ld (ENEMY1),hl
	CALL_(PUTNAME)	
	JUMP_(RETFROMLEADER)
LEADERDRAGON:
	ld de,$040A
	ld hl,LEADER3p1
	ld c,40
	CALL_(drawbig2)	
	ld de,$0412
	ld hl,LEADER3p2
	ld c,40
	CALL_(drawbig2)	
	ld de,$041A
	ld hl,LEADER3p3
	ld c,40
	CALL_(drawbig2)	
	ld de,$0422
	ld hl,LEADER3p4
	ld c,40
	CALL_(drawbig2)	
	ld de,$042A
	ld hl,LEADER3p5
	ld c,40
	CALL_(drawbig2)	
	ld de,$0B32
	ld hl,LEADER3p6
	ld c,24
	CALL_(drawbig2)
	ld a,(SCENARIO)
	inc a
	ld (SCENARIO),a
	ld (LEADERORNO),a
	ld hl,8000
	ld (ENEMYHP),hl
	ld hl,30
	ld (ENEMYSPEED),hl
	ld a,180
	ld (ENEMY1STR),a	;load enemy 1's strength
	ld hl,leadername3
	ld (ENEMY1),hl
	CALL_(PUTNAME)
	JUMP_(RETFROMLEADER)
LEADERDRAKES:
	ld de,$060F
	ld hl,DRAKES
	ld c,39
	CALL_(drawbig2)	
	ld de,$0621
	ld hl,DRAKES
	ld c,39
	CALL_(drawbig2)	
	ld a,8
	ld (SCENARIO),a
	ld (LEADERORNO),a
	ld hl,2000
	ld (ENEMYHP),hl
	ld hl,14
	ld (ENEMYSPEED),hl
	ld a,80
	ld (ENEMY1STR),a	;load enemy 1's strength
	ld hl,leadername4
	ld (ENEMY1),hl
	CALL_(PUTNAME)
	JUMP_(RETFROMLEADER)
LEADEREVIL:
	ld de,$0A0A
	ld hl,$AFAF
	ld c,28
	CALL_(drawbig2)	
	ld de,$0712
	ld hl,$AFAF
	ld c,34
	CALL_(drawbig2)	
	ld de,$0A1A
	ld hl,$AFAF
	ld c,28
	CALL_(drawbig2)	
	ld de,$0722
	ld hl,$AFAF
	ld c,34
	CALL_(drawbig2)	
	ld de,$0A2A
	ld hl,$AFAF
	ld c,28
	CALL_(drawbig2)	
	ld a,9
	ld (SCENARIO),a
	ld (LEADERORNO),a
	ld hl,3000
	ld (ENEMYHP),hl
	ld hl,20
	ld (ENEMYSPEED),hl
	ld a,120
	ld (ENEMY1STR),a	;load enemy 1's strength
	ld hl,leadername5
	ld (ENEMY1),hl
	CALL_(PUTNAME)
	JUMP_(RETFROMLEADER)
AFTERLEADER:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld a,(SCENARIO)
	cp 3
	jr z,AFTERLEADER2
	cp 8
	jr z,AFTERLEADER3
	cp 9
	jr z,AFTERLEADER3
	cp 10
	jr z,ENDOFGAME
AFTERLEADER1:
	ld hl,afterleader1
	ROM_CALL(D_ZT_STR)
	call WaitKey
	JUMP_(RETFROMLDR2)
AFTERLEADER2:
	ld hl,afterleader2
	ROM_CALL(D_ZT_STR)
	call WaitKey
	JUMP_(RETFROMLDR2)
AFTERLEADER3:
	ld hl,getcrystal
	ROM_CALL(D_ZT_STR)
	call WaitKey
	JUMP_(RETFROMLDR2)

ENDOFGAME:	;; end
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,endgametext1
	ROM_CALL(D_ZT_STR)
	call WaitKey
	CALL_(TIMEDISTORT)
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,endgametext2
	ROM_CALL(D_ZT_STR)
	call WaitKey
	CALL_(DRAWWALLS)

	ld de,$341E
	ld hl,ENDISISp1
	ld c,10
	CALL_(drawbig2)
	ld de,$2026
	ld hl,ENDISISp2
	ld c,30
	CALL_(drawbig2)
	ld de,$202E
	ld hl,ENDISISp3
	ld c,30
	CALL_(drawbig2)
	ld de,$2036
	ld hl,ENDISISp4
	ld c,30
	CALL_(drawbig2)
	ld bc,$363B
	ld hl,ENDISISp5
	CALL_(drawit2)
	ld a,7
	ld (CHKDFD),a
	CALL_(DRAWRUIN)
	ld a,47
	ld (CHKDFD),a
	CALL_(DRAWRUIN)
	call WaitKey
	ld de, $1E03
   	ld hl,empty 
             call DISPSTRING   
	call WaitKey
	ld de,$1E3D
   	ld hl,lost  
             call DISPSTRING   
	call WaitKey
	ld bc,$1624
	ld hl,TITLE1
	CALL_(drawit2)
	ld bc,$162C
	ld hl,TITLE2
	CALL_(drawit2)
	ld bc,$1634
	ld hl,TITLE3
	CALL_(drawit2)
	call WaitKey
	JUMP_(EXIT)  ;; You win! =]	

DRAWRUIN:
	ld a,(CHKDFD)
	ld (BKX),a
	ld a,9
	ld (BKY),a
	ld hl,RUINOFWORLDp1
	ld c,12
	CALL_(drawbig)
	ld a,(CHKDFD)
	add a,8
	ld (BKX),a
	ld a,9
	ld (BKY),a
	ld hl,RUINOFWORLDp2
	ld c,12
	CALL_(drawbig)
	ld a,(CHKDFD)
	add a,16
	ld (BKX),a
	ld a,9
	ld (BKY),a
	ld hl,RUINOFWORLDp3
	ld c,12
	CALL_(drawbig)
	ld a,(CHKDFD)
	add a,24
	ld (BKX),a
	ld a,9
	ld (BKY),a
	ld hl,RUINOFWORLDp4
	ld c,12
	CALL_(drawbig)
	ld a,(CHKDFD)
	add a,32
	ld (BKX),a
	ld a,9
	ld (BKY),a
	ld hl,RUINOFWORLDp5
	ld c,12
	CALL_(drawbig)
	RET

STATUSSCREEN:
	CALL_(DRAWWALLS)
	ld bc,$070E
	ld hl,TITLE1
	CALL_(drawit2)
	ld bc,$0716
	ld hl,TITLE2
	CALL_(drawit2)
	ld bc,$071E
	ld hl,TITLE3
	CALL_(drawit2)
	ld de,$1207
	ld hl,PIC1
	ld c,16
	CALL_(drawbig2)
	ld de,$120F
	ld hl,PIC1p2
	ld c,16
	CALL_(drawbig2)
	ld de,$261B
	ld hl,PIC2
	ld c,16
	CALL_(drawbig2)
	ld de,$2623
	ld hl,PIC2p2
	ld c,16
	CALL_(drawbig2)

	ld a,-4
	ld (CHKDFD),a
	ld b,7
VINELOOP:
	push bc
	ld a,47
	ld (BKX),a
	ld a,(CHKDFD)	
	add a,8
	ld (CHKDFD),a	
	ld (BKY),a
	ld hl,VINE
	CALL_(drawit)
	pop bc
	djnz VINELOOP

	ld bc,$0837
	ld hl,CURSOR2
	CALL_(drawit2)
	ld de,$0841
   	ld hl,sitem         
             call DISPSTRING     
	ld de,$1041
   	ld hl,sspell         
             call DISPSTRING     
	ld de,$1841
   	ld hl,sstats         
             call DISPSTRING     
	ld de,$2041
   	ld hl,ssave         
             call DISPSTRING     
	ld de,$2841
   	ld hl,sload         
             call DISPSTRING     
LOOPSTAT:
	call GET_KEY
	cp G_2nd
	jr z,STATPRESS
	cp G_CLEAR
	JUMP_Z(STATEND)
	cp G_DOWN
	jr z,DOWNARROW
	cp G_UP
	jr nz,LOOPSTAT
UPARROW:
	ld a,(BKY)
	cp 8
	jr z,LOOPSTAT
	ld hl,CURSOR2
	CALL_(drawit)
	ld a,(BKY)
	sub 8
	ld (BKY),a	
	ld hl,CURSOR2
	CALL_(drawit)
	jr LOOPSTAT
DOWNARROW:
	ld a,(BKY)
	cp 40
	jr z,LOOPSTAT
	ld hl,CURSOR2
	CALL_(drawit)
	ld a,(BKY)
	add a,8
	ld (BKY),a	
	ld hl,CURSOR2
	CALL_(drawit)
	jr LOOPSTAT
STATPRESS:
	ld a,(BKY)
	cp 32
	jr z,SAVEGAME
	cp 40
	jr z,LOADGAME	
	cp 24
	JUMP_Z(STATUS)
	cp 16
	JUMP_Z(SPELLS)
	cp 8
	JUMP_Z(ITEMS)
SAVEGAME:
	ld a,(DUNGEON)
	or a
	JUMP_NZ(LOOPSTAT)

        LD DE,SAVERAM
        LD HL,ROOM
        LD BC,52
        LDIR
        ROM_CALL(CLEARLCD)
        ld hl,$0303
        ld ($800C),hl
        ld hl,gamesaved
        ROM_CALL(D_ZT_STR)
        call WaitKey
        call CR_GRBCopy        
        JUMP_(STATUSSCREEN)

;and so on...  that can probably be optimized a little to fit your game

LOADGAME:
       
        LD HL,SAVERAM
        LD DE,ROOM
        LD BC,52
        LDIR
        ROM_CALL(CLEARLCD)
        ld hl,$0303
        ld ($800C),hl
        ld hl,gameloaded
        res 3,(IY+05)
        ROM_CALL(D_ZT_STR)
        call WaitKey
        	CALL_(DRAWWALLS)
	ld a,28
	ld (DOTY),a
	ld (BKY),a
	ld a,44
	ld (DOTX),a	
	ld (BKX),a
	ld hl,UP
	ld (Save),hl
	CALL_(drawit)
	JUMP_(RELOADROOM)
STATEND:
	CALL_(DRAWWALLS)
	ld a,(DOTY)
	ld (BKY),a
	ld a,(DOTX)	
	ld (BKX),a
	ld hl,(Save)
	CALL_(drawit)
	JUMP_(RELOADROOM)
STATUS:
	CALL_(DRAWWALLS)
	ld de,$0322
   	ld hl,isis         
             call DISPSTRING
	ld de, $0336
   	ld hl,darq         
   	call DISPSTRING
	ld de, $0A03
   	ld hl,hp         
             call DISPSTRING
	ld de, $1103
   	ld hl,hpmax         
              call DISPSTRING
	ld de, $1903
   	ld hl,mp         
             call DISPSTRING
	ld de, $2003
   	ld hl,mpmax         
             call DISPSTRING
	ld de, $2803
   	ld hl,strength         
             call DISPSTRING
	ld de, $2F03
   	ld hl,defense         
             call DISPSTRING
	ld de, $3703
   	ld hl,level         
             call DISPSTRING
	LD DE,$0A22	
	ld a,(HPI)
	CALL_(DISPHL)	
	LD DE,$0A36
	ld a,(HPD)	
	CALL_(DISPHL)	
	LD DE,$1122	
	ld a,(HPIMAX)
	CALL_(DISPHL)	
	LD DE,$1136
	ld a,(HPDMAX)	
	CALL_(DISPHL)	
	LD DE,$1922	
	ld a,(ISISMP)
	CALL_(DISPHL)	
	LD DE,$1936
	ld a,(DARQMP)	
	CALL_(DISPHL)	
	LD DE,$2022	
	ld a,(MPIMAX)
	CALL_(DISPHL)	
	LD DE,$2036
	ld a,(MPDMAX)	
	CALL_(DISPHL)	
	LD DE,$2822	
	ld a,(STRENGTHI)
	CALL_(DISPHL)	
	LD DE,$2836
	ld a,(STRENGTHD)	
	CALL_(DISPHL)	
	LD DE,$2F22	
	ld a,(DEFENDI)
	CALL_(DISPHL)	
	LD DE,$2F36
	ld a,(DEFENDD)	
	CALL_(DISPHL)	
	LD DE,$3722	
	ld a,(ISISLVL)
	CALL_(DISPHL)	
	LD DE,$3736
	ld a,(DARQLVL)	
	CALL_(DISPHL)	
	call WaitKey	
	CALL_(YOURGOLD)
	call WaitKey	
	JUMP_(STATUSSCREEN)
ITEMS:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,towntext2
	ROM_CALL(D_ZT_STR)
ITEMLOOP2:
	call GET_KEY
                    cp G_1
                    jr z,MEDKITUSE
                    cp G_2
                    jr z,MAGKITUSE
                    cp G_3
                    JUMP_Z(STATUSSCREEN)
	jr ITEMLOOP2
MEDKITUSE:
	ld a,(MEDKITS)
	or a
	jr z,ITEMLOOP2
	dec a
	ld (MEDKITS),a	
	ld b,45
	ld a,(HPD)
	or a
	jr z,(ISISMED2)
	add a,b
	ld (HPD),a
	CALL_(HPOVERMAXD)
ISISMED2:
	ld b,45
	ld a,(HPI)
	or a
	jr z,ENDMED2
	add a,b
	ld (HPI),a
	CALL_(HPOVERMAXI)
ENDMED2:
	ld hl,4
	ld ($800C),hl
	ld hl,gainhp
	ROM_CALL(D_ZT_STR)
	call WaitKey
	jr ITEMS	
	
MAGKITUSE:
	ld a,(MAGIKITS)
	or a
	jr z,ITEMLOOP2
	dec a
	ld (MAGIKITS),a	
	ld b,30
	ld a,(DARQMP)
	add a,b
	ld (DARQMP),a
	CALL_(MPOVERMAXD)
	ld b,30
	ld a,(ISISMP)
	add a,b
	ld (ISISMP),a
	CALL_(MPOVERMAXI)
ENDMAGI2:
	ld hl,4
	ld ($800C),hl
	ld hl,gainmp
	ROM_CALL(D_ZT_STR)
	call WaitKey
	JUMP_(ITEMS)
SPELLS:
	ld a,(HPI)
	or a
	JUMP_Z(LOOPSTAT)
	ROM_CALL(CLEARLCD)
	ld hl,2
	ld ($800C),hl
	ld hl,healorno
	ROM_CALL(D_ZT_STR)
	ld hl,0
	ld ($800C),hl
	ld hl,healing
	ROM_CALL(D_ZT_STR)

	ld a,(HPI)	
	ld b,a
	ld a,(HPIMAX)
	sub b
	ld (CHKDFD),a
	ld a,(HPD)	
	ld c,a
	ld a,(HPDMAX)
	sub c
	ld (HITBYWHO),a	
	ld a,(CHKDFD)
	ld b,a
	ld a,(HITBYWHO)
	add a,b
	sra a
	sra a
	ld (CHKDFD),a
	ld l,a
	ld h,0
	push hl
	ld h,6
	ld l,0
	ld ($800C),hl
	pop hl
	ROM_CALL(D_HL_DECI)
	ld h,4
	ld l,1
	ld ($800C),hl
	ld a,(ISISMP)
	ld l,a
	ld h,0
	ROM_CALL(D_HL_DECI)
HEALLOOP:	
	call GET_KEY
	cp G_1
             jr z,HEALTHEM
             cp G_2
	JUMP_Z(STATUSSCREEN)
	jr HEALLOOP                    
HEALTHEM:
	ld a,(CHKDFD)
	ld b,a
	ld a,(ISISMP)
	sub b
	JUMP_C(NEEDMPS)	
	ld (ISISMP),a
	ld a,(HPIMAX)
	ld (HPI),a
	ld a,(HPDMAX)
	or a
	JUMP_Z(STATUSSCREEN)
	ld (HPD),a
             JUMP_(STATUSSCREEN)
NEEDMPS:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld ($800C),hl
	ld hl,YOUNEEDMP
	ROM_CALL(D_ZT_STR)
	call WaitKey
             JUMP_(STATUSSCREEN)
DISPSTRING:
             ld ($8252),de
	ROM_CALL(D_ZM_STR)
	call CR_GRBCopy
	ret
WaitKey:
	call GET_KEY
	cp G_ENTER
	ret z
	cp G_2nd
	jr nz,WaitKey
	RET

FIND_PIXEL:
 push bc
 push de
 ld a,63
 sub c
 ld c,a
 ld hl,ExpTable+1
 ld d,0
 ld a,b
 and $07
 ld e,a
 add hl,de
 ld e,(hl)
 srl b
 srl b
 srl b
 ld a,c
 add a,a
 add a,a
 ld h,0
 ld l,a
 ld a,e
 ld e,l
 add hl,hl
 add hl,de
 ld e,b
 add hl,de
 pop de
 pop bc
 ret
ExpTable:
 .db $01,$80,$40,$20,$10,$08,$04,$02,$01

.include battle.db

UP      .db       00011000b
        .db       00101000b
        .db       00100100b
        .db       01101100b
        .db       01101010b
        .db       01010110b
        .db       11111111b
        .db       01101100b

DN      .db       00011000b
        .db       00111000b
        .db       00101100b
        .db       01010100b
        .db       01100110b
        .db       01100110b
        .db       11111111b
        .db       01101100b

RT      .db       00001000b
        .db       00010100b
        .db       00010010b
        .db       00101100b
        .db       01000100b
        .db       01010010b
        .db       11111111b
        .db       00110110b

LT     .db       00010000b
        .db       00101000b
        .db       01001000b
        .db       00110100b
        .db       00100010b
        .db       01001010b
        .db       11111111b
        .db       01101100b

CASTLE  
        .db     10100101b
        .db     11100111b
        .db     10100101b
        .db     10111101b
        .db     11100111b
        .db     11011011b
        .db     11000011b
        .db     11111111b
WPNSHOP: ;for erasing walls left
        .db     01011111b
        .db     01010101b
        .db     01011111b
        .db     01010101b
        .db     01010101b
        .db     01010101b
        .db     11101110b
        .db     01000100b
BLANK3: ;for erasing walls left
        .db     11000000b
        .db     11000000b
        .db     11000000b
        .db     11000000b
        .db     11000000b
        .db     11000000b
        .db     11000000b
        .db     11000000b
CAVE: 
        .db     00000000b
        .db     00011100b
        .db     00100011b
        .db     00101101b
        .db     01011101b
        .db     01011111b
        .db     11011111b
        .db     11111111b
STAIRZ:
        .db     00000000b
        .db     00000000b
        .db     00000111b
        .db     00001101b
        .db     00011011b
        .db     00110111b
        .db     01101101b
        .db     11111111b
CHEST:
        .db     00011111b
        .db     00100011b
        .db     01000101b
        .db     11111001b
        .db     10001001b
        .db     10001010b
        .db     10001100b
        .db     11111000b

SAVERAM:
	.dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
endgametext1:
	.db "You use all 3   "
	.db "crystals...",0
endgametext2:
	.db "This is home... "
	.db "but...?",0
sitem:
	.db "Item",0
sstats:
	.db "Status",0
sspell:
	.db "Heal",0
ssave:
	.db "Save",0
new:
	.db "New ",0
sload:
	.db "Load",0
leadername1:
	.db "EyeKill",0
leadername2:
	.db "DrkOne",0
leadername3:
	.db "DrkKing",0
leadername4:
	.db "Drakes",0
leadername5:
	.db "Evil",0
runetext5:
	.db "Go now..find the"
	.db "other 2!",0
empty:
	.db "all is empty",0
lost:
	.db "all is lost",0
healing:
	.db "Costs:          "
	.db "MP:",0
healorno:
	.db "1. Yes          " 
	.db "2. No",0
runetext:
	.db "A tall wizard is"
	.db "standing here",0
runetext2:
	.db "Hmm..a different" 
	.db "dimension? What "
	.db "you need is the "
	.db "time crystals...",0
runetext3:
	.db "They change time"
	.db "and space. With "
	.db "3 of them you   "	
	.db "can return home.",0
runetext4:
	.db "1 crystal is in "
	.db "this tower. Come"
	.db "to the portal   "
	.db "when you get it.",0
crystal1:
	.db "The 1st crystal."
	.db "2 drakes appear "
	.db "to guard it!",0
crystal2:
	.db "The 2nd crystal."
	.db "You feel an evil"
	.db "presence..",0
lastcrystal:
	.db "Last crystal..",0
thewayhome:
	.db "the way home?",0
needkey:
	.db "Need key",0
portal:
	.db "The portal gate "
	.db "is locked",0
darkcrystal:
	.db "A humanoid alien"
	.db "is guarding a   "
	.db "glowing crystal."
	.db "It attacks!",0
throne:
.db "The Kings Throne",0

kingsays:
.db "A strange ship  "
.db "fell from the   "
.db "sky. Won't you  "
.db "go investigate?",0

kingsays1:
.db "Ah! The crystal!"
.db "The King starts "
.db "to take it.",0

DarkKing:
	.db "The Dark King!",0
finalboss:
	.db "Is this what you"
	.db "seek? Take it.",0
throws:
	.db "He throws you it",0
endtext:
	.db "Sadly, you won't" 
	.db "be using it.",0
kingattacks:
	.db "Wait!",0
kingattacks2:
	.db "The symbol on his hand!!",0	
afterleader1:
	.db "The monster was "
	.db "guarding this   " 
	.db "cave..",0
weaklings:
	.db "HahAhA! Now i'll"
	.db "send you on a   " 
	.db "little trip.",0
thanx:
	.db "Thanks for the  "
	.db "crystal!",0
time:
	.db "Time distorts...",0
towntalk2:
	.db "SkyReach? The   "
	.db "Dark King? Seek "
	.db "Rune..maybe he  "
	.db "can help.",0 
towntalk3:
	.db "A Time Crystal? "
	.db "Search west.",0
towntalk4:
	.db "...",0
afterleader2:
	.db "You take the    "
	.db "crystal back for"
	.db "the king.       "
	.db "What was that   "
	.db "symbol on the   "
	.db "aliens forehead?",0
cave1:
	.db "The ship's crash"
	.db "unearthed this  " 
	.db "cave..",0
isis:
	.db "Isis",0
darq:
	.db "Darq",0
hp:
	.db "HP",0
hpmax:
	.db "HPmax",0
mp:
	.db "MP",0
mpmax:
	.db "MPmax",0
strength:
	.db "Attk",0
defense:
	.db "Dfnd",0
level:
	.db "Lvl",0
ufotext:
	.db "What in the world..?",0
yourg:
	.db "Your Gold:",0
nameoftown1:
	.db "   ~SkyReach~   ",0
nameoftown2:
	.db "   ~Arcanick~   ",0
nameoftown3:
	.db "   ~Moonbeam~   ",0
nameoftown4:
	.db "   ~Finality~   ",0
towntext1:
	.db "1.Inn - 50g     "
	.db "2.Item Shop     "
	.db "3.Talk with ppl "
	.db "4.Exit",0
towntext2:
	.db "1. MediKit      "
	.db "2. MagiKit      "
	.db "3. Exit",0
getcrystal:
	.db "Crystal attained",0
gamesaved:
	.db "Game Saved",0
gameloaded:
	.db "Game Loaded",0
towntext3:
	.db "  ~Items 30g~   ",0
restored:
	.db " HP&MP restored ",0
wpnshoptext:
	.db "Weapons & Armor ",0
wpnshoptext2:
	.db "1.Upgrade Weapon"
	.db "2.Upgrade Armor ",
	.db "3.Exit",0
upweapon:
	.db "Weapon +3 = 60g",0
uparmor:
	.db "Armor +3 = 60g",0
wpnshoptext4:
	.db "1.Upgrade Isis  "
	.db "2.Upgrade Darq  "
	.db "3.Exit",0
gainmp:
	.db "MP +30!",0
gainhp:
	.db "HP +45!",0
youfind:
	.db "You find",0
youneedg:
	.db " You need gold! ",0	
thankmessage:
	.db "  Thank you!!!  ",0
YOUWIN:
	.db "You win!",0
DAMAGE:
	.db "Damage!!!",0
ISISDEFEND:
	.db "Isis Dfnds",0
BLANKGOLD:
	.db "some gold",0
BLANKITEM:
	.db "a MedKit",0
BLANKITEM2:
	.db "a MagiKit",0
BLANKSCROLL:
	.db "a scroll.You get"
	.db "some xp!",0
BLANKKEY:
	.db "a key.",0
DARQDEFEND:
	.db "Darq Dfnds",0
NOTTURN:
	.db "It's not their turn",0
WHY:
	.db " ",0				;i don't know why this has to be here
BLANKTEXT:
	.db "                             ",0
ENEMYATTACKS:
	.db "Enemy      Attacks!",0
BLANKLIFE:
	.db "            ",0
ISISFALLS:
	.db "Isis falls...",0
DARQFALLS:
	.db "Darq Falls...",0
YOULOSE:
	.db "Game Over",0
YOUNEEDMP:
	.db "You need MP!",0
EXP:
	.db "xp:",0
GOLDSTR:
	.db "$:",0
GAIN:
	.db "Gain",0
hasgainedlvl:
	.db "gains a level!",0
Fire:
	.db "Fire",0
Cure:
	.db "Cure",0
Flee:
	.db "Flee",0
Deathtext:
	.db "atashi no aijin...",0
Curetext:
	.db "...the cure...",0
Fleetext:
	.db "the winds of change...",0
Drain:
	.db "Drain",0
Wrath:
	.db "Hate",0
Cure2:
	.db "Cure2",0
Cure3:
	.db "Cure3",0
Life:
	.db "Life",0
Death:
	.db "Death",0
Siphon:
	.db "Suck",0
Nuke:
	.db "Nuke",0
itemmedkit:
	.db "MKit",0
itemmagkit:
	.db "Magi",0
Clown:
	.db "Clown",0
Robo:
	.db "Robo",0
Spider:
	.db "Tick",0
Wisp:
	.db "Wisp",0
Slime:
	.db "Slime",0
Stinger:
	.db "Sting",0
Hawk:
	.db "Hawk",0
Knight:
	.db "Knight",0
Eye:
	.db "Eye",0
Flame:
	.db "Burn",0
Skeleton:
	.db "Skel",0
Bee:
	.db "Bee",0
Mask:
	.db "Mask",0
Torch:
	.db "Torch",0
Mage:
	.db "Mage",0
Kiss:
	.db "Kiss",0
Sun:
	.db "Sun",0
Head:
	.db "Head",0
Junk:
	.db "Junk",0
Zorg:
	.db "Zorg",0

credits:
 .db "by Alex Highsmith/Bill Nagel",0
Description:
 .db "FFX4 v1.0",0

SPELLCURE:
        .db     00000100b
        .db     01000100b
        .db     00100100b
        .db     00010001b
        .db     00000100b
        .db     11101010b
        .db     00000100b
        .db     00010001b
        .db     00100100b
        .db     01000100b
        .db     00000100b
SPELLCURE2:
        .db     00000000b
        .db     01000000b
        .db     10000000b
        .db     00000000b
        .db     00000000b
        .db     11100000b
        .db     00000000b
        .db     00000000b
        .db     10000000b
        .db     01000000b
        .db     00000000b
SPELLLIFE:
        .db     00000001b
        .db     00000010b
        .db     00000001b
        .db     00000011b
        .db     00000010b
        .db     00000111b
        .db     00000111b
        .db     00000101b
        .db     00000111b
        .db     00000111b
        .db     00011000b
        .db     00110010b
        .db     00100010b
        .db     01100011b
        .db     11011001b
        .db     01110110b
        .db     10101100b
        .db     11000100b
        .db     01001001b
        .db     00001001b
        .db     00010011b
        .db     00010111b
        .db     00001101b
SPELLLIFE2:
        .db     11100000b
        .db     00010000b
        .db     11100001b
        .db     11011010b
        .db     11111111b
        .db     00111110b
        .db     10111010b
        .db     00110100b
        .db     11111000b
        .db     11000001b
        .db     11110001b
        .db     00001111b
        .db     00000110b
        .db     00000111b
        .db     10001101b
        .db     11110011b
        .db     01000001b
        .db     10101001b
        .db     00001000b
        .db     00000100b
        .db     00000010b
        .db     00111010b
        .db     11011111b
SPELLLIFE3:
        .db     10110000b
        .db     11010000b
        .db     10100000b
        .db     11100000b
        .db     00010000b
        .db     11110000b
        .db     00100000b
        .db     00100000b
        .db     11000000b
        .db     10110000b
        .db     11000000b
        .db     11111000b
        .db     11011000b
        .db     01111000b
        .db     11101000b
        .db     00100000b
        .db     10000000b
        .db     00000000b
        .db     10000000b
        .db     10000000b
        .db     10000000b
        .db     11000000b
        .db     00000000b
SPELLNUKE:
        .db     00001011b
        .db     00110000b
        .db     11001111b
        .db     00111100b
        .db     01100101b
        .db     01010001b
        .db     11101110b
        .db     10010011b
        .db     11001100b
        .db     10101011b
        .db     11010111b
        .db     01010101b
        .db     01100000b
        .db     10111100b
        .db     01101111b
        .db     00010000b

SPELLNUKE2:
        .db     10000000b
        .db     01111000b
        .db     10000110b
        .db     11111001b
        .db     01011111b
        .db     00110011b
        .db     11011010b
        .db     01001111b
        .db     11001100b
        .db     00101111b
        .db     01011111b
        .db     11110010b
        .db     00111111b
        .db     11110000b
        .db     10001111b
        .db     11110000b
SPELLNUKE3:
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     10000000b
        .db     11111100b
        .db     11001000b
        .db     01111000b
        .db     11111110b
        .db     00011100b
        .db     11110000b
        .db     11111000b
        .db     11100000b
        .db     00000000b
        .db     11000000b
        .db     00000000b
        .db     00000000b

SPELLDEATH:
        .db     00000000b
        .db     00001100b
        .db     00010110b
        .db     00110001b
        .db     00110110b
        .db     00110110b
        .db     01001010b
        .db     01010101b
        .db     01010111b
        .db     10101011b
        .db     11101101b
        .db     11000100b
        .db     10101101b
        .db     01111111b

SPELLDEATH2:
        .db     01000000b
        .db     01100000b
        .db     01110000b
        .db     01011000b
        .db     01001000b
        .db     01000000b
        .db     11000000b
        .db     11000000b
        .db     10000000b
        .db     01000000b
        .db     01000000b
        .db     11000000b
        .db     10100000b
        .db     11110000b

FLEE:
        .db     11111111b
        .db     00000000b
        .db     00111111b
        .db     00000000b
        .db     01111111b
        .db     00000000b
        .db     11110000b
        .db     00000111b
SPELLHATE:
        .db     10001001b
        .db     01001000b
        .db     10011010b
        .db     00101001b
        .db     10101100b
        .db     01101101b
        .db     00111010b
        .db     00100110b
        .db     01101101b
        .db     01110101b
        .db     01010011b
        .db     10100111b
        .db     10101011b
        .db     10010001b
SPELLFIRE:
        .db     01001010b
        .db     11011011b
        .db     11110111b
        .db     10111101b
        .db     11010111b
        .db     01101011b
        .db     01111110b
        .db     00111100b

SPELLDRAIN:
        .db     11111100b
        .db     10000100b
        .db     10111111b
        .db     10100101b
        .db     10100101b
        .db     11111101b
        .db     00100001b
        .db     00111111b
SPELLDRAIN2:
        .db     00111111b
        .db     00100001b
        .db     11111101b
        .db     10100101b
        .db     10100101b
        .db     10111111b
        .db     10000100b
        .db     11111100b
SPELLDRAIN3:
        .db     11111100b
        .db     11111100b
        .db     11111111b
        .db     11111111b
        .db     11111111b
        .db     11111111b
        .db     00111111b
        .db     00111111b
SPELLDRAIN4:
        .db     00111111b
        .db     00111111b
        .db     11111111b
        .db     11111111b
        .db     11111111b
        .db     11111111b
        .db     11111100b
        .db     11111100b
ITEMMEDKIT:
        .db     00011000b
        .db     01011010b
        .db     00011000b
        .db     11111111b
        .db     11111111b
        .db     00011000b
        .db     01011010b
        .db     00011000b
ITEMMEDKIT2:
        .db     11001001b
        .db     01100011b
        .db     00110110b
        .db     10011101b
        .db     00111100b
        .db     01100110b
        .db     11000011b
        .db     10010001b
ITEMMEDKIT3:
        .db     01100100b
        .db     00110001b
        .db     10011011b
        .db     00011110b
        .db     01111100b
        .db     11001101b
        .db     10000110b
        .db     00100011b
ITEMMEDKIT4:
        .db     00110000b
        .db     00011000b
        .db     00011000b
        .db     00011011b
        .db     01111110b
        .db     11011000b
        .db     00001100b
        .db     00000110b
ITEMMAGIKIT:
        .db     10010011b
        .db     11011010b
        .db     00100100b
        .db     01011011b
        .db     11011010b
        .db     00100100b
        .db     01011011b
        .db     11001001b
BLANK:
        .db     11111111b
        .db     11111111b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
BLANK2: ;for erasing walls right
        .db     00000011b
        .db     00000011b
        .db     00000011b
        .db     00000011b
        .db     00000011b
        .db     00000011b
        .db     00000011b
        .db     00000011b

LIFESTAR:
        .db %00000000
        .db %00010000
        .db %01010100
        .db %00101000
        .db %11010110
        .db %00101000
        .db %01010100
        .db %00010000

ISISATTACK:
        .db %00000000
        .db %00001000
        .db %00001100
        .db %00011111
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000000
ATTACKINUMBER1:
        .db %00111000
        .db %01000100
        .db %10111010
        .db %10110010
        .db %10101010
        .db %01000100
        .db %00111000
        .db %00000000
ATTACKINUMBER2:
        .db %10000000
        .db %11000000
        .db %01100000
        .db %00110000
        .db %00011000
        .db %00001100
        .db %00010000
        .db %00000000
ATTACKINUMBER3:
        .db %00000100
        .db %00001000
        .db %10011000
        .db %01100100
        .db %00111010
        .db %00001001
        .db %00010000
        .db %00100000
ATTACKINUMBER4:
        .db %00000010
        .db %10000100
        .db %01001000
        .db %00110100
        .db %00010110
        .db %00001001
        .db %00010000
        .db %00100000
ATTACKINUMBER5:
        .db %10000000
        .db %01000000
        .db %00101011
        .db %00010100
        .db %00110100
        .db %00101010
        .db %01000001
        .db %10000000
ATTACKINUMBER6:
        .db %00010000
        .db %00010000
        .db %00001000
        .db %10010110
        .db %01110101
        .db %00001001
        .db %00010000
        .db %00100000

ISIS1:
        .db     00110000b
        .db     01111000b
        .db     11011100b
        .db     00101110b
        .db     00011111b
        .db     00110011b
        .db     00011001b
        .db     00011110b
ISIS2:	
        .db     00100110b
        .db     00111011b
        .db     01010001b
        .db     11111111b
        .db     01110110b
        .db     00000000b
        .db     00000000b
        .db     00000000b
ISIS3:	
        .db     10000000b
        .db     10000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     10000000b
        .db     01000000b
        .db     00000000b
ISIS4:	
        .db     00100110b
        .db     00101011b
        .db     01000101b
        .db     11111111b
        .db     00000110b
        .db     00000000b
        .db     00000000b
        .db     00000000b
ISIS5:	
        .db     00100110b
        .db     00111011b
        .db     01010001b
        .db     11111111b
        .db     01110000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
ISIS6:	
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     01110110b
        .db     00000000b
        .db     00000000b
        .db     00000000b

ATTACKDNUMBER1:
        .db     10000010b
        .db     11000110b
        .db     01101100b
        .db     00111000b
        .db     00010000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
ATTACKDNUMBER2:
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00010000b
        .db     00111000b
        .db     01101100b
        .db     11000110b
        .db     10000010b
ATTACKDNUMBER3:
        .db %01111000
        .db %11111110
        .db %00011111
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000000
DARQATTACK:
   .db %11111100
   .db %01000011
   .db %00101110
   .db %00011111
   .db %00010011
   .db %00001010
   .db %00000101
   .db %00000011
DARQATTACK2:
  .db %10000000
  .db %10000000
  .db %10000000
  .db %10000000
  .db %00000000
  .db %10000000
  .db %00000000
  .db %10000000

DARQ1:
        .db     00111000b
        .db     00101100b
        .db     01001100b
        .db     00101000b
        .db     01100110b
        .db     11011011b
        .db     11101111b
        .db     10101011b
DARQ2:
        .db     11010111b
        .db     11111111b
        .db     11111011b
        .db     11111101b
        .db     11111101b
        .db     11101111b
        .db     11011111b
        .db     00000000b
DARQ3:
        .db     10000000b
        .db     10000000b
        .db     10000000b
        .db     10000000b
        .db     10000000b
        .db     10000000b
        .db     10000000b
        .db     10000000b

ENEMY1AREA1:
        .db     11100111b
        .db     10100101b
        .db     11100111b
        .db     00011000b
        .db     00011000b
        .db     11000011b
        .db     11111111b
        .db     01111110b
ENEMY2AREA1:
        .db %10011001
        .db %11011011
        .db %01100110
        .db %01111110
        .db %01111110
        .db %10011001
        .db %10011001
        .db %10011001
ENEMY4AREA1:
        .db %00001000
        .db %00011000
        .db %00100100
        .db %00100010
        .db %01010110
        .db %01010101
        .db %10001001
        .db %11111111
ENEMY5AREA1:
        .db %00100010
        .db %01010000
        .db %00100100
        .db %00001010
        .db %10000100
        .db %00100000
        .db %01010010
        .db %00100000
ENEMY3AREA1:
        .db     10000000b
        .db     01110011b
        .db     01011111b
        .db     01010101b
        .db     00101110b
        .db     00111011b
        .db     00101110b
        .db     01110101b
        .db     01011111b
        .db     10110101b
        .db     00111111b
        .db     01101010b
        .db     01111111b
        .db     01011010b
        .db     11010010b
        .db     10010010b
ENEMY3AREA1p2:
        .db     01010000b
        .db     10011000b
        .db     01001000b
        .db     01001100b
        .db     10000110b
        .db     10000110b
        .db     10001110b
        .db     11111100b
        .db     01110100b
        .db     11010000b
        .db     10100000b
        .db     11100000b
        .db     10110000b
        .db     10010000b
        .db     11011000b
        .db     01001000b
ENEMY6AREA1:
        .db     00001111b
        .db     00010000b
        .db     00010101b
        .db     00010101b
        .db     00010000b
        .db     00001011b
        .db     00000111b
        .db     11111010b
        .db     10101111b
        .db     11111010b
        .db     10101010b
        .db     10110101b
        .db     01110111b
        .db     00101010b
        .db     00010000b
        .db     00110000b
ENEMY6AREA1p2:
        .db     00000000b
        .db     10000000b
        .db     10000011b
        .db     10000101b
        .db     10001010b
        .db     00010110b
        .db     01101100b
        .db     01011100b
        .db     10110100b
        .db     11100000b
        .db     00010100b
        .db     00010000b
        .db     00001110b
        .db     10011111b
        .db     01011111b
        .db     01101110b
ENEMY1AREA2:
        .db %00110010
        .db %01101010
        .db %00110010
        .db %11010110
        .db %11101111
        .db %11011010
        .db %00010100
        .db %00100010
ENEMY2AREA2:
        .db %00111100
        .db %01001010
        .db %10100101
        .db %11001011
        .db %10001011
        .db %10100101
        .db %01010010
        .db %00111100
ENEMY3AREA2:
        .db %10001001
        .db %10010011
        .db %11011011
        .db %11110011
        .db %11101111
        .db %01110110
        .db %00111100
        .db %01011010
ENEMY4AREA2:
        .db %01011110
        .db %11001111
        .db %11100101
        .db %11011000
        .db %00011011
        .db %10100111
        .db %11110011
        .db %01111010
ENEMY1AREA3:
        .db %01011110
        .db %10111011
        .db %11010101
        .db %01110111
        .db %10101101
        .db %11011010
        .db %10101101
        .db %01110110
ENEMY2AREA3:
        .db %01111110
        .db %11011101
        .db %10111011
        .db %11011101
        .db %11111111
        .db %01111110
        .db %01000010
        .db %00111100
ENEMY3AREA3:
        .db %01010101
        .db %10101010
        .db %01111101
        .db %00101110
        .db %00111011
        .db %01101110
        .db %11111000
        .db %11100000
ENEMY4AREA3:
        .db %10111101
        .db %11111111
        .db %01111110
        .db %11111111
        .db %00111100
        .db %01100110
        .db %10011001
        .db %10100101
ENEMY1AREA4:
        .db %11000011
        .db %10100101
        .db %01100110
        .db %00000000
        .db %10111101
        .db %01100110
        .db %01100110
        .db %00111100
ENEMY2AREA4:
        .db %00100000
        .db %01100010
        .db %01010101
        .db %11110010
        .db %11111100
        .db %11111000
        .db %11110000
        .db %11111000
ENEMY3AREA4:
        .db %00011111
        .db %00101010
        .db %01001110
        .db %10011011
        .db %11110101
        .db %10010011
        .db %01011110
        .db %01100100
        .db %00100101
        .db %00101111
        .db %01010110
        .db %01010000
        .db %01001110
        .db %00100111
        .db %01111001
        .db %10001111
ENEMY3AREA4p2:
        .db %11111000
        .db %10101100
        .db %00111010
        .db %01101101
        .db %01010111
        .db %01101101
        .db %00111010
        .db %00010010
        .db %11110100
        .db %01011010
        .db %00001010
        .db %01101010
        .db %01110110
        .db %10000010
        .db %00111110
        .db %11100001
ENEMY4AREA4:
        .db %00000010
        .db %00001001
        .db %00100011
        .db %00000101
        .db %01001100
        .db %00011001
        .db %10100010
        .db %01111011
        .db %10100010
        .db %00011001
        .db %01001100
        .db %00010101
        .db %00100011
        .db %00001001
        .db %00000010
        .db %00000000
ENEMY4AREA4p2:
        .db %10000000
        .db %00100000
        .db %10001000
        .db %01010000
        .db %01100100
        .db %00110000
        .db %10001010
        .db %10111100
        .db %10001010
        .db %00110000
        .db %01100100
        .db %01010000
        .db %10001000
        .db %00100000
        .db %10000000
        .db %00000000
ENEMY1AREA5:
        .db %01100100
        .db %11011010
        .db %10110101
        .db %01101010
        .db %01010110
        .db %10101101
        .db %01011011
        .db %00100110
ENEMY2AREA5:
        .db %01000010
        .db %00111100
        .db %00100100
        .db %11011010
        .db %01010011
        .db %00100100
        .db %01011010
        .db %01010010
ERASURE:
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     01111111b
        .db     01111111b
CURSOR:
        .db     00010000b
        .db     00110000b
        .db     01111111b
        .db     11111111b
        .db     01111111b
        .db     00110000b
        .db     00010000b
        .db     00000000b
CURSOR2:
        .db     00001000b
        .db     00001100b
        .db     11111110b
        .db     11111111b
        .db     11111110b
        .db     00001100b
        .db     00001000b
        .db     00000000b
CURSORDN:
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00111110b
        .db     00011100b
        .db     00001000b

SHIELD1:
	.db     01111111b
        .db     01010101b
        .db     01101010b
        .db     01010101b
        .db     01101010b
        .db     01010101b
        .db     01111111b 
        .db     01111111b
SHIELD2:
	.db     11111111b
        .db     01011101b
        .db     10111110b
        .db     01011101b
        .db     10111110b
        .db     01011101b
        .db     11111111b
        .db     11111111b
SHIELD3: 
	.db     11111111b
        .db     01010101b
        .db     10101011b
        .db     01010101b
        .db     10101011b 
        .db     01010101b
        .db     11111111b
        .db     11111111b
SHIELD4:
	.db     01111111b
        .db     01010101b
        .db     01101010b
        .db     01010101b
        .db     01101010b
        .db     01010101b
        .db     01101010b
        .db     01010101b
SHIELD5:
	.db     11111111b
        .db     01011101b
        .db     10111110b 
        .db     01011101b
        .db     10111110b
        .db     01011101b
        .db     10111110b
        .db     01011101b
SHIELD6:
	.db     11111111b
        .db     01010101b
        .db     10101011b
        .db     01010101b
        .db     10101011b
        .db     01010101b
        .db     10101011b
        .db     01010101b
SHIELD7:
	.db     01101010b 
        .db     01010101b
        .db     01101010b
        .db     01010101b
        .db     01101010b
        .db     01010101b
        .db     01101010b
        .db     00110101b
SHIELD8:
	.db     10111110b
        .db     01011101b
        .db     10111110b
        .db     01011101b
        .db     10111110b
        .db     01011101b
        .db     10111110b
        .db     01011101b
SHIELD9:
	.db     10101011b
        .db     01010101b
        .db     10101011b
        .db     01010101b
        .db     10101011b
        .db     01010101b
        .db     10101011b
        .db     01010110b
SHIELD10:
	.db     00011010b
        .db     00001101b
        .db     00000110b
        .db     00000011b
        .db     00000001b
        .db     00000000b
        .db     00000000b
        .db     00000000b
SHIELD11:
	.db     10111110b
        .db     01011101b
        .db     10111110b
        .db     01011101b
        .db     10111110b
        .db     11011101b
        .db     01111111b
        .db     00111110b
SHIELD12:
	.db     10101100b
        .db     01011000b
        .db     10110000b 
        .db     01100000b
        .db     11000000b
        .db     10000000b
        .db     00000000b
        .db     00000000b
SHIELD13:
	.db     00011100b
        .db     00001000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
ICONRING:
        .db     11111111b
        .db     10000001b
        .db     10000001b
        .db     10000001b
        .db     10000001b
        .db     10000001b
        .db     10000001b
        .db     11111111b
TOWNPIC:
        .db     %00111000
        .db     %01100100
        .db     %10011110
        .db     %10111111
        .db     %11010001
        .db     %01110111
        .db     %00110111
        .db     %11111111
SAND:
        .db     %11111111
        .db     %01001000
        .db     %00010010
        .db     %10000100
        .db     %01010001
        .db     %10101000
        .db     %00000010
        .db     %01001000
MOUNTAIN:
        .db     %00100010
        .db     %01110101
        .db     %11011000
        .db     %10010100
        .db     %11001010
        .db     %00101001
        .db     %01010111
        .db     %11010011
CLOUD:
        .db     %00000000
        .db     %00101110
        .db     %01010001
        .db     %10000010
        .db     %01000001
        .db     %11000011
        .db     %00111100
        .db     %00000000
SPACESHIP1:
        .db     00000000b
        .db     00000011b
        .db     00011110b
        .db     01111001b
        .db     01100100b
        .db     10100001b
        .db     00011110b
        .db     00010010b
        .db     01000001b
        .db     11111110b
        .db     10010111b
        .db     11111010b
        .db     00101101b
        .db     00010010b
        .db     11110001b
        .db     11111111b
        .db     00001011b
        .db     00010000b
        .db     00010000b
SPACESHIP2:
        .db     11110000b
        .db     10111110b
        .db     01000111b
        .db     01100001b
        .db     11011101b
        .db     01000100b
        .db     01000111b
        .db     00001000b
        .db     11111111b
        .db     01010011b
        .db     11111100b
        .db     10011010b
        .db     01100101b
        .db     01010010b
        .db     00101010b
        .db     11100011b
        .db     11111111b
        .db     10001110b
        .db     01110001b
SPACESHIP3:
        .db     00000000b
        .db     00000000b
        .db     11000000b
        .db     11110000b
        .db     00111100b
        .db     00001111b
        .db     10100001b
        .db     10011111b
        .db     11101011b
        .db     10111100b
        .db     10010010b
        .db     11011011b
        .db     10101111b
        .db     01111111b
        .db     11110110b
        .db     10001010b
        .db     00001010b
        .db     00010100b
        .db     10100101b
SPACESHIP4:
        .db     10000000b
        .db     11100000b
        .db     11111000b
        .db     00111100b
        .db     11110000b
        .db     11000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     00000000b
        .db     11000000b
        .db     00100000b

LEADER1p1:
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000001
        .db %00000110
        .db %00001001
        .db %00001001
        .db %00010010
        .db %00100000
        .db %00100100
        .db %01011000
        .db %01000010
        .db %01000010
        .db %10001100
        .db %10010000
        .db %10000010
        .db %10100001
        .db %11011100
        .db %10001000
        .db %10010000
        .db %01000100
        .db %01001010
        .db %01001010
        .db %00100000
        .db %01110000
        .db %01110010
        .db %11001000
        .db %01001000
        .db %01100110
        .db %10101001
        .db %00101000
        .db %01001100
        .db %10000010

LEADER1p2:
        .db %00000111
        .db %00111000
        .db %11000000
        .db %00000000
        .db %00000100
        .db %00000100
        .db %01000010
        .db %10100001
        .db %00000010
        .db %10001000
        .db %00010000
        .db %10110010
        .db %01000001
        .db %00000000
        .db %00100011
        .db %01010000
        .db %10001010
        .db %00000001
        .db %00010010
        .db %01100100
        .db %10000011
        .db %10000110
        .db %00001000
        .db %10000000
        .db %01011000
        .db %00000100
        .db %11000010
        .db %01001100
        .db %10001010
        .db %00001100
        .db %11010000
        .db %00111000
        .db %00000111

LEADER1p3:
        .db %11111000
        .db %00000111
        .db %00000000
        .db %10100000
        .db %00011010
        .db %00000101
        .db %00000001
        .db %00000000
        .db %10001011
        .db %00010101
        .db %00010000
        .db %01100001
        .db %10000010
        .db %10100010
        .db %00011100
        .db %00001000
        .db %00110010
        .db %10000101
        .db %00001000
        .db %01101000
        .db %00010000
        .db %00000001
        .db %00101110
        .db %11010100
        .db %00001000
        .db %00010001
        .db %01100010
        .db %00000000
        .db %01000001
        .db %00010000
        .db %00101000
        .db %00000111
        .db %11111000
        
LEADER1p4:
        .db %00000000
        .db %00000000
        .db %11000000
        .db %00100000
        .db %00011000
        .db %01100100
        .db %01000100
        .db %10001110
        .db %00011001
        .db %10110100
        .db %00100101
        .db %01100011
        .db %01001011
        .db %01010111
        .db %01000111
        .db %01000111
        .db %01010110
        .db %11100111
        .db %11000111
        .db %01110111
        .db %00110011
        .db %00101011
        .db %10010000
        .db %00001001
        .db %00001101
        .db %11000110
        .db %00100111
        .db %11000101
        .db %01011001
        .db %00100110
        .db %11001101
        .db %00011001
        .db %00010001

LEADER1p5:
        .db %10000000
        .db %10000000
        .db %10000000
        .db %11000000
        .db %11000000
        .db %01000000
        .db %01000000
        .db %11000000
        .db %11000000
        .db %11000000
        .db %11000000
        .db %10000000
        .db %10001100
        .db %10010000
        .db %00010000
        .db %00011000
        .db %00101000
        .db %01000010
        .db %10000100
        .db %00000110
        .db %11011000
        .db %10110100

LEADER2p1:
        .db %00000000
        .db %00000000
        .db %00000111
        .db %00001100
        .db %00010001
        .db %00110110
        .db %00101001
        .db %00101111
        .db %00101100
        .db %01101001
        .db %01011001
        .db %01010001
        .db %01011111
        .db %11001001
        .db %11001100
        .db %10010101
        .db %11010110
        .db %11011010
        .db %11001001
        .db %01100100
        .db %01100100
        .db %00111011
        .db %00000111
        .db %00000001
        .db %00000011
        .db %00001111
        .db %00011101
        .db %11110111
        .db %10001001
        .db %11101011
        .db %10111110
        .db %00100110
        .db %01010001
        .db %00101100
        .db %10100011
        .db %11010110
        .db %01111100
        .db %00000011
        .db %11110000
        .db %00111111
        .db %00000000
LEADER2p2:
        .db %00000011
        .db %01111111
        .db %11101000
        .db %00010001
        .db %11010110
        .db %11111100
        .db %10010010
        .db %00100101
        .db %11100100
        .db %01001011
        .db %01010100
        .db %01010100
        .db %01101011
        .db %11001000
        .db %01101000
        .db %00110000
        .db %10010000
        .db %01000000
        .db %00110000
        .db %10010000
        .db %11000000
        .db %00110000
        .db %10010000
        .db %11110000
        .db %11001000
        .db %10000100
        .db %10000011
        .db %10010000
        .db %00010000
        .db %00010000
        .db %00110000
        .db %00100000
        .db %11111000
        .db %00000110
        .db %10110001
        .db %11001111
        .db %01100010
        .db %00010001
        .db %11111111
        .db %10000001
        .db %00000000
LEADER2p3:
        .db %11111000
        .db %00101110
        .db %10000011
        .db %00111100
        .db %01010000
        .db %01100011
        .db %11001110
        .db %00011100
        .db %01100000
        .db %10000000
        .db %00000001
        .db %00000010
        .db %10000000
        .db %11000000
        .db %01100000
        .db %00111110
        .db %00011101
        .db %00001110
        .db %00001110
        .db %01000000
        .db %00100000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000001
        .db %11100000
        .db %00111000
        .db %00011111
        .db %00100000
        .db %01000000
        .db %10000000
        .db %10000000
        .db %10000000
        .db %10000000
        .db %11000001
        .db %01000110
        .db %01001100
        .db %01010000
        .db %11000000
LEADER2p4:
        .db %00111110
        .db %01000001
        .db %11011111
        .db %00101000
        .db %01011011
        .db %10001110
        .db %10010100
        .db %01100111
        .db %00000001
        .db %00000001
        .db %10110001
        .db %11101000
        .db %01000011
        .db %10100110
        .db %01000100
        .db %00011101
        .db %00110101
        .db %00011001
        .db %00011010
        .db %01000011
        .db %01000010
        .db %01100011
        .db %00110010
        .db %00100110
        .db %01000100
        .db %00001000
        .db %10010000
        .db %00100000
        .db %11000000
        .db %00000001
        .db %00000011
        .db %00000010
        .db %00001110
        .db %00011110
        .db %00110100
        .db %11001100
        .db %10001000
        .db %00001001
        .db %00001001
        .db %00001011
        .db %00011110
LEADER2p5:
        .db %10000000
        .db %01000000
        .db %11110000
        .db %10010000
        .db %00101110
        .db %10010010
        .db %11001010
        .db %01101001
        .db %10010101
        .db %01010011
        .db %10011001
        .db %11101010
        .db %01011110
        .db %10010000
        .db %10110000
        .db %10010000
        .db %01110000
        .db %01000000
        .db %10000000
        .db %01000100
        .db %10001110
        .db %00111010
        .db %00100110
        .db %01101100
        .db %01001000
        .db %10001000
        .db %10001100
        .db %10000011
        .db %10000001
        .db %10000000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00011110
        .db %00110011
        .db %01000000
        .db %11000000
        .db %10000000
        .db %10000000
        .db %00000000
        .db %00000000
LEADER2p6:
        .db %11000001
        .db %01111111
        .db %00000001
        .db %01111111
        .db %10001100
        .db %01111000
        .db %11000000
        .db %00000000
LEADER2p7:
        .db %11000000
        .db %10000000
        .db %10000000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000000
LEADER2p8:
        .db %00000011
        .db %00001110
        .db %00011011
        .db %00010110
        .db %00010011
        .db %00011101
        .db %00001011
        .db %00001110
        .db %00000100
        .db %00000011
        .db %00000011
LEADER3p1:
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %00000011
        .db %01111110
        .db %00110000
        .db %00011111
        .db %00001100
        .db %00000110
        .db %00000010
        .db %00000011
        .db %00000001
        .db %00000001
        .db %00000110
        .db %00011000
        .db %01101111
        .db %11110000
        .db %11000000
        .db %11111001
        .db %10010010
        .db %00100101
        .db %01100101
        .db %01011110
        .db %10110111
        .db %10100100
        .db %11000101
        .db %11000101
        .db %10001101
        .db %10011101
        .db %11110100
        .db %10110101
        .db %10100110
        .db %00100100
        .db %00111110
        .db %00010011
        .db %00000000
        .db %00000000
LEADER3p2:
        .db %00000000
        .db %00000000
        .db %00000011
        .db %00001101
        .db %00011001
        .db %01110111
        .db %11011101
        .db %00110011
        .db %11100110
        .db %10001100
        .db %00011011
        .db %00110110
        .db %01100101
        .db %10011010
        .db %01110100
        .db %11101011
        .db %00011110
        .db %00001100
        .db %10111010
        .db %01110011
        .db %10011000
        .db %01000101
        .db %01110111
        .db %00011001
        .db %10100010
        .db %00110011
        .db %00000000
        .db %00100100
        .db %00110110
        .db %10000001
        .db %00100001
        .db %10110100
        .db %00011100
        .db %00100100
        .db %10110110
        .db %11000011
        .db %00101100
        .db %00110101
        .db %11000010
        .db %00111111
LEADER3p3:
        .db %00000001
        .db %00001110
        .db %00000010
        .db %00000010
        .db %00001110
        .db %00111001
        .db %01100010
        .db %11111110
        .db %10000111
        .db %10000010
        .db %11000100
        .db %11011110
        .db %01100100
        .db %01001001
        .db %01111110
        .db %11000001
        .db %10010001
        .db %11011100
        .db %01000110
        .db %01101000
        .db %00001100
        .db %00000010
        .db %10111011
        .db %10001100
        .db %11100100
        .db %00110101
        .db %10000010
        .db %11010010
        .db %00011010
        .db %00000010
        .db %10100011
        .db %10110011
        .db %11001010
        .db %00010011
        .db %10011001
        .db %11111110
        .db %00001011
        .db %01010101
        .db %10000010
        .db %11111111
LEADER3p4:
        .db %11111000
        .db %00001100
        .db %00000111
        .db %11110100
        .db %10011000
        .db %01100000
        .db %00000000
        .db %11100100
        .db %10110110
        .db %00111000
        .db %00100101
        .db %01100110
        .db %10000000
        .db %01001001
        .db %01101101
        .db %00010000
        .db %10011001
        .db %00000111
        .db %01001000
        .db %01101000
        .db %00111000
        .db %10001100
        .db %01001100
        .db %00010101
        .db %11101101
        .db %00100110
        .db %00010001
        .db %00011010
        .db %00110100
        .db %01000011
        .db %11000000
        .db %00000000
        .db %00000000
        .db %00000000
        .db %11000000
        .db %01100000
        .db %11111111
        .db %01001000
        .db %00100110
        .db %11111111
LEADER3p5:
        .db %00000000
        .db %00000000
        .db %11100000
        .db %00111000
        .db %00001100
        .db %01110110
        .db %00011011
        .db %00010001
        .db %00000000
        .db %00000000
        .db %10000001
        .db %11011100
        .db %00110111
        .db %00100000
        .db %11000000
        .db %10000000
        .db %00000000
        .db %00000000
        .db %10000000
        .db %10000111
        .db %10000101
        .db %10001100
        .db %10001011
        .db %00010010
        .db %00110100
        .db %01001000
        .db %10010001
        .db %10100001
        .db %01100010
        .db %11000010
        .db %10000101
        .db %00000111
        .db %00001101
        .db %00001011
        .db %00110101
        .db %11010011
        .db %00100110
        .db %10011100
        .db %01110000
        .db %10000000
LEADER3p6:
        .db %11100000
        .db %01010000
        .db %00010000
        .db %11110000
        .db %01100000
        .db %10110000
        .db %00001000
        .db %00000100
        .db %00000011
        .db %00000001
        .db %00000000
        .db %00000000
        .db %10000000
        .db %00000000
        .db %11000000
        .db %10000000
        .db %00000000
        .db %00000000
        .db %01111100
        .db %10001010
        .db %00100100
        .db %01011000
        .db %11100000
        .db %10000000
VINE:
        .db %00011000
        .db %00110000
        .db %01100000
        .db %00110000
        .db %00011000
        .db %00001100
        .db %00011000
        .db %00110000
TITLE1:
        .db %11111111
        .db %01100101
        .db %01110001
        .db %01100001
        .db %01100001
        .db %11110011
        .db %00000000
        .db %00000000
TITLE2:
        .db %11111110
        .db %10010110
        .db %11000011
        .db %10000011
        .db %10000110
        .db %11001110
        .db %00000000
        .db %00000000
TITLE3:
        .db %11100110
        .db %11001110
        .db %10001110
        .db %10011010
        .db %11011111
        .db %11100110
        .db %00000000
        .db %00000000
PIC1:
        .db %11111111
        .db %10010000
        .db %11010111
        .db %11001100
        .db %10010010
        .db %10110101
        .db %11000000
        .db %11110011
        .db %11001010
        .db %10100101
        .db %11010011
        .db %11101011
        .db %10010101
        .db %11101111
        .db %10011111
        .db %11111111
PIC1p2:
        .db %11111111
        .db %00011011
        .db %10011101
        .db %11001111
        .db %01000111
        .db %01010001
        .db %11010011
        .db %01000011
        .db %10001001
        .db %00101001
        .db %00100001
        .db %11000011
        .db %01101011
        .db %10101001
        .db %11100001
        .db %11111111
PIC2:
        .db %11111111
        .db %10000000
        .db %10101000
        .db %10010000
        .db %10000000
        .db %11010100
        .db %10100010
        .db %10000001
        .db %10000000
        .db %10011000
        .db %10100100
        .db %11000011
        .db %10010100
        .db %10101001
        .db %10000010
        .db %11111111
PIC2p2:
        .db %11111111
        .db %00011001
        .db %00110101
        .db %00111101
        .db %00011001
        .db %01000001
        .db %10000001
        .db %00001001
        .db %00010101
        .db %01101011
        .db %10010011
        .db %00001001
        .db %10100101
        .db %00010011
        .db %01000101
        .db %11111111
HANDp1:
        .db %11111111
        .db %11111111
        .db %11111111
        .db %11111111
        .db %11111110
        .db %11111110
        .db %11111100
        .db %11111111
HANDp2:
        .db %00000001
        .db %00001110
        .db %00110000
        .db %11000100
        .db %00000010
        .db %00010110
        .db %00101100
        .db %00010110
        .db %11000010
        .db %00110100
        .db %00001111
HANDp3:
        .db %11110000
        .db %01001000
        .db %00011110
        .db %01000001
        .db %00110110
        .db %00000001
        .db %00110110
        .db %00000001
        .db %00110110
        .db %01111100
        .db %11100000
CRYSTAL:
        .db %00010000
        .db %00111000
        .db %01101100
        .db %01000100
        .db %10110010
        .db %11101110
        .db %10100110
        .db %11000110
        .db %10110010
        .db %11000110
        .db %11010010
        .db %10011010
        .db %10100010
        .db %11001110
        .db %01100100
        .db %01010100
        .db %00101000
        .db %00010000
PORTAL:
        .db %11111111
        .db %01111110
        .db %00101100
        .db %01110110
        .db %01101110
        .db %01110110
        .db %11111011
        .db %11111111
TOWER:
        .db %00011110
        .db %00011010
        .db %00010110
        .db %00011010
        .db %00010110
        .db %00010010
        .db %01101001
        .db %11010001
DRAKES:
        .db %01100000
        .db %11011000
        .db %10110110
        .db %10110001
        .db %10001111
        .db %10010101
        .db %10010000
        .db %01001000
        .db %01000100
        .db %01101010
        .db %00110001
        .db %00001011
        .db %00001001
        .db %00011011
        .db %00110010
        .db %01000100
        .db %01101010
        .db %00110001
        .db %00001011
        .db %00001001
        .db %00010111
        .db %00100110
        .db %01010100
        .db %01001100
        .db %01100010
        .db %00110101
        .db %00001011
        .db %00001001
        .db %00010011
        .db %00101010
        .db %00101100
        .db %00010100
        .db %10011010
        .db %11011001
        .db %10101111
        .db %10011001
        .db %01101110
        .db %00100100
        .db %00011100
ENDISISp1:
        .db %00000001
        .db %00000001
        .db %00000001
        .db %00000010
        .db %00011110
        .db %00100100
        .db %01000101
        .db %01001100
        .db %01001001
        .db %10011100

ENDISISp2
       .db %00000001
       .db %00000010
       .db %00000100
       .db %00001000
       .db %00010000
       .db %00110000
       .db %01000000
       .db %01000100
       .db %01000100
       .db %01000100
       .db %01000100
       .db %01000100
       .db %01001000
       .db %01010001
       .db %10010001
       .db %10000001
       .db %10100010
       .db %10000100
       .db %10000000
       .db %10000000
       .db %00100010
       .db %00000100
       .db %01000101
       .db %01000000
       .db %10010010
       .db %00100010
       .db %00000001
       .db %00010011
       .db %00100000
       .db %00001100
ENDISISp3:
       .db %11111111
       .db %00000000
       .db %00100000
       .db %00000011
       .db %00001000
       .db %10000010
       .db %10010001
       .db %10000001
       .db %01000001
       .db %00010000
       .db %10010000
       .db %10000001
       .db %00010001
       .db %00100000
       .db %00001100
       .db %00100000
       .db %00100000
       .db %01000000
       .db %01000001
       .db %01000110
       .db %10001001
       .db %00001001
       .db %00010000
       .db %00100001
       .db %00100001
       .db %11000010
       .db %00100110
       .db %00001111
       .db %10001101
       .db %00001101
ENDISISp4:
       .db %00000000
       .db %10000000
       .db %01000000
       .db %01100000
       .db %00010000
       .db %00001000
       .db %00001000
       .db %00011000
       .db %10101000
       .db %10001000
       .db %01010000
       .db %00010000
       .db %00110000
       .db %00100000
       .db %01000000
       .db %01000000
       .db %01000000
       .db %11000000
       .db %01000000
       .db %10000000
       .db %10000000
       .db %11000000
       .db %11000000
       .db %00100000
       .db %00111000
       .db %00010000
       .db %01010000
       .db %01001000
       .db %01100000
       .db %11011000
ENDISISp5:
       .db %00000000
       .db %00000000
       .db %11111100
       .db %10001110
       .db %10011010
       .db %00001101
       .db %11100001
       .db %00011001
RUINOFWORLDp1:
       .db %00000000
       .db %00000000
       .db %00000000
       .db %00000001
       .db %00000011
       .db %00000010
       .db %00000110
       .db %00001100
       .db %00110011
       .db %00100111
       .db %01100010
       .db %11111111
RUINOFWORLDp2:
       .db %00111111
       .db %11000011
       .db %10010110
       .db %10000100
       .db %01001111
       .db %00110000
       .db %01111000
       .db %11110010
       .db %10100010
       .db %00101000
       .db %00101000
       .db %11111111
RUINOFWORLDp3:
       .db %00010010
       .db %00101101
       .db %00100100
       .db %11110100
       .db %00010110
       .db %00110100
       .db %01111100
       .db %10110101
       .db %00100100
       .db %01100110
       .db %01000001
       .db %11111111
RUINOFWORLDp4:
       .db %00000000
       .db %11000000
       .db %00100000
       .db %00100000
       .db %10100000
       .db %00100000
       .db %00100000
       .db %00100111
       .db %00111100
       .db %00110101
       .db %00101100
       .db %11111111
RUINOFWORLDp5:
       .db %00000000
       .db %00000000
       .db %00000000
       .db %00000000
       .db %00000000
       .db %00000000
       .db %00000000
       .db %10001100
       .db %10111010
       .db %11100001
       .db %01100101
       .db %11111111

.end
