/**
 * A simple servlet which stores all names entered and displays
 * them each time it is called.
 *
 * This file was automatically generated by
 * Omnicore CodeGuide.
 */

import java.net.*;
import java.util.*;
import java.io.*;

import java.awt.*;
import java.awt.event.*;

import com.sun.web.core.*;
import com.sun.web.server.*;

/**
 * Starts the servlet web server.
 *
 * This utility is supplied so servlets can be developed, tested
 * and debugged from within CodeGuide.
 *
 * It starts a simple web server (as supplied with the JWSDK) on the specified port.
 *
 * The corresponding files ServletWebServerStartup.class and ServletWebServerStartup$1.class
 * do not need to be deployed on your web server.
 */
public class ServletWebServerStartup
{
	/** Starts the servlet web server. */
    public static void main(String[] args)
	{
		// Check for correct usage.
		if (args.length != 3) usage();
		
		// null uses all inets on the machine.
		InetAddress inet = null;
		
		// Local host.
		String hostname = null;
		
		// Parse port.
		int port = 8080;
		try
		{
			port = Integer.parseInt(args[0]);
		}
		catch (NumberFormatException e)
		{
			// Parse did not succeed.
			usage();
		}
		
		// Create web server.
		HttpServer server = new HttpServer(port, inet, hostname);
		
		// Check document base.
		File docBase = new File(args[1]);
		if (!docBase.exists() || ! docBase.isDirectory())
		{
			System.out.println("The given document base (" + args[1] + ") is not valid!");
			System.exit(-1);
		}
		
		// Check temporary directory.
		File tmpDir = new File(args[2]);
		if (!tmpDir.exists() || !tmpDir.isDirectory() || !tmpDir.canRead()|| !tmpDir.canWrite())
		{
			System.out.println("The given temporary directory ("+args[2]+") is not valid!");
			System.exit(-1);
		}
		
		// Start server.
		try
		{
			URL docBaseUrl = new URL("file:"+docBase);
			server.setWorkDir(tmpDir);
			server.setDocumentBase(docBaseUrl);
			server.start();
		}
		catch (MalformedURLException e)
		{
			System.out.println("The given document base (file:" + docBase + ") does not form a valid URL!");
			System.exit(-1);
		}
		catch (HttpServerException hse)
		{
			System.out.println("The server threw an exception while running:");
			hse.printStackTrace();
			System.exit(-1);
		}
		
		// Show a dialog that the server has been started.
		// Can be removed safely.
		showServerStartedDialog(port);
    }
	
	/** Prints usage and exits. */
	private static void usage()
	{
		System.out.println("Usage: ServletServerStartup http_port document_base temp_dir");
		System.exit(-1);
	}
	
	/** Shows a dialog that the server has been started. */
	private static void showServerStartedDialog(int port)
	{
		final Frame frame = new Frame();
		final Dialog dialog = new Dialog(frame,"Web Server Startup");
		ActionListener closeAction = new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				dialog.setVisible(false);
				dialog.dispose();
				frame.dispose();
			}
		};
		Button okButton = new Button("OK");
		okButton.addActionListener(closeAction);
		Panel buttonPanel = new Panel();
		buttonPanel.setLayout(new FlowLayout());
		buttonPanel.add(okButton);
		dialog.setLayout(new BorderLayout());
		dialog.add
		(
			new Label
			(
				"The web server has been started. " +
					"Point your web browser to http://localhost:" + port +
					" to test the servelet!",
				Label.CENTER
			),
			BorderLayout.CENTER
		);
		dialog.add(buttonPanel,BorderLayout.SOUTH);
		dialog.pack();
		dialog.show();
	}
}
