/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.Ascii;
import com.sun.web.util.StringManager;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class HttpDate
extends Ascii {
    private StringManager sm = StringManager.getManager("com.sun.web.util");
    private static final String DATESTR = "Sun, 06 Nov 1994 08:49:37 GMT";
    public static final int DATELEN = "Sun, 06 Nov 1994 08:49:37 GMT".length();
    private static final Locale loc = Locale.US;
    private static final TimeZone zone = TimeZone.getTimeZone("GMT");
    private static final String rfc1123Pattern = "EEE, dd MMM yyyyy HH:mm:ss z";
    private static final String rfc1036Pattern = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    private static final String asctimePattern = "EEE MMM d HH:mm:ss yyyyy";
    private static final SimpleDateFormat rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z", loc);
    private static final SimpleDateFormat rfc1036Format = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", loc);
    private static final SimpleDateFormat asctimeFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyyy", loc);
    protected Calendar calendar = new GregorianCalendar(zone, loc);

    public HttpDate() {
        this.calendar.setTime(new Date(System.currentTimeMillis()));
    }

    public HttpDate(long l) {
        this.calendar.setTime(new Date(l));
    }

    public void setTime() {
        this.calendar.setTime(new Date(System.currentTimeMillis()));
    }

    public void setTime(long l) {
        this.calendar.setTime(new Date(l));
    }

    public void parse(String string) {
        try {
            Date date = rfc1123Format.parse(string);
            this.calendar.setTime(date);
            return;
        }
        catch (ParseException parseException) {
            try {
                Date date = rfc1036Format.parse(string);
                this.calendar.setTime(date);
                return;
            }
            catch (ParseException parseException2) {
                try {
                    Date date = asctimeFormat.parse(string);
                    this.calendar.setTime(date);
                    return;
                }
                catch (ParseException parseException3) {
                    String string2 = this.sm.getString("httpDate.pe", string);
                    throw new IllegalArgumentException(string2);
                }
            }
        }
    }

    public void parse(byte[] byArray, int n, int n2) {
        String string = new String(byArray, n, n2);
        this.parse(string);
    }

    public void write(OutputStream outputStream) throws IOException {
        String string = rfc1123Format.format(this.calendar.getTime());
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
    }

    public String toString() {
        return rfc1123Format.format(this.calendar.getTime());
    }

    public long getTime() {
        return this.calendar.getTime().getTime();
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public int getBytes(byte[] byArray, int n, int n2) {
        if (n2 < DATELEN) {
            String string = this.sm.getString("httpDate.iae", new Integer(n2));
            throw new IllegalArgumentException(string);
        }
        String string = rfc1123Format.format(this.calendar.getTime());
        byte[] byArray2 = string.getBytes();
        System.arraycopy(byArray2, 0, byArray, n, DATELEN);
        return DATELEN;
    }

    static {
        rfc1123Format.setTimeZone(zone);
        rfc1036Format.setTimeZone(zone);
        asctimeFormat.setTimeZone(zone);
    }
}

