/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.StringManager;

public class Ascii {
    private static final byte[] toUpper;
    private static final byte[] toLower;
    private static final boolean[] isAlpha;
    private static final boolean[] isUpper;
    private static final boolean[] isLower;
    private static final boolean[] isWhite;
    private static final boolean[] isDigit;

    public static int toUpper(int n) {
        return toUpper[n & 0xFF] & 0xFF;
    }

    public static int toLower(int n) {
        return toLower[n & 0xFF] & 0xFF;
    }

    public static boolean isAlpha(int n) {
        return isAlpha[n & 0xFF];
    }

    public static boolean isUpper(int n) {
        return isUpper[n & 0xFF];
    }

    public static boolean isLower(int n) {
        return isLower[n & 0xFF];
    }

    public static boolean isWhite(int n) {
        return isWhite[n & 0xFF];
    }

    public static boolean isDigit(int n) {
        return isDigit[n & 0xFF];
    }

    public static int parseInt(byte[] byArray, int n, int n2) throws NumberFormatException {
        byte by;
        if (byArray == null || n2 <= 0 || !Ascii.isDigit(by = byArray[n++])) {
            StringManager stringManager = StringManager.getManager("com.sun.web.util");
            String string = stringManager.getString("ascii.parseInit.nfe", (Object)byArray);
            throw new NumberFormatException(string);
        }
        int n3 = by - 48;
        while (--n2 > 0) {
            if (!Ascii.isDigit(by = byArray[n++])) {
                StringManager stringManager = StringManager.getManager("com.sun.web.util");
                String string = stringManager.getString("ascii.parseInit.nfe", (Object)byArray);
                throw new NumberFormatException(string);
            }
            n3 = n3 * 10 + by - 48;
        }
        return n3;
    }

    static {
        int n;
        toUpper = new byte[256];
        toLower = new byte[256];
        isAlpha = new boolean[256];
        isUpper = new boolean[256];
        isLower = new boolean[256];
        isWhite = new boolean[256];
        isDigit = new boolean[256];
        int n2 = 0;
        while (n2 < 256) {
            Ascii.toUpper[n2] = (byte)n2;
            Ascii.toLower[n2] = (byte)n2;
            ++n2;
        }
        int n3 = 97;
        while (n3 <= 122) {
            n = n3 + 65 - 97;
            Ascii.toUpper[n3] = (byte)n;
            Ascii.toLower[n] = (byte)n3;
            Ascii.isAlpha[n3] = true;
            Ascii.isAlpha[n] = true;
            Ascii.isLower[n3] = true;
            Ascii.isUpper[n] = true;
            ++n3;
        }
        Ascii.isWhite[32] = true;
        Ascii.isWhite[9] = true;
        Ascii.isWhite[13] = true;
        Ascii.isWhite[10] = true;
        Ascii.isWhite[12] = true;
        Ascii.isWhite[8] = true;
        n = 48;
        while (n <= 57) {
            Ascii.isDigit[n] = true;
            ++n;
        }
    }
}

