/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.shell;

import com.sun.web.shell.StartupException;
import com.sun.web.shell.WebServerConfig;
import com.sun.web.shell.WebServerConfigParser;
import com.sun.web.util.StringManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class WebServerConfigUtil {
    private StringManager sm = StringManager.getManager("com.sun.web.shell");
    private String[] args;
    private URL configURL;

    public WebServerConfigUtil() throws StartupException {
        this(null);
    }

    public WebServerConfigUtil(String[] stringArray) throws StartupException {
        this.args = stringArray;
    }

    public WebServerConfig loadConfig(String string) throws StartupException {
        return this.loadConfig(string, true);
    }

    public WebServerConfig loadConfig(String string, boolean bl) throws StartupException {
        Object object;
        WebServerConfig webServerConfig = null;
        File file = new File(string);
        if (this.isArg("validate")) {
            object = this.getArg("validate");
            bl = Boolean.valueOf((String)object);
        }
        if (!file.exists() && !this.isArg("noconfig")) {
            this.createConfigFile(string);
        }
        try {
            this.configURL = this.resolveURL(string, null);
        }
        catch (MalformedURLException malformedURLException) {
            object = this.sm.getString("startup.loadconfig.mue", string);
            throw new StartupException((String)object);
        }
        System.out.println(this.sm.getString("startup.loadconfig.msg", this.configURL));
        object = new WebServerConfigParser();
        try {
            webServerConfig = ((WebServerConfigParser)object).process(this.configURL, bl);
        }
        catch (Exception exception) {
            this.sm.getString("config.xml.parse.e", exception.getMessage());
            throw new StartupException(exception.getMessage());
        }
        return webServerConfig;
    }

    public void processArgs(WebServerConfig webServerConfig) {
        Object object;
        String string = (String)webServerConfig.getAttribute("id");
        String cfr_ignored_0 = (String)webServerConfig.getAttribute("adminPort");
        Vector<String> vector = new Vector<String>();
        vector.addElement("adminPort");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.isArg((String)object)) continue;
            webServerConfig.addAttribute(object, this.getArg((String)object));
        }
        enumeration = webServerConfig.elements();
        while (enumeration.hasMoreElements()) {
            object = (WebServerConfig)enumeration.nextElement();
            string = (String)((WebServerConfig)object).getAttribute("id");
            vector = new Vector();
            vector.addElement("port");
            vector.addElement("hostName");
            vector.addElement("inet");
            vector.addElement("docBase");
            vector.addElement("workDir");
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                if (this.isArg(String.valueOf(string2) + ":" + string)) {
                    ((WebServerConfig)object).addAttribute(string2, this.getArg(String.valueOf(string2) + ":" + string));
                    continue;
                }
                if (this.isArg(String.valueOf(string2) + ":*")) {
                    ((WebServerConfig)object).addAttribute(string2, this.getArg(String.valueOf(string2) + ":*"));
                    continue;
                }
                if (!this.isArg(string2) || webServerConfig.getElements().size() != 1 && !string.equals(this.getArg("serviceid"))) continue;
                ((WebServerConfig)object).addAttribute(string2, this.getArg(string2));
            }
        }
    }

    public URL resolveURL(String string) throws MalformedURLException {
        return this.resolveURL(string, this.configURL);
    }

    public boolean isArg(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n].equalsIgnoreCase("-" + string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public String getArg(String string) {
        String string2 = null;
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n].equalsIgnoreCase("-" + string) && n < this.args.length - 1) {
                string2 = this.args[n + 1];
                break;
            }
            ++n;
        }
        return string2;
    }

    private void createConfigFile(String string) throws StartupException {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            byte[] byArray = new byte[1024];
            int n = 0;
            do {
                fileOutputStream.write(byArray, 0, n);
            } while ((n = inputStream.read(byArray, 0, byArray.length)) > -1);
            inputStream.close();
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            String string2 = this.sm.getString("startup.loadconfig.ioe", string);
            throw new StartupException(string2);
        }
    }

    private URL resolveURL(String string, URL uRL) throws MalformedURLException {
        URL uRL2 = null;
        if (string.indexOf("://") > -1) {
            uRL2 = new URL(string);
        } else if (uRL != null) {
            uRL2 = new URL(uRL, string);
        } else if (string.startsWith(File.separator) || string.startsWith("/") || string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            String string2 = string;
            try {
                string2 = new File(string).getCanonicalPath();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException iOException) {}
            uRL2 = new URL("file", null, string2);
        } else {
            String string3 = String.valueOf(System.getProperty("user.dir")) + File.separator + string;
            uRL2 = new URL("file", null, string3);
        }
        return uRL2;
    }

    public static void main(String[] stringArray) {
        try {
            new WebServerConfigUtil(stringArray);
            return;
        }
        catch (StartupException startupException) {
            System.out.println(startupException.getMessage());
            return;
        }
    }
}

