/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.shell;

import com.sun.web.shell.WebServerConfig;
import com.sun.web.util.StringManager;
import com.sun.xml.parser.Resolver;
import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WebServerConfigParser {
    private XmlDocument doc;
    private StringManager sm = StringManager.getManager("com.sun.web.shell");
    private static final boolean DefaultCheckType = false;
    private static final String DefaultContentType = "text/html;charset=utf-8";
    private static final String DefaultScheme = "file";
    private static final boolean DefaultXMLValidate = true;

    public void WebServerConfigParser() {
        this.clear();
    }

    public void clear() {
        this.doc = null;
    }

    public WebServerConfig process(InputStream inputStream) throws IOException, SAXParseException, SAXException {
        return this.process(inputStream, false, DefaultContentType, DefaultScheme);
    }

    public WebServerConfig process(InputStream inputStream, boolean bl) throws IOException, SAXParseException, SAXException {
        return this.process(inputStream, bl, DefaultContentType, DefaultScheme);
    }

    public WebServerConfig process(InputStream inputStream, boolean bl, String string) throws IOException, SAXParseException, SAXException {
        return this.process(inputStream, bl, string, DefaultScheme);
    }

    public WebServerConfig process(InputStream inputStream, boolean bl, String string, String string2) throws IOException, SAXParseException, SAXException {
        return this.parse(Resolver.createInputSource((String)string, (InputStream)inputStream, (boolean)bl, (String)string2));
    }

    public WebServerConfig process(URL uRL) throws IOException, SAXParseException, SAXException {
        return this.process(uRL, false);
    }

    public WebServerConfig process(URL uRL, boolean bl) throws IOException, SAXParseException, SAXException {
        return this.parse(Resolver.createInputSource((URL)uRL, (boolean)bl), bl);
    }

    private WebServerConfig parse(InputSource inputSource) throws IOException, SAXParseException, SAXException {
        return this.parse(inputSource, true);
    }

    private WebServerConfig parse(InputSource inputSource, boolean bl) throws IOException, SAXParseException, SAXException {
        try {
            this.doc = XmlDocument.createXmlDocument((InputSource)inputSource, (boolean)bl);
        }
        catch (SAXParseException sAXParseException) {
            String string = String.valueOf(this.sm.getString("startup.xml.parse")) + ": " + sAXParseException.getSystemId() + " : " + sAXParseException.getLineNumber() + "\n  msg : " + sAXParseException.getMessage();
            throw new SAXParseException(string, sAXParseException.getPublicId(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        }
        WebServerConfig webServerConfig = new WebServerConfig();
        Element element = this.doc.getDocumentElement();
        webServerConfig.setName(element.getTagName());
        this.addAttributes(webServerConfig, element);
        this.addElements(webServerConfig, element);
        return webServerConfig;
    }

    public void write() throws IOException {
        this.write(null);
    }

    public void write(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            outputStream = System.out;
        }
        this.doc.getDocumentElement().normalize();
        this.doc.write(outputStream);
    }

    private void addAttributes(WebServerConfig webServerConfig, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node2 = namedNodeMap.item(n);
            webServerConfig.addAttribute(node2.getNodeName(), node2.getNodeValue());
            ++n;
        }
    }

    private void addElements(WebServerConfig webServerConfig, Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            WebServerConfig webServerConfig2 = new WebServerConfig();
            Node node2 = nodeList.item(n);
            webServerConfig2.setName(node2.getNodeName());
            this.addAttributes(webServerConfig2, node2);
            this.addElements(webServerConfig2, node2);
            webServerConfig.addElement(webServerConfig2);
            ++n;
        }
    }
}

