/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.shell;

import com.sun.web.core.Context;
import com.sun.web.server.HttpServer;
import com.sun.web.server.HttpServerException;
import com.sun.web.shell.AdminImpl;
import com.sun.web.shell.StartupException;
import com.sun.web.shell.WebServerConfig;
import com.sun.web.shell.WebServerConfigUtil;
import com.sun.web.util.StringManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.Random;

public class Startup {
    private StringManager sm = StringManager.getManager("com.sun.web.shell");
    private String[] args;
    private WebServerConfigUtil util;
    private static final int MaximumAdminPortAttempts = 5;
    private static final int MinimumAdminPort = 2048;
    private static final int MaximumAdminPort = 8192;

    public Startup(String[] stringArray) throws StartupException {
        this.args = stringArray;
        this.util = new WebServerConfigUtil(stringArray);
        System.out.println(this.sm.getString("startup.banner"));
        if (this.util.isArg("help")) {
            System.out.println(this.sm.getString("startup.help"));
            System.out.println();
            return;
        }
        WebServerConfig webServerConfig = new WebServerConfig();
        String string = "webserver.xml";
        if (this.util.isArg("config")) {
            string = this.util.getArg("config");
        }
        webServerConfig = this.util.loadConfig(string);
        this.util.processArgs(webServerConfig);
        Registry registry = this.createRegistry((String)webServerConfig.getAttribute("adminPort"));
        Enumeration enumeration = webServerConfig.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            Object object3;
            WebServerConfig webServerConfig2 = (WebServerConfig)enumeration.nextElement();
            String cfr_ignored_0 = (String)webServerConfig2.getAttribute("id");
            String string2 = (String)webServerConfig2.getAttribute("port");
            String string3 = (String)webServerConfig2.getAttribute("hostName");
            String string4 = (String)webServerConfig2.getAttribute("inet");
            String string5 = (String)webServerConfig2.getAttribute("docBase");
            String string6 = (String)webServerConfig2.getAttribute("workDir");
            String string7 = (String)webServerConfig2.getAttribute("workDirIsPersistent");
            int n = Integer.parseInt(string2);
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string4);
            }
            catch (UnknownHostException unknownHostException) {
                object3 = this.sm.getString("startup.setinit.uhe1", string4);
                throw new StartupException((String)object3);
            }
            object3 = new HttpServer(n, inetAddress, string3);
            try {
                registry.bind("service:" + n, new AdminImpl((HttpServer)object3));
            }
            catch (Exception exception) {
                System.out.println(this.sm.getString("startup.registry.e"));
                System.out.println(exception.toString());
            }
            try {
                ((HttpServer)object3).setWorkDir(string6);
                ((HttpServer)object3).setWorkDirPersistent(Boolean.valueOf(string7));
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(this.sm.getString("startup.setworkdir.npe", string6));
            }
            try {
                ((HttpServer)object3).setDocumentBase(this.util.resolveURL(string5));
            }
            catch (MalformedURLException malformedURLException) {
                object2 = this.sm.getString("startup.setdocbase.mue2", string5);
                throw new StartupException((String)object2);
            }
            catch (NullPointerException nullPointerException) {
                object2 = this.sm.getString("startup.setdocbase.npe");
                throw new StartupException((String)object2);
            }
            object2 = webServerConfig2.elements();
            while (object2.hasMoreElements()) {
                object = (WebServerConfig)object2.nextElement();
                String string8 = (String)((WebServerConfig)object).getAttribute("id");
                String string9 = (String)((WebServerConfig)object).getAttribute("mapping");
                String string10 = (String)((WebServerConfig)object).getAttribute("docBase");
                Context context = ((HttpServer)object3).createContext(string8, string9);
                URL uRL = null;
                try {
                    uRL = this.util.resolveURL(string10);
                }
                catch (MalformedURLException malformedURLException) {
                    String string11 = this.sm.getString("startup.configapp.mue", string10);
                    throw new StartupException(string11);
                }
                context.setDocumentBase(uRL);
                context.init();
            }
            try {
                Class.forName("sun.tools.javac.Main");
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = this.sm.getString("startup.classes.cnfe", "sun.tools.javac.Main");
                System.out.println("warning: " + (String)object);
            }
            try {
                ((HttpServer)object3).start();
            }
            catch (HttpServerException httpServerException) {
                System.out.println(httpServerException.getMessage());
            }
        }
    }

    private Registry createRegistry(String string) throws StartupException {
        String string2;
        Registry registry = null;
        int n = 0;
        int n2 = -1;
        try {
            n2 = string == null || string.trim().length() == 0 ? this.nextPort() : Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new StartupException(this.sm.getString("startup.setport.nfe", string));
        }
        while (true) {
            string2 = null;
            try {
                registry = LocateRegistry.createRegistry(n2);
                this.createLog(n2);
            }
            catch (Exception exception) {
                string2 = this.sm.getString("startup.registry.e");
            }
            if (registry != null || n++ >= 5) break;
            n2 = this.nextPort();
        }
        if (registry == null) {
            throw new StartupException(string2);
        }
        return registry;
    }

    private int nextPort() {
        Random random = new Random();
        double d = random.nextDouble();
        int n = 2048;
        int n2 = 8192;
        return (int)Math.round((double)n + d * (double)(n2 - n));
    }

    private void createLog(int n) {
        File file = null;
        try {
            file = new File("webserverlog.txt");
        }
        catch (NullPointerException nullPointerException) {
            System.out.println(this.sm.getString("startup.log.npe", "webserver.xml"));
        }
        if (file != null) {
            try {
                if (file.exists() && file.isFile()) {
                    file.delete();
                }
            }
            catch (SecurityException securityException) {
                System.out.println(this.sm.getString("startup.log.se", "webserver.xml"));
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write("admin.port:" + n);
                bufferedWriter.newLine();
                bufferedWriter.close();
                return;
            }
            catch (IOException iOException) {
                System.out.println(this.sm.getString("startup.log.ioe", "webserver.xml"));
                return;
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            new Startup(stringArray);
            return;
        }
        catch (StartupException startupException) {
            System.out.println(startupException.getMessage());
            return;
        }
    }
}

