/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.web.server.ServerResponse;
import com.sun.web.util.StringManager;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class ServletOutputStreamImpl
extends ServletOutputStream {
    private StringManager sm = StringManager.getManager("com.sun.web.server");
    private ServerResponse response;
    private OutputStream out;
    private byte[] buffer = new byte[4096];
    private int bufferCount;
    private int totalCount;
    private boolean committed = false;
    private boolean closed = false;

    ServletOutputStreamImpl(ServerResponse serverResponse, OutputStream outputStream) {
        this.response = serverResponse;
        this.out = outputStream;
    }

    public void write(int n) throws IOException {
        if (this.closed) {
            return;
        }
        this.buffer[this.bufferCount] = (byte)n;
        ++this.bufferCount;
        ++this.totalCount;
        if (this.bufferCount >= this.buffer.length) {
            this.flush();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return;
        }
        if (n2 < 0) {
            String string = this.sm.getString("servletOutputStreamImpl.write.iae");
            throw new IllegalArgumentException(string);
        }
        if (n2 >= this.buffer.length) {
            this.flush();
            this.out.write(byArray, n, n2);
            return;
        }
        if (n2 > this.buffer.length - this.bufferCount) {
            this.flush();
        }
        System.arraycopy(byArray, n, this.buffer, this.bufferCount, n2);
        this.bufferCount += n2;
    }

    public void flush() throws IOException {
        if (!this.committed) {
            this.response.writeHeaders(this.out);
            this.committed = true;
        }
        if (this.bufferCount > 0) {
            this.out.write(this.buffer, 0, this.bufferCount);
        }
        this.bufferCount = 0;
    }

    public void close() throws IOException {
        this.closed = true;
        this.flush();
        this.out.close();
    }
}

