/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.web.core.Context;
import com.sun.web.core.Server;
import com.sun.web.server.EndpointManager;
import com.sun.web.server.HttpServerException;
import com.sun.web.util.StringManager;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class HttpServer
implements Server {
    private StringManager sm = StringManager.getManager("com.sun.web.server");
    private int port = 80;
    private InetAddress address;
    private String hostname = "";
    private String serverInfo;
    private String serverHeader;
    private Context defaultContext;
    private Hashtable contexts = new Hashtable();
    private Hashtable contextMaps = new Hashtable();
    private File workDir = new File(String.valueOf(System.getProperty("user.dir", ".")) + System.getProperty("file.separator") + "work");
    private boolean isWorkDirPersistent = false;
    private static final String ServerProperties = "server.properties";

    public HttpServer() {
        this(80, null, null);
    }

    public HttpServer(int n, InetAddress inetAddress, String string) {
        this.port = n;
        this.address = inetAddress;
        this.hostname = string;
        this.defaultContext = new Context(this, "default");
        this.defaultContext.setPath("");
        this.contexts.put("default", this.defaultContext);
        Properties properties = this.getProperties(ServerProperties);
        this.serverHeader = properties.getProperty("server.header", "JavaServer Web Dev Kit/1.0 EA with JSP/1.0 and Servlet/2.1");
        this.serverInfo = this.defaultContext.getEngineHeader();
    }

    public void setWorkDir(String string) throws NullPointerException {
        if (string == null || string != null && string.trim().length() == 0) {
            String string2 = this.sm.getString("server.workDir.npe");
            throw new NullPointerException(string2);
        }
        this.setWorkDir(new File(string));
    }

    public void setWorkDir(File file) throws NullPointerException {
        if (file == null) {
            String string = this.sm.getString("server.workDir.npe");
            throw new NullPointerException(string);
        }
        this.workDir = file;
    }

    public boolean isWorkDirPersistent() {
        return this.isWorkDirPersistent();
    }

    public void setWorkDirPersistent(boolean bl) {
        this.isWorkDirPersistent = bl;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setHostName(String string) {
        this.hostname = string;
    }

    public String getHostName() {
        return this.hostname;
    }

    public void setServerInfo(String string) {
        this.serverInfo = string;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public URL getDocumentBase() {
        return this.defaultContext.getDocumentBase();
    }

    public void setDocumentBase(URL uRL) {
        this.defaultContext.setDocumentBase(uRL);
    }

    public Context getDefaultContext() {
        return this.defaultContext;
    }

    public Context createContext(String string, String string2) {
        return this.createContext(string, string2, this.isWorkDirPersistent);
    }

    public Context createContext(String string, String string2, boolean bl) {
        Context context = (Context)this.contexts.get(string);
        if (context != null) {
            String string3 = this.sm.getString("server.createctx.existname", string);
            throw new IllegalStateException(string3);
        }
        context = (Context)this.contextMaps.get(string2);
        if (context != null) {
            String string4 = this.sm.getString("server.createctx.existmap", string2);
            throw new IllegalStateException(string4);
        }
        context = new Context(this, string);
        context.setPath(string2);
        context.setWorkDir(this.getWorkDir(string2), bl);
        this.contexts.put(string, context);
        this.contextMaps.put(string2, context);
        return context;
    }

    public Enumeration getContextNames() {
        return this.contexts.keys();
    }

    public Context getContext(String string) {
        return (Context)this.contexts.get(string);
    }

    public Context getContextByPath(String string) {
        Context context = null;
        do {
            if ((context = (Context)this.contextMaps.get(string)) != null) continue;
            int n = string.lastIndexOf(47);
            if (n <= -1 || string.length() <= 1) break;
            if ((string = string.substring(0, n)).length() != 0) continue;
            string = "/";
        } while (context == null);
        if (context == null) {
            context = this.defaultContext;
        }
        return context;
    }

    public void removeContext(String string) {
    }

    public void start() throws HttpServerException {
        this.defaultContext.setWorkDir(this.getWorkDir(), this.isWorkDirPersistent);
        this.defaultContext.init();
        EndpointManager endpointManager = EndpointManager.getManager();
        endpointManager.startServer(this);
    }

    public void stop() throws HttpServerException {
        System.out.println("Shutting down Http Server");
        EndpointManager endpointManager = EndpointManager.getManager();
        endpointManager.stopServer(this);
        Enumeration enumeration = this.contexts.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Context context = (Context)this.contexts.get(string);
            System.out.println("Taking down context: " + string);
            context.shutdown();
        }
        try {
            this.workDir.delete();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private Properties getProperties(String string) {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream(string));
        }
        catch (IOException iOException) {}
        return properties;
    }

    private File getWorkDir() {
        return this.getWorkDir("");
    }

    private File getWorkDir(String string) {
        if (string == null || string.trim().length() == 0 || !string.trim().startsWith("/")) {
            string = "/" + string.trim();
        }
        return new File(this.workDir, this.encodeWorkDirPath(string));
    }

    private String encodeWorkDirPath(String string) {
        String string2 = this.hostname == null ? "" : this.hostname;
        String string3 = Integer.toString(this.port);
        return URLEncoder.encode(String.valueOf(string2) + ":" + string3 + string);
    }
}

