/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.web.net.ServerSocketFactory;
import com.sun.web.server.ConnectionHandler;
import com.sun.web.server.Endpoint;
import com.sun.web.server.HttpServer;
import com.sun.web.server.HttpServerException;
import com.sun.web.util.StringManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EndpointManager {
    private StringManager sm = StringManager.getManager("com.sun.web.server");
    private static final int BACKLOG = 50;
    private static final int TIMEOUT = 1000;
    private static EndpointManager manager = new EndpointManager();
    private Vector endpoints = new Vector();
    private Hashtable endpointMaps = new Hashtable();
    private ServerSocketFactory factory = ServerSocketFactory.getDefault();
    private int backlog = 50;
    private int timeout = 1000;

    public static EndpointManager getManager() {
        return manager;
    }

    private EndpointManager() {
    }

    ConnectionHandler getHandler() {
        return new ConnectionHandler(this);
    }

    void returnHandler(ConnectionHandler connectionHandler) {
        connectionHandler.reset();
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.factory = serverSocketFactory;
    }

    public void setBacklog(int n) {
        this.backlog = n;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    void startServer(HttpServer httpServer) throws HttpServerException {
        Endpoint endpoint = this.getEndpoint(httpServer);
        Vector<HttpServer> vector = (Vector<HttpServer>)this.endpointMaps.get(endpoint);
        if (vector == null) {
            vector = new Vector<HttpServer>();
            vector.addElement(httpServer);
            this.endpointMaps.put(endpoint, vector);
            return;
        }
        vector.addElement(httpServer);
    }

    void stopServer(HttpServer httpServer) throws HttpServerException {
        Endpoint endpoint = this.getEndpoint(httpServer);
        Vector vector = (Vector)this.endpointMaps.get(endpoint);
        vector.removeElement(httpServer);
        System.out.println("Taking down endpoint: " + endpoint);
        endpoint.shutdown();
    }

    HttpServer resolveServer(Endpoint endpoint, String string) {
        HttpServer httpServer = null;
        Vector vector = (Vector)this.endpointMaps.get(endpoint);
        if (vector == null) {
            System.out.println("NO SERVER FOR CONNECTION ON: " + endpoint);
            System.exit(1);
        }
        if (vector.size() == 1) {
            httpServer = (HttpServer)vector.firstElement();
        } else {
            System.out.println("CAN'T DO VIRTUAL HOSTS YET");
            System.exit(1);
        }
        return httpServer;
    }

    private synchronized Endpoint getEndpoint(HttpServer httpServer) throws HttpServerException {
        Object object;
        Endpoint endpoint;
        int n = httpServer.getPort();
        InetAddress inetAddress = httpServer.getAddress();
        Enumeration enumeration = this.endpoints.elements();
        while (enumeration.hasMoreElements()) {
            endpoint = (Endpoint)enumeration.nextElement();
            if (endpoint.getPort() != n || endpoint.getAddress() != inetAddress) continue;
            return endpoint;
        }
        endpoint = new Endpoint(inetAddress, n);
        this.endpoints.addElement(endpoint);
        try {
            object = null;
            object = inetAddress != null ? this.factory.createServerSocket(n, this.backlog) : this.factory.createServerSocket(n, this.backlog, inetAddress);
            endpoint.setServerSocket((ServerSocket)object);
            System.out.println("endpoint created: " + endpoint);
        }
        catch (InstantiationException instantiationException) {
            System.out.println("FOO: " + instantiationException);
        }
        catch (IOException iOException) {
            String string = this.sm.getString("endptmgr.getendpt.ioe", inetAddress, Integer.toString(n), iOException);
            throw new HttpServerException(string);
        }
        this.endpoints.addElement(endpoint);
        object = new Thread(endpoint);
        ((Thread)object).start();
        return endpoint;
    }

    void notifyEndpointDown(Endpoint endpoint) {
        System.out.println("endpoint down: " + endpoint);
    }
}

