/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.web.core.Context;
import com.sun.web.server.Endpoint;
import com.sun.web.server.EndpointManager;
import com.sun.web.server.HttpServer;
import com.sun.web.server.ServerRequest;
import com.sun.web.server.ServerResponse;
import com.sun.web.server.ServletInputStreamImpl;
import com.sun.web.util.StringManager;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;

class ConnectionHandler
extends Thread {
    private StringManager sm = StringManager.getManager("com.sun.web.server");
    private EndpointManager manager;
    private ServerRequest request = new ServerRequest();
    private ServerResponse response = new ServerResponse();
    private Endpoint endpoint;
    private Socket socket;

    ConnectionHandler(EndpointManager endpointManager) {
        this.manager = endpointManager;
    }

    void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
    }

    void reset() {
        this.request.reset();
        this.response.reset();
        this.endpoint = null;
        this.socket = null;
    }

    public void run() {
        if (this.endpoint == null || this.socket == null) {
            String string = this.sm.getString("conhandler.run.ise");
            throw new IllegalStateException(string);
        }
        try {
            Object object;
            this.request.setSocket(this.socket);
            this.response.setSocket(this.socket);
            while (this.request.hasMoreRequests()) {
                Object object2;
                int n;
                this.request.setResponse(this.response);
                this.response.setRequest(this.request);
                this.request.readNextRequest();
                if (this.request.getProtocol() == null) {
                    this.response.setOmitHeaders(true);
                }
                if (this.response.getStatus() >= 400) {
                    this.response.finish();
                    this.request.reset();
                    this.response.reset();
                    break;
                }
                object = this.request.getHeader("host");
                if (object != null) {
                    n = ((String)object).indexOf(58);
                    if (n > -1) {
                        object = ((String)object).substring(0, n);
                    }
                    this.request.setServerName((String)object);
                } else {
                    InetAddress inetAddress = this.socket.getLocalAddress();
                    this.request.setServerName(inetAddress.getHostName());
                }
                n = this.request.getIntHeader("content-length");
                if (n != -1) {
                    object2 = (ServletInputStreamImpl)this.request.getInputStream();
                    ((ServletInputStreamImpl)((Object)object2)).setLimit(n + 2);
                }
                object2 = this.manager.resolveServer(this.endpoint, (String)object);
                String string = this.request.getRequestURI();
                int n2 = string.indexOf("?");
                this.response.setServerHeader(((HttpServer)object2).getServerHeader());
                if (n2 > 0) {
                    string = string.substring(0, n2);
                }
                Context context = ((HttpServer)object2).getContextByPath(string);
                String string2 = context.getPath();
                string.substring(string2.length(), string.length());
                context.handleRequest(this.request, this.response);
                this.response.finish();
                this.request.reset();
                this.response.reset();
            }
            try {
                object = this.socket.getInputStream();
                if (((InputStream)object).available() > 1) {
                    ((InputStream)object).read();
                    ((InputStream)object).read();
                }
            }
            catch (NullPointerException nullPointerException) {}
            this.socket.close();
        }
        catch (Exception exception) {
            System.out.println("HANDLER THREAD PROBLEM: " + exception);
            exception.printStackTrace();
        }
        this.manager.returnHandler(this);
    }
}

