/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.HttpServletResponseFacade;
import com.sun.web.core.Request;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;

public abstract class Response {
    protected Request request;
    protected HttpServletResponseFacade responseFacade;
    protected Vector cookies = new Vector();
    protected String contentType = "text/plain";
    protected String characterEncoding = System.getProperty("file.encoding", "8859_1");
    protected int contentLength = -1;
    protected int status = 200;

    public Response() {
        this.responseFacade = new HttpServletResponseFacade(this);
    }

    HttpServletResponseFacade getFacade() {
        return this.responseFacade;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void reset() {
        this.cookies.removeAllElements();
        this.contentType = "text/plain";
        this.characterEncoding = System.getProperty("file.encoding", "8859_1");
        this.contentLength = -1;
        this.status = 200;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.addElement(cookie);
    }

    public abstract boolean containsHeader(String var1);

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public abstract boolean isStarted();

    public abstract boolean isCommitted();

    public abstract ServletOutputStream getOutputStream();

    public abstract PrintWriter getWriter() throws IOException;

    public void setContentType(String string) {
        this.contentType = string;
        this.setCharacterEncodingFromContentType(string);
    }

    public void setContentLength(int n) {
        this.contentLength = n;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void sendError(int n) throws IOException {
        this.sendError(n, "No detailed message");
    }

    public void sendError(int n, String string) throws IOException {
        this.status = n;
        this.setContentType("text/html");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h1>Error: " + n + "</h1>\r\n");
        stringBuffer.append(String.valueOf(string) + "\r\n");
        this.sendBodyText(stringBuffer.toString());
        this.close();
    }

    public void sendRedirect(String string) throws IOException {
        this.setStatus(302);
        this.setContentType("text/html");
        string = this.makeAbsolute(string);
        this.setHeader("Location", string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<head><title>Document moved</title></head>\r\n");
        stringBuffer.append("<body><h1>Document moved</h1>\r\n");
        stringBuffer.append("This document has moved <a href=\"");
        stringBuffer.append(string);
        stringBuffer.append("\">here</a>.<p>\r\n");
        stringBuffer.append("</body>\r\n");
        String string2 = stringBuffer.toString();
        this.setContentLength(string2.length());
        this.sendBodyText(string2);
        this.close();
    }

    private String getCharsetFromContentType(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(";");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        int n2 = string2.indexOf("charset=");
        if (n2 == -1) {
            return null;
        }
        String string3 = string2.substring(n2 + 8);
        String string4 = string3.trim();
        return string4;
    }

    private void setCharacterEncodingFromContentType(String string) {
        String string2 = this.getCharsetFromContentType(string);
        if (string2 != null) {
            this.setCharacterEncoding(string2);
        }
    }

    private void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    private String makeAbsolute(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = HttpUtils.getRequestURL((HttpServletRequest)this.request.getFacade()).toString();
            try {
                uRL = new URL(new URL(string2), string);
            }
            catch (MalformedURLException malformedURLException2) {
                return string;
            }
        }
        return uRL.toString();
    }

    public void sendBodyText(String string) throws IOException {
        try {
            PrintWriter printWriter = this.getWriter();
            printWriter.print(string);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            ServletOutputStream servletOutputStream = this.getOutputStream();
            servletOutputStream.print(string);
            return;
        }
    }

    private void close() throws IOException {
        try {
            PrintWriter printWriter = this.getWriter();
            printWriter.close();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            ServletOutputStream servletOutputStream = this.getOutputStream();
            servletOutputStream.close();
            return;
        }
    }

    public abstract void setDateHeader(String var1, long var2);

    public abstract void setHeader(String var1, String var2);

    public abstract void setIntHeader(String var1, int var2);
}

