/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.ApplicationSession;
import com.sun.web.core.Container;
import com.sun.web.core.DefaultLogModule;
import com.sun.web.core.DefaultSecurityModule;
import com.sun.web.core.LogModule;
import com.sun.web.core.LookupResult;
import com.sun.web.core.Request;
import com.sun.web.core.Response;
import com.sun.web.core.SecurityModule;
import com.sun.web.core.Server;
import com.sun.web.core.ServerSession;
import com.sun.web.core.ServerSessionManager;
import com.sun.web.core.ServletContextFacade;
import com.sun.web.util.MimeMap;
import com.sun.web.util.StringManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Context {
    private StringManager sm = StringManager.getManager("com.sun.web.core");
    private boolean initialized = false;
    private Server server;
    private String name;
    private String engineHeader;
    private Container container = new Container(this);
    private ClassLoader classLoader;
    private ServerSessionManager sessionManager = ServerSessionManager.getManager();
    private ServletContextFacade contextFacade;
    private SecurityModule secMod;
    private LogModule logMod;
    private Hashtable attributes = new Hashtable();
    private MimeMap mimeTypes = new MimeMap();
    private Vector welcomeFiles = new Vector();
    private URL docBase;
    private String path = "";
    private File workDir;
    private boolean isWorkDirPersistent = false;
    private static final String CoreProperties = "core.properties";

    public Context(Server server, String string) {
        this.server = server;
        this.name = string;
        this.contextFacade = new ServletContextFacade(server, this);
        this.secMod = new DefaultSecurityModule(this);
        this.logMod = new DefaultLogModule(this);
        Properties properties = this.getProperties(CoreProperties);
        this.engineHeader = properties.getProperty("engine.header", "JavaServer Web Dev Kit/1.0 EA (JSP 1.0; Servlet 2.1; Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "; java.vendor=" + System.getProperty("java.vendor") + ")");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            int n;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("mimeType") || (n = string2.lastIndexOf(46)) <= -1 || n + 1 >= string2.length()) continue;
            this.mimeTypes.addContentType(string2.substring(n + 1), properties.getProperty(string2));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEngineHeader() {
        return this.engineHeader;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setWorkDir(File file) {
        this.setWorkDir(file, false);
    }

    public void setWorkDir(File file, boolean bl) {
        this.isWorkDirPersistent = bl;
        if (!bl) {
            this.clearDir(file);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        this.workDir = file;
    }

    public boolean isWorkDirPersistent() {
        return this.isWorkDirPersistent;
    }

    public void setWorkDirPersistent(boolean bl) {
        this.isWorkDirPersistent = bl;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public synchronized void init() {
        Object object;
        if (this.initialized) {
            String string = this.sm.getString("context.init.alreadyinit");
            throw new IllegalStateException(string);
        }
        this.initialized = true;
        if (this.workDir != null) {
            this.setAttribute("sun.servlet.workdir", this.workDir);
        }
        this.container.addServlet("default", "com.sun.web.core.DefaultServlet");
        String[] stringArray = new String[]{"webapp.properties", "mime.properties", "servlets.properties", "mappings.properties"};
        URL uRL = null;
        Properties properties = null;
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            bl = false;
            object = null;
            try {
                uRL = new URL(this.docBase, "WEB-INF/" + stringArray[n]);
                properties = new Properties();
                properties.load(uRL.openStream());
                bl = true;
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    object = this.sm.getString("context.init.propfile.url.error", stringArray[n], this.docBase);
                }
                catch (MissingResourceException missingResourceException) {}
            }
            catch (IOException iOException) {
                try {
                    object = this.sm.getString("context.init.propfile.file.error", stringArray[n], this.docBase);
                }
                catch (MissingResourceException missingResourceException) {}
            }
            if ((bl || !bl) && stringArray[n].equals("webapp.properties")) {
                this.processWebAppProps(properties);
            }
            if (bl && stringArray[n].equals("mime.properties")) {
                this.processMIMEProps(properties);
            }
            if (bl && stringArray[n].equals("servlets.properties")) {
                this.processServletsProps(properties);
            }
            if (bl && stringArray[n].equals("mappings.properties")) {
                this.processMappingsProps(properties);
            }
            ++n;
        }
        try {
            object = new URL(this.docBase, "WEB-INF/servlets");
            this.container.setServletBase((URL)object);
            return;
        }
        catch (Exception exception) {
            System.out.println("ARGH: " + exception);
            return;
        }
    }

    public void shutdown() {
        this.container.shutdown();
        this.sessionManager.removeApplicationSessions(this);
        if (!this.isWorkDirPersistent) {
            this.clearDir(this.workDir);
        }
        System.out.println("Context: " + this + " down");
    }

    public Enumeration getWelcomeFiles() {
        return this.welcomeFiles.elements();
    }

    public SecurityModule getSecurityModule() {
        return this.secMod;
    }

    public void setSecurityModule(SecurityModule securityModule) {
        this.secMod = securityModule;
    }

    public LogModule getLogModule() {
        return this.logMod;
    }

    public void setLogModule(LogModule logModule) {
        this.logMod = logModule;
    }

    public Object getAttribute(String string) {
        this.attributes.get(string);
        return this.attributes.get(string);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setDocumentBase(URL uRL) {
        String string = uRL.getFile();
        if (!string.endsWith("/")) {
            try {
                uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(string) + "/");
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("SHOULD NEVER HAPPEN: " + malformedURLException);
            }
        }
        this.docBase = uRL;
    }

    public URL getDocumentBase() {
        return this.docBase;
    }

    public MimeMap getMimeMap() {
        return this.mimeTypes;
    }

    public Container getContainer() {
        return this.container;
    }

    ServletContextFacade getFacade() {
        return this.contextFacade;
    }

    public void handleRequest(Request request, Response response) throws IOException {
        Object object;
        response.setHeader("Servlet-Engine", this.getEngineHeader());
        request.setContext(this);
        request.setResponse(response);
        ServerSession serverSession = this.sessionManager.getServerSession(request, response, false);
        if (serverSession != null) {
            serverSession.accessed();
            object = serverSession.getApplicationSession(this, false);
            if (object != null) {
                ((ApplicationSession)object).accessed();
            }
        }
        request.setServerSession(serverSession);
        if (this.secMod.authenticateRequest(request.getFacade(), response.getFacade()) && this.secMod.authorizeRequest(request.getFacade(), response.getFacade())) {
            object = this.container.lookupServlet(request.getLookupPath());
            request.setPathInfo(((LookupResult)object).getPathInfo());
            request.setServletPath(((LookupResult)object).getServletPath());
            ((LookupResult)object).getWrapper().handleRequest(request.getFacade(), response.getFacade());
        }
        this.logMod.logRequest(request.getFacade(), response.getFacade());
    }

    private Properties getProperties(String string) {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream(string));
        }
        catch (IOException iOException) {}
        return properties;
    }

    private void clearDir(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                this.clearDir(file2);
            }
            try {
                file2.delete();
            }
            catch (Exception exception) {}
            ++n;
        }
        try {
            file.delete();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void processWebAppProps(Properties properties) {
        String string = properties.getProperty("invoker");
        Vector<String> vector = new Vector<String>();
        vector.addElement("true");
        vector.addElement("yes");
        vector.addElement("on");
        if (string == null || string != null && vector.contains(string.toLowerCase())) {
            this.container.addServlet("invoker", "com.sun.web.core.InvokerServlet");
            this.container.addMapping("invoker", "/servlet");
        } else {
            this.container.addServlet("invoker", "com.sun.web.core.NoInvokerServlet");
            this.container.addMapping("invoker", "/servlet");
        }
        string = properties.getProperty("welcomefiles");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.welcomeFiles.addElement(stringTokenizer.nextToken().trim());
            }
        }
    }

    private void processMIMEProps(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string).trim();
            this.mimeTypes.addContentType(string, string2);
        }
    }

    private void processServletsProps(Properties properties) {
        String string;
        String string2;
        Vector<String> vector = new Vector<String>();
        Enumeration<Object> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            try {
                string = string2.substring(0, string2.indexOf("."));
                if (vector.contains(string)) continue;
                vector.addElement(string);
            }
            catch (Exception exception) {
                string = this.sm.getString("context.init.propfile.servlet.format", string2);
                System.out.println(string);
            }
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            string2 = (String)enumeration.nextElement();
            string = properties.getProperty(String.valueOf(string2) + ".code");
            String string3 = properties.getProperty(String.valueOf(string2) + ".initparams");
            if (string == null) {
                object = this.sm.getString("context.props.iae", string2);
                throw new IllegalArgumentException((String)object);
            }
            object = new Hashtable();
            if (string3 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    int n = string4.indexOf("=");
                    if (n <= 0) continue;
                    String string5 = string4.substring(0, n).trim();
                    String string6 = string4.substring(n + 1, string4.length()).trim();
                    ((Hashtable)object).put(string5, string6);
                }
            }
            this.container.addServlet(string2, string);
            this.container.setServletInitParams(string2, (Hashtable)object);
        }
    }

    private void processMappingsProps(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string).trim();
            this.container.addMapping(string2, string);
        }
    }
}

