/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class TreePath
implements Serializable {
    protected transient Object[] path;

    public TreePath(Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.path = objectArray;
    }

    public TreePath(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.path = new Object[1];
        this.path[0] = object;
    }

    public Object[] getPath() {
        int n = this.path.length;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.path, 0, objectArray, 0, n);
        return objectArray;
    }

    public Object getLastPathComponent() {
        if (this.path.length > 0) {
            return this.path[this.path.length - 1];
        }
        return null;
    }

    public int getPathCount() {
        return this.path.length;
    }

    public Object getPathComponent(int n) {
        if (n < 0 || n >= this.getPathCount()) {
            throw new IllegalArgumentException("Index " + n + " is greater than path length");
        }
        return this.path[n];
    }

    public boolean equals(Object object) {
        if (object instanceof TreePath) {
            TreePath treePath = (TreePath)object;
            Object[] objectArray = treePath.path;
            if (objectArray != null && this.path == null || objectArray == null && this.path != null) {
                return false;
            }
            if (this.path != null) {
                int n = this.path.length;
                if (n != objectArray.length) {
                    return false;
                }
                int n2 = 0;
                while (n2 < n) {
                    if (!this.path[n2].equals(objectArray[n2])) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isDescendant(TreePath treePath) {
        int n;
        Object[] objectArray;
        if (this.path != null && (objectArray = treePath.getPath()).length >= (n = this.path.length) && n > 0) {
            int n2 = 0;
            while (n2 < n) {
                if (!this.path[n2].equals(objectArray[n2])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = 0;
        while (n < this.path.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.path[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Vector<Object> vector = new Vector<Object>();
        boolean bl = true;
        int n = 0;
        int n2 = this.path.length;
        while (n < n2) {
            if (!(this.path[n] instanceof Serializable)) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            vector.addElement("path");
            vector.addElement(this.path);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("path")) {
            this.path = (Object[])vector.elementAt(++n);
            ++n;
            return;
        }
        this.path = new Object[0];
    }
}

