/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.Action;
import com.sun.java.swing.text.AbstractDocument;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Caret;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.EditorKit;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.PlainDocument;
import com.sun.java.swing.text.Segment;
import com.sun.java.swing.text.TextAction;
import com.sun.java.swing.text.Utilities;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class DefaultEditorKit
extends EditorKit {
    public static final String insertContentAction = "insert-content";
    public static final String insertBreakAction = "insert-break";
    public static final String insertTabAction = "insert-tab";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String deleteNextCharAction = "delete-next";
    public static final String readOnlyAction = "set-read-only";
    public static final String writableAction = "set-writable";
    public static final String cutAction = "cut-to-clipboard";
    public static final String copyAction = "copy-to-clipboard";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String beepAction = "beep";
    public static final String pageUpAction = "page-up";
    public static final String pageDownAction = "page-down";
    public static final String forwardAction = "caret-forward";
    public static final String backwardAction = "caret-backward";
    public static final String selectionForwardAction = "selection-forward";
    public static final String selectionBackwardAction = "selection-backward";
    public static final String upAction = "caret-up";
    public static final String downAction = "caret-down";
    public static final String selectionUpAction = "selection-up";
    public static final String selectionDownAction = "selection-down";
    public static final String beginWordAction = "caret-begin-word";
    public static final String endWordAction = "caret-end-word";
    public static final String selectionBeginWordAction = "selection-begin-word";
    public static final String selectionEndWordAction = "selection-end-word";
    public static final String previousWordAction = "caret-previous-word";
    public static final String nextWordAction = "caret-next-word";
    public static final String selectionPreviousWordAction = "selection-previous-word";
    public static final String selectionNextWordAction = "selection-next-word";
    public static final String beginLineAction = "caret-begin-line";
    public static final String endLineAction = "caret-end-line";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String beginParagraphAction = "caret-begin-paragraph";
    public static final String endParagraphAction = "caret-end-paragraph";
    public static final String selectionBeginParagraphAction = "selection-begin-paragraph";
    public static final String selectionEndParagraphAction = "selection-end-paragraph";
    public static final String beginAction = "caret-begin";
    public static final String endAction = "caret-end";
    public static final String selectionBeginAction = "selection-begin";
    public static final String selectionEndAction = "selection-end";
    public static final String selectWordAction = "select-word";
    public static final String selectLineAction = "select-line";
    public static final String selectParagraphAction = "select-paragraph";
    public static final String selectAllAction = "select-all";
    public static final String defaultKeyTypedAction = "default-typed";
    private static final Action[] defaultActions = new Action[]{new InsertContentAction(), new DeletePrevCharAction(), new DeleteNextCharAction(), new ReadOnlyAction(), new WritableAction(), new CutAction(), new CopyAction(), new PasteAction(), new PageUpAction(), new PageDownAction(), new InsertBreakAction(), new BeepAction(), new ForwardAction("caret-forward", false), new BackwardAction("caret-backward", false), new ForwardAction("selection-forward", true), new BackwardAction("selection-backward", true), new UpAction("caret-up", false), new DownAction("caret-down", false), new UpAction("selection-up", true), new DownAction("selection-down", true), new BeginWordAction("caret-begin-word", false), new EndWordAction("caret-end-word", false), new BeginWordAction("selection-begin-word", true), new EndWordAction("selection-end-word", true), new PreviousWordAction("caret-previous-word", false), new NextWordAction("caret-next-word", false), new PreviousWordAction("selection-previous-word", true), new NextWordAction("selection-next-word", true), new BeginLineAction("caret-begin-line", false), new EndLineAction("caret-end-line", false), new BeginLineAction("selection-begin-line", true), new EndLineAction("selection-end-line", true), new BeginParagraphAction("caret-begin-paragraph", false), new EndParagraphAction("caret-end-paragraph", false), new BeginParagraphAction("selection-begin-paragraph", true), new EndParagraphAction("selection-end-paragraph", true), new BeginAction("caret-begin", false), new EndAction("caret-end", false), new BeginAction("selection-begin", true), new EndAction("selection-end", true), new DefaultKeyTypedAction(), new InsertTabAction(), new SelectWordAction(), new SelectLineAction(), new SelectParagraphAction(), new SelectAllAction(), new DumpModelAction()};

    public Object clone() {
        return new DefaultEditorKit();
    }

    public String getContentType() {
        return "text/plain";
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public Action[] getActions() {
        return defaultActions;
    }

    public Caret createCaret() {
        return null;
    }

    public Document createDefaultDocument() {
        return new PlainDocument();
    }

    public void read(InputStream inputStream, Document document, int n) throws IOException, BadLocationException {
        this.read(new InputStreamReader(inputStream), document, n);
    }

    public void write(OutputStream outputStream, Document document, int n, int n2) throws IOException, BadLocationException {
        this.write(new OutputStreamWriter(outputStream), document, n, n2);
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        int n2;
        char[] cArray = new char[4096];
        while ((n2 = reader.read(cArray, 0, cArray.length)) != -1) {
            document.insertString(n, new String(cArray, 0, n2), null);
            n += n2;
        }
    }

    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (n < 0 || n + n2 > document.getLength()) {
            throw new BadLocationException("DefaultEditorKit.write", n);
        }
        Segment segment = new Segment();
        int n3 = n2;
        int n4 = n;
        while (n3 > 0) {
            int n5 = Math.min(n3, 4096);
            document.getText(n4, n5, segment);
            writer.write(segment.array, segment.offset, segment.count);
            n4 += n5;
            n3 -= n5;
        }
        writer.flush();
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        public DefaultKeyTypedAction() {
            super(DefaultEditorKit.defaultKeyTypedAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                char c;
                String string = actionEvent.getActionCommand();
                int n = actionEvent.getModifiers();
                if (string != null && string.length() > 0 && n != 8 && (c = string.charAt(0)) >= ' ' && c != '\u007f') {
                    jTextComponent.replaceSelection(string);
                }
            }
        }
    }

    public static class InsertContentAction
    extends TextAction {
        public InsertContentAction() {
            super(DefaultEditorKit.insertContentAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                String string = actionEvent.getActionCommand();
                if (string != null) {
                    jTextComponent.replaceSelection(string);
                    return;
                }
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class InsertBreakAction
    extends TextAction {
        public InsertBreakAction() {
            super(DefaultEditorKit.insertBreakAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.replaceSelection("\n");
            }
        }
    }

    public static class InsertTabAction
    extends TextAction {
        public InsertTabAction() {
            super(DefaultEditorKit.insertTabAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.replaceSelection("\t");
            }
        }
    }

    static class DeletePrevCharAction
    extends TextAction {
        DeletePrevCharAction() {
            super(DefaultEditorKit.deletePrevCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            boolean bl = true;
            if (jTextComponent != null && jTextComponent.isEditable()) {
                try {
                    Document document = jTextComponent.getDocument();
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    int n2 = caret.getMark();
                    if (n != n2) {
                        document.remove(Math.min(n, n2), Math.abs(n - n2));
                        bl = false;
                    } else if (n > 0) {
                        document.remove(n - 1, 1);
                        bl = false;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            if (bl) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    static class DeleteNextCharAction
    extends TextAction {
        DeleteNextCharAction() {
            super(DefaultEditorKit.deleteNextCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            boolean bl = true;
            if (jTextComponent != null && jTextComponent.isEditable()) {
                try {
                    Document document = jTextComponent.getDocument();
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    int n2 = caret.getMark();
                    if (n != n2) {
                        document.remove(Math.min(n, n2), Math.abs(n - n2));
                        bl = false;
                    } else if (n < document.getLength()) {
                        document.remove(n, 1);
                        bl = false;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            if (bl) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    static class ReadOnlyAction
    extends TextAction {
        ReadOnlyAction() {
            super(DefaultEditorKit.readOnlyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.setEditable(false);
            }
        }
    }

    static class WritableAction
    extends TextAction {
        WritableAction() {
            super(DefaultEditorKit.writableAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.setEditable(true);
            }
        }
    }

    public static class CutAction
    extends TextAction {
        public CutAction() {
            super(DefaultEditorKit.cutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.cut();
            }
        }
    }

    public static class CopyAction
    extends TextAction {
        public CopyAction() {
            super(DefaultEditorKit.copyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.copy();
            }
        }
    }

    public static class PasteAction
    extends TextAction {
        public PasteAction() {
            super(DefaultEditorKit.pasteAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.paste();
            }
        }
    }

    public static class BeepAction
    extends TextAction {
        public BeepAction() {
            super(DefaultEditorKit.beepAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    static class PageUpAction
    extends TextAction {
        PageUpAction() {
            super(DefaultEditorKit.pageUpAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Rectangle rectangle = new Rectangle();
                jTextComponent.computeVisibleRect(rectangle);
                int n = rectangle.y;
                rectangle.y -= rectangle.height;
                if (rectangle.y < 0) {
                    rectangle.y = 0;
                }
                n -= rectangle.y;
                jTextComponent.scrollRectToVisible(rectangle);
                int n2 = jTextComponent.getCaretPosition();
                try {
                    if (n2 != -1) {
                        Rectangle rectangle2 = jTextComponent.modelToView(n2);
                        rectangle2.y -= n;
                        n2 = jTextComponent.viewToModel(new Point(rectangle2.x, rectangle2.y));
                        if (n2 < 0) {
                            n2 = 0;
                        }
                        jTextComponent.setCaretPosition(n2);
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
            }
        }
    }

    static class PageDownAction
    extends TextAction {
        PageDownAction() {
            super(DefaultEditorKit.pageDownAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Rectangle rectangle = new Rectangle();
                jTextComponent.computeVisibleRect(rectangle);
                int n = rectangle.y;
                rectangle.y += rectangle.height;
                if (rectangle.y + rectangle.height > jTextComponent.getHeight()) {
                    rectangle.y = jTextComponent.getHeight() - rectangle.height;
                }
                n = rectangle.y - n;
                jTextComponent.scrollRectToVisible(rectangle);
                int n2 = jTextComponent.getCaretPosition();
                try {
                    if (n2 != -1) {
                        Document document;
                        Rectangle rectangle2 = jTextComponent.modelToView(n2);
                        rectangle2.y += n;
                        n2 = jTextComponent.viewToModel(new Point(rectangle2.x, rectangle2.y));
                        if (n2 > (document = jTextComponent.getDocument()).getLength() - 1) {
                            n2 = document.getLength() - 1;
                        }
                        jTextComponent.setCaretPosition(n2);
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
            }
        }
    }

    static class DumpModelAction
    extends TextAction {
        DumpModelAction() {
            super("dump-model");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Document document;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && (document = jTextComponent.getDocument()) instanceof AbstractDocument) {
                ((AbstractDocument)document).dump(System.err);
            }
        }
    }

    static class ForwardAction
    extends TextAction {
        private boolean select;

        ForwardAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                int n = jTextComponent.getCaretPosition();
                if (n < document.getLength()) {
                    ++n;
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        jTextComponent.setCaretPosition(n);
                    }
                } else {
                    jTextComponent.getToolkit().beep();
                }
                jTextComponent.getCaret().setMagicCaretPosition(null);
            }
        }
    }

    static class BackwardAction
    extends TextAction {
        private boolean select;

        BackwardAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                if (n > 0) {
                    --n;
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        jTextComponent.setCaretPosition(n);
                    }
                } else {
                    jTextComponent.getToolkit().beep();
                }
                jTextComponent.getCaret().setMagicCaretPosition(null);
            }
        }
    }

    static class UpAction
    extends TextAction {
        private boolean select;

        UpAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    Point point = caret.getMagicCaretPosition();
                    if (point == null) {
                        Rectangle rectangle = jTextComponent.modelToView(n);
                        point = new Point(rectangle.x, rectangle.y);
                        caret.setMagicCaretPosition(point);
                    }
                    n = Utilities.getPositionAbove(jTextComponent, n, point.x);
                    if (this.select) {
                        caret.moveDot(n);
                        return;
                    }
                    caret.setDot(n);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
            }
        }
    }

    static class DownAction
    extends TextAction {
        private boolean select;

        DownAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    Point point = caret.getMagicCaretPosition();
                    if (point == null) {
                        Rectangle rectangle = jTextComponent.modelToView(n);
                        point = new Point(rectangle.x, rectangle.y);
                        caret.setMagicCaretPosition(point);
                    }
                    n = Utilities.getPositionBelow(jTextComponent, n, point.x);
                    if (this.select) {
                        caret.moveDot(n);
                        return;
                    }
                    caret.setDot(n);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
            }
        }
    }

    static class BeginWordAction
    extends TextAction {
        private boolean select;

        BeginWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getWordStart(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                        return;
                    }
                    jTextComponent.setCaretPosition(n2);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
            }
        }
    }

    static class EndWordAction
    extends TextAction {
        private boolean select;

        EndWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getWordEnd(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                        return;
                    }
                    jTextComponent.setCaretPosition(n2);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
            }
        }
    }

    static class PreviousWordAction
    extends TextAction {
        private boolean select;

        PreviousWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    n = Utilities.getPreviousWord(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                        return;
                    }
                    jTextComponent.setCaretPosition(n);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
            }
        }
    }

    static class NextWordAction
    extends TextAction {
        private boolean select;

        NextWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    n = Utilities.getNextWord(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                        return;
                    }
                    jTextComponent.setCaretPosition(n);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
            }
        }
    }

    static class BeginLineAction
    extends TextAction {
        private boolean select;

        BeginLineAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getRowStart(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                        return;
                    }
                    jTextComponent.setCaretPosition(n2);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
            }
        }
    }

    static class EndLineAction
    extends TextAction {
        private boolean select;

        EndLineAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getRowEnd(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                        return;
                    }
                    jTextComponent.setCaretPosition(n2);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
            }
        }
    }

    static class BeginParagraphAction
    extends TextAction {
        private boolean select;

        BeginParagraphAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                Element element = Utilities.getParagraphElement(jTextComponent, n);
                n = element.getStartOffset();
                if (this.select) {
                    jTextComponent.moveCaretPosition(n);
                    return;
                }
                jTextComponent.setCaretPosition(n);
            }
        }
    }

    static class EndParagraphAction
    extends TextAction {
        private boolean select;

        EndParagraphAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                Element element = Utilities.getParagraphElement(jTextComponent, n);
                n = element.getEndOffset();
                if (this.select) {
                    jTextComponent.moveCaretPosition(n);
                    return;
                }
                jTextComponent.setCaretPosition(n);
            }
        }
    }

    static class BeginAction
    extends TextAction {
        private boolean select;

        BeginAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                if (this.select) {
                    jTextComponent.moveCaretPosition(0);
                    return;
                }
                jTextComponent.setCaretPosition(0);
            }
        }
    }

    static class EndAction
    extends TextAction {
        private boolean select;

        EndAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                int n = document.getLength();
                if (this.select) {
                    jTextComponent.moveCaretPosition(n);
                    return;
                }
                jTextComponent.setCaretPosition(n);
            }
        }
    }

    static class SelectWordAction
    extends TextAction {
        private Action start = new BeginWordAction("pigdog", false);
        private Action end = new EndWordAction("pigdog", true);

        SelectWordAction() {
            super(DefaultEditorKit.selectWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class SelectLineAction
    extends TextAction {
        private Action start = new BeginLineAction("pigdog", false);
        private Action end = new EndLineAction("pigdog", true);

        SelectLineAction() {
            super(DefaultEditorKit.selectLineAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class SelectParagraphAction
    extends TextAction {
        private Action start = new BeginParagraphAction("pigdog", false);
        private Action end = new EndParagraphAction("pigdog", true);

        SelectParagraphAction() {
            super(DefaultEditorKit.selectParagraphAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class SelectAllAction
    extends TextAction {
        SelectAllAction() {
            super(DefaultEditorKit.selectAllAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                jTextComponent.setCaretPosition(0);
                jTextComponent.moveCaretPosition(document.getLength());
            }
        }
    }
}

