/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.MenuElement;
import com.sun.java.swing.MenuSelectionManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import com.sun.java.swing.plaf.basic.BasicMenuItemUI;
import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;

public class MotifMenuItemUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifMenuItemUI();
    }

    protected void initListeners(JComponent jComponent) {
        super.initListeners(jComponent);
        this.changeListener = this.createChangeListener(jComponent);
    }

    protected void addListeners(JComponent jComponent) {
        super.addListeners(jComponent);
        ((JMenuItem)jComponent).addChangeListener(this.changeListener);
    }

    protected void removeListeners(JComponent jComponent) {
        super.removeListeners(jComponent);
        ((JMenuItem)jComponent).removeChangeListener(this.changeListener);
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return new MenuChangeListener();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return BasicGraphicsUtils.getPreferredMenuItemSize(jComponent, this.checkIcon, this.menuArrow, 4);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        MotifGraphicsUtils.paintMenuItem(graphics, jComponent, this.checkIcon, this.menuArrow, BasicMenuItemUI.pressedBackground, BasicMenuItemUI.pressedForeground, 4);
    }

    public void processMouseEvent(JMenuItem jMenuItem, MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        Point point = mouseEvent.getPoint();
        if (point.x >= 0 && point.x < jMenuItem.getWidth() && point.y >= 0 && point.y < jMenuItem.getHeight()) {
            if (mouseEvent.getID() == 502) {
                menuSelectionManager.clearSelectedPath();
                jMenuItem.doClick(0);
                jMenuItem.setArmed(false);
                return;
            }
            if (mouseEvent.getID() == 506 || mouseEvent.getID() == 501) {
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
            return;
        }
        if (mouseEvent.getID() == 502) {
            menuSelectionManager.clearSelectedPath();
            return;
        }
        if (jMenuItem.getModel().isArmed() && mouseEvent.getID() == 506) {
            MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
            int n = 0;
            int n2 = menuElementArray.length - 1;
            while (n < n2) {
                menuElementArray2[n] = menuElementArray[n];
                ++n;
            }
            menuSelectionManager.setSelectedPath(menuElementArray2);
        }
    }

    protected class MenuChangeListener
    implements ChangeListener,
    Serializable {
        public void stateChanged(ChangeEvent changeEvent) {
            JMenuItem jMenuItem = (JMenuItem)changeEvent.getSource();
            if (jMenuItem.isArmed() || jMenuItem.isSelected()) {
                jMenuItem.setBorderPainted(true);
                return;
            }
            jMenuItem.setBorderPainted(false);
        }

        MenuChangeListener() {
            MotifMenuItemUI.this = MotifMenuItemUI.this;
        }
    }
}

