/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.JDialog;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JProgressBar;
import java.awt.Component;

public class ProgressMonitor {
    private int millisToDecideToPopup = 500;
    private int millisToPopup = 2000;
    private int min;
    private int max;
    private int v;
    private int lastDisp;
    private int reportDelta;
    private ProgressMonitor root;
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private Component parentComponent;
    private String note;
    private Object message;
    private long T0;

    public ProgressMonitor(Component component, Object object, String string, int n, int n2) {
        this(component, object, string, n, n2, null);
    }

    private ProgressMonitor(Component component, Object object, String string, int n, int n2, ProgressMonitor progressMonitor) {
        this.min = n;
        this.max = n2;
        this.parentComponent = component;
        this.reportDelta = (n2 - n) / 100;
        if (this.reportDelta < 1) {
            this.reportDelta = 1;
        }
        this.v = n;
        this.message = object;
        this.note = string;
        if (progressMonitor != null) {
            this.root = progressMonitor.root != null ? progressMonitor.root : progressMonitor;
            this.T0 = this.root.T0;
            this.dialog = this.root.dialog;
            return;
        }
        this.T0 = System.currentTimeMillis();
    }

    public void setProgress(int n) {
        this.v = n;
        if (n >= this.max) {
            this.close();
            return;
        }
        if (n >= this.lastDisp + this.reportDelta) {
            int n2;
            this.lastDisp = n;
            if (this.myBar != null) {
                this.myBar.setValue(n);
                return;
            }
            long l = System.currentTimeMillis();
            long l2 = (int)(l - this.T0);
            if (l2 >= (long)this.millisToDecideToPopup && (n2 = n > this.min ? (int)(l2 * (long)(this.max - this.min) / (long)(n - this.min)) : this.millisToPopup) >= this.millisToPopup) {
                this.myBar = new JProgressBar();
                this.myBar.setMinimum(this.min);
                this.myBar.setMaximum(this.max);
                this.myBar.setValue(n);
                if (this.note != null) {
                    this.noteLabel = new JLabel(this.note);
                }
                this.pane = new ProgressOptionPane(new Object[]{this.message, this.noteLabel, this.myBar});
                this.dialog = this.pane.createDialog(this.parentComponent, "Progress...");
                this.dialog.setModal(false);
                this.dialog.show();
            }
        }
    }

    public void close() {
        if (this.dialog != null) {
            ((Component)this.dialog).setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.myBar = null;
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n) {
        this.min = n;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int n) {
        this.max = n;
    }

    public boolean isCanceled() {
        if (this.pane == null) {
            return false;
        }
        Object object = this.pane.getValue();
        return object != null && object instanceof Integer && (Integer)object == 2;
    }

    public void setMillisToDecideToPopup(int n) {
        this.millisToDecideToPopup = n;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int n) {
        this.millisToPopup = n;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String string) {
        this.note = string;
        if (this.noteLabel != null) {
            this.noteLabel.setText(string);
        }
    }

    public String getNote() {
        return this.note;
    }

    private static class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object object) {
            super(object, 1, 2, null, null, null);
        }

        public int getMaxCharactersPerLineCount() {
            return 60;
        }
    }
}

