/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.accessibility.AccessibleValue;
import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.DefaultBoundedRangeModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ProgressBarUI;
import java.awt.Graphics;
import java.io.Serializable;

public class JProgressBar
extends JComponent
implements SwingConstants,
Accessible {
    protected int orientation;
    protected boolean paintBorder;
    protected BoundedRangeModel barModel;
    protected transient ChangeEvent changeEvent;
    protected ChangeListener changeListener;
    static /* synthetic */ Class class$com$sun$java$swing$event$ChangeListener;

    public JProgressBar() {
        this.setModel(new DefaultBoundedRangeModel());
        this.updateUI();
        this.orientation = 0;
        this.paintBorder = true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (this.orientation != n) {
            switch (n) {
                case 0: 
                case 1: {
                    int n2 = this.orientation;
                    this.orientation = n;
                    if (this.accessibleContext == null) break;
                    this.accessibleContext.firePropertyChange("AccessibleState", n2 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, this.orientation == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(n) + " is not a legal orientation");
                }
            }
            this.repaint();
        }
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        this.paintBorder = bl;
        this.repaint();
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public ProgressBarUI getUI() {
        return (ProgressBarUI)this.ui;
    }

    public void setUI(ProgressBarUI progressBarUI) {
        if (this.ui != progressBarUI) {
            super.setUI(progressBarUI);
            this.repaint();
        }
    }

    public void updateUI() {
        this.setUI((ProgressBarUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ProgressBarUI";
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = JComponent.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = JComponent.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : JComponent.class$("com.sun.java.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public BoundedRangeModel getModel() {
        return this.barModel;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        BoundedRangeModel boundedRangeModel2 = this.getModel();
        if (boundedRangeModel != boundedRangeModel2) {
            if (boundedRangeModel2 != null) {
                boundedRangeModel2.removeChangeListener(this.changeListener);
                this.changeListener = null;
            }
            this.barModel = boundedRangeModel;
            if (boundedRangeModel != null) {
                this.changeListener = this.createChangeListener();
                boundedRangeModel.addChangeListener(this.changeListener);
            }
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", boundedRangeModel2 == null ? null : new Integer(boundedRangeModel2.getValue()), boundedRangeModel == null ? null : new Integer(boundedRangeModel.getValue()));
            }
            this.barModel.setExtent(0);
            this.repaint();
        }
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public void setValue(int n) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n2 = boundedRangeModel.getValue();
        boundedRangeModel.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n2), new Integer(boundedRangeModel.getValue()));
        }
    }

    public void setMinimum(int n) {
        this.getModel().setMinimum(n);
    }

    public void setMaximum(int n) {
        this.getModel().setMaximum(n);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJProgressBar();
        }
        return this.accessibleContext;
    }

    protected class ModelListener
    implements ChangeListener,
    Serializable {
        public void stateChanged(ChangeEvent changeEvent) {
            JProgressBar.this.fireStateChanged();
        }

        ModelListener() {
            JProgressBar.this = JProgressBar.this;
        }
    }

    protected class AccessibleJProgressBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JProgressBar.this.getModel().getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (JProgressBar.this.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JProgressBar.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                JProgressBar.this.setValue(number.intValue());
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JProgressBar.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JProgressBar.this.getMaximum());
        }

        AccessibleJProgressBar() {
            JProgressBar.this = JProgressBar.this;
        }
    }
}

