/*
 * Decompiled with CFR 0.152.
 */
package com.omnicore.nativeinterface.win32;

import com.omnicore.nativeinterface.win32.Win32MouseWheelListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.StringTokenizer;

public class Win32Interface {
    private static Win32Interface instance;
    private static final boolean DEBUG = false;
    private static final String NATIVE_JAR_FILENAME = "native.jar";
    private static final String LIBARARY_NAME = "CodeGuideWin32";
    private Win32MouseWheelListener listener = null;

    public static Win32Interface getInterface() {
        if (instance != null) {
            return instance;
        }
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            return null;
        }
        String string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            File file;
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(NATIVE_JAR_FILENAME) == -1) continue;
            File file2 = new File(string3);
            String string4 = file2.getParent();
            if (string4 == null || !(file = new File(string2 = string4 + File.separator + LIBARARY_NAME + ".dll")).exists()) break;
            try {
                System.load(string2);
                instance = new Win32Interface();
                instance.startCaptureWheelMessagesImpl();
                return instance;
            }
            catch (Throwable throwable) {
                instance = null;
                break;
            }
        }
        try {
            System.loadLibrary(LIBARARY_NAME);
            instance = new Win32Interface();
            instance.startCaptureWheelMessagesImpl();
            return instance;
        }
        catch (Throwable throwable) {
            instance = null;
            return null;
        }
    }

    private native void startCaptureWheelMessagesImpl();

    private native void stopCaptureWheelMessagesImpl();

    private native int listDrivesImpl();

    private native void setCurrentDirectoryImpl(byte[] var1);

    private native int getDaysOfUseImpl();

    private native String getUserProfileDirectoryImpl();

    private synchronized void onWheelMoved(int n, int n2, int n3, int n4) {
        if (this.listener != null) {
            this.listener.mouseWheelMoved(n, n2, n3, n4);
        }
    }

    public int getLogicalDrives() {
        return this.listDrivesImpl();
    }

    public void setMouseWheelListener(Win32MouseWheelListener win32MouseWheelListener) {
        this.listener = win32MouseWheelListener;
    }

    public void setCurrentDirectory(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        outputStreamWriter.write(string);
        ((Writer)outputStreamWriter).close();
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.setCurrentDirectoryImpl(byArray);
    }

    public int getDaysOfUse() {
        return this.getDaysOfUseImpl();
    }

    public String getUserProfileDirectory() {
        return this.getUserProfileDirectoryImpl();
    }
}

