/*
   This is a modified version of nice() from the GNU C Library.  The
   GNU C Library is Copyright (C) 1992, 1996, 1997, 2001 Free Software
   Foundation, Inc.  This is a free software, see COPYING.LIB for
   details.
*/

#include <errno.h>
#include <unistd.h>
#include <sys/resource.h>

/* Oct-06-2002: For debugging purpose. */
#ifdef DEBUG
#include <stdio.h>
#endif

#define __set_errno(val) (*__errno_location()) = (val)

/* Increment the scheduling priority of the calling process by INCR.
   The superuser may use a negative INCR to decrement the priority.  */
int nice(int incr)
{
   int save;
   int prio;
   int result;

   /* -1 is a valid priority, so we use errno to check for an error.  */
   save = errno;
   __set_errno(0);
   prio = getpriority (PRIO_PROCESS, 0);
   if(prio == -1) {
      if(errno != 0)
	 return -1;
      else
	 __set_errno(save);
   }

   /* Oct-06-2002: Fixes the VMware "not implemented" issue. */
   if(prio + incr == -1)
      incr++;

   /* Oct-06-2002: For debugging purpose. */
#ifdef DEBUG
   fprintf(stderr, "%s, line %d: prio = %d, incr = %d\n",
	   __FILE__, __LINE__, prio, incr);
#endif

   result = setpriority (PRIO_PROCESS, 0, prio + incr);
   if(result != -1)
      return prio + incr;
   else
      return -1;
}
