/*
 * Decompiled with CFR 0.152.
 */
package jmgmt.snmp.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import jmgmt.asn1.Asn1Value;
import jmgmt.asn1.OID;
import jmgmt.snmp.io.SMI;

public class Varbind {
    public Asn1Value name;
    public Asn1Value value;

    public Varbind(Asn1Value name, Asn1Value value) {
        this.name = name;
        this.value = value;
    }

    private void set(Asn1Value name, Asn1Value value) {
        this.name = name;
        this.value = value;
    }

    public Varbind(OID name, Asn1Value value) {
        this(new Asn1Value(name), value);
    }

    public Varbind(OID name) {
        this(new Asn1Value(name));
    }

    public Varbind(Asn1Value name) {
        this.name = name;
        this.value = Asn1Value.Null;
    }

    public Varbind(Object v) {
        if (v instanceof Varbind) {
            this.set(((Varbind)v).name, ((Varbind)v).value);
        } else if (v instanceof OID) {
            this.set(new Asn1Value((OID)v), Asn1Value.Null);
        } else if (v instanceof Asn1Value[]) {
            this.set(((Asn1Value[])v)[0], ((Asn1Value[])v)[1]);
        } else {
            this.set((Asn1Value)v, Asn1Value.Null);
        }
    }

    public Asn1Value[] getArray() {
        Asn1Value[] array = new Asn1Value[]{this.name, this.value};
        return array;
    }

    public Asn1Value encode() {
        return new Asn1Value(this.getArray());
    }

    public static Vector decodeSequence(Asn1Value varbinds) {
        Vector v = varbinds.getVector();
        Vector<Varbind> decoded = new Vector<Varbind>();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            decoded.addElement(Varbind.decode((Asn1Value)e.nextElement()));
        }
        return decoded;
    }

    public static Varbind decode(Asn1Value varbind) {
        Vector v = varbind.getVector();
        Asn1Value val = (Asn1Value)v.elementAt(1);
        Varbind.decodeSNMPSyntax(val);
        return new Varbind((Asn1Value)v.elementAt(0), val);
    }

    public static void decodeSNMPSyntax(Asn1Value asn1) {
        block3: {
            block2: {
                if (asn1.identifier != SMI.IP_ADDRESS_ID) break block2;
                byte[] content = (byte[])asn1.content;
                asn1.content = String.valueOf(Varbind.charStr(content, 0)) + "." + Varbind.charStr(content, 1) + "." + Varbind.charStr(content, 2) + "." + Varbind.charStr(content, 3);
                break block3;
            }
            if (asn1.identifier != SMI.COUNTER_ID && asn1.identifier != SMI.GAUGE_ID && asn1.identifier != SMI.TIME_TICKS_ID) break block3;
            byte[] content = (byte[])asn1.content;
            try {
                asn1.content = new Long(Asn1Value.decodeLong(new ByteArrayInputStream(content), content.length));
            }
            catch (IOException iOException) {}
        }
    }

    private static String charStr(byte[] s, int pos) {
        int ch = s[pos];
        if (ch < 0) {
            ch += 256;
        }
        return String.valueOf(ch);
    }

    public String toString() {
        return String.valueOf(this.name.toString()) + " = " + this.value.toString();
    }

    public void print(PrintWriter out) throws IOException {
        this.name.print(out);
        out.print(" = ");
        this.value.print(out);
    }
}

