/*
 * Decompiled with CFR 0.152.
 */
package jmgmt.snmp.io;

import java.util.Enumeration;
import java.util.Vector;
import jmgmt.asn1.Asn1Value;
import jmgmt.snmp.io.SMI;
import jmgmt.snmp.io.SnmpDecodeException;
import jmgmt.snmp.io.Varbind;

public class SnmpPdu {
    public static final int NO_ERROR = 0;
    public static final int TOO_BIG = 1;
    public static final int NO_SUCH_NAME = 2;
    public static final int BAD_VALUE = 3;
    public static final int READ_ONLY = 4;
    public static final int GEN_ERR = 5;
    public static final int COLD_START = 0;
    public static final int WARM_START = 1;
    public static final int LINK_DOWN = 2;
    public static final int LINK_UP = 3;
    public static final int AUTHENTICATION_FAILURE = 4;
    public static final int EGP_NEIGHBOR_LOSS = 5;
    public static final int ENTERPRISE_SPECIFIC = 6;
    public int id = SMI.GET_REQUEST_ID;
    public int requestId;
    public int errorStatus;
    public int errorIndex;
    public Vector varbinds;
    private static int lastId;

    public SnmpPdu(int id, int requestId, int errorStatus, int errorIndex, Vector varbinds) {
        this.id = id;
        this.requestId = requestId;
        this.errorStatus = errorStatus;
        this.errorIndex = errorIndex;
        this.varbinds = new Vector();
        this.addVarbinds(varbinds);
    }

    public SnmpPdu(int id, int requestId, Vector varbinds) {
        this(id, requestId, 0, 0, varbinds);
    }

    public SnmpPdu(int id, int requestId) {
        this(id, requestId, 0, 0, null);
    }

    public SnmpPdu(int id) {
        this(id, 0);
        this.requestId = this.uniqeId();
    }

    public int uniqeId() {
        return ++lastId;
    }

    public void addVarbind(Object v) {
        if (v != null) {
            this.varbinds.addElement(new Varbind(v));
        }
    }

    public void addVarbinds(Object[] v) {
        if (v != null) {
            int i = 0;
            while (i < v.length) {
                this.addVarbind(v[i]);
                ++i;
            }
        }
    }

    public void addVarbinds(Vector v) {
        if (v != null) {
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                this.addVarbind(e.nextElement());
            }
        }
    }

    public void addVarbinds(Object v) {
        if (v instanceof Vector) {
            this.addVarbinds((Vector)v);
            return;
        }
        if (v instanceof Object[]) {
            this.addVarbinds((Object[])v);
            return;
        }
        throw new ClassCastException("pdu varbinds");
    }

    public Asn1Value encode() {
        Asn1Value[] vb = new Asn1Value[this.varbinds.size()];
        int i = 0;
        while (i < vb.length) {
            vb[i] = ((Varbind)this.varbinds.elementAt(i)).encode();
            ++i;
        }
        Asn1Value[] content = new Asn1Value[]{new Asn1Value(this.requestId), new Asn1Value(this.errorStatus), new Asn1Value(this.errorIndex), new Asn1Value(vb)};
        return new Asn1Value(this.id, content);
    }

    public Varbind[] getVarbindArray() {
        if (this.varbinds == null) {
            return null;
        }
        Object[] result = new Varbind[this.varbinds.size()];
        this.varbinds.copyInto(result);
        return result;
    }

    public static SnmpPdu decode(Asn1Value v) throws SnmpDecodeException {
        try {
            if (v.content instanceof Vector) {
                Vector pduParts = (Vector)v.content;
                Asn1Value requestId = (Asn1Value)pduParts.elementAt(0);
                Asn1Value errorStatus = (Asn1Value)pduParts.elementAt(1);
                Asn1Value errorIndex = (Asn1Value)pduParts.elementAt(2);
                Asn1Value varbinds = (Asn1Value)pduParts.elementAt(3);
                return new SnmpPdu(v.identifier, requestId.getInt(), errorStatus.getInt(), errorIndex.getInt(), Varbind.decodeSequence(varbinds));
            }
            throw new SnmpDecodeException("pdu content");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpDecodeException("pdu structure");
        }
    }
}

