/*
 * Decompiled with CFR 0.152.
 */
package jmgmt.snmp.io;

import java.util.Vector;
import jmgmt.asn1.Asn1Value;
import jmgmt.snmp.io.SnmpDecodeException;
import jmgmt.snmp.io.SnmpPdu;

public class SnmpMessage {
    public static final int VERSION_1 = 0;
    public String community;
    public SnmpPdu pdu;
    public static Asn1Value ASN1_VERSION_1 = new Asn1Value(0);

    public SnmpMessage(String community, SnmpPdu pdu) {
        this.community = community;
        this.pdu = pdu;
    }

    public Asn1Value encode() {
        Asn1Value[] content = new Asn1Value[]{ASN1_VERSION_1, new Asn1Value(this.community), this.pdu.encode()};
        return new Asn1Value(content);
    }

    public static SnmpMessage decode(Asn1Value value) throws SnmpDecodeException {
        if (value.content instanceof Vector) {
            Asn1Value pdu;
            Asn1Value community;
            Asn1Value version;
            Vector pduParts = (Vector)value.content;
            try {
                version = (Asn1Value)pduParts.elementAt(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new SnmpDecodeException("version");
            }
            if (version.getInt() != 0) {
                throw new SnmpDecodeException("illegal version");
            }
            try {
                community = (Asn1Value)pduParts.elementAt(1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new SnmpDecodeException("community");
            }
            try {
                pdu = (Asn1Value)pduParts.elementAt(2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new SnmpDecodeException("pdu missing");
            }
            return new SnmpMessage(community.getString(), SnmpPdu.decode(pdu));
        }
        throw new SnmpDecodeException("message");
    }
}

