/*
 * Decompiled with CFR 0.152.
 */
package jmgmt.snmp.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import jmgmt.asn1.Asn1Value;
import jmgmt.snmp.io.SMI;
import jmgmt.snmp.io.SnmpDecodeException;
import jmgmt.snmp.io.SnmpMessage;
import jmgmt.snmp.io.SnmpPdu;
import jmgmt.snmp.io.SnmpPeer;
import jmgmt.snmp.io.SnmpResponseException;
import jmgmt.snmp.io.Varbind;

public class SnmpConnection {
    private DatagramSocket socket;
    protected SnmpPeer peer;
    private byte[] buffer;
    private DatagramPacket request;

    public SnmpConnection(SnmpPeer snmpPeer) throws SocketException {
        this.peer = snmpPeer;
        this.socket = new DatagramSocket();
        this.buffer = new byte[snmpPeer.mtu];
    }

    public void setPacket(SnmpPdu snmpPdu) {
        SnmpMessage snmpMessage = new SnmpMessage(this.peer.community, snmpPdu);
        this.setPacket(snmpMessage.encode());
    }

    public void setPacket(Asn1Value asn1Value) {
        this.setPacket(asn1Value.encode());
    }

    public void setPacket(byte[] byArray) {
        this.request = new DatagramPacket(byArray, byArray.length, this.peer.address, this.peer.port);
    }

    public void send() throws IOException {
        this.socket.send(this.request);
    }

    public void send(SnmpPdu snmpPdu) throws IOException {
        this.setPacket(snmpPdu);
        this.send();
    }

    public void send(Asn1Value asn1Value) throws IOException {
        this.setPacket(asn1Value);
        this.send();
    }

    public void send(byte[] byArray) throws IOException {
        this.setPacket(byArray);
        this.send();
    }

    public void close() {
        this.socket.close();
    }

    public Asn1Value receiveAsn1(int n) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(this.buffer, this.buffer.length);
        this.socket.setSoTimeout(n);
        this.socket.receive(datagramPacket);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData(), 0, datagramPacket.getLength());
        return Asn1Value.decode(byteArrayInputStream);
    }

    public SnmpMessage receiveMessage(int n) throws IOException, SnmpDecodeException {
        Asn1Value asn1Value = this.receiveAsn1(n);
        return SnmpMessage.decode(asn1Value);
    }

    public SnmpPdu response(SnmpPdu snmpPdu) throws IOException, SnmpDecodeException {
        SnmpMessage snmpMessage = new SnmpMessage(this.peer.community, snmpPdu);
        byte[] byArray = snmpMessage.encode().encode();
        this.setPacket(byArray);
        int n = 0;
        while (n < this.peer.timeout.length) {
            this.send();
            try {
                SnmpMessage snmpMessage2;
                do {
                    snmpMessage2 = this.receiveMessage(this.peer.timeout[n]);
                } while (snmpMessage2.pdu.requestId != snmpPdu.requestId);
                return snmpMessage2.pdu;
            }
            catch (IOException iOException) {
                ++n;
            }
        }
        return null;
    }

    public Varbind[] response(int n, Object object) throws IOException, SnmpDecodeException, SnmpResponseException {
        SnmpPdu snmpPdu = new SnmpPdu(n);
        snmpPdu.addVarbinds(object);
        SnmpPdu snmpPdu2 = this.response(snmpPdu);
        if (snmpPdu2 == null) {
            return null;
        }
        if (snmpPdu2.errorStatus != 0) {
            throw new SnmpResponseException(snmpPdu2);
        }
        return snmpPdu2.getVarbindArray();
    }

    public Varbind[] getRequest(Object object) throws IOException, SnmpDecodeException, SnmpResponseException {
        return this.response(SMI.GET_REQUEST_ID, object);
    }

    public Varbind[] setRequest(Object object) throws IOException, SnmpDecodeException, SnmpResponseException {
        return this.response(SMI.SET_REQUEST_ID, object);
    }

    public Varbind[] getNextRequest(Object object) throws IOException, SnmpDecodeException, SnmpResponseException {
        return this.response(SMI.GET_NEXT_REQUEST_ID, object);
    }
}

