/*
 * Decompiled with CFR 0.152.
 */
package jmgmt.asn1;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;

public class OID {
    public int[] numbers;
    public static final OID zero = new OID(0, 0);

    public OID(int[] numbers) {
        this.numbers = numbers;
    }

    private void set(Vector values) {
        this.numbers = new int[values.size()];
        int i = 0;
        while (i < values.size()) {
            this.numbers[i] = (Integer)values.elementAt(i);
            ++i;
        }
    }

    public OID(Vector values) {
        this.set(values);
    }

    public OID(String s) {
        Vector<Integer> values = new Vector<Integer>();
        StringTokenizer st = new StringTokenizer(s, " .-,:/;");
        while (st.hasMoreTokens()) {
            try {
                String token = st.nextToken();
                values.addElement(new Integer(token));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.set(values);
    }

    public OID(int v1, int v2) {
        int[] numbers = new int[]{v1, v2};
        this.numbers = numbers;
    }

    public OID index(int v) {
        int[] nn = new int[this.numbers.length + 1];
        int i = 0;
        while (i < this.numbers.length) {
            nn[i] = this.numbers[i];
            ++i;
        }
        nn[this.numbers.length] = v;
        return new OID(nn);
    }

    public OID index(String v) {
        int[] nn = new int[this.numbers.length + 1 + v.length()];
        int i = 0;
        while (i < this.numbers.length) {
            nn[i] = this.numbers[i];
            ++i;
        }
        nn[this.numbers.length] = v.length();
        int i2 = 0;
        while (i2 < v.length()) {
            nn[this.numbers.length + 1 + i2] = v.charAt(i2);
            ++i2;
        }
        return new OID(nn);
    }

    public OID index(OID v) {
        int[] nn = new int[this.numbers.length + 1 + v.numbers.length];
        int i = 0;
        while (i < this.numbers.length) {
            nn[i] = this.numbers[i];
            ++i;
        }
        nn[this.numbers.length] = v.numbers.length;
        int i2 = 0;
        while (i2 < v.numbers.length) {
            nn[this.numbers.length + 1 + i2] = v.numbers[i2];
            ++i2;
        }
        return new OID(nn);
    }

    public OID index(InetAddress v) {
        byte[] addr0 = v.getAddress();
        int[] addr = new int[addr0.length];
        int i = 0;
        while (i < addr0.length) {
            addr[i] = addr0[i];
            if (addr[i] < 0) {
                int n = i;
                addr[n] = addr[n] + 256;
            }
            ++i;
        }
        return this.append(addr);
    }

    public OID append(int[] v) {
        int[] nn = new int[this.numbers.length + v.length];
        int i = 0;
        while (i < this.numbers.length) {
            nn[i] = this.numbers[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < v.length) {
            nn[this.numbers.length + i2] = v[i2];
            ++i2;
        }
        return new OID(nn);
    }

    public int[] getIntArray() {
        return this.numbers;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.numbers.length <= 0) {
            return ".";
        }
        b.append(String.valueOf(this.numbers[0]));
        int i = 1;
        while (i < this.numbers.length) {
            b.append(".");
            b.append(String.valueOf(this.numbers[i]));
            ++i;
        }
        return b.toString();
    }

    public void print(PrintWriter out) throws IOException {
        out.print(this.toString());
    }
}

