/*
 * Decompiled with CFR 0.152.
 */
package jmgmt.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import jmgmt.asn1.LimitedInputStream;
import jmgmt.asn1.OID;

public class Asn1Value {
    private static final boolean debugEncode = false;
    private static final boolean debugDecode = false;
    public static final int UNIVERSAL_CLASS = 0;
    public static final int APPLICATION_CLASS = 1;
    public static final int CONTEXT_CLASS = 2;
    public static final int PRIVATE_CLASS = 3;
    static final int TAG_MASK = 0xFFFFFFF;
    static final int constructedShift = 28;
    static final int classShift = 29;
    static final int CONSTRUCTED_MASK = 0x10000000;
    static final int CLASS_MASK = 0x60000000;
    public static final int ZERO_ID = Asn1Value.universalId(0);
    public static final int BOOLEAN_ID = Asn1Value.universalId(1);
    public static final int INTEGER_ID = Asn1Value.universalId(2);
    public static final int BIT_STRING_ID = Asn1Value.universalId(3);
    public static final int OCTET_STRING_ID = Asn1Value.universalId(4);
    public static final int NULL_ID = Asn1Value.universalId(5);
    public static final int OBJECT_IDENTIFIER_ID = Asn1Value.universalId(6);
    public static final int OBJECT_DESCRIPTOR_ID = Asn1Value.universalId(7);
    public static final int EXTERNAL_ID = Asn1Value.universalId(8);
    public static final int REAL_ID = Asn1Value.universalId(9);
    public static final int ENUMERATED_ID = Asn1Value.universalId(10);
    public static final int SEQUENCE_ID;
    public static final int SEQUENCE_OF_ID;
    public static final int SET_ID;
    public static final int SET_OF_ID;
    public static final int NUMERIC_STRING_ID;
    public static final int PRINTABLE_STRING_ID;
    public static final int TELETEX_STRING_ID;
    public static final int T61_STRING_ID;
    public static final int VIDEOTEX_STRING_ID;
    public static final int IA5_STRING_ID;
    public static final int UTC_TIME_ID;
    public static final int GENERALIZED_TIME_ID;
    public static final int GRAPHIC_STRING_ID;
    public static final int VISIBLE_STRING_ID;
    public static final int ISO646_STRING_ID;
    public static final int GENERAL_STRING_ID;
    public int identifier;
    public Object content;
    public static boolean forceDefinite;
    public static final Asn1Value Null;
    public static final Asn1Value True;
    public static final Asn1Value False;
    public static final Asn1Value EmptySequence;
    public static final Asn1Value EmptySet;
    public static final Asn1Value EmptyString;

    public static int identifier(int n, int n2) {
        return n << 29 | n2 & 0xFFFFFFF;
    }

    public static int identifierClass(int n) {
        return n >> 29;
    }

    public static int identifierTag(int n) {
        return n & 0xFFFFFFF;
    }

    public static boolean identifierConstructed(int n) {
        return (n & 0x10000000) != 0;
    }

    public static final int universalId(int n) {
        return Asn1Value.identifier(0, n);
    }

    public static final int applicationId(int n) {
        return Asn1Value.identifier(1, n);
    }

    public static final int contextId(int n) {
        return Asn1Value.identifier(2, n);
    }

    public static final int privateId(int n) {
        return Asn1Value.identifier(3, n);
    }

    public Asn1Value(int n, Object object) {
        this.identifier = n;
        this.content = object;
    }

    public Asn1Value(int n) {
        this.identifier = INTEGER_ID;
        this.content = new Integer(n);
    }

    public Asn1Value(long l) {
        this.identifier = INTEGER_ID;
        this.content = new Long(l);
    }

    public Asn1Value(String string) {
        this.identifier = OCTET_STRING_ID;
        this.content = string.getBytes();
    }

    public Asn1Value(byte[] byArray) {
        this.identifier = OCTET_STRING_ID;
        this.content = byArray;
    }

    public Asn1Value(OID oID) {
        this.identifier = OBJECT_IDENTIFIER_ID;
        this.content = oID;
    }

    public Asn1Value(Vector vector) {
        this.identifier = SEQUENCE_OF_ID;
        this.content = vector;
    }

    public Asn1Value(Asn1Value[] asn1ValueArray) {
        this.identifier = SEQUENCE_ID;
        this.content = asn1ValueArray;
    }

    public Asn1Value(boolean bl) {
        this.identifier = BOOLEAN_ID;
        this.content = new Integer(bl ? 1 : 0);
    }

    public Asn1Value explicit(int n, Asn1Value asn1Value) {
        Asn1Value[] asn1ValueArray = new Asn1Value[]{asn1Value};
        return new Asn1Value(n, asn1ValueArray);
    }

    public Asn1Value implicit(int n, Asn1Value asn1Value) {
        return new Asn1Value(n, asn1Value.content);
    }

    int getIdentifier() {
        return this.identifier;
    }

    Object getContent() {
        return this.content;
    }

    public int getInt() {
        return (int)this.getLong();
    }

    public long getLong() {
        if (this.content instanceof Long) {
            return (Long)this.content;
        }
        return ((Integer)this.content).intValue();
    }

    public String getString() {
        if (this.content instanceof byte[]) {
            return new String((byte[])this.content);
        }
        return (String)this.content;
    }

    public byte[] getBytes() {
        return (byte[])this.content;
    }

    public Vector getVector() {
        return (Vector)this.content;
    }

    public Asn1Value[] getArray() {
        return (Asn1Value[])this.content;
    }

    public void print(PrintWriter printWriter) throws IOException {
        int n = Asn1Value.identifierClass(this.identifier);
        int n2 = Asn1Value.identifierTag(this.identifier);
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 2: {
                        printWriter.print("[Integer32]    ");
                        break block0;
                    }
                    case 4: {
                        printWriter.print("[Octet-string] ");
                        break block0;
                    }
                    case 5: {
                        printWriter.print("[Null]         ");
                        break block0;
                    }
                    case 6: {
                        printWriter.print("[OID]          ");
                        break block0;
                    }
                }
                printWriter.print("[UNIVERSAL " + n2 + "] ");
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        printWriter.print("[IP address]   ");
                        break block0;
                    }
                    case 1: {
                        printWriter.print("[Counter32]    ");
                        break block0;
                    }
                    case 2: {
                        printWriter.print("[Gauge32]      ");
                        break block0;
                    }
                    case 3: {
                        printWriter.print("[Time-ticks]   ");
                        break block0;
                    }
                    case 4: {
                        printWriter.print("[Opaque]       ");
                        break block0;
                    }
                    case 6: {
                        printWriter.print("[Counter64]    ");
                        break block0;
                    }
                }
                printWriter.print("[APPLICATION " + n2 + "] ");
                break;
            }
            case 2: {
                printWriter.print("[CONTEXT " + n2 + "] ");
                break;
            }
            case 3: {
                printWriter.print("[PRIVATE " + n2 + "] ");
                break;
            }
            default: {
                printWriter.print("[CLASS " + n + "/" + n2 + "] ");
            }
        }
        if (this.content == null) {
            printWriter.print("NULL");
            return;
        }
        if (this.content instanceof Integer) {
            printWriter.print((Integer)this.content);
            return;
        }
        if (this.content instanceof Long) {
            printWriter.print((Long)this.content);
            return;
        }
        if (this.content instanceof String) {
            printWriter.print("\"" + (String)this.content + "\"");
            return;
        }
        if (this.content instanceof byte[]) {
            int n3;
            byte[] byArray = (byte[])this.content;
            boolean bl = byArray.length == 0 | byArray.length > 1;
            int n4 = 0;
            while (n4 < byArray.length) {
                n3 = byArray[n4];
                if (!(Character.isSpace((char)n3) | n3 >= 32 & n3 <= 126 | (n4 == byArray.length - 1 && n3 == 0 && byArray.length > 2))) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl) {
                n3 = byArray.length;
                if (n3 > 0 && byArray[n3 - 1] == 0) {
                    --n3;
                }
                if (n3 > 0 && byArray[n3 - 1] == 10) {
                    --n3;
                }
                if (n3 > 0 && byArray[n3 - 1] == 13) {
                    --n3;
                }
                printWriter.print("\"" + new String(byArray, 0, n3) + "\"");
                return;
            }
            Asn1Value.printHex(printWriter, byArray);
            return;
        }
        if (this.content instanceof OID) {
            ((OID)this.content).print(printWriter);
            return;
        }
        if (this.content instanceof Vector) {
            printWriter.print("{ ");
            Enumeration enumeration = ((Vector)this.content).elements();
            while (enumeration.hasMoreElements()) {
                ((Asn1Value)enumeration.nextElement()).print(printWriter);
                printWriter.print(", ");
            }
            printWriter.print("}");
            return;
        }
        if (this.content instanceof Asn1Value[]) {
            Asn1Value[] asn1ValueArray = (Asn1Value[])this.content;
            printWriter.print("{ ");
            int n5 = 0;
            while (n5 < asn1ValueArray.length) {
                asn1ValueArray[n5].print(printWriter);
                printWriter.print(", ");
                ++n5;
            }
            printWriter.print("}");
            return;
        }
        printWriter.print("<UNKNOWN>");
    }

    public static void encodeTagInteger(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[5];
        int n2 = 0;
        while (n != 0) {
            byArray[n2] = (byte)(n & 0x7F);
            n >>= 7;
            ++n2;
        }
        int n3 = n2 - 1;
        while (n3 > 0) {
            outputStream.write(byArray[n3] | 0x80);
            --n3;
        }
        outputStream.write(byArray[0]);
    }

    public static void encodeLength(OutputStream outputStream, int n) throws IOException {
        if (n < 128) {
            outputStream.write((byte)n);
            return;
        }
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n != 0) {
            byArray[n2] = (byte)(n & 0xFF);
            n >>= 8;
            n2 = (byte)(n2 + 1);
        }
        outputStream.write(0x80 | n2);
        int n3 = n2 - 1;
        while (n3 >= 0) {
            outputStream.write(byArray[n3]);
            --n3;
        }
    }

    public void encodeIdentifier(OutputStream outputStream, boolean bl) throws IOException {
        int n = Asn1Value.identifierClass(this.identifier);
        int n2 = Asn1Value.identifierTag(this.identifier);
        byte by = (byte)(n << 6 | (bl ? 32 : 0));
        if (n2 <= 30) {
            outputStream.write(by | n2);
            return;
        }
        outputStream.write(by | 0x1F);
        Asn1Value.encodeTagInteger(outputStream, n2);
    }

    public void encode(OutputStream outputStream) throws IOException {
        boolean bl = this.content instanceof Vector || this.content instanceof Asn1Value[];
        this.encodeIdentifier(outputStream, bl);
        if (this.content instanceof Integer) {
            Asn1Value.encodeContent(outputStream, this.getInt());
            return;
        }
        if (this.content instanceof Long) {
            Asn1Value.encodeContent(outputStream, this.getLong());
            return;
        }
        if (this.content instanceof String) {
            Asn1Value.encodeContent(outputStream, this.getString());
            return;
        }
        if (this.content instanceof byte[]) {
            Asn1Value.encodeContent(outputStream, (byte[])this.content);
            return;
        }
        if (this.content instanceof OID) {
            Asn1Value.encodeContent(outputStream, (OID)this.content);
            return;
        }
        if (this.content instanceof Vector) {
            Asn1Value.encodeContent(outputStream, this.getVector());
            return;
        }
        if (this.content instanceof Asn1Value[]) {
            Asn1Value.encodeContent(outputStream, this.getArray());
            return;
        }
        if (this.content == null) {
            outputStream.write(0);
            return;
        }
        throw new ClassCastException("invalid content class");
    }

    public static void encodeContent(OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[8];
        long l2 = l < 0L ? -1 : 0;
        long l3 = l2 & 0x80L;
        int n = 0;
        while (n == 0 || l != l2 || (long)(byArray[n - 1] & 0x80) != l3) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>= 8;
            n = (byte)(n + 1);
        }
        outputStream.write(n);
        int n2 = n - 1;
        while (n2 >= 0) {
            outputStream.write(byArray[n2]);
            --n2;
        }
    }

    public static void encodeContent(OutputStream outputStream, String string) throws IOException {
        Asn1Value.encodeLength(outputStream, string.length());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        outputStreamWriter.write(string);
        outputStreamWriter.close();
    }

    public static void encodeContent(OutputStream outputStream, byte[] byArray) throws IOException {
        Asn1Value.encodeLength(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    public static void encodeContent(OutputStream outputStream, OID oID) throws IOException {
        int[] nArray = oID.getIntArray();
        if (nArray.length < 2) {
            throw new IllegalArgumentException("OID has less than 2 numbers");
        }
        int n = 40 * nArray[0] + nArray[1];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Asn1Value.encodeTagInteger(byteArrayOutputStream, n);
        int n2 = 2;
        while (n2 < nArray.length) {
            Asn1Value.encodeTagInteger(byteArrayOutputStream, nArray[n2]);
            ++n2;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Asn1Value.encodeLength(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    public static void encodeContent(OutputStream outputStream, Vector vector) throws IOException {
        if (forceDefinite) {
            Object object;
            Vector<Object> vector2 = new Vector<Object>();
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = new ByteArrayOutputStream();
                ((Asn1Value)enumeration.nextElement()).encode((OutputStream)object);
                vector2.addElement(object);
                n += ((ByteArrayOutputStream)object).size();
            }
            Asn1Value.encodeLength(outputStream, n);
            object = vector2.elements();
            while (object.hasMoreElements()) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)object.nextElement();
                outputStream.write(byteArrayOutputStream.toByteArray());
            }
            return;
        }
        outputStream.write(128);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Asn1Value)enumeration.nextElement()).encode(outputStream);
        }
        outputStream.write(0);
        outputStream.write(0);
    }

    public static void encodeContent(OutputStream outputStream, Asn1Value[] asn1ValueArray) throws IOException {
        if (forceDefinite) {
            ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[asn1ValueArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < asn1ValueArray.length) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                asn1ValueArray[n2].encode(byteArrayOutputStream);
                byteArrayOutputStreamArray[n2] = byteArrayOutputStream;
                n += byteArrayOutputStream.size();
                ++n2;
            }
            Asn1Value.encodeLength(outputStream, n);
            int n3 = 0;
            while (n3 < asn1ValueArray.length) {
                outputStream.write(byteArrayOutputStreamArray[n3].toByteArray());
                ++n3;
            }
            return;
        }
        outputStream.write(128);
        int n = 0;
        while (n < asn1ValueArray.length) {
            asn1ValueArray[n].encode(outputStream);
            ++n;
        }
        outputStream.write(0);
        outputStream.write(0);
    }

    public byte[] encode() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.encode(byteArrayOutputStream);
        }
        catch (IOException iOException) {}
        return byteArrayOutputStream.toByteArray();
    }

    public static void printHex(PrintWriter printWriter, byte[] byArray, int n) {
        String string = "0123456789ABCDEF";
        int n2 = 0;
        while (n2 < byArray.length && n2 < n) {
            int n3 = byArray[n2];
            if (n3 < 0) {
                n3 += 256;
            }
            int n4 = n3 & 0xF;
            int n5 = n3 >> 4;
            printWriter.print(string.substring(n5, n5 + 1));
            printWriter.print(string.substring(n4, n4 + 1));
            ++n2;
        }
    }

    public static void printHex(PrintWriter printWriter, byte[] byArray) {
        Asn1Value.printHex(printWriter, byArray, byArray.length);
    }

    public void printHex(PrintWriter printWriter) {
        byte[] byArray = this.encode();
        Asn1Value.printHex(printWriter, byArray);
    }

    public void printHex(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.printHex(printWriter);
        printWriter.close();
    }

    public static Asn1Value decode(InputStream inputStream) throws IOException {
        return Asn1Value.decode(new LimitedInputStream(inputStream, -1));
    }

    public static Asn1Value decode(LimitedInputStream limitedInputStream) throws IOException {
        int n = Asn1Value.decodeIdentifier(limitedInputStream);
        if (!Asn1Value.identifierConstructed(n)) {
            int n2 = Asn1Value.decodeLength(limitedInputStream);
            if (n == INTEGER_ID || n == BOOLEAN_ID || n == ENUMERATED_ID) {
                return new Asn1Value(n, new Long(Asn1Value.decodeLong(limitedInputStream, n2)));
            }
            if (n == OBJECT_IDENTIFIER_ID) {
                return new Asn1Value(n, Asn1Value.decodeOID(limitedInputStream, n2));
            }
            byte[] byArray = Asn1Value.decodeOctets(limitedInputStream, n2);
            if (n == OCTET_STRING_ID) {
                return new Asn1Value(n, byArray);
            }
            return new Asn1Value(n, byArray);
        }
        int n3 = Asn1Value.decodeLength(limitedInputStream);
        Vector<Asn1Value> vector = new Vector<Asn1Value>();
        if (n3 < 0) {
            while (true) {
                Asn1Value asn1Value = Asn1Value.decode(limitedInputStream);
                if (asn1Value.identifier != 0) {
                    vector.addElement(asn1Value);
                    continue;
                }
                break;
            }
        } else {
            int n4 = limitedInputStream.limit;
            limitedInputStream.limit = n3;
            while (limitedInputStream.limit > 0) {
                Asn1Value asn1Value = Asn1Value.decode(limitedInputStream);
                vector.addElement(asn1Value);
            }
            limitedInputStream.limit = n4 - n3;
        }
        return new Asn1Value(n, vector);
    }

    public static byte[] decodeOctets(LimitedInputStream limitedInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = limitedInputStream.read(byArray);
        if (n2 != n) {
            throw new EOFException("Asn1Value: decode: EOF in primitive value");
        }
        return byArray;
    }

    public static int decodeIdentifier(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException("Asn1Value: decode: EOF in identifier");
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        if (n3 == 31) {
            n = Asn1Value.decodeTagInteger(inputStream);
        }
        int n4 = n2 << 28 | n3;
        return n4;
    }

    static int decodeLength(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException("Asn1Value: decode: EOF in length");
        }
        if (n == 128) {
            return -1;
        }
        if (n < 128) {
            return n;
        }
        int n2 = 0;
        n &= 0x7F;
        while (n > 0) {
            int n3 = inputStream.read();
            if (n3 < 0) {
                throw new EOFException("Asn1Value: decode: EOF in length");
            }
            n2 = (n2 << 8) + n3;
            --n;
        }
        return n2;
    }

    public static long decodeLong(InputStream inputStream, int n) throws IOException {
        long l = 0L;
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException("Asn1Value: decode: EOF in integer");
        }
        if ((n2 & 0x80) != 0) {
            l = -1L;
        }
        l = l << 8 | (long)n2;
        int n3 = 1;
        while (n3 < n) {
            n2 = inputStream.read();
            if (n2 < 0) {
                throw new EOFException("Asn1Value: decode: EOF in integer");
            }
            l = l << 8 | (long)n2;
            ++n3;
        }
        return l;
    }

    public static OID decodeOID(LimitedInputStream limitedInputStream, int n) throws IOException {
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = limitedInputStream.limit;
        limitedInputStream.limit = n;
        int n3 = Asn1Value.decodeTagInteger(limitedInputStream);
        int n4 = n3 / 40;
        int n5 = n3 % 40;
        vector.addElement(new Integer(n4));
        vector.addElement(new Integer(n5));
        while (limitedInputStream.limit > 0) {
            vector.addElement(new Integer(Asn1Value.decodeTagInteger(limitedInputStream)));
        }
        limitedInputStream.limit = n2 - n;
        OID oID = new OID(vector);
        return oID;
    }

    public static int decodeTagInteger(InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        do {
            if ((n = inputStream.read()) < 0) {
                throw new EOFException("Asn1Value: decode: EOF in tag integer");
            }
            n2 = (n2 << 7) + (n & 0x7F);
        } while ((n & 0x80) != 0);
        return n2;
    }

    public static Asn1Value decode(byte[] byArray) throws IOException {
        return Asn1Value.decode(new ByteArrayInputStream(byArray));
    }

    static {
        SEQUENCE_OF_ID = SEQUENCE_ID = Asn1Value.universalId(16);
        SET_OF_ID = SET_ID = Asn1Value.universalId(17);
        NUMERIC_STRING_ID = Asn1Value.universalId(18);
        PRINTABLE_STRING_ID = Asn1Value.universalId(19);
        T61_STRING_ID = TELETEX_STRING_ID = Asn1Value.universalId(20);
        VIDEOTEX_STRING_ID = Asn1Value.universalId(21);
        IA5_STRING_ID = Asn1Value.universalId(22);
        UTC_TIME_ID = Asn1Value.universalId(23);
        GENERALIZED_TIME_ID = Asn1Value.universalId(24);
        GRAPHIC_STRING_ID = Asn1Value.universalId(25);
        ISO646_STRING_ID = VISIBLE_STRING_ID = Asn1Value.universalId(26);
        GENERAL_STRING_ID = Asn1Value.universalId(27);
        forceDefinite = true;
        Null = new Asn1Value(NULL_ID, null);
        True = new Asn1Value(BOOLEAN_ID, new Integer(1));
        False = new Asn1Value(BOOLEAN_ID, new Integer(0));
        EmptySequence = new Asn1Value(new Asn1Value[0]);
        EmptySet = new Asn1Value(SET_ID, new Asn1Value[0]);
        EmptyString = new Asn1Value("");
    }
}

