/*  Copyright Daryl Gray 2001 email daryl.g@visto.com
 * 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */



#ifndef __GTKSORTHEADING_H__
#define __GTKSORTHEADING_H__

#include <gtk/gtkhbox.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_SORT_HEADING                  (gtk_sort_heading_get_type())
#define GTK_SORT_HEADING(obj)                  (GTK_CHECK_CAST ((obj), GTK_TYPE_SORT_HEADING, GtkSortHeading))
#define GTK_SORT_HEADING_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_SORT_HEADING, GtkSortHeadingClass))
#define GTK_IS_SORT_HEADING(obj)               (GTK_CHECK_TYPE ((obj), GTK_TYPE_SORT_HEADING))
#define GTK_IS_SORT_HEADING_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_SORT_HEADING))


typedef enum {
	GTK_SORT_HEADING_ASCENDING,
	GTK_SORT_HEADING_DESCENDING,
	GTK_SORT_HEADING_OFF,
	GTK_SORT_HEADING_UNKNOWN
} GtkSortHeadingMode;

typedef struct _GtkSortHeading       		GtkSortHeading;
typedef struct _GtkSortHeadingPrivate 		GtkSortHeadingPrivate;
typedef struct _GtkSortHeadingClass  		GtkSortHeadingClass;

struct _GtkSortHeading {
	GtkHBox hbox;

	GSList *group;
	GtkSortHeadingPrivate *priv;
};

struct _GtkSortHeadingClass {
	GtkHBoxClass parent_class;

	void (* gtk_sort_heading) (GtkSortHeading *sh);
};

GtkType
gtk_sort_heading_get_type 	  			(void);


/*
 *Make a new sort heading widget.
 *You need everything except the label - That can be NULL
 *The group works similar to a radiobutton group
*/
GtkWidget
*gtk_sort_heading_new					(GSList			*group,
							 GtkCList		*parent_clist,
							 gint			column,
							 const gchar		*label);

/*
 *Set or change the heading text
*/
void
gtk_sort_heading_set_label				(GtkSortHeading		*sh,
							 const gchar		*label);

/*
 *Set or change the label text justification
*/
void
gtk_sort_heading_set_label_justify			(GtkSortHeading		*sh,
							GtkJustification	jtype);
/*
 *Get a pointer to the list or "group" of GtkSortHeadings
 *Don't know why you would want to but threw it in anyways
*/
GSList
*gtk_sort_heading_group					(GtkSortHeading		*sh);

/*
 *Change the CList column to be sorted if not the same column
 *This is handy for dates etc
 *(Keep a non - visible column of the dates as time_t and sort them instead)
*/
void
gtk_sort_heading_set_sort_column			(GtkSortHeading		*sh,
							 gint			column);

/*
 *Change the mode to ASCENDING or DECENDING.
 *The rest in the group will be turned off
*/
void
gtk_sort_heading_set_mode				(GtkSortHeading		*gcsh,
							 GtkSortHeadingMode	mode);

/*
 *Get the current Sort Mode
*/
GtkSortHeadingMode
gtk_sort_heading_get_mode				(GtkSortHeading		*sh);



/*Don't use this. It is for groups to keep in sinc with each other
======================================================================================
*/
void
gtk_sort_heading_set_new_group				(GtkSortHeading		*sh,
							 GSList			*ngroup);
#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTKSORTHEADING_H__ */

