/*  Copyright Daryl Gray 2001 email daryl.g@visto.com
 * 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */



#ifndef __FAX_VIEWER_H__
#define __FAX_VIEWER_H__

#include <gtk/gtkbin.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define LIBGEFAX_TYPE_FAX_VIEWER		(lib_gefax_fax_viewer_get_type())
#define LIBGEFAX_FAX_VIEWER(obj)		(GTK_CHECK_CAST ((obj), LIBGEFAX_TYPE_FAX_VIEWER, LibGefaxFaxViewer))
#define LIBGEFAX_FAX_VIEWER_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), LIBGEFAX_TYPE_FAX_VIEWER, LibGefaxFaxViewerClass))
#define LIBGEFAX_IS_FAX_VIEWER(obj)		(GTK_CHECK_TYPE ((obj), LIBGEFAX_TYPE_FAX_VIEWER))
#define LIBGEFAX_IS_FAX_VIEWER_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), LIBGEFAX_TYPE_FAX_VIEWER))

typedef struct _LibGefaxFaxViewer       	LibGefaxFaxViewer;
typedef struct _LibGefaxFaxViewerPrivate 	LibGefaxFaxViewerPrivate;
typedef struct _LibGefaxFaxViewerClass 		LibGefaxFaxViewerClass;

struct _LibGefaxFaxViewer {
	GtkHBox box;

	LibGefaxFaxViewerPrivate *priv;
};

struct _LibGefaxFaxViewerClass {
	GtkHBoxClass parent_class;

	/*Additional Signals*/
	void (* right_click)		(LibGefaxFaxViewer *fax_viewer, guint button, guint32 activate_time);
	void (* scale_changed)		(LibGefaxFaxViewer *fax_viewer, gdouble scale);
	void (* page_changed)		(LibGefaxFaxViewer *fax_viewer, gint page);
	void (* lib_gefax_fax_viewer)	(LibGefaxFaxViewer *fax_viewer);
};

GtkType
lib_gefax_fax_viewer_get_type 	  			(void);


/*
 * Create a new Fax Viewer Widget with GdkInterpType = GDK_INTERP_TILES and
 * Scale set to 0.35:1
*/
GtkWidget
*lib_gefax_fax_viewer_new				(void);

/*
 * Create a new Fax Viewer Widget with "scale", "interp_type"
 * and view a file or all Tiff files in "file_or_directory"
*/
GtkWidget
*lib_gefax_fax_viewer_construct				(const gchar		*file_or_directory,
							gdouble			scale,
							GdkInterpType		interp_type);

/*
 * Set the GdkInterpType to use when rendering images
*/
void
lib_gefax_fax_viewer_set_interp_type			(LibGefaxFaxViewer	*fv,
							GdkInterpType		interp_type);

/*
 * Build a list of all Tiff files in directory (Clearing any existing file paths)
 * The first file will automatically be displayed
 * NOTE: Only useful if the files can be sorted by "alphasort" or order is not relevant
*/
gboolean
lib_gefax_fax_viewer_load_directory			(LibGefaxFaxViewer	*fv,
							const gchar		*directory);

/*
 * Replace current page list (if any) with new PageList
 * PageList->data is an allocated gchar of full path to tiff page file
 * Do not free PageList after, fax viewer will take care of it!
*/
void
lib_gefax_fax_viewer_load_page_list			(LibGefaxFaxViewer	*fv,
							GList			*PageList);
/*
 * Load a single Tiff file (Clearing any existing file paths)
*/
gboolean
lib_gefax_fax_viewer_load_file				(LibGefaxFaxViewer	*fv,
							const gchar		*file_name);

gboolean
lib_gefax_fax_viewer_show_png_file			(LibGefaxFaxViewer	*fv,
							const gchar		*file_name);

/*
 * Set the image scale
 * Must be within the *SCALE_MAX and *SCALE_MIN as below
*/
#define LIBGEFAX_FAX_VIEWER_SCALE_MAX 2.0
#define LIBGEFAX_FAX_VIEWER_SCALE_MIN 0.1
void
lib_gefax_fax_viewer_set_scale				(LibGefaxFaxViewer	*fv,
							gdouble			scale);

/*
 * Get the current image scale
*/
gdouble
lib_gefax_fax_viewer_get_scale				(LibGefaxFaxViewer	*fv);

/*
 * Get the number of loaded file paths
*/
gint
lib_gefax_fax_viewer_get_pages				(LibGefaxFaxViewer	*fv);

/*
 * The rest are page navigation
 * "unused" is so you can use these directly from a "gtk_signal_connect" as they will simply return on failure
 * **"unused" may be scrapped soon I think as it has very limited benifits**
*/
void
lib_gefax_fax_viewer_show_first_page			(GtkWidget		*unused,
							LibGefaxFaxViewer	*fv);

void
lib_gefax_fax_viewer_show_last_page			(GtkWidget		*unused,
							LibGefaxFaxViewer	*fv);

void
lib_gefax_fax_viewer_show_next_page			(GtkWidget		*unused,
							LibGefaxFaxViewer	*fv);

void
lib_gefax_fax_viewer_show_previous_page			(GtkWidget		*unused,
							LibGefaxFaxViewer	*fv);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __FAX_VIEWER_H__ */

