/*  Copyright Daryl Gray 2001 email daryl.g@visto.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __TEXTFILE_WRAP_H__
#define __TEXTFILE_WRAP_H__

#include <gnome.h>

#define LIBGEFAX_WRAPTEXTFILE_MIN_LINELENGTH		20
#define LIBGEFAX_WRAPTEXTFILE_MAX_WORDLENGTH		30
#define LIBGEFAX_WRAPTEXTFILE_MAX_TABEXPAND		16

typedef enum {
	LIBGEFAX_WRAPTEXTFILE_ERROR_NONE,
	LIBGEFAX_WRAPTEXTFILE_ERROR_MIMETYPE,
	LIBGEFAX_WRAPTEXTFILE_ERROR_LINELENGTH,
	LIBGEFAX_WRAPTEXTFILE_ERROR_NOFILE,
	LIBGEFAX_WRAPTEXTFILE_ERROR_NOFILEACCESS,
	LIBGEFAX_WRAPTEXTFILE_ERROR_OUTFILE
} LibGefaxWrapTextError;

typedef struct _LibGefaxWrapTextResult     	  	LibGefaxWrapTextResult;
typedef struct _LibGefaxInternalData     	  	LibGefaxInternalData;

struct _LibGefaxWrapTextResult{
	gchar *return_file;				/*Must be freed*/
	gint file_linecount;
	gint lines_wrapped;
	gint words;
	LibGefaxInternalData *priv;
	LibGefaxWrapTextError error;
};

/*
 * The returned structure must be freed. The internal->priv is already freed
 * Filenames must be full absolute paths. Linelength must be at least 30
*/
LibGefaxWrapTextResult *libGefax_wrap_text_file		(const gchar	*infile,
							 gint		tab_expand,
							 gint 		line_length);





#endif	/* __TEXTFILE_WRAP_H__*/
