/*  Copyright Daryl Gray 2000 email daryl.g@visto.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __HISTORY_DATA_H__
#define __HISTORY_DATA_H__

#include <gnome.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define LIB_GEFAX_HISTORY_DATA_FILE	"gefax.metadata"

typedef struct	_Fax_Page		Fax_Page;
typedef struct	_Fax_Data		Fax_Data;

struct _Fax_Page {
	gchar	*page_file_name;	/*The page file name*/
	gchar	*page_thumb_file_name;	/*The page tiff thumbnail*/
	gint	index;			/*page order*/
};
struct _Fax_Data {
	gint	key;			/*unique key generated when read*/
	gchar	*directory;		/*the file directory path*/
	gchar	*polled;		/*if the fax was polled*/
	gint	pages;			/*number of pages in the fax*/
	time_t	save_time;		/*save time*/
	time_t	print_time;		/*last time the fax was printed*/
	GSList	*Pages;			/*List of Type Fax_Page*/
};

GList
*lib_gefax_history_data_read_xml_file		(const gchar		*directory_path);

gboolean
lib_gefax_history_data_save_xml_file		(const gchar		*directory_path,
						GList			*FaxList);

void
lib_gefax_history_data_free_data		(GList			*FaxList);

Fax_Data
*lib_gefax_history_data_get_fax_data_from_key	(GList			*FaxList,
						gint			key);

GList
*lib_gefax_history_data_remove_fax_data_from_key(GList			*FaxList,
						gint			key);

GList
*lib_gefax_history_data_append_fax_data		(GList			*FaxList,
						Fax_Data		*FaxData);

GList
*lib_gefax_history_data_get_file_list_from_key	(GList			*FaxList,
						gint			key);
void
lib_gefax_history_data_free_file_list		(GList			*FileList);

/*
 * Get the file name of page. If page doesn't have a thumb try to generate one
 * Returns null if FaxData does not contain page or the thumb could not be
 * generated. FaxData is updated if a thumb is generated
*/
gchar
*lib_gefax_history_data_get_fax_page_thumb	(Fax_Data		*FaxData,
						gint			page);

/*
 * Backwards Compatabiliy with gefax vers < 0.4-3
 * WILL BE REMOVED
*/
#define BACKWARDS_COMPATIBLE

#ifdef BACKWARDS_COMPATIBLE
GList
*lib_gefax_history_data_read_old_history	(const gchar		*directory_path);
#endif BACKWARDS_COMPATIBLE

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __HISTORY_DATA_H__ */
