/*  Copyright Daryl Gray 2001 email daryl.g@visto.com
 * 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "vcard_util.h"

gchar
*vcard_util_primary_type_to_tag				(const PrimaryType	p_type)
{
	gchar *tag = NULL;
	
	switch (p_type) {
/*		case BEGIN:
			tag = "BEGIN";
			break;
		case END:
			tag = "END";
			break;*/
		case FN:
			tag = "FN";
			break;
		case N:
			tag = "N";
			break;
		case ADR:
			tag = "ADR";
			break;
		case TEL:
			tag = "TEL";
			break;
		case EMAIL:
			tag = "EMAIL";
			break;
		case BDAY:
			tag = "BDAY";
			break;
		case REV:
			tag = "REV";
			break;
		case ORG:
			tag = "ORG";
			break;
		case TITLE:
			tag = "TITLE";
			break;
		case URL:
			tag = "URL";
			break;
		case CATEGORIES:
			tag = "CATEGORIES";
			break;
		case NOTE:
			tag = "NOTE";
			break;
		case KEY:
			tag = "KEY";
			break;
		case TZ:
			tag = "TZ";
			break;
		case GEO:
			tag = "GEO";
			break;
		case LOGO:
			tag = "LOGO";
			break;
		default :
			break;
	}
	return tag;
}

gchar
*vcard_util_sub_type_to_tag				(const int		s_type)
{
	gchar *tag = NULL;
	
	switch (s_type) {
		case DOM:
			tag = "DOM";
			break;
		case POSTAL:
			tag = "POSTAL";
			break;
		case PARCEL:
			tag = "PARCEL";
			break;
		case INTL:
			tag = "INTL";
			break;
		case HOME:
			tag = "HOME";
			break;
		case WORK:
			tag = "WORK";
			break;
		case PREF:
			tag = "PREF";
			break;
		case VOICE:
			tag = "VOICE";
			break;
		case FAX:
			tag = "FAX";
			break;
		case MSG:
			tag = "MSG";
			break;
		case CELL:
			tag = "CELL";
			break;
		case PAGER:
			tag = "PAGER";
			break;
		case BBS:
			tag = "BBS";
			break;
		case MODEM:
			tag = "MODEM";
			break;
		case CAR:
			tag = "CAR";
			break;
		case ISDN:
			tag = "ISDN";
			break;
		case VIDEO:
			tag = "VIDEO";
			break;
		case AOL:
			tag = "AOL";
			break;
		case APPLELINK:
			tag = "APPLELINK";
			break;
		case ATTMAIL:
			tag = "ATTMAIL";
			break;
		case CIS:
			tag = "CIS";
			break;
		case EWORLD:
			tag = "EWORLD";
			break;
		case INTERNET:
			tag = "INTERNET";
			break;
		case IBMMail:
			tag = "IBMMail";
			break;
		case MCIMAIL:
			tag = "MCIMAIL";
			break;
		case POWERSHARE:
			tag = "POWERSHARE";
			break;
		case PRODIGY:
			tag = "PRODIGY";
			break;
		case TLX:
			tag = "TLX";
			break;
		case X400:
			tag = "X400";
			break;
		case PGP:
			tag = "PGP";
			break;
		case X509:
			tag = "X509";
			break;
		case GIF:
			tag = "GIF";
			break;
		case BMP:
			tag = "BMP";
			break;
		case PMB:
			tag = "PMB";
			break;
		case TIFF:
			tag = "TIFF";
			break;
		case PS:
			tag = "PS";
			break;
		case PDF:
			tag = "PDF";
			break;
		case JPEG:
			tag = "JPEG";
			break;
		default :
			break;
	}
	return tag;
}
