/*  Copyright Daryl Gray 2001 email daryl.g@visto.com
 * 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "add_field.h"
#include "vcard_util.h"

void
add_TEL_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	LibGefaxTelephone *t;
	gint gslist_len, i;
	GSList *S_Tag = NULL;
	
	g_return_if_fail ((c != NULL) && (d != NULL));

	t = LIB_GEFAX_TELEPHONE_NEW ();

	if (d->Data)
		t->number = g_strdup (d->Data->data);
		t->key = g_slist_length (c->Tel) + 1;
	if (!d->S_Tags) {
		t->type |= LIBGEFAX_PHONE_NONE;
	} else {
		S_Tag = d->S_Tags;
		gslist_len = g_slist_length (S_Tag);
		for (i = 0; i < gslist_len; i++) {
			STag *stag = S_Tag->data;
			if (stag->type == HOME) {
				t->type |= LIBGEFAX_PHONE_HOME;
			} else if (stag->type == WORK) {
				t->type |= LIBGEFAX_PHONE_WORK;
			} else if (stag->type == PREF) {
				t->type |= LIBGEFAX_PHONE_PREF;
			} else if (stag->type == VOICE) {
				t->type |= LIBGEFAX_PHONE_VOICE;
			} else if (stag->type == FAX) {
				t->type |= LIBGEFAX_PHONE_FAX;
			} else if (stag->type == MSG) {
				t->type |= LIBGEFAX_PHONE_MSG;
			} else if (stag->type == CELL) {
				t->type |= LIBGEFAX_PHONE_CELL;
			} else if (stag->type == PAGER) {
				t->type |= LIBGEFAX_PHONE_PAGER;
			} else if (stag->type == BBS) {
				t->type |= LIBGEFAX_PHONE_BBS;
			} else if (stag->type == MODEM) {
				t->type |= LIBGEFAX_PHONE_MODEM;
			} else if (stag->type == CAR) {
				t->type |= LIBGEFAX_PHONE_CAR;
			} else if (stag->type == ISDN) {
				t->type |= LIBGEFAX_PHONE_ISDN;
			} else if (stag->type == VIDEO) {
				t->type |= LIBGEFAX_PHONE_VIDEO;
			} else {
				/*OOps don't know*/
				g_warning ("Unknown Telephone type, No type will be specified");
				t->type |= LIBGEFAX_PHONE_NONE;
			}
			S_Tag = g_slist_next (S_Tag);
		}
	}
	
	c->Tel = g_slist_append (c->Tel, t);
}

void
add_ADR_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	LibGefaxAddress *a;
	gint gslist_len, i;
	GSList *S_Tag = NULL;
	GSList *Data = NULL;
	
	g_return_if_fail ((c != NULL) && (d != NULL));
	
	a = LIB_GEFAX_ADDRESS_NEW ();

	if (d->Data) {
		Data = d->Data;
		a->key = g_slist_length (c->Address) + 1;
		if (Data->data) a->post_box = g_strdup (Data->data);
		Data = g_slist_next (Data);
		if (Data) {
			if (Data->data) a->extended = g_strdup (Data->data);
			Data = g_slist_next (Data);
		}
		if (Data) {
			if (Data->data) a->street = g_strdup (Data->data);
			Data = g_slist_next (Data);
		}
		if (Data) {
			if (Data->data) a->city = g_strdup (Data->data);
			Data = g_slist_next (Data);
		}
		if (Data) {
			if (Data->data) a->region = g_strdup (Data->data);
			Data = g_slist_next (Data);
		}
		if (Data) {
			if (Data->data) a->post_code = g_strdup (Data->data);
			Data = g_slist_next (Data);
		}
		if (Data)
			if (Data->data ) a->country = g_strdup (Data->data);
	}
	if (!d->S_Tags) {
		a->type |= LIBGEFAX_ADDRESS_NONE;
	} else {
		S_Tag = d->S_Tags;
		gslist_len = g_slist_length (S_Tag);
		for (i = 0; i < gslist_len; i++) {
			STag *stag = S_Tag->data;
			if (stag->type == DOM) {
				a->type |= LIBGEFAX_ADDRESS_DOMESTIC;
			} else if (stag->type == POSTAL) {
				a->type |= LIBGEFAX_ADDRESS_POSTAL;
			} else if (stag->type == PARCEL) {
				a->type |= LIBGEFAX_ADDRESS_PARCEL;
			} else if (stag->type == INTL) {
				a->type |= LIBGEFAX_ADDRESS_INTERNATIONAL;
			} else if (stag->type == HOME) {
				a->type |= LIBGEFAX_ADDRESS_HOME;
			} else if (stag->type == WORK) {
				a->type |= LIBGEFAX_ADDRESS_WORK;
			} else {
				/*OOps don't know*/
				g_warning ("Unknown Address type, No type will be specified");
				a->type |= LIBGEFAX_ADDRESS_NONE;
			}
			S_Tag = g_slist_next (S_Tag);
		}
	}
	
	c->Address = g_slist_append (c->Address, a);
}

void
add_N_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	LibGefaxIdentity *i;
	GSList *Data = NULL;
	
	g_return_if_fail ((c != NULL) && (d != NULL));

	i = c->Identity;

	if (d->Data) {
		Data = d->Data;
		if (Data->data) i->family = g_strdup (Data->data);
		Data = g_slist_next (Data);
		if (Data) {
			if (Data->data) i->given = g_strdup (Data->data);
			Data = g_slist_next (Data);
		}
		if (Data) {
			if (Data->data) i->additional = g_strdup (Data->data);
			Data = g_slist_next (Data);
		}
		if (Data) {
			if (Data->data) i->prefix = g_strdup (Data->data);
			Data = g_slist_next (Data);
		}
		if (Data)
			if (Data->data ) i->suffix = g_strdup (Data->data);
		
	}
}

void
add_FN_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	g_return_if_fail ((c != NULL) && (d != NULL));
	
	if (d->Data)
		c->filename = g_strdup (d->Data->data);
}

void
add_EMAIL_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	LibGefaxEmail *e;
	GSList *S_Tag = NULL;
	
	g_return_if_fail ((c != NULL) && (d != NULL));
	
	e = LIB_GEFAX_EMAIL_NEW ();

	S_Tag = d->S_Tags;
	if (d->Data) {
		e->number = g_strdup (d->Data->data);
	}
	if (!d->S_Tags) {
		e->type = LIBGEFAX_EMAIL_NONE;
	} else {
		STag *stag = S_Tag->data;
		if (stag->type == AOL) {
			e->type = LIBGEFAX_EMAIL_AOL;
		} else if (stag->type == APPLELINK) {
			e->type = LIBGEFAX_EMAIL_APPLELINK;
		} else if (stag->type == ATTMAIL) {
			e->type = LIBGEFAX_EMAIL_ATT;
		} else if (stag->type == CIS) {
			e->type = LIBGEFAX_EMAIL_CIS;
		} else if (stag->type == EWORLD) {
			e->type = LIBGEFAX_EMAIL_EWORLD;
		} else if (stag->type == INTERNET) {
			e->type = LIBGEFAX_EMAIL_INTERNET;
		} else if (stag->type == IBMMail) {
			e->type = LIBGEFAX_EMAIL_IBM;
		} else if (stag->type == MCIMAIL) {
			e->type = LIBGEFAX_EMAIL_MCI;
		} else if (stag->type == POWERSHARE) {
			e->type = LIBGEFAX_EMAIL_POWERSHARE;
		} else if (stag->type == PRODIGY) {
			e->type = LIBGEFAX_EMAIL_PRODIGY;
		} else if (stag->type == TLX) {
			e->type = LIBGEFAX_EMAIL_TLX;
		} else if (stag->type == X400) {
			e->type = LIBGEFAX_EMAIL_X400;
		} else {
			/*OOps don't know*/
			g_warning ("Unknown Email type, No type will be specified");
			e->type = LIBGEFAX_EMAIL_NONE;
		}
	}
	e->key = g_slist_length (c->Email) + 1;
	c->Email = g_slist_append (c->Email, e);
}

void
add_BDAY_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	/*BDAY:years-months-days*/
	LibGefaxDate *bd;
	gchar *p1, *p2, *p3;
	
	g_return_if_fail ((c != NULL) && (d != NULL));
	
	bd = c->BirthDate;
	p1 = d->Data->data;
	p2 = strchr(p1, '-');
	
	if (!p2) {
										/*ERROR MSG*/
		return;
	} else {
		*p2 = '\0';
		++p2;
		p3 = strchr(p2, '-');
		if (!p2) {
											/*ERROR MSG*/
			return;
		} else {
			*p3 = '\0';
			++p3;
			bd->years = atoi (p1);
			bd->months = atoi (p2);
			bd->days = atoi (p3);
		}
	}
	
}

void
add_REV_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	LibGefaxDate *rev;
	gchar *date, *time;
	gchar *p1, *p2, *p3;
	
	g_return_if_fail ((c != NULL) && (d != NULL));

	rev = c->Revision;

	/*Split Date and Time*/
	date = d->Data->data;
	time = strchr(date, 'T');
	if (!time) {
										/*ERROR MSG*/
		return;
	} else {
		*time = '\0';
		++time;
	}
	
	/*Break down the Date*/
	p1 = date;
	p2 = strchr(p1, '-');
	
	if (!p2) {
										/*ERROR MSG*/
		return;
	} else {
		*p2 = '\0';
		++p2;
		p3 = strchr(p2, '-');
		if (!p2) {
										/*ERROR MSG*/
			return;
		} else {
			*p3 = '\0';
			++p3;
			rev->years = atoi (p1);
			rev->months = atoi (p2);
			rev->days = atoi (p3);
		}
	}
	
	/*Break down the Time*/
	p1 = time;
	p2 = strchr(p1, ':');
	
	if (!p2) {
										/*ERROR MSG*/
		return;
	} else {
		*p2 = '\0';
		++p2;
		p3 = strchr(p2, ':');
		if (!p2) {
											/*ERROR MSG*/
			return;
		} else {
			*p3 = '\0';
			++p3;
			rev->hours = atoi (p1);
			rev->minutes = atoi (p2);
			rev->seconds = atoi (p3);
		}
	}
}

void
add_ORG_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	LibGefaxBusiness *b;
	
	g_return_if_fail ((c != NULL) && (d != NULL));
	
	b = c->Business;
	
	if (d->Data)
		b->org_name = g_strdup (d->Data->data);
}

void
add_TITLE_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	LibGefaxBusiness *b;
	
	g_return_if_fail ((c != NULL) && (d != NULL));
	
	b = c->Business;
	
	if (d->Data)
		b->org_title = g_strdup (d->Data->data);
}

void
add_URL_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	g_return_if_fail ((c != NULL) && (d != NULL));
	
	if (d->Data)
		c->url = g_strdup (d->Data->data);
}

void
add_CATEGORIES_to_contact				(LibGefaxContact	*c,
							FieldData 		*d)
{
	/*Categories are commer(,) delimeted?*/
	GSList *li = NULL;
	gchar *p1,*p2;
	
	g_return_if_fail ((c != NULL) && (d != NULL));
	
	if (d->Data) {
		p1 = d->Data->data;
		while (*p1 != '\0') {
			p2 = strchr(p1, ',');
			if (!p2) {
				li = g_slist_append (li, g_strdup (p1));
				break;
			}
			*p2 = '\0';
			++p2;
			li = g_slist_append (li, g_strdup (p1));
			p1 = p2;
		}
	}
	c->Categories = li;
}

void
add_NOTE_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	g_return_if_fail ((c != NULL) && (d != NULL));

	if (d->Data)
		c->note = g_strdup (d->Data->data);
}

void
add_KEY_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	LibGefaxPublicKey *pc;
	GSList *S_Tag;
	STag *stag;
	
	g_return_if_fail ((c != NULL) && (d != NULL));

	pc = c->PublicKey;
	S_Tag = d->S_Tags;
	stag = S_Tag->data;

	if (stag->type == PGP) {
		pc->type = LIBGEFAX_PGP;
	} else {
		pc->type = LIBGEFAX_X509;
	}
	if (d->Data) {
		pc->key = g_strdup (d->Data->data);
	}
	
}

void
add_TZ_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	LibGefaxTimeZone *tz;
	gchar *p1, *p2;
	
	g_return_if_fail ((c != NULL) && (d != NULL));
	
	tz = c->TimeZone;

	/*TZ:hours:minutes*/
	p1 = d->Data->data;
	p2 = strchr(p1, ':');
	if (!p2) {
										/*ERROR MSG*/
		return;
	} else {
		*p2 = '\0';
		++p2;
		tz->hours = atoi (p1);
		tz->minutes = atoi (p2);
	}
}

void
add_GEO_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	LibGefaxGeo *gl;
	gchar *p1, *p2;
	
	g_return_if_fail ((c != NULL) && (d != NULL));
	
	gl = c->GeoLocation;

	/*GEO:lon,lat*/
	p1 = d->Data->data;
	p2 = strchr(p1, ',');
	if (!p2) {
										/*ERROR MSG*/
		return;
	} else {
		*p2 = '\0';
		++p2;
		gl->longitude = atof (p1);
		gl->latitude = atof (p2);
	}
}

void
add_LOGO_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	STag *stag;
	LibGefaxLogo *logo;
	
	g_return_if_fail ((c != NULL) && (d != NULL));
	g_return_if_fail (c->Logo == NULL);
	
	stag = d->S_Tags->data;
	logo = LIB_GEFAX_LOGO_NEW ();
	
	if (stag->type == GIF) {
		logo->type = LIBGEFAX_LOGO_GIF;
	} else if (stag->type == BMP) {
		logo->type = LIBGEFAX_LOGO_BMP;
	} else if (stag->type == PMB) {
		logo->type = LIBGEFAX_LOGO_PMB;
	} else if (stag->type == TIFF) {
		logo->type = LIBGEFAX_LOGO_TIFF;
	} else if (stag->type == PS) {
		logo->type = LIBGEFAX_LOGO_PS;
	} else if (stag->type == PDF) {
		logo->type = LIBGEFAX_LOGO_PDF;
	} else if (stag->type == JPEG) {
		logo->type = LIBGEFAX_LOGO_JPEG;
	} else {
		logo->type = LIBGEFAX_LOGO_UNKNOWN;					/*ERROR*/
	}
	
	if (d->Data)
		logo->data = g_strdup (d->Data->data);
	
	c->Logo = logo;

}

void
add_UNKNOWN_to_contact					(LibGefaxContact	*c,
							FieldData 		*d)
{
	LibGefaxUnknown *Un;
	PTag *ptag;
	GSList *stags;
	gint l, i;
	GSList *tags = NULL;
	
	g_return_if_fail ((c != NULL) && (d != NULL));

	ptag = d->P_Tag;
	stags = d->S_Tags;
	Un = LIB_GEFAX_UNKNOWN_NEW ();

	if (ptag->type == UNKNOWN) {
		if (ptag->tag) {
			tags = g_slist_append (tags, g_strdup (ptag->tag));
		} else {
											/*ERROR*/
		}
	} else {
		tags = g_slist_append (tags, g_strdup (vcard_util_primary_type_to_tag (ptag->type)));
	}
	
	l = g_slist_length (stags);
	for (i = 0; i < l; i++ ) {
		STag *S = stags->data;
		if (S->type == SUBUNKNOWN) {
			if (S->tag) {
				tags = g_slist_append (tags, g_strdup (S->tag));
			} else {
											/*ERROR*/
			}
		} else {
			tags = g_slist_append (tags, g_strdup (vcard_util_sub_type_to_tag (S->type)));
		}
		stags = g_slist_next (stags);
	}
	
	Un->Tags = tags;
	Un->Data = d->Data;
	d->Data = NULL;
	
	if (d->encode == ENC_NONE) {
		Un->data_type = LIBGEFAX_ENC_NONE;
	} else if (d->encode == ENC_BASE64) {
		Un->data_type = LIBGEFAX_ENC_BASE64;
	} else {
		Un->data_type = LIBGEFAX_ENC_QUOTED_PRINTABLE;
	}
	
	/*Add the Unknown to contact*/
	c->Unknown = g_slist_append (c->Unknown, Un);
}
