/*  Copyright Daryl Gray 2001 email daryl.g@visto.com
 * 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __CONTACT_DIALOG_H__
#define __CONTACT_DIALOG_H__

#include <libgnomeui/gnome-propertybox.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "address-book.h"

#define LIBGEFAX_TYPE_CONTACT_DIALOG       	(lib_gefax_contact_dialog_get_type ())
#define LIBGEFAX_CONTACT_DIALOG(obj)            (GTK_CHECK_CAST ((obj), LIBGEFAX_TYPE_CONTACT_DIALOG, LibGefaxContactDialog))
#define LIBGEFAX_CONTACT_DIALOG_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), LIBGEFAX_TYPE_CONTACT_DIALOG, LibGefaxContactDialogClass))
#define LIBGEFAX_IS_CONTACT_DIALOG(obj)         (GTK_CHECK_TYPE ((obj), LIBGEFAX_TYPE_CONTACT_DIALOG))
#define LIBGEFAX_IS_CONTACT_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), LIBGEFAX_TYPE_CONTACT_DIALOG))

#define LIBGEFAX_CONTACT_DIALOG_NEW_CONTACT	-1

typedef struct _LibGefaxContactDialog		LibGefaxContactDialog;
typedef struct _ContactDialogPriv		ContactDialogPriv;
typedef struct _I_Tab				I_Tab;
typedef struct _A_Tab				A_Tab;
typedef struct _P_Tab				P_Tab;
typedef struct _N_Tab				N_Tab;
typedef struct _X_Tab				X_Tab;
typedef struct _LibGefaxContactDialogClass	LibGefaxContactDialogClass;

struct _LibGefaxContactDialog {
	GnomePropertyBox	card_dialog;
	ContactDialogPriv	*Priv;
	I_Tab			*ITab;		/*Identity Tab*/
	A_Tab			*ATab;		/*Address Tab*/
	P_Tab			*PTab;		/*Phone Tab*/
	N_Tab			*NTab;		/*Network Tab*/
	X_Tab			*XTab;		/*Additional Tab*/
};

struct _LibGefaxContactDialogClass {
	GnomePropertyBoxClass	parent_class;
	
	/*Additional Signals*/
	void (* addressbook_changed)		(LibGefaxContactDialog *contactdialog, gpointer contact, gint key);
	void (* dialog_help)			(LibGefaxContactDialog *contactdialog, gint page_num);
	
	void (* lib_gefax_contact_dialog) 	(LibGefaxContactDialog *ContactDiag);
};

guint
lib_gefax_contact_dialog_get_type		(void);


GtkWidget
*lib_gefax_contact_dialog_new			(GList			*LibGefaxAddressBook,
						gint			key);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __CONTACT_DIALOG_H__ */
