/*  Copyright Daryl Gray 2001 email daryl.g@visto.com
 * 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */



#ifndef __ADDRESSBOOK_ENUMS_H__
#define __ADDRESSBOOK_ENUMS_H__

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*******************************************************************
 *
 *	Types relating to LibGefaxContact defined in address_book.h
 *
 *******************************************************************/
 
enum LibGefaxAddressType {
	LIBGEFAX_ADDRESS_HOME		= 1 << 0,
	LIBGEFAX_ADDRESS_WORK		= 1 << 1,
	LIBGEFAX_ADDRESS_POSTAL		= 1 << 2,
	LIBGEFAX_ADDRESS_PARCEL		= 1 << 3,
	LIBGEFAX_ADDRESS_DOMESTIC	= 1 << 4,
	LIBGEFAX_ADDRESS_INTERNATIONAL	= 1 << 5,
	LIBGEFAX_ADDRESS_NONE		= 1 << 6
};

enum LibGefaxPhoneType {
	LIBGEFAX_PHONE_PREF		= 1 << 0,
	LIBGEFAX_PHONE_WORK		= 1 << 1,
	LIBGEFAX_PHONE_HOME		= 1 << 2,
	LIBGEFAX_PHONE_VOICE		= 1 << 3,
	LIBGEFAX_PHONE_FAX		= 1 << 4,
	LIBGEFAX_PHONE_MSG		= 1 << 5,
	LIBGEFAX_PHONE_CELL		= 1 << 6,
	LIBGEFAX_PHONE_PAGER		= 1 << 7,
	LIBGEFAX_PHONE_BBS		= 1 << 8,
	LIBGEFAX_PHONE_MODEM		= 1 << 9,
	LIBGEFAX_PHONE_CAR		= 1 << 10,
	LIBGEFAX_PHONE_ISDN		= 1 << 11,
	LIBGEFAX_PHONE_VIDEO		= 1 << 12,
	LIBGEFAX_PHONE_NONE		= 1 << 13
};

typedef enum {
	LIBGEFAX_EMAIL_AOL		= 0,
	LIBGEFAX_EMAIL_APPLELINK	= 1,
	LIBGEFAX_EMAIL_ATT		= 2,
	LIBGEFAX_EMAIL_CIS		= 3,
	LIBGEFAX_EMAIL_EWORLD		= 4,
	LIBGEFAX_EMAIL_INTERNET		= 5,
	LIBGEFAX_EMAIL_IBM		= 6,
	LIBGEFAX_EMAIL_MCI		= 7,
	LIBGEFAX_EMAIL_POWERSHARE	= 8,
	LIBGEFAX_EMAIL_PRODIGY		= 9,
	LIBGEFAX_EMAIL_TLX		= 10,
	LIBGEFAX_EMAIL_X400		= 11,
	LIBGEFAX_EMAIL_NONE		= 12
} LibGefaxEmailType;

typedef enum {
	LIBGEFAX_LOGO_GIF,
	LIBGEFAX_LOGO_BMP,
	LIBGEFAX_LOGO_PMB,
	LIBGEFAX_LOGO_TIFF,
	LIBGEFAX_LOGO_PS,
	LIBGEFAX_LOGO_PDF,
	LIBGEFAX_LOGO_JPEG,
	LIBGEFAX_LOGO_UNKNOWN
} LibGefaxLogoType;

typedef enum {
	LIBGEFAX_PGP,
	LIBGEFAX_X509
} LibGefaxKeyType;

typedef enum {
	LIBGEFAX_ENC_QUOTED_PRINTABLE,
	LIBGEFAX_ENC_BASE64,
	LIBGEFAX_ENC_NONE
} LibGefaxEncodeType;

/*******************************************************************
 *
 *	File types to save address book as.
 *	Auto detected when reading
 *
 *******************************************************************/
 
typedef enum {
	LIBGEFAX_FILETYPE_VCARD
} LibGefaxFileType;

/*******************************************************************
 *
 *	Types relating to searching and sorting address book
 *
 *******************************************************************/
 
typedef enum {
	LIBGEFAX_FILTER_PHONE,		/*Any Phone Number type*/
	LIBGEFAX_FILTER_FAX,		/*Phone Number with type fax*/
	LIBGEFAX_FILTER_ADDRESS,	/*Any Address*/
	LIBGEFAX_FILTER_EMAIL,		/*Any Email*/
	LIBGEFAX_FILTER_URL		/*Any Url*/
} LibGefaxFilterType;

typedef enum {
	LIBGEFAX_SEARCH_IDENTITY,	/*Search Name & filename*/
	LIBGEFAX_SEARCH_ADDRESS,	/*Search Address/s*/
	LIBGEFAX_SEARCH_CATEGORY,	/*Search Categories*/
	LIBGEFAX_SEARCH_TELEPHONE,	/*Search Telephone Numbers*/
	LIBGEFAX_SEARCH_BUSINESS,	/*Search Org & Title*/
	LIBGEFAX_SEARCH_EMAIL,		/*Search Email address/s*/
	LIBGEFAX_SEARCH_ALL		/*Search All fields except Public Key & Logo*/
} LibGefaxSearch;

typedef enum {
	LIBGEFAX_SEARCHTYPE_CONTAINS,	/*A field contains (*string*)*/
	LIBGEFAX_SEARCHTYPE_IS,		/*A field is (string)*/
	LIBGEFAX_SEARCHTYPE_BEGIN,	/*A field begins (string*)*/
	LIBGEFAX_SEARCHTYPE_END		/*A feild ends (*string)*/
} LibGefaxSearchType;

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ADDRESSBOOK_ENUMS_H__ */

