#!/usr/bin/perl -w
#
# v0.2
#
# Based upon log files from Insane Bot v1.
#
# This program is written in Perl and modified from Diatheke's script. If you'd like to use it you need
# to download Perl for Windows first. I highly recommend ActiveState Perl
# which can be found at http://www.activestate.com/Products/Download/Get.plex?id=ActivePerl
#
# Save this file as something like insane-report.pl then simply run it from
# the MS-DOS prompt by typing "perl -w insane-report.pl". 
#
# I don't know perl, so everything I've done here has been patched together as best I can figure out.
# You'll probably see lots of unused variables and bits that I have commented out as I've been working on this.
# I'm dying to get this data into a SQL back-end so I can *REALLY* have fun with it.  I grok SQL.
#
# I can be found on http://forums.insanity-inc.org
# -or-
# irc.sorcery.net in #insane-bot 
#
#
# -Grok
#
#
# Abrafo v1.3
# by neoaeon (nick@null.net)
#
# V1.3
# o Fixed a couple more reporting errors
# o Added a Trade Note Value multiplier variable, set to 0.8 if you spend your notes in the wrong places
#  or set it to 1.0 if you want to give full value to all trade notes.
#
# v1.2
# o Just ignoreing "speechblock" commands all together helps with the pri -1 issues
#  only problem is any "speechblock" command that spawns REAL commands owned by the bot get screwed,
#  but they would have w/ the old script anyway.
#
# v1.1
# o Semi-Fixed a bug that would bill any -1 priority command to the previous person if the previous
#  buff was unfinished.
# o Made +1M donators bold
# o Configuration is a BITCH now, you must located every -1 priority command, and speech block and
#  place them in the arrays to properly bill.  If you have -1 priority commands that actually buff
#  I really can't help you, you can ignore them, or get horribly wrong numbers, your choice =D.
# o Took spaces out of all data fields so that the output .htm can be directly imported into Excell XP
#  for sorting and reporting
# 
# v1
# Took Groks version and cleaned it up a bit.
# o Removed the DSH/Laydee section
# o Removed "Fulano" from the web page title
# o All math is based off of the same formulas, as opposed to a different forumla for each section and 
#  calculation. (tapers * 24, *25, *28 WTF was that about?)
# o Monarch and Patron ties are tracked regardless of the security rule that let them get buffs.
# o Made the minor reporting sections (abusers and monarchies) more robust, I hated having to scroll down
#  and up and down and up to see if an "abuser" was really an abuser.  Someone who pays 0 but gives sings
#  smalls isn't an abuser =D
# o Added a $markup variable that calculates all values just like the botconfig's MarkUp="", 1.3 is Groks
#  default.
# o Tweaked the Patron ties so that its a seperate array.  Also tweaked it so that the patron is also
#  included with his vassals in the report.
# 

use strict;
use diagnostics -verbose;

# Change below to match your installation location if you did not select the default install location.
my $html_out = "Logs/insane-usage.htm";
my $log_dir = "Logs/";
my $abuserThresh = 60; # This is the number of Life and/or Critter spells cast upon a user
my $markup = 1.6; # This is just like the MarkUp="" in the BotConfig.xml, the number comp. values are multiplied by
my $tnvalue = 0.8; # This is the value of trade notes, 0.8 is what you get from "another vender" 1.0 is what you get from "the same vender"

# Any commands in your config listed as priority "-1" should be listed here
# otherwise what ever command was interupted by the pri -1 command, the
# rest of it will be billed to the pri -1 user.
my @commandsIgnore = ( "help", "status", "line", "about", "news", "problem", "singles", "whereto", "assistance", "move", "where", "whereareyou", "plats", "components", "comps", "setflag", "setuserlevel", "cancel", "announce", "motd", "home", "mansion", "mansionreturn", "sancrecall", "reset", "permitme", "quit", "lifestone", "portalrecall", "repeat", "speechblock");

# Any Speech Blocks that are triggered by commands that should be ignored, same reason as above as well as
# any speech block that could interupt a buff
my @speechIgnore = ( "Thanks", "Howdy", "NoAccess" );

# Change the list below to cycle thru the allegiances for usage information
# Delete everything between the parens if you don't wish to parse any allegiance usage
my %AllegianceList = (	"Bennet of Swords", "allegiance",
					"Weelock", "allegiance",
					"Finis", "allegiance"
					);
# Change the list below to cycle thru the patron groups for usage information
# Delete everything between the parens if you don't wish to parse any patron group usage
my %PatronList = (	"Italuwa", "vassals",
					);

my @logDates;
my $lCommandUser = "_unknown_";
my $spellName = "_unknown_";
my $nSummons = 0;
my $targetID = 0;
my %comps;
my @tmp;
my %users;
my $name = "";
my $UpgradeName = "_unknown_";
my $OtherItem = "_unknown_";
my $targetName = "_unknown_";
my $value = 0;
my $key = "";
my $count = 0;
my $patron = "";
my $monarch = "";
my $platval = int((40000 * $markup) + 0.5);
my $prismaticval = int((22 * $markup) + 0.5);
my $item = 0;
my $componentTotalv = 0;
my $tradeTotalv = 0;
my $platTotalv = 0;
my $pyrealTotalv = 0;
my $prismTotalv = 0;
my $lvl6Total = 0;
my $lvl7Total = 0;
my $i = 0;
my $j = 0;
my $p = 0;
my %spellcount;
my $spellnames = "";
my $spellcounts = 0;
my %UserInfo;
my @curruser;
my $sloop = 0;
my $cloop = 0;
my $badcmdflag = 0;

sub HTML_tableHead {
my @th = @_;

print <<EOF;
<table border="0">
  <thead>
    <tr bgcolor="#CCCCCC">
EOF

foreach $_ (@th) { 
print "      <th>" . $_ . "</th>\n";
}

print <<EOF;
    </tr>
  </thead>
  <tbody>
EOF
}

opendir(DIR, $log_dir) || die "Are you using a non-default installation location?\n";

my @files =  readdir(DIR);
shift(@files);
shift(@files);
closedir(DIR);

foreach my $file (@files) {


# Lets do some sanity checking... We're going to assume the user didn't change the bot log name.
if ($file !~ /Bot-Log/) {
	next;
	}

open(FILE, "$log_dir$file") || die "Internal Error: Somethings changed with the logs!\n\n";

 LOOP: while(!eof(FILE)) {
 	$_ = <FILE>;

    	
    	#<LogOpen TimeStamp="2002-04-07T13:42:29" Timer="49349307" />
    	if ($_ =~ /^<LogOpen TimeStamp="/) {
    		@_ = split(/"/,$');
    		unshift(@logDates,$_[0]);
    	}

	# Count portal summon's
	if ($_ =~ /^<Cast SpellName="Summon /) {
		$nSummons++;
		next LOOP;
	}
		
	# Look for new commands and get the user name to bill
	if ($_ =~ /^<Command Name="/ ) {
		$badcmdflag = 0;
		for ($cloop = 0; $cloop <= $#commandsIgnore; $cloop++) {
			if ( $_ =~ /^<Command Name="$commandsIgnore[$cloop]"/ ) {
				$badcmdflag = 1;
			}
		}
		if ( $badcmdflag == 0 ) {
			@_ = split(/"/,$');
			$lCommandUser = $_[4];
			$curruser[$p] = $lCommandUser;
			$p++;
		}
	}

	# look for ignored speech blocks and start billing the last valid user
	if ($_ =~ /^<Start Name="Speech" Item="/ ) {
		for ($sloop = 0; $sloop <= $#speechIgnore; $sloop++) {
			if ( $_ =~ /^<Start Name="Speech" Item=""$speechIgnore[$sloop]"/ ) {
				$p--;
				$lCommandUser = $curruser[$p];
			}
		}
	}

	# Watch and increase Spells cast on user
    	if ( $_ =~ /^<Cast SpellName="/ ) {
		@_ = split(/"/,$');
		$spellName = $_[0];
		$targetName = $_[4];
		$targetID = $_[6];

		$spellcount{$spellName}{$spellcounts}++;
		if ( $targetName eq "Self" ) {
			next LOOP;
		}
		$users{$lCommandUser}{'SpellsCastUpon'}{$spellName}++;
	}
    	
    	# Comp usage/value
    	if ($_ =~ /^<CompBurn CompName="/) {
    		@_ = split(/"/,$');
    		$comps{$_[0]} += $_[2];
		if (defined($users{$lCommandUser}{'UserCompValue'})) {
			$users{$lCommandUser}{'UserCompValue'} += $_[2];
		}
		
		else {
			$users{$lCommandUser}{'UserCompValue'} = $_[2];
		}
    	}

	#Time to see who Monarchs are for each person
	if ($_ =~ /^<AssessUser UserName="/ ) {
		@_ = split(/"/,$');
		$name =  $_[0];
		$monarch = $_[6];

		if (defined($users{$name}{'Monarch'})) {
			$users{$name}{'Monarch'} = $monarch;
		}
		else {
			$users{$name}{'Monarch'} = $monarch;
		}
	} #END Time to see who Monarchs are for each person

	#Time to see who Patrons are for each person
	if ($_ =~ /^<AssessUser UserName="/ ) {
		@_ = split(/"/,$');
		$name =  $_[0];
		$patron = $_[4];

		if (defined($users{$name}{'Patron'})) {
			$users{$name}{'Patron'} = $patron;
		}
		else {
			$users{$name}{'Patron'} = $patron;
		}
	} #END Time to see who Patrons are for each person

	#Time to handle ALL given items
	if ($_ =~ /^<Gift Name/ ) {
		# Donated Trade Notes	
		if ($_ =~ /^<Gift Name="Trade Note"/ ) {
			@_ = split(/"/,$');
			$name = $_[7];
			$value = $_[1];
			$UpgradeName = $name;
			
			if (defined($users{$name}{'Trade Note Value'})) {
				$users{$name}{'Trade Note Value'} += ($value * $tnvalue) ;
			}
			else {
				$users{$name}{'Trade Note Value'} = ($value * $tnvalue) ;
			}

			if (defined($users{$name}{'TotalGifts'})) {
				$users{$name}{'TotalGifts'} += ($value * $tnvalue);
			}
			else {
				$users{$name}{'TotalGifts'} = ($value * $tnvalue);
			}
		}
		
		# Donated Pyreals	
		elsif ($_ =~ /^<Gift Name="Pyreal" Value="/) {
			@_ = split(/"/,$');
			$name = $_[6];
			$value = $_[0];
			$UpgradeName = $name;
			
			if (defined($users{$name}{'Pyreals'})) {
				$users{$name}{'Pyreals'} += $value;
			}
			else {
				$users{$name}{'Pyreals'} = $value;
			}

			if (defined($users{$name}{'TotalGifts'})) {
				$users{$name}{'TotalGifts'} += $value;
			}
			else {
				$users{$name}{'TotalGifts'} = $value;
			}
		}
		
		# Donated Platinum Scarabs	
		elsif ($_ =~ /^<Gift Name="Platinum Scarab"/) {
			@_ = split(/"/,$');
			$name = $_[7];
			$count = $_[3];
			$UpgradeName = $name;
		
			if (defined($users{$name}{'Platinum Scarabs Donated'})) {
				$users{$name}{'Platinum Scarabs Donated'} = $count + $users{$name}{'Platinum Scarabs Donated'};
			}
			else {
				$users{$name}{'Platinum Scarabs Donated'} = $count;
			}
			
			if (defined($users{$name}{'TotalGifts'})) {
				$users{$name}{'TotalGifts'} += ($count * $platval);
			}
			else {
				$users{$name}{'TotalGifts'} = ($count * $platval);
			}
		}

		# Donated Prismatic Tapers
		elsif ($_ =~ /^<Gift Name="Prismatic Taper"/) {
			@_ = split(/"/,$');
			$name = $_[7];
			$count = $_[3];
			$UpgradeName = $name;
		
			if (defined($users{$name}{'Prismatic Tapers Donated'})) {
				$users{$name}{'Prismatic Tapers Donated'} = $count + $users{$name}{'Prismatic Tapers Donated'};
			}
			else {
				$users{$name}{'Prismatic Tapers Donated'} = $count;
			}

			if (defined($users{$name}{'TotalGifts'})) {
				$users{$name}{'TotalGifts'} += ($count * $prismaticval);
			}
			else {
				$users{$name}{'TotalGifts'} = ($count * $prismaticval);
			}
		}

		# Other Stuff given
		else {
			@_ = split(/"/,$');
			$name = $_[9];
			$item = $_[1];
			$UpgradeName = $name;
			$OtherItem = $item;

			if ((defined($users{$name}{'Other Donated'}) && (length ($users{$name}{'Other Donated'}) > 0))) {
				$users{$name}{'Other Donated'} = $item . ", " . $users{$name}{'Other Donated'};
			}
			else {
				$users{$name}{'Other Donated'} = $item;
			}
		}
	} #END Time to handle ALL given items

	# Check for Upgrades (6)
	if ($_ =~ /^<Start Name="Speech" Item="UpgradeLevel6"/) {
		@_ = split(/"/,$');
		$name =	$UpgradeName;
		$lvl6Total++;

		if (defined($users{$name}{'Level6Upgrade'})) {
			$users{$name}{'Level6Upgrade'}++;
		}
		else {
			$users{$name}{'Level6Upgrade'} = 1;
		}
	} #END Check for Upgrades

	# Check for Upgrades (7)
	if ($_ =~ /^<Start Name="Speech" Item="UpgradeLevel7"/) {
		@_ = split(/"/,$');
		$name =	$UpgradeName;
		$lvl7Total++;

		if (defined($users{$name}{'Level7Upgrade'})) {
			$users{$name}{'Level7Upgrade'} = 1 + $users{$name}{'Level7Upgrade'};
		}
		else {
			$users{$name}{'Level7Upgrade'} = 1;
		}
	} #END Check for Upgrades

	#Check to see if given items are for armor baning
	if ($_ =~ /^<Start Name="Speech" Item="PreBaneArmor"/ || $_ =~ /^<Start Name="Speech" Item="NotBaneArmor"/ || $_ =~ /^<Start Name="Speech" Item="OldPreBaneArmor"/ || $_ =~ /^<Start Name="Speech" Item="NonBaneable"/) {
		my $TempVal = 0;
		my $TempStrLen = 0;

		my $TempStrTest = "";

		$TempVal = index $users{$UpgradeName}{'Other Donated'},$OtherItem;
		$TempStrLen = (length $OtherItem);

		# Here we clear out gifts if they are baned
		if (length $OtherItem == length $users{$UpgradeName}{'Other Donated'}) {
			$users{$UpgradeName}{'Other Donated'} = "";
		}
		else {
			$users{$UpgradeName}{'Other Donated'} = substr $users{$UpgradeName}{'Other Donated'}, ($TempStrLen)+2;
		}
	} #END Check to see if given items are for armor baning

	if ($_ =~ /^<IdentifyUser UserName="/) {
		@_ = split(/"/, $');
		$targetName = $_[0];
		$targetID = $_[2];
		$UserInfo{$targetName}{'TargetID'} =  $targetID;
	}    	
  
 } # while
 close(FILE);
} # foreach

open(HTML, ">$html_out") || die "Couldn't open $html_out for writing!\n\n";

select(HTML);

print <<EOF;
<html>
<head><title>Insane Bot Usage Summary</title><head>
<body bgcolor="#FFFFFFFF"><basefont face="Arial">

EOF

print "<img src=\"banner.jpg\">\n";


# Validate the data to prevent Perl warnings
printf "<p>\n";
foreach $key ( sort keys %users) {

	if (defined($users{$key}{'UserCompValue'})) {
	}
	else {
		$users{$key}{'UserCompValue'} = 0;
	}
	if (defined($users{$key}{'TotalGifts'})) {
	}
	else {
		$users{$key}{'TotalGifts'} = 0;
	}
	if (defined($users{$key}{'Trade Note Value'})) {
	}
	else {
		$users{$key}{'Trade Note Value'} = 0;
	}
	if (defined($users{$key}{'Pyreals'})) {
	}
	else {
		$users{$key}{'Pyreals'} = 0;
	}
	if (defined($users{$key}{'Platinum Scarabs Donated'})) {
	}
	else {
		$users{$key}{'Platinum Scarabs Donated'} = 0;
	}
	if (defined($users{$key}{'Prismatic Tapers Donated'})) {
	}
	else {
		$users{$key}{'Prismatic Tapers Donated'} = 0;
	}
	if (defined($users{$key}{'Other Donated'})) {
	}
	else {
		$users{$key}{'Other Donated'} = "";
	}
	if (defined($users{$key}{'Level6Upgrade'})) {
	}
	else {
		$users{$key}{'Level6Upgrade'} = "";
	}
	if (defined($users{$key}{'Level7Upgrade'})) {
	}
	else {
		$users{$key}{'Level7Upgrade'} = "";
	}
# BIG KLUDGE! -Neoaeon
	if (defined($users{$key}{'Monarch'})) {
		if ($users{$key}{'Monarch'} eq "" ) {
			$users{$key}{'Monarch'} = "Unknown-Rank $key";
		}
	}
	else {
		$users{$key}{'Monarch'} = "Unknown-Rank $key";
	}
	if (defined($users{$key}{'Patron'})) {
		if ($users{$key}{'Patron'} eq "" ) {
			$users{$key}{'Patron'} = "Unknown-Rank $key";
		}
	}
	else {
		$users{$key}{'Patron'} = "Unknown-Rank $key";
	}
}

# Get total component usage value
foreach $key (keys %comps) {
	$componentTotalv += $comps{$key}; 
}

# Get totals for plats and notes
foreach $key ( sort keys %users) {

	if (! defined($users{$key}{'Trade Note Value'})) {
		$users{$key}{'Trade Note Value'} = 0;
	}
	
	if (! defined($users{$key}{'Platinum Scarabs Donated'})) {
		$users{$key}{'Platinum Scarabs Donated'} = 0;
	}

	if (! defined($users{$key}{'Pyreals'})) {
		$users{$key}{'Pyreals'} = 0;
	}

	if (! defined($users{$key}{'Prismatic Tapers Donated'})) {
		$users{$key}{'Prismatic Tapers Donated'} = 0;
	}

	$tradeTotalv += $users{$key}{'Trade Note Value'};
	$platTotalv += $users{$key}{'Platinum Scarabs Donated'};
	$pyrealTotalv += $users{$key}{'Pyreals'};
	$prismTotalv += $users{$key}{'Prismatic Tapers Donated'};
} # foreach

# Donation calc 
my $totalv = $tradeTotalv + ($platTotalv * $platval) + $pyrealTotalv + ($prismTotalv * $prismaticval);

$_ = $#files + 1;

################################
# Print up Summary                                        #
################################

print <<EOF;

<table>
  <tr>
    <td>
<h2><font color="#996633">Summary</font></h2>
<b>Dates:</b> <font size="2">$logDates[$#logDates] through $logDates[0]</font><p>
<b>Value of Comps burned:</b> $componentTotalv<br>
<b>Value of Gifts received:</b> $totalv<br>
<b>Portals Summoned:</b> $nSummons
<p>
<b><i>Total operating
EOF

$_ = $totalv - $componentTotalv;

if ( $_ < 0) { # Deficit
	print"<font color=\"#CC0000\">expense</font>: ",$componentTotalv - $totalv," pyreals.</b></i>\n\n";
}
elsif ( $_ > 0) { # Profit
	print"<font color=\"#00CC00\">profit</font>: ",$_," pyreals.</b></i>\n\n";
}
else {
	print "expenses are equal to donations.</b></i>\n\n"
}

printf"<p><font size=\"1\">Statistics compiled at " . localtime() . "</font></p></td>";


################################
# Print up Component Usage                             #
################################

print "<td width=\"10\"></td><td><h2><font color=\"#996633\">Component Usage</font></h2>";

HTML_tableHead("Component Name", "Aggregate Value");

$i = 0;

foreach $key (sort keys (%comps)) {
	if ($i %2 == 0) {
		print "    <tr bgcolor=\"#FFFFCC\">";
		}
	else {
		print "    <tr bgcolor=\"#EAEAFF\">";
		}

	print "<td>" . $key . "</td><td>" .  $comps{$key} . "</td></tr>\n";

	$i++;
}

print <<EOF;
    <tr bgcolor="#CCCCCC">
      <td><b>Total Value</b></td>
      <td><b>$componentTotalv</b></td>
    </tr>
  </tbody>
</table>

  </tr>
</table>

EOF

################################
# Print up User Action Summary                        #
################################

print "<p><h2><font color=\"#996633\">User Action Summary</font></h2>";

HTML_tableHead("Requestor", "Spells Requested", "Amount Donated","Buff Costs","Balance", "Level 6<br>Upgrades", "Level 7<br>Upgrades", "Things");


$i = 0;
my $k = 0;
my $CompMarkup = 0;
for my $key (sort keys %users) {

	if ($i %2 == 0) {
	 	print "    <tr bgcolor=\"#FFFFCC\">";
	}
	 else {
		print "    <tr bgcolor=\"#EAEAFF\">";
	}

	$j = 0;
	for my $key2  ( sort keys %{ $users{$key}{'SpellsCastUpon'}} ) {
		 $j += $users{$key}{'SpellsCastUpon'}{$key2};
	}

	$k = $users{$key}{'TotalGifts'};
	
	 print "      <td nowrap><font size=\"2\">$key</font></td><td><font size=\"2\">" .  $j ."</font></td>\n";

	if ($k > 0) {
		print "      <td><font size=\"2\">" . $k ."</font></td>\n";
	}
	else	{
		print "      <td><font size=\"2\"><font color=\"#CC0000\">" . $k ."</font></font></td>\n";
	}

	$CompMarkup = int(($users{$key}{'UserCompValue'} * $markup));

	print "      <td><font size=\"2\">" . $CompMarkup . "</font></td>\n";

	if ($k - $CompMarkup >= 100000) {
		print "      <td><font size=\"2\"><font color=\"#00CC00\"><b>" . ($k - $CompMarkup) . "</b></font></font></td>\n";
	}
	elsif ($k - $CompMarkup >= 0)	{
		print "      <td><font size=\"2\"><font color=\"#00CC00\">" . ($k - $CompMarkup) . "</font></font></td>\n";
	}
	elsif ($k - $CompMarkup <= -100000)	{
		print "      <td><font size=\"2\"><font color=\"#CC0000\"><b>" . ($k - $CompMarkup) . "</b></font></font></td>\n";
	}
	else {
		print "      <td><font size=\"2\"><font color=\"#CC0000\">" . ($k - $CompMarkup) . "</font></font></td>\n";
	}

	print "      <td><font size=\"2\">" . $users{$key}{'Level6Upgrade'} . "</font></td>\n";
	print "      <td><font size=\"2\">" . $users{$key}{'Level7Upgrade'} . "</font></td>\n";

	# Print up stuff given and upgrades
	print "      <td><font size=\"1\">" . $users{$key}{'Other Donated'} . "</font></td></tr>\n";

	$i++;
} # for

print <<EOF;
  </tbody>
</table>


EOF


################################
# Print up Abusers                                           #
################################

print "<h2><font color=\"#996633\">Abusers</font></h2>";
print "<p><i>Users who have requested over $abuserThresh spell(s) but not donated any Trade Notes, Platinum Scarabs, Prismatic Tapers, or Pyreals.</i></p>";

HTML_tableHead("Character Name", "Monarch", "Buffs Received", "Balance", "Gifts");
my $AbuseMarkup = 0;
my $AbuseBalance = 0;
$i = 0;
foreach my $key ( sort keys %users) {

	$AbuseMarkup = 0;
	$AbuseBalance = 0;

	if ( $users{$key}{'TotalGifts'} == 0 ) {

		$count = 0;
		for  my $key2  ( sort keys %{ $users{$key}{'SpellsCastUpon'} } ) {
			$count += $users{$key}{'SpellsCastUpon'}{$key2};
	      }

		if ($count >= $abuserThresh) {
			if ($i %2 == 0) {
			      print "    <tr bgcolor=\"#FFFFCC\">\n";
		      }
		      else {
			      print "    <tr bgcolor=\"#EAEAFF\">\n";
		      }
		      $AbuseMarkup = int(($users{$key}{'UserCompValue'} * $markup));
		      $AbuseBalance = int(($users{$key}{'TotalGifts'} - $AbuseMarkup));

		      print "      <td>$key</td>\n";
		      print "      <td>$users{$key}{'Monarch'}</td>\n";
		      print "      <td>$count</td>\n";
		      if ($AbuseBalance >= 0) {
			      print "      <td><font size=\"2\"><font color=\"#00CC00\">" . $AbuseBalance . "</font></font></td>\n";
		      }
		      elsif ($AbuseBalance <= -100000)	{
			      print "      <td><font size=\"2\"><font color=\"#CC0000\"><b>" . $AbuseBalance . "</b></font></font></td>\n";
		      }
		      else {
			      print "      <td><font size=\"2\"><font color=\"#CC0000\">" . $AbuseBalance . "</font></font></td>\n";
		      }
		      print "      <td><font size=\"1\">" . $users{$key}{'Other Donated'} . "</font></td></tr>\n";
		      print "    </tr>";
		    $i++;
		} # if
	} # if
} # foreach

if ($i == 0) {
	print "      <td bgcolor=\"#FFFFCC\" colspan=\"2\"><font color=\"#00CC00\"><b>No big leeches yet.</b></font></td></tr>\n";
}

print <<EOF;
    </tr>
  </tbody>
</table>

<br>

EOF

#######################
# Print up allegiance use              #
#######################

	my $Allcost = 0;
	my $Allgifts = 0;
	my $AllTotal = 0;
	my $AllColor = 0;
	my $AllBalance = 0;
	my $HighUserName = "";
	my $HighUserCost = 0;
	my $HighGiverName = "";
	my $HighGiverAmount = 0;
	my $Allegiancekey = "";
	my $Allegiancetext = "";
	$CompMarkup = 0;
	$i = 0;


while (($Allegiancekey,$Allegiancetext) = each %AllegianceList) {

	$Allcost = 0;
	$Allgifts = 0;
	$AllTotal = 0;
	$AllColor = 0;
	$AllBalance = 0;
	$HighUserName = "";
	$HighUserCost = 0;
	$HighGiverName = "";
	$HighGiverAmount = 0;
	$CompMarkup = 0;
	$i = 0;
	$j = 0;

	print "<h2><font color=\"#996633\">$Allegiancekey</font></h2>";
	print "<p><i>Total gifts/debts for the $Allegiancetext of $Allegiancekey.</i></p>";

	HTML_tableHead("Character Name", "Costs", "Donations", "Balance", "Gifts");

	# $users{$name}{'Monarch'}
	foreach my $key (sort keys %users) {
		if ($users{$key}{'Monarch'} =~ /\w $Allegiancekey$/) {
			$CompMarkup = int(($users{$key}{'UserCompValue'} * $markup));
			$Allcost += $CompMarkup;
			$Allgifts += $users{$key}{'TotalGifts'};

			#Check for Highest User in comps
			if (($CompMarkup-$users{$key}{'TotalGifts'}) > $HighUserCost) {
				$HighUserName = $key;
				$HighUserCost = ($CompMarkup-$users{$key}{'TotalGifts'});
			}
			#Check for Highest giver
			if ($users{$key}{'TotalGifts'} > $HighGiverAmount) {
				$HighGiverName = $key;
				$HighGiverAmount = $users{$key}{'TotalGifts'};
			}
			
			if ($i %2 == 0) {
				print "    <tr bgcolor=\"#FFFFCC\">\n";
			}
			else {
			print "    <tr bgcolor=\"#EAEAFF\">\n";
			} # if
			print "      <td>$key</td>\n";
			print "      <td>$CompMarkup</td>\n";
			print "      <td>$users{$key}{'TotalGifts'}</td>\n";
			$AllBalance = int(($users{$key}{'TotalGifts'} - $CompMarkup));
			if ($AllBalance >= 100000) {
				print "      <td><font size=\"2\"><font color=\"#00CC00\"><b>" . $AllBalance . "</b></font></font></td>\n";
			}
			elsif ($AllBalance >= 0)	{
				print "      <td><font size=\"2\"><font color=\"#00CC00\">" . $AllBalance . "</font></font></td>\n";
			}
			elsif ($AllBalance <= -100000)	{
				print "      <td><font size=\"2\"><font color=\"#CC0000\"><b>" . $AllBalance . "</b></font></font></td>\n";
			}
			else {
				print "      <td><font size=\"2\"><font color=\"#CC0000\">" . $AllBalance . "</font></font></td>\n";
			}
			print "      <td><font size=\"1\">" . $users{$key}{'Other Donated'} . "</font></td></tr>\n";
			print "    </tr>";
			$i++;
		} # if
	}# foreach

	$AllTotal = $Allgifts - $Allcost;
	$AllColor = "00CC00";
	if ($AllTotal < 0) {
		$AllColor = "CC0000"
	} # if

	print "    <tr bgcolor=\"#CCCCCC\">\n";
	print "      <td><b>Totals</b></td>\n";
	print "      <td><b>$Allcost</b></td>\n";
	print "      <td><b>$Allgifts</b></td>\n";
	print "      <td colspan=\"2\"></td>\n";
	print "    </tr>";
	print "    <tr bgcolor=\"#CCCCCC\">\n";
	print "      <td><b>Balance:</b></td>\n";
	print "      <td colspan=\"4\"><font color=\"#$AllColor\"><b>$AllTotal</b></font></td>\n";
	print "    </tr>";

	print <<EOF;
	    </tr>
	  </tbody>
	</table>

	<br>

EOF
	print "<font color=\"#CC0000\">Highest Debt: $HighUserName - $HighUserCost pyreals</font><br>\n";
	print "<font color=\"#00CC00\">Highest Gifts: $HighGiverName - $HighGiverAmount pyreals</font><br>\n";

} # end while (($key,$value) = each %AllegianceList) 

#######################
# Print up patron use              #
#######################

	my $Valcost = 0;
	my $Valgifts = 0;
	my $ValTotal = 0;
	my $ValColor = 0;
	my $ValBalance = 0;
	my $PHighUserName = "";
	my $PHighUserCost = 0;
	my $PHighGiverName = "";
	my $PHighGiverAmount = 0;
	my $Patronkey = "";
	my $Patrontext = "";
	$CompMarkup = 0;
	$i = 0;


while (($Patronkey,$Patrontext) = each %PatronList) {

	$Valcost = 0;
	$Valgifts = 0;
	$ValTotal = 0;
	$ValColor = 0;
	$ValBalance = 0;
	$PHighUserName = "";
	$PHighUserCost = 0;
	$PHighGiverName = "";
	$PHighGiverAmount = 0;
	$CompMarkup = 0;
	$i = 0;
	$j = 0;

	print "<h2><font color=\"#996633\">$Patronkey</font></h2>";
	print "<p><i>Total gifts/debts for the $Patrontext of $Patronkey.</i></p>";

	HTML_tableHead("Character Name", "Costs", "Donations", "Balance", "Gifts");

	# $users{$name}{'Patron'}
	foreach my $key (sort keys %users) {
		if ($users{$key}{'Patron'} =~ /\w $Patronkey$/ || $key =~ /$Patronkey$/ ) {
			$CompMarkup = int(($users{$key}{'UserCompValue'} * $markup));
			$Valcost += $CompMarkup;
			$Valgifts += $users{$key}{'TotalGifts'};

			#Check for Highest User in comps
			if (($CompMarkup-$users{$key}{'TotalGifts'}) > $PHighUserCost) {
				$PHighUserName = $key;
				$PHighUserCost = ($CompMarkup-$users{$key}{'TotalGifts'});
			}
			#Check for Highest giver
			if ($users{$key}{'TotalGifts'} > $PHighGiverAmount) {
				$PHighGiverName = $key;
				$PHighGiverAmount = $users{$key}{'TotalGifts'};
			}
			
			if ($i %2 == 0) {
				print "    <tr bgcolor=\"#FFFFCC\">\n";
			}
			else {
			print "    <tr bgcolor=\"#EAEAFF\">\n";
			} # if
			print "      <td>$key</td>\n";
			print "      <td>$CompMarkup</td>\n";
			print "      <td>$users{$key}{'TotalGifts'}</td>\n";
			$ValBalance = int(($users{$key}{'TotalGifts'} - $CompMarkup));
			if ($ValBalance >= 100000) {
				print "      <td><font size=\"2\"><font color=\"#00CC00\"><b>" . $ValBalance . "</b></font></font></td>\n";
			}
			elsif ($ValBalance >= 0)	{
				print "      <td><font size=\"2\"><font color=\"#00CC00\">" . $ValBalance . "</font></font></td>\n";
			}
			elsif ($ValBalance <= -100000)	{
				print "      <td><font size=\"2\"><font color=\"#CC0000\"><b>" . $ValBalance . "</b></font></font></td>\n";
			}
			else {
				print "      <td><font size=\"2\"><font color=\"#CC0000\">" . $ValBalance . "</font></font></td>\n";
			}
			print "      <td><font size=\"1\">" . $users{$key}{'Other Donated'} . "</font></td></tr>\n";
			print "    </tr>";
			$i++;
		} # if
	}# foreach

	$ValTotal = $Valgifts - $Valcost;
	$ValColor = "00CC00";
	if ($ValTotal < 0) {
		$ValColor = "CC0000"
	} # if

	print "    <tr bgcolor=\"#CCCCCC\">\n";
	print "      <td><b>Totals</b></td>\n";
	print "      <td><b>$Valcost</b></td>\n";
	print "      <td><b>$Valgifts</b></td>\n";
	print "      <td colspan=\"2\"></td>\n";
	print "    </tr>";
	print "    <tr bgcolor=\"#CCCCCC\">\n";
	print "      <td><b>Balance:</b></td>\n";
	print "      <td colspan=\"4\"><font color=\"#$ValColor\"><b>$ValTotal</b></font></td>\n";
	print "    </tr>";

	print <<EOF;
	    </tr>
	  </tbody>
	</table>

	<br>

EOF
	print "<font color=\"#CC0000\">Highest Debt: $PHighUserName - $PHighUserCost pyreals</font><br>\n";
	print "<font color=\"#00CC00\">Highest Gifts: $PHighGiverName - $PHighGiverAmount pyreals</font><br>\n";

} # end while (($key,$value) = each %PatronList) 

print <<EOF;
</body>
</html>
EOF
