/////////////////////////////////////////////////////////////////////////////
// Name:        cube.h
// Purpose:     wxGLCanvas demo program
// Author:      Julian Smart
// Modified by:
// Created:     04/01/98
// RCS-ID:      $Id: cube.h,v 1.7 2005/03/27 18:08:08 VZ Exp $
// Copyright:   (c) Julian Smart
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

#ifndef _WX_CUBE_H_
#define _WX_CUBE_H_

#include "wx/glcanvas.h"
#include "3dsloader.h"
#include "math3d.h"
// C++ STL Headers
#include <iostream>
#include <queue>
#include <set>
using namespace std;
#include <tnt.h>
#include <jama_qr.h>
using namespace TNT;
using namespace JAMA;
#include "mesh.h"



extern "C"
{
#include "trackball.h"
}

// Define a new application type
class MyApp: public wxApp
{
public:
    bool OnInit();
};

// Define a new frame type
class TestGLCanvas;

class MyFrame: public wxFrame
{
public:
    static MyFrame *Create(MyFrame *parentFrame, bool isCloneWindow = false);

    void OnExit(wxCommandEvent& event);
    void OnNewWindow(wxCommandEvent& event);
    void OnDefRotateLeftKey(wxCommandEvent& event);
    void OnDefRotateRightKey(wxCommandEvent& event);

private:

    MyFrame(wxWindow *parent, const wxString& title, const wxPoint& pos,
            const wxSize& size, long style = wxDEFAULT_FRAME_STYLE);


    TestGLCanvas *m_canvas;

    DECLARE_EVENT_TABLE()
};

#if wxUSE_GLCANVAS

class TestGLCanvas: public wxGLCanvas
{
    friend class MyFrame;
public:
    TestGLCanvas( wxWindow *parent, wxWindowID id = wxID_ANY,
        const wxPoint& pos = wxDefaultPosition,
        const wxSize& size = wxDefaultSize,
        long style = 0, const wxString& name = _T("TestGLCanvas") );

    TestGLCanvas( wxWindow *parent, const TestGLCanvas *other,
        wxWindowID id = wxID_ANY, const wxPoint& pos = wxDefaultPosition,
        const wxSize& size = wxDefaultSize, long style = 0,
        const wxString& name = _T("TestGLCanvas") );

    ~TestGLCanvas();

    // EVENTS:
    void OnPaint(wxPaintEvent& event);
    void OnSize(wxSizeEvent& event);
    void OnEraseBackground(wxEraseEvent& event);
    void OnKeyDown(wxKeyEvent& event);
    void OnKeyUp(wxKeyEvent& event);
    void OnEnterWindow(wxMouseEvent& event);
    
    // mouse events:
    void OnMouseEvent(wxMouseEvent& event);
    void OnMouseMotion(wxMouseEvent& event);
    void OnMouseLeftDown(wxMouseEvent& event);
    void OnMouseRightDown(wxMouseEvent& event);
    void OnMouseLeftUp(wxMouseEvent& event);
    void OnMouseRightUp(wxMouseEvent& event);
    void OnMouseMiddleDown(wxMouseEvent& event);

    void Render();
    void InitGL();
    void Rotate(GLfloat deg);
    static GLfloat CalcRotateSpeed(unsigned long acceltime);
    static GLfloat CalcRotateAngle( unsigned long lasttime,
        unsigned long acceltime );
    void Action( long code, unsigned long lasttime,
        unsigned long acceltime );

    void set_id_A(int v);
    void set_frame_A(int v, int a);
    void set_frame_A(int v);
    void clear_frame_A(int v, int a);
    void set_B(int v, int a, Vector3D *vT, Vector3D *vB, Vector3D *vN);
    void transform_add_B(int v, int a, 
	    Vector3D *vT, Vector3D *vB, Vector3D *vN);
    void getNewFrame(int v,Vector3D *vT,Vector3D *vB,Vector3D *vN);

private:
    bool   m_init;
    GLuint m_gllist;
    long   m_rleft;
    long   m_rright;

    static unsigned long  m_secbase;
    static int            m_TimeInitialized;
    static unsigned long  m_xsynct;
    static unsigned long  m_gsynct;

    long           m_Key;
    unsigned long  m_StartTime;
    unsigned long  m_LastTime;
    unsigned long  m_LastRedraw;

    // for quaternion rotation
    int m_prevX, m_prevY;
    float m_q[4];           // quaternion for rotating the model
    float m_qTrans[4];      // quaternion for rotating handle frames
    Mesh m_model;
    float m_zDist;
    float m_xDist;
    float m_yDist;

    int m_polygon_mode;     // wirefram or solid
    int m_show_vert;	    // chosen vertex to show
    int m_choose_state;	    // choosing bound, handle, or just vertices
    int m_show_local_frames;// true if local frames (original) are showed
    int m_draw_modified;    // true if to display the modified vertices
    int m_show_mod_frames;  // true if to show the modified frames
    int m_show_mod_set;	    // true to show all verts in mod_set
    int m_bv1,m_bv2;	    // two vertices defining a path for a bound
    list<ushort> path;	    // path between two vertices
    set<ushort> bound_set;  // set of vertices defining a boundary on model
    set<ushort> handle_set; // set of vertices defining a handle
    set<ushort> mod_set;    // set of modifiable vertices (not bound or handle)

    /*
    int m_choosing_bound;   // true if bound is being chosen now
    int m_bv[2];	// vertices choose bound
    int m_bvinit[2];	// if each vertex has been picked
    int m_bound_init;	// if at least 1 vertex chosen on the boundary
    int m_tris[MAX_POLYGONS];
    int m_tris_num;
    int m_vbound[MAX_VERTICES];
    int m_vbound_num;
    Vector3D m_T, m_B, m_N;
    set<int> bound_set;	    // set of bound vertices that dont change
    int m_showPath;	// true if to show the triangle path
    int m_showFrames;
    int m_choosing_conn;    // set of vertices in component that changes
    set<int> conn_comp_set;

    int m_m2i[MAX_VERTICES];    // map matrix index to vertex index
    int m_i2m[MAX_VERTICES];    // map from vertex to matrix index
    int m_matM;
    int m_matN;
    Array2D<float> *A;
    Array1D<float> *B;
    QR<float> *qr;
    int m_matI[MAX_VERTICES];	// which row each vertex starts at in A
    int m_choosing_handle;
    set<int> handle_set;
    float trans_m[4][4];
    Array1D<float> X;
    int m_show_mod_frames;

    Array2D<float> *Ac;
    Array1D<float> *Bc;
    Array1D<float> Xc;
    QR<float> *qrc;
    int m_got_coords;
    */


    wxWindow *pwin;

DECLARE_EVENT_TABLE()
};

#endif // #if wxUSE_GLCANVAS

#endif // #ifndef _WX_CUBE_H_

