

#ifndef __MY_MATH3D_H_
#define __MY_MATH3D_H_


#include <math.h>

#define PI		3.141592653589793
#define PIover2		1.5707963267948965
#define PItimes2	6.283185307179586

#define SQRT2		1.41421356237
#define SQRT3		1.73205080757

// given as unions for easier access within loops
// or to pass as a array into opengl functions

// 3D vector or point
typedef union {
    struct {
	float x, y, z;
    };
    float a[3];
} Vector3D;


// 4D vector or quaternion (used for rotations)
typedef union {
    struct {
	float w;
	union {
	    Vector3D v;
	    struct {
		float x,y,z;
	    };
	};
    };
    float a[4];
} Quaternion, Vector4D;






// math macros
//dot product of 2 vectors:
#define DOT(v,u) ((v).x*(u).x+(v).y*(u).y+(v).z*(u).z)			    
#define VEC_MAG2(v) DOT(v,v)
#define VEC_MAG(v) ((float)sqrt(VEC_MAG2(v)))
// magnetude of a quaternion
#define MAG_QUAT(q) ((float)sqrt((q).w*(q).w + DOT((q).v,(q).v)))	

// cross product (also by components if needed)
#define CROSSX(v,u) ((v).y*(u).z-(v).z*(u).y)
#define CROSSY(v,u) ((v).z*(u).x-(v).x*(u).z)
#define CROSSZ(v,u) ((v).x*(u).y-(v).y*(u).x)
#define CROSS(v,u,res) {(res).x=CROSSX(v,u);(res).y=CROSSY(v,u);(res).z=CROSSZ(v,u);}

// scales same vector by a scalar
#define VEC_SCALE(v,s) {(v).x*=s; (v).y*=s; (v).z*=s;}    
// inverse scale by s
#define VEC_ISCALE(v,s) {(v).x/=s; (v).y/=s; (v).z/=s;}    

// vector,scalar operations
#define VEC_MULT_SCALAR(v,f,res) {(res).x=(v).x*f;(res).y=(v).y*f;(res).z=(v).z*f;}
#define VEC_DIV_SCALAR(v,f,res) {res.x = v.x/f; res.y = v.y/f; res.z = v.z/f;}
#define VEC_ADD_SCALAR(v,f,res) {res.x = v.x+f; res.y = v.y+f; res.z = v.z+f;}

// vector +/- vector
#define VEC_ADD_VEC(v1,v2,res) {(res).x = (v1).x+(v2).x; (res).y = (v1).y+(v2).y; (res).z = (v1).z+(v2).z;}
#define VEC_SUB_VEC(v1,v2,res) {(res).x = (v1).x-(v2).x; (res).y = (v1).y-(v2).y; (res).z = (v1).z-(v2).z;}

// normalize a vector (m is variable to store the magnitude):
#define VEC_NORM(v,m) {m=VEC_MAG(v); VEC_ISCALE(v,m);}

#define VEC_COPY(dest,from) {(dest).x=(from).x;(dest).y=(from).y;(dest).z=(from).z;}

#define MAX(x,y) ((x) > (y) ? (x) : (y))
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#define ABS(x) ((x) < 0 ? -(x) : (x))
#define SIGN(x) ((x) < 0 ? -1 : 1)


// 3D vectors
void vecCross(Vector3D *v1, Vector3D *v2, Vector3D *res);

// matrices
void multMatVec(float *m, Vector3D *v, Vector3D *res);
void vecLinComb(Vector3D *c1,Vector3D *c2,Vector3D *c3,
		    Vector3D *a, Vector3D *res);


// quaternion functions 
void quatMatrix(Quaternion *q, float *m);
void quatMult(Quaternion *p, Quaternion *q, Quaternion *r);


// rotations 
void rotMatrix(float theta, Vector3D *v, float *m);
void lookMatrix(float xPos, float yPos, float zPos,
	Vector3D *norm, Vector3D *up, float *m);


// help debugging functions
void printMatrix(float *m);
void printVector3D(const Vector3D &v);


#endif
