
#include "math3d.h"
#include <math.h>
#include <stdio.h>


///////// 3D Vector Functions ////////////////
void vecCross(Vector3D *v1, Vector3D *v2, Vector3D *res)
{
    res->x = CROSSX((*v1),(*v2));
    res->y = CROSSY((*v1),(*v2));
    res->z = CROSSZ((*v1),(*v2));
}
//////////////////////////////////////////////



////////// MATRIX ///////////////////////////

// mult 4x4 matrix by 3x1 vector on the left
// m is matrix in column-major order (like OpenGL)
// (components of columns are adjacent in memory
// and columns are sequensial)
void multMatVec(float *m, Vector3D *v, Vector3D *res)
{
    Vector3D tv;
    VEC_MULT_SCALAR((*(Vector3D*)&m[0]),v->x,*res);
    VEC_MULT_SCALAR((*(Vector3D*)&m[4]),v->y,tv);
    VEC_ADD_VEC(*res,tv,*res);
    VEC_MULT_SCALAR((*(Vector3D*)&m[8]),v->z,tv);
    VEC_ADD_VEC(*res,tv,*res);
}

// take linear combinations of vectors (c1,c2,c3) using
// vector a as coefficients. Same as multiplying matrix
// whose columns are (c1,c2,c3) by column vector a on the right
// result is returned in res
void vecLinComb(Vector3D *c1,Vector3D *c2,Vector3D *c3,
		    Vector3D *a, Vector3D *res)
{
    res->x = c1->x*a->x+c2->x*a->y+c3->x*a->z;
    res->y = c1->y*a->x+c2->y*a->y+c3->y*a->z;
    res->z = c1->z*a->x+c2->z*a->y+c3->z*a->z;
}



//////////////////////////////////////////////



void quatMult(Quaternion *p, Quaternion *q, Quaternion *r)
{
    r->w = p->w*q->w - p->x*q->x - p->y*q->y - p->z*q->z;
    r->x = p->w*q->x + q->w*p->x + CROSSX(p->v,q->v);
    r->y = p->w*q->y + q->w*p->y + CROSSY(p->v,q->v);
    r->z = p->w*q->z + q->w*p->z + CROSSZ(p->v,q->v);
}


/* quatMatrix: returns rotation matrix representing quaternion q
*/
void quatMatrix(Quaternion *q, float *m)
{
    float x2 = 2*q->a[1];
    float y2 = 2*q->a[2];
    float z2 = 2*q->a[3];
    float x22 = x2*q->a[1];
    float y22 = y2*q->a[2];
    float z22 = z2*q->a[3];
    float wx2 = x2*q->a[0];
    float wy2 = y2*q->a[0];
    float wz2 = z2*q->a[0];
    float xy2 = x2*q->a[2];
    float xz2 = x2*q->a[3];
    float yz2 = y2*q->a[3];

    m[0] = 1 - y22 - z22;
    m[1] = xy2 + wz2;
    m[2] = xz2 - wy2;
    m[3] = 0;

    m[4] = xy2 - wz2;
    m[5] = 1 - x22 - z22;
    m[6] = yz2 + wx2;
    m[7] = 0;

    m[8] = xz2 + wy2;
    m[9] = yz2 - wx2;
    m[10] = 1 - x22 - y22;
    m[11] = 0;

    /*
       float x2 = 2*q->x;
       m[0] = 2*q->y;
       m[5] = 2*q->z;

       m[4] = x2*q->y;
       m[8] = x2*q->z;
       m[9] = m[0]*q->z;

       m[1] = 

       m[12] = 0;
       m[13] = 0;
       m[14] = 0;
       m[15] = 1;
       */
}


/* rotMatrix: compute rotation matrix m for rotation theta radians counter
   clockwise around axis given by a UNIT vector v
   matrix is stored in column format like in OpenGL
   */
void rotMatrix(float theta, Vector3D *v, float *m)
{
    float c = cosf(theta);
    float s = sinf(theta);
    float c1 = 1 - c;
    float lc1 = v->x*c1;
    float mc1 = v->y*c1;
    float lm = lc1*v->y;
    float nl = lc1*v->z;
    float mn = mc1*v->z;
    float ls = v->x*s;
    float ms = v->y*s;
    float ns = v->z*s;


    m[0] = lc1*v->x+c;
    m[1] = lc1*v->y + ns;
    m[2] = lc1*v->z - ms;
    m[3] = 0;

    m[4] = mc1*v->x - ns;
    m[5] = mc1*v->y + c;
    m[6] = mc1*v->z + ls;
    m[7] = 0;

    m[8] = lc1*v->z + ms;
    m[9] = mc1*v->z - ls;
    m[10] = c1*v->z*v->z + c;
    m[11] = 0;

    m[12] = 0;
    m[13] = 0;
    m[14] = 0;
    m[15] = 1;
}


void lookMatrix(float xPos, float yPos, float zPos,
	Vector3D *norm, Vector3D *up, float *m)
{
    //Vector3D v, n, u;

    /*float f = VEC_MAG(norm);
      VEC_DIV_SCALAR(norm,f,n);
      f = DOT(up,n);
      v.x = up.x - f*n.x;
      v.y = up.y - f*n.y;
      v.z = up.z - f*n.z;
      f = VEC_MAG(v);
      VEC_DIV_SCALAR(v,f,v);
      vecCross(&n,&v,&u);*/

    Vector3D f = *norm;
    Vector3D upp = *up;
    Vector3D s, u;
    Vector3D F = {norm->x-xPos,norm->y-yPos,norm->z-zPos};
    F.y = -F.y;
    F.x = -F.x;

    float mag = VEC_MAG(F);
    VEC_DIV_SCALAR(F,mag,f);
    mag = VEC_MAG(upp);
    VEC_DIV_SCALAR(upp,mag,upp);
    vecCross(&f, &upp, &s);
    vecCross(&s, &f, &u);
    m[0] = s.x; m[1] = s.y; m[2] = s.z; m[3] = 0;
    m[4] = u.x; m[5] = u.y; m[6] = u.z; m[7] = 0;
    m[8] = -f.x; m[9] = -f.y; m[10] = -f.z; m[11] = 0;
    m[12] = 0; m[13] = 0; m[14] = 0; m[15] = 1;


    /*float f = VEC_MAG((*norm));
      VEC_DIV_SCALAR((*norm),f,n);
      f = VEC_MAG((*up));
      VEC_DIV_SCALAR((*up),f,v);
      vecCross(&n,&v,&u);
      vecCross(&u,&n,&v);*/

    /*float mag = DOT(norm,norm);		// get n*n
    //VEC_MULT_SCALAR(norm,1,n);		// get n=-n
    n = norm;
    float f = -DOT(up,n)/mag;		// get -up*n/n*n
    VEC_MULT_SCALAR(n,f,v);			// v = -n*f
    VEC_ADD_VEC(up,v,v);			// v = up + v

    mag = (float)sqrt(mag);
    VEC_DIV_SCALAR(n,mag,n);			// make n unit vector
    mag = VEC_MAG(v);
    VEC_DIV_SCALAR(v,mag,v);			// make v unit vector
    vecCross(&n,&v,&u);					// compute 3rd vector u
    */


    //mag = VEC_MAG(u);
    //VEC_DIV_SCALAR(u,mag,u);

    /*printVector3D(u);
      printVector3D(v);
      printVector3D(n);
      printf("\n");*/

    // now we have all the needed components to make matrix
    /*m[0] = u.x; m[1] = v.x; m[2] = -n.x; m[3] = 0;
      m[4] = u.y; m[5] = v.y; m[6] = -n.y; m[7] = 0;
      m[8] = u.z; m[9] = v.z; m[10] = -n.z; m[11] = 0;*/
    //m[12] = 0; m[13] = 0; m[14] = 0; m[15] = 1;
    //m[12] = -xPos; m[13] = -yPos; m[14] = -zPos; m[15] = 1;
    //printMatrix(m);
    //printf("\n");
    /*m[0] = u.x; m[1] = u.y; m[2] = u.z; m[3] = 0;
      m[4] = v.x; m[5] = v.y; m[6] = v.z; m[7] = 0;
      m[8] = -n.x; m[9] = -n.y; m[10] = -n.z; m[11] = 0;
      m[12] = 0; m[13] = 0; m[14] = 0; m[15] = 1;*/
}




void printMatrix(float *m)
{
    printf("[%f] [%f] [%f] [%f]\n", m[0], m[4], m[8], m[12]);
    printf("[%f] [%f] [%f] [%f]\n", m[1], m[5], m[9], m[13]);
    printf("[%f] [%f] [%f] [%f]\n", m[2], m[6], m[10], m[14]);
    printf("[%f] [%f] [%f] [%f]\n", m[3], m[7], m[11], m[15]);
}

void printVector3D(const Vector3D &v)
{
    printf("[[%f] [%f] [%f]]\n", v.x,v.y,v.z);
}
