/*
 * ---------------- www.spacesimulator.net --------------
 *   ---- Space simulators and 3d engine tutorials ----
 *
 *  Author: Damiano Vitulli <info@spacesimulator.net>
 *
 * ALL RIGHTS RESERVED
 *
 *
 * Tutorial 4: 3d engine - 3ds models loader
 * 
 * File header: 3dsloader.h
 *  
 */

/*
Linux port by Panteleakis Ioannis
mail: pioann@csd.auth.gr

just run: make and you are done.
of course you may need to change the makefile
*/

#ifndef _3DSLOADER_H_
#define _3DSLOADER_H_

#include "math3d.h"
#include "mesh.h"



//typedef ushort unsigned short;
#define INVALID_VERT ((ushort)-1)

// Our vertex type
typedef struct{
    union {
	struct {float x,y,z;};
	float vec[3];
    };
    //float x,y,z;
    int *ps;	// adjacent polygons
    int *vs;	// adjacent vertices
	// vs[i] is vertex shared by polygons ps[i] & ps[i+1]
    //int vnum;
    int pnum;	// lengh of ps
    float dist;	// for shortest path algos
    int index;

    // coefficients of local frames for each adjacent vertex
    Vector3D *cT,*cB,*cN;
    // local coordinates coefs
    Vector3D *q;
    
} vertex_type;

// The polygon (triangle), 3 numbers that aim 3 vertices
// modified to a union, so can remember which vertex by number
typedef union {
    struct {
	int a,b,c;
    };
    int v[3];
} polygon_type;


// The object type
/*
typedef struct {
    char name[20];
    
    int vertices_qty;
    int polygons_qty;

    //int *polbuf;
    // place holders for vertex-specifig info (ps and vs)
    //int polbuf[3*MAX_POLYGONS];
    //int vertbuf[3*MAX_POLYGONS];
    //Vector3D Tbuf[3*MAX_POLYGONS];
    //Vector3D Bbuf[3*MAX_POLYGONS];
    //Vector3D Nbuf[3*MAX_POLYGONS];
    //Vector3D qbuf[3*MAX_POLYGONS];

    //Vector3D tnormals[MAX_POLYGONS];

    // this is a local frame at each vertex
    //Vector3D vnormals[MAX_VERTICES];	// averaged normal at each vertex
    //Vector3D vT[MAX_VERTICES];
    //Vector3D vB[MAX_VERTICES];

    vertex_type vertex[MAX_VERTICES]; 
    polygon_type polygon[MAX_POLYGONS];
    mapcoord_type mapcoord[MAX_VERTICES];
    int id_texture;
} obj_type, *obj_type_ptr;
*/



/**********************************************************
 *
 * FUNCTION Load3DS (obj_type_ptr, char *)
 *
 * This function loads a mesh from a 3ds file.
 * Please note that we are loading only the vertices, polygons and mapping lists.
 * If you need to load meshes with advanced features as for example: 
 * multi objects, materials, lights and so on, you must insert other chunk parsers.
 *
 *********************************************************/

char Load3DS (Mesh *ogg, char *filename);


#endif
