//
// * This code is grabbed from sc_0.15 - Thanks to the author :) * 
//
// Minimal smartcard interface to phonix/smouse for real seca card
// 
#include <termios.h> 
#include <stdio.h> 
#include <unistd.h> 
#include <fcntl.h> 
#include <string.h> 
#include <stdlib.h> 
#include <sys/signal.h> 
#include <sys/types.h> 
#include <sys/ioctl.h> 
#include <sys/poll.h> 
#include <sys/stat.h> 
#include "smartcard.h"

//#define DEBUG  

// Attiva la define seguente per testare il funzionamento della smartmouse
// e per inviare comandi alla smartcard. Se tutto e' ok commentala di nuovo e
// applica la patch a softcam.c
//#define TEST 

// Attiva questa define sempre in fase di test per controllare le risposte 
// della tua card alle INS3C/3A
//#define TESTECM

char devicename[80]; 
static int i_fd=-1; 

//
// ins 
//
// UA
static unsigned char ins0e[]= {0xC1, 0x0e, 0x00, 0x00, 0x08}; 
// provider info
static unsigned char ins12[]= {0xC1, 0x12, 0x00, 0x00, 0x19}; 
// num provider, status pin
//static unsigned char ins16[]= {0xC1, 0x16, 0x00, 0x00, 0x06}; 
// decoding cw 
static unsigned char ins3a[]= {0xC1, 0x3a, 0x00, 0x00, 0x10}; 
// coding cw 
static unsigned char ins3c[]= {0xC1, 0x3c, 0x00, 0x00, 0x00}; 

// internal card data
static struct _secacard s_card;


int sio_init(int *i_fd, char *pc_dev) 
{ 
       struct termios newtio; 
       unsigned int modembits; 

       if ((*i_fd = open(pc_dev, O_RDWR | O_NOCTTY)) < 0) 
               return 1; 

       modembits = TIOCM_DTR; 
       if (ioctl(*i_fd, TIOCMBIS, &modembits) < 0) 
               return 1; 

       modembits = TIOCM_RTS; 
       if (ioctl(*i_fd, TIOCMBIC, &modembits) < 0) 
               return 1; 

       memset(&newtio, 0, sizeof(newtio)); 
       cfsetispeed(&newtio, B9600); 
       cfsetospeed(&newtio, B9600); 
       newtio.c_cflag &= (~PARODD); 
       newtio.c_cflag |= PARENB | CS8 | CSTOPB | CREAD | HUPCL | CLOCAL; 
       newtio.c_iflag &= ~(IGNPAR | PARMRK | INLCR | IGNCR | ICRNL | ISTRIP); 
       newtio.c_iflag |= INPCK | BRKINT; 
       newtio.c_oflag = 0; 
       newtio.c_lflag = 0; 
       newtio.c_cc[VMIN] = 1; 
       newtio.c_cc[VTIME] = 0; 

       if (tcsetattr(*i_fd, TCSANOW, &newtio) < 0) 
               return 1; 

       if (tcflush(*i_fd, TCIFLUSH) < 0) 
               return 1; 

       return 0; 
} 

int sio_read(int i_fd, int i_timeout, int i_size, unsigned char * pc_data, int *i_datalen) 
{ 
       unsigned char c; 
       int i_count; 
       struct pollfd pfd; 

       *i_datalen = 0;

       for (i_count = 0; i_count < i_size; i_count++) { 
               //  *i_datalen = i_count; 
               pfd.fd = i_fd; 
               pfd.events = POLLIN; 
               pfd.revents = 0x0000; 

               if (poll(&pfd, 1, i_timeout) != 1) { 
                       return 1; 
               } 

               if ((pfd.revents & POLLIN) == POLLIN) { 
                       if (read(i_fd, &c, 1) != 1) { 
                               return 2; 
                       } 
                       pc_data[i_count] = c; 
					   *i_datalen = i_count +1;
			   } else { 
                      return 3; 
               } 
       } 

       return 0; 
} 

int sio_write(int i_fd, int i_delay, int i_size, unsigned char * pc_data) 
{ 
       int i_count; 
       struct pollfd pfd; 

       tcflush(i_fd, TCIFLUSH); 

       for (i_count = 0; i_count < i_size; i_count++) { 

               if (i_delay > 0) 
                       usleep(((unsigned long)i_delay) * 1000); 

               pfd.fd = i_fd; 
               pfd.events = POLLOUT; 
               pfd.revents = 0x0000; 

               if (poll(&pfd, 1, 1000) != 1) { 
                       return 1; 
               } 

               if ((pfd.revents & POLLOUT) == POLLOUT) { 
                       if (write(i_fd, &pc_data[i_count], 1) != 1) { 
                               return 1; 
                       } 
               } else {
	              //tcflush (i_fd, TCIFLUSH); 
                       return 1; 
               } 
       } 

       return 0; 
} 

// ritorna puntatore alla struttura s_card
int sm_carddata ( void )
{
	return (int)&s_card;
};


int sm_iso_write(unsigned char *pc_ins, unsigned char *pc_data, unsigned char *pc_sb) 
{ 
       int i_len; 
       unsigned char pc_ack[MAX_LEN + 1]; 

       if (sio_write(i_fd, 0, INS_LEN, pc_ins)) 
               return 1; 
       if (sio_read(i_fd, INS_TO, INS_LEN + 1, pc_ack, &i_len)) 
               return 1; 
       /* XXX compare ack a ins */ 
       if (pc_ack[INS_LEN + 1] == INS_ACK(pc_ins)) 
               return 1; 

       if (sio_write(i_fd, 0, DATA_LEN(pc_ins), pc_data)) 
               return 1; 
       if (sio_read(i_fd, DATA_TO, DATA_LEN(pc_ins) + SB_LEN, pc_ack, &i_len)) 
               return 1; 
       /* XXX compare ack a ins */ 
       if (pc_ack[DATA_LEN(pc_ins)] != pc_sb[0] || 
               pc_ack[DATA_LEN(pc_ins) + 1] != pc_sb[1]) 
               return 1; 

       return 0; 
} 

int sm_iso_read(unsigned char *pc_ins, unsigned char *pc_data, unsigned char *pc_sb, int *dataread) 
{ 
       unsigned char pc_ack[MAX_LEN + 1]; 
       int datalen; 
       int res; 
      
#ifdef DEBUG
       fprintf(stderr,"**** Isoread\n"); 
#endif
       if (sio_write(i_fd, 0, INS_LEN, pc_ins)) 
               return 1; 

       res = sio_read(i_fd, INS_TO, INS_LEN+DATA_LEN(pc_ins)+SB_LEN+ACK_INS, pc_ack, &datalen); 

	   // guarda se la card risponde con un ACK
	   if (res) {
		
		   if (INS_ACK(pc_ack) == INS_CMD(pc_ins)) {
#ifdef DEBUG
              fprintf(stderr, "ACK: %X\n", INS_ACK(pc_ack)); 
#endif
              // spara il resto dei dati
              res = sio_write(i_fd, 0, DATA_LEN(pc_ins), &pc_ins[INS_LEN]);
              res = sio_read(i_fd, INS_TO, INS_LEN+DATA_LEN(pc_ins)+SB_LEN+ACK_INS, pc_ack, &datalen); 
		   }
       }
#ifdef DEBUG
       fprintf(stderr, "[ ---- Sio_read expected: %X returned: %X ---rv:%d--- ] \n", DATA_LEN(pc_ins)+SB_LEN+ACK_INS,datalen-INS_LEN, res); 

			for (i = 0; i < datalen; i++) 
                  fprintf(stderr,"%2.2X ",pc_ack[i] & 0xff); 
                fprintf(stderr,"\n"); 
#endif

       memcpy(pc_sb, &pc_ack[datalen-2], SB_LEN);  
       memcpy(pc_data, &pc_ack[DATA_POS], DATA_LEN(pc_ins)); 
       *dataread = DATA_LEN(pc_ins);
       return 0; 
} 

// trova posizione ident nella carta, ritorna ff se errore
int sm_findprovider(unsigned char id1, unsigned char id2) {

	int i;
	for (i = 0 ; i < 16 ; i++ ) {
		if (id1 == s_card.pr[i].ident[0] && id2 == s_card.pr[i].ident[1])
			return i;
	}
	return 0xff;
}

// visualizza tipo carta
void sm_cardtype(void) {

  fprintf(stderr,"Card Type: ");     

  if (s_card.atr[7] == 0x50 && s_card.atr[8] == 0x84)
     fprintf(stderr,"GENERIC v2");    

  if (s_card.atr[7] == 0x52 && s_card.atr[8] == 0x84)
     fprintf(stderr,"SIEMENS v3");    

  if (s_card.atr[7] == 0x53 && s_card.atr[8] == 0x84)
     fprintf(stderr,"PHILIPS v3");    

  if (s_card.atr[7] == 0x51 && s_card.atr[8] == 0x30)
     fprintf(stderr,"THOMPSON v3");    

  if (s_card.atr[7] == 0x54 && s_card.atr[8] == 0x30)
     fprintf(stderr,"THOMPSON v4");

  if (s_card.atr[7] == 0x57 && s_card.atr[8] == 0x60)
     fprintf(stderr,"THOMPSON v4");

  if (s_card.atr[7] == 0x58 && s_card.atr[8] == 0x42)
     fprintf(stderr,"SIEMENS v4");

  if (s_card.atr[7] == 0x60 && s_card.atr[8] == 0x60)
     fprintf(stderr,"SIEMENS v6");

  switch (s_card.atr[9]) {
  case 0x02:
     fprintf(stderr,"(2.0)");
	 break;
  case 0x03:
     fprintf(stderr,"(3.0)");
     break;
  case 0x13:
     fprintf(stderr,"(3.1)");
	 break;
  case 0x04:
     fprintf(stderr,"(4.0)");
	 break;
  case 0x14:
     fprintf(stderr,"(4.1)");
     break;
  case 0x06:
     fprintf(stderr,"(6.0)");
     break;
  default:
     fprintf(stderr,"(7.0)");
  }
  fprintf(stderr,"\n");
  return;
}


// invia l'ecm alla card
// 0 - ok
// 1 - error in iso_read
// 2 - status byte not 9000

int sm_ecm2card(unsigned char * buffer, unsigned char * data, int ecmlen, int provider,unsigned char * sb)
{
	int i, bytesread;
	unsigned char retbuf[1024];

	// provider ins3c
	ins3c[2] = provider;
	// key ins3c
	ins3c[3] = buffer[7];
	// len ins3c 
	ins3c[4] = (ecmlen - 0x08);

    // copia ins3c nel buffer
	for (i = 0;i < 5 ;i++ )	
		buffer[3+i] = ins3c[i];

	//lo invia alla card
    if (sm_iso_read(&buffer[3],retbuf,sb,&bytesread)) 
		return 1;

#ifdef TESTECM
	fprintf(stderr, "INS: "); 
    for (i = 0; i < ecmlen-3; i++) 
       fprintf(stderr,"%2.2X ",buffer[3+i] & 0xff); 
    fprintf(stderr,"\n"); 
    fprintf(stderr, "Status byte: %2.2X %2.2X \n",sb[0]&0xff,sb[1]&0xff); 
#endif

	// processa ins3a
	if (sb[0] == 0x90 && (sb[1] == 0x00 || 0x27)) {
		//lo invia alla card
		if (sm_iso_read(ins3a,retbuf,sb,&bytesread)) 
			return 1;
	}
	else
		return 2;

	// controlla status bytes ins 3a
	if (sb[0] == 0x90 && sb[1] == 0x00) 
		memcpy(data,retbuf,ins3a[4]);
	else
		return 2;

#ifdef TESTECM
	fprintf(stderr, "INS: "); 
    for (i = 0; i < INS_LEN; i++) 
       fprintf(stderr,"%2.2X ",ins3a[i] & 0xff); 
    fprintf(stderr,"\n"); 

	fprintf(stderr, "Card read:"); 
    for (i = 0; i < bytesread; i++) 
       fprintf(stderr,"%2.2X ",retbuf[i] & 0xff); 
    fprintf(stderr,"\n"); 

	fprintf(stderr, "Status byte: %2.2X %2.2X \n",sb[0]&0xff,sb[1]&0xff); 
#endif

	return 0;
}

// legge dai carta
int sm_readcardinfo(void)
{
	int bytesread,i;
	unsigned char sb[2],buffer[MAX_LEN];

	// ins0e - UA
	if (sm_iso_read(ins0e,buffer,sb,&bytesread))
		return 1; 
	memcpy(s_card.ua,buffer,UA_LEN);

#ifdef DEBUG
    fprintf(stderr,"bytes read: %d\n-------->UA: ",bytesread);
    for (i = 0; i < UA_LEN; i++) 
       fprintf(stderr,"%2.2X ",buffer[i] & 0xff); 
    fprintf(stderr,"\n"); 
#endif

	// ins12 - provider name, ppua,data,rc
	for (i = 0;i < 16 ;i++ ) {
		ins12[2] = i;
    	if (sm_iso_read(ins12,buffer,sb,&bytesread))
		return 2; 
        memcpy(s_card.pr[i].ident,buffer,IDENT_LEN);
		if (s_card.pr[i].ident[0] != 0xff){
		    memcpy(s_card.pr[i].name,&buffer[IDENT_LEN],NAME_LEN-1);
		    memcpy(s_card.pr[i].ppua,&buffer[IDENT_LEN+NAME_LEN],PPUA_LEN);
		    memcpy(s_card.pr[i].data,&buffer[IDENT_LEN+NAME_LEN+PPUA_LEN],DABB_LEN);
		    memcpy(s_card.pr[i].rc,&buffer[IDENT_LEN+NAME_LEN+PPUA_LEN+DABB_LEN],RC_LEN);
		}
		//else
		//	break;
	}

#ifdef DEBUG
    for (i = 0; i < 16; i++) 
       fprintf(stderr,"%2.2X%2.2X %16s %2.2X%2.2X%2.2X%2.2X\n",s_card.pr[i].ident[0],s_card.pr[i].ident[1],s_card.pr[i].name,s_card.pr[i].ppua[0],s_card.pr[i].ppua[1],s_card.pr[i].ppua[2],s_card.pr[i].ppua[3]); 
#endif

return 0;	
}


int sm_iso_open(char *pc_dev)
{ 
       int len; 

       if (sio_init(&i_fd, pc_dev)) 
               return 1; 

       if(sio_read(i_fd, ATR_TO, ATR_LEN, s_card.atr, &len)) 
               return 1; 

	   if(sm_readcardinfo())
          return 1;

	   return 0; 
}


#ifdef TEST
int main(int Parm_Count, char *Parms[]) 
{ 

  int res, i; 
  int bytesread;
  char buf[255];                       //buffer for where data is put 
  char testStr5[255];
  char sb[2];
  struct _secacard *seca;

  if (Parm_Count < 2){ 
     fprintf(stderr,"No serial device specified ... bailing out\n"); 
    exit(-2); 
  } 

  sscanf(Parms[1],"%s",devicename); 
  res = sm_iso_open(devicename);

  if (res > 0 ) { 
    perror("Couldn't open serial device: "); 
    exit (-1); 
  } 

  // copia dati smartcard;
  (int) seca = sm_carddata();

  fprintf(stderr,"-------->ATR: ");
  
  for (i = 0; i < ATR_LEN; i++) 
    fprintf(stderr,"%2.2X ",seca->atr[i] & 0xff); 
  fprintf(stderr,"\n"); 

  sm_cardtype();

  // res = sm_readcardinfo();

  fprintf(stderr,"-------->UA: ");
  for (i = 0; i < UA_LEN; i++) 
    fprintf(stderr,"%2.2X ",seca->ua[i] & 0xff); 
  fprintf(stderr,"\n"); 

	for (i = 0; i < 16; i++) 
       fprintf(stderr,"%2.2X%2.2X %16s %2.2X%2.2X%2.2X%2.2X\n",seca->pr[i].ident[0],seca->pr[i].ident[1],seca->pr[i].name,seca->pr[i].ppua[0],seca->pr[i].ppua[1],seca->pr[i].ppua[2],seca->pr[i].ppua[3]); 


#ifdef TESTECM
	{

	unsigned int pr_id;
    unsigned char cwdata[16];
    unsigned char sb[2];

	unsigned char ecm_0025[] = { 0x80,0x70,0x2f,0x00,0x25,0x00,0x00,0x0c,
						0x71,0x00,0x00,0x25,0x07,0xd2,0x00,0x0c,
						0x2d,0x11,0x7e,0x27,0x19,0x90,0x13,0x01, 
						0xd1,0x1f,0x6b,0xc1,0xfc,0x75,0xf3,0x97, 
						0x93,0x33,0x6b,0x2b,0x5a,0xcb,0x72,0xf2,
						0xb1,0x82,0x37,0x1f,0x35,0xe7,0x60,0xb9, 
						0x02,0x74 };


	unsigned char ecm_grigio[] = {  0x80,0x00,0x61,0x00,0x70,0x00,0x00,0xbc, 
									0x10,0x01,0x79,0xb5,0x53,0x9c,0x63,0x51, 
									0x0c,0x41,0x8f,0x9d,0x4c,0x71,0xac,0xd0,
									0xad,0x25,0x26,0x3d,0x6a,0x91,0x94,0xb8, 
									0x30,0x39,0xa2,0x98,0x6e,0x38,0x9a,0x30, 
									0x6c,0x44,0x5a,0x20,0x71,0xaf,0x9b,0xa5,
									0x6d,0x32,0x39,0xa0,0x69,0xc8,0x2e,0xe7, 
									0x7c,0x4f,0x20,0xea,0x39,0x6a,0x35,0x11, 
									0x64,0xb2,0x5e,0x51,0xc7,0xdc,0x6d,0xf9, 
									0xaf,0xf2,0x02,0x53,0xe3,0x22,0x84,0x17, 
									0xcf,0xe0,0xf6,0xaa,0x0d,0x03,0x42,0x33, 
									0x8e,0x1e,0x6c,0x93,0x02,0x1e,0x26,0xed, 
									0x28,0x36,0x46,0x1a };

	unsigned char ecm_eurosport[] = {	0x81,0x00,0x61,0x00,0x70,0x00,0x00,0xbc, 
										0x10,0x01,0x69,0x65,0x34,0xc6,0x35,0xde, 
										0x26,0xb5,0x7e,0x01,0x6b,0xf8,0xa4,0x8b, 
										0x29,0x6e,0xcb,0x64,0x89,0x27,0xc6,0x25, 
										0x30,0x65,0x23,0x2c,0xcb,0x89,0xf6,0x59, 
										0x5c,0xf4,0xc3,0x3b,0x57,0xff,0xc4,0x2b, 
										0x51,0x04,0x98,0x30,0x88,0x5a,0x74,0xfc, 
										0x13,0x4b,0x73,0xf3,0x80,0xc1,0xbd,0x23, 
										0xc1,0x2d,0x6a,0xbf,0xf7,0x09,0xfa,0x4c, 
										0x5b,0x92,0x19,0xf0,0x5c,0x84,0x24,0x1a, 
										0x62,0x7c,0x7b,0x8c,0x7f,0xe6,0xaa,0x4a, 
										0xb3,0xf1,0x97,0xe7,0x9b,0x0e,0xff,0x35, 
										0x46,0x66,0xf0,0x6f };

	fprintf(stderr,"ECM 0025\n"); 
    if ((pr_id = sm_findprovider(ecm_0025[3],ecm_0025[4])) != 0xff) {

		sm_ecm2card(ecm_0025,cwdata,sizeof(ecm_0025),pr_id,sb);
		fprintf(stderr,"Cw odd: "); 
	    for (i = 0; i < 8; i++) 
	      fprintf(stderr,"%2.2X ",cwdata[i]& 0xff); 
		fprintf(stderr,"\nCw even: "); 
	    for (i = 0; i < 8; i++) 
	      fprintf(stderr,"%2.2X ",cwdata[8+i]& 0xff); 
		fprintf(stderr,"\n"); 
	}
	else
		fprintf(stderr,"Provider %2.2X%2.2X non presente\n",ecm_0025[3],ecm_0025[4]); 

	fprintf(stderr,"ECM T+Grigio (0070)\n"); 
	if ((pr_id = sm_findprovider(ecm_grigio[3],ecm_grigio[4])) != 0xff) {

		sm_ecm2card(ecm_grigio,cwdata,sizeof(ecm_grigio),pr_id,sb);
		fprintf(stderr,"Cw odd: "); 
	    for (i = 0; i < 8; i++) 
	      fprintf(stderr,"%2.2X ",cwdata[i]& 0xff); 
		fprintf(stderr,"\nCw even: "); 
	    for (i = 0; i < 8; i++) 
	      fprintf(stderr,"%2.2X ",cwdata[8+i]& 0xff); 
		fprintf(stderr,"\n"); 
	}
	else
		fprintf(stderr,"Provider %2.2X%2.2X non presente\n",ecm_grigio[3],ecm_grigio[4]); 

	fprintf(stderr,"ECM Eurosport (0070)\n"); 
	if ((pr_id = sm_findprovider(ecm_eurosport[3],ecm_eurosport[4])) != 0xff) {

		sm_ecm2card(ecm_eurosport,cwdata,sizeof(ecm_eurosport),pr_id,sb);
		fprintf(stderr,"Cw odd: "); 
	    for (i = 0; i < 8; i++) 
	      fprintf(stderr,"%2.2X ",cwdata[i]& 0xff); 
		fprintf(stderr,"\nCw even: "); 
	    for (i = 0; i < 8; i++) 
	      fprintf(stderr,"%2.2X ",cwdata[8+i]& 0xff); 
		fprintf(stderr,"\n"); 
	}
	else
		fprintf(stderr,"Provider %2.2X%2.2X non presente\n",ecm_grigio[3],ecm_grigio[4]); 
	
	}

#endif

  while(1){ 

    char buff[1024]; 
    bzero(testStr5,5); 
    fgets(buff, 256, stdin); 
    //fprintf(stderr, "Read: %d\n",buff[0]); 
    if ((buff[0] == 10) || (buff[0] == 13)) { 
      fprintf(stderr, "Read: %d\n",buff[0]); 
      return(1); 
    } 
    sscanf(buff,"%X%X%X%X%X",(int *)&testStr5[0],(int *)&testStr5[1],(int *)&testStr5[2],(int *)&testStr5[3],(int *)&testStr5[4]); 
    fprintf(stderr, "<------- %2.2X %2.2X %2.2X %2.2X %2.2X\n",testStr5[0]&0xff,testStr5[1]&0xff,testStr5[2]&0xff,testStr5[3]&0xff,testStr5[4]&0xff); 
    res = sm_iso_read(testStr5,buf,sb,&bytesread); 

    fprintf(stderr, "Card read:"); 
    for (i = 0; i < bytesread; i++) 
       fprintf(stderr,"%2.2X ",buf[i] & 0xff); 
    fprintf(stderr,"\n"); 

	fprintf(stderr, "Status byte: %2.2X %2.2X \n",sb[0]&0xff,sb[1]&0xff); 

   
	if (res) 
      fprintf(stderr, "[ ---- Isoread returned: %d ------ ] \n", res); 
    usleep(4000); 
  } 
  return 1; 
  
}  //end of main 
#endif