/**
* @author Carlo Guglielmin
* @version 1.3
*
* Run.java
*  Standard void main class to perform initial functionality and begin
*  Note: See Scribe.java for License details...
*/

import javax.swing.*;
import javax.swing.plaf.metal.*;
import java.awt.*;

public class Run
{
	public static void main (String [] args)
	{
		// Set decorated title bars, etc.
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);

		// Create and set the custom theme
                MetalLookAndFeel.setCurrentTheme(new Overlay());

		try{
			// Set the default look and feel to Metal (to accept the custom theme)
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
		}catch (Exception all) {
			JOptionPane.showMessageDialog(null, "An error has occurred and Scribe must close.\n" +
					 	      "Please send a description of the problem so it can be fixed.\n",
						      "Error!", JOptionPane.ERROR_MESSAGE);
			System.exit(-1);
		} // End of try-catch

		// Get the current screen size and pass it to the Graphical object
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		double screenWidth = screenSize.getWidth();
		double screenHeight = screenSize.getHeight();

		// Create a new Graphical object and begin the GUI
		Scribe load = new Scribe();
		load.drawGUI((int)screenWidth, (int)screenHeight);
	} // End of void main
} // End of Run class
