/**
* A filter for displaying only supported image types and folders
*
*@author Carlo
*@version 1.0
*/

import java.io.File;
import javax.swing.*;
import javax.swing.filechooser.*;

public class ImageFilter extends FileFilter 
{
    // Accept all directories and all image files
    public boolean accept(File f)
    {
	// Accept directories
        if (f.isDirectory()) 
	{
            return (true);
        }

	// Break off the file extension
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');

        if (i > 0 &&  i < s.length() - 1) 
	{
            ext = s.substring(i+1).toLowerCase();
        }
	String extension = ext;       

	// A file extension is present
	
        if (extension != null)
	{
            // Supported: jpg, jpeg, gif, png
            // Unsupported: pcx, bmp, tga
            if (extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg") || extension.equalsIgnoreCase("gif") || extension.equalsIgnoreCase("png"))                
	    {
                    return (true);
            } // Correct extension
	    else 
	    {
                return (false);
            } // Incorrect extension
        } // Has a file extension

        return (false);
    } // End of accept method

    // The description of this filter
    public String getDescription() 
    {
        return ("Images [JPG JPEG GIF PNG]");
    } // End of getDescription method    
} // End of ImageFilter class
