/**
* A program to open and view various image files
*
*@author Carlo
*@version 1.1
*/

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.JOptionPane;
import javax.swing.filechooser.*;

public class ImageBrowser extends JPanel implements ActionListener
{
    final Double SWIDTH = new Double(Toolkit.getDefaultToolkit().getScreenSize().getWidth()),
                 SHEIGHT = new Double(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
    int iconWidth, iconHeight;
    ImageIcon currentImage;
    JButton viewButton, helpButton, quitButton;
    JFrame window;
    JFrame view;
    JFileChooser imageChooser;    
    JLabel wrapper;    
    JScrollPane scrollWrapper;

    /** Default constructor */
    public ImageBrowser()
    {
    } // End of default constructor

    /**
    * Create and set up the main GUI attributes
    *@param none
    *@return none
    */
    public void drawElements()
    {
        // Call various methods to set up the individual elements
        drawWindow();
        drawFileChooser();
        drawButtons();
        addElements();

        // Clean up and display
        Runtime.getRuntime().gc();
        window.setVisible(true);
    } // End of drawElements method

    /**
    * Method to set up the main GUI JFrame
    *@param none
    *@return none
    */
    public void drawWindow()
    {
        // Create and set up the window
        window = new JFrame("Image Browser");
        window.setBounds(0, 0, 225, 65);
        window.setLocationRelativeTo(null);
        window.setResizable(false);
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        // Set up the image viewer window
        view = new JFrame("");
        view.setBounds(0, 0, 100, 100);
	view.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
    } // End of drawWindow method

    /**
    * Method to set up the file chooser for images
    *@param none
    *@return none
    */
    public void drawFileChooser()
    {
        // Create a file chooser
        imageChooser = new JFileChooser();
        imageChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
	imageChooser.setDialogTitle("Select image file...");
	imageChooser.setDragEnabled(true);
	imageChooser.setFileHidingEnabled(false);
	imageChooser.setAcceptAllFileFilterUsed(false);
	imageChooser.setFileFilter(new ImageFilter());
	imageChooser.setMultiSelectionEnabled(false);
        imageChooser.setApproveButtonToolTipText("View the selected file");

        // Set up the image wrapper
	wrapper = new JLabel();
	wrapper.setCursor(new Cursor(Cursor.MOVE_CURSOR));
	
	// Set up the scroll pane
	scrollWrapper = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
					JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	scrollWrapper.setViewportBorder(null);
    } // End of drawFileChooser method

    /**
    * Method to create the buttons
    *@param none
    *@return none
    */
    public void drawButtons()
    {
    	// Call the generic button method
        viewButton = makeButton("View", KeyEvent.VK_V, "Open the file chooser dialog");
        helpButton = makeButton("Help", KeyEvent.VK_H, "Display the help popup");
        quitButton = makeButton("Quit", KeyEvent.VK_Q, "Quit the program");
    } // End of drawButtons method

    /**
    * Redundancy reducing method to create unified buttons
    *@param the button attributes
    *@return the finished button
    */
    public JButton makeButton(String text, int mnemonic, String tooltip)
    {
        // Create the new button and set default attributes
        JButton created = new JButton(text);
        created.addActionListener(this);
        created.setMnemonic(mnemonic);
        created.setToolTipText(tooltip);
        created.setCursor(new Cursor(Cursor.HAND_CURSOR));
        return(created);
    } // End of makeButton method

    /**
    * Set up the layout and add all elements
    *@param none
    *@return none
    */
    public void addElements()
    {
        // Create and set up the content pane and layout
	Container content = window.getContentPane();
        content.setLayout(new GridLayout(1, 3, 1, 1));
	content.add(viewButton);
        content.add(helpButton);
	content.add(quitButton);
    } // End of addElements method
    /**
    * Override method to handle all button clicks
    *@param the button click event
    *@return none
    */
    public void actionPerformed(ActionEvent e)
    {
    	Object source = e.getSource();

        if (source == viewButton)
	{
	    // Correct file selected and can now be used
            if (imageChooser.showDialog(ImageBrowser.this, "View") == JFileChooser.APPROVE_OPTION)
	    {
		// Get and place the selected image
                File file = imageChooser.getSelectedFile();
		currentImage = new ImageIcon(file.getAbsolutePath());
                wrapper.setIcon(currentImage);
                scrollWrapper.setViewportView(wrapper);

		// Reset the viewing window and display
		iconWidth = wrapper.getIcon().getIconWidth()+30;
		iconHeight = wrapper.getIcon().getIconHeight()+40;
		// Add scroll bars if the size is too large
		if (iconWidth > SWIDTH.intValue())
			iconWidth = SWIDTH.intValue();
		if (iconHeight > SHEIGHT.intValue())
			iconHeight = SHEIGHT.intValue();
                view.setSize(iconWidth, iconHeight);
                view.setTitle(file.getName() + " - Image Browser");
                view.getContentPane().removeAll();                
		view.getContentPane().add(scrollWrapper);
		view.setVisible(true);
            }
        } // End of viewButton click
	else if (source == quitButton)
	{
                if ((JOptionPane.showConfirmDialog(null, "Are you sure you want to quit Image Browser?", "Confirm Quit",
                     JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE)) == 0)
			System.exit(0);
	} // End of quitButton click
        else if (source == helpButton)
        {
                String help = "1. Click the " + viewButton.getText() + " button. A file choosing dialog will appear.\n" +
                              "2. Navigate to the image file you wish to view and double click on it.\n" +
                              "3. All images will be displayed in a seperate window, which can be closed as needed.\n" +
                              "4. When finished, click the " + quitButton.getText() + " button to leave Image Browser.\n\n" +
                              "Program created in 2004 by Carlo (written in Java).";

                JOptionPane.showMessageDialog(null, help, "Image Browser - Help", JOptionPane.QUESTION_MESSAGE);
        } // End of helpButton click
    } // End of actionPerformed override method
} // End of ImageBrowser class
