/*
 * mtrxsub.c
 *
 * Function to subtract a matrix from another
 * Part of the mtrxmath package
 *
 * Jeff Craig <luserjeff@linuxfreemail.com>
 *
 * 7-30-2000  Initial revision
 * 12-10-2000 Paul Sack's Contributions added
 */

#include "mtrxmath.h"

MATRIX_PTR matrix_sub (MATRIX_PTR first, MATRIX_PTR second)
{
  MATRIX_PTR solution;
  int x, y;

  if(first->rows != second->rows || first->columns != second->columns)
    {
      printf("Matrices must be the same size\n");
      return NULL;
    }

  solution = alloc_matrix(first->rows,first->columns);
  
  for(y=0;y < solution->columns;y++) {
    for(x=0;x < solution->rows;x++) {
      solution->matrix[x][y] = first->matrix[x][y]-second->matrix[x][y];
    }
  }

  return(solution);
}
