/*
 * mtrxmult - A function to Multiply Matrices
 * 
 * Jeff Craig 
 * <luserjeff@linuxfreemail.com>
 * 
 * Version 0.1 Coded on  5-2-2000
 * Version 0.5 Completed 7-29-2000
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mtrxmath.h"

/* 
 * Multiplies two matrices together
 */
MATRIX_PTR matrix_multiply( MATRIX_PTR first,  MATRIX_PTR second)
{
  MATRIX_PTR solution;
  int x, y, i;
  
  if (first->columns != second->rows) {
    printf("Number of Columns on first Matrix does not equal\nnumber of rows on Second Matrix.\n");
    return NULL;
  }
  x = y = i = 0;
  
  solution = alloc_matrix(first->rows, second->columns);
  
  for(y=0; y<solution->columns; y++)
    for(x=0; x<solution->rows; x++)
      for(i=0; i<first->columns; i++)         // which == second->rows
	solution->matrix[x][y] += first->matrix[x][i] * second->matrix[i][y];

  return(solution);
}

/*
 * Multiplies a matrix by a scalar value 
 */
void scalar_mult ( MATRIX_PTR matrix, float scalar )
{
  int row, col;

  for ( row=0 ; row < matrix->rows ; row++ ) {
    for ( col=0 ; col < matrix->columns ; col++ ) {
      matrix->matrix[row][col] *= scalar;
    }
  }
}

/*
 * Divides a matrix by another
 * This is really just multiplying by the inverse
 * which is why this function is located here
 */
MATRIX_PTR matrix_divide (MATRIX_PTR first, MATRIX_PTR second)
{
  MATRIX_PTR tmp, final;
  tmp = inverse(second);

  final = matrix_multiply(first, tmp);
  free_matrix(tmp);
  return(final);
}




