/*
 * mtrxmath.h
 *
 * Header file for Matrix Math Package
 *
 * Jeff Craig <luserjeff@linuxfreemail.com>
 *
 * 7-30-2000  Initial Revision (Jeff Craig)
 * 12-10-2000 Changed the MATRIX_TAG struct to be dynamic(Paul Sack)
 *	      Added the die() and alloc_matrix() prototypes (Paul Sack)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <unistd.h>
#include <getopt.h>

#define ADD         1
#define SUBTRACT    2
#define MULTIPLY    3
#define DETERMINANT 4
#define INVERT      5
#define DIVIDE      6
#define REDUCE      7

extern char *optarg; // PTR to option argument
extern int optind;   // argv[] index
extern int opterr;   // Controls error processing


typedef struct MATRIX_TAG
{
  float** matrix; 	 // The actual values of the Matrix
  unsigned int rows;     // Number of Rows in the Matrix
  unsigned int columns;  // Number of columns in the Matrix
} MATRIX, *MATRIX_PTR;

void show_matrix(MATRIX_PTR show);
MATRIX_PTR collect_matrix(FILE* file);
MATRIX_PTR alloc_matrix(unsigned int rows, unsigned int columns);
void free_matrix(MATRIX_PTR m);

void die(const char* msg);

MATRIX_PTR matrix_multiply (MATRIX_PTR first, MATRIX_PTR second);
MATRIX_PTR matrix_add      (MATRIX_PTR first, MATRIX_PTR second);
MATRIX_PTR matrix_sub      (MATRIX_PTR first, MATRIX_PTR second);
MATRIX_PTR reduce_matrix   (int columns, int rows, MATRIX_PTR matrix);
float      determinant     (MATRIX_PTR matrix);
MATRIX_PTR inverse         (MATRIX_PTR matrix);
int        power           (int base, int power);
void       scalar_mult     (MATRIX_PTR matrix, float scalar);
MATRIX_PTR matrix_divide   (MATRIX_PTR first, MATRIX_PTR second);
