/*
 * mtrxadd.c
 *
 * function to add two matrices together
 * Part of the mtrxmath package
 *
 * Jeff Craig <luserjeff@linuxfreemail.com>
 *
 * 7-30-2000  Initial revision
 */

#include "mtrxmath.h"

/* 
 * matrix_add
 * Adds two Matrices together
 * Returns a pointer to a Matrix
 */

MATRIX_PTR matrix_add (MATRIX_PTR first, MATRIX_PTR second)
{
  MATRIX_PTR solution;
  int x, y;

  /* Error checking, making sure that addition can be performed */
  if(first->rows != second->rows || first->columns != second->columns)
    {
      printf("Matrices must be the same size\n");
      return NULL;
    }

  solution = alloc_matrix(first->rows, first->columns);
  
  /* I think this particular code speaks for itself */
  for(y=0;y < solution->columns;y++) {
    for(x=0;x < solution->rows;x++) {
      solution->matrix[x][y] = first->matrix[x][y]+second->matrix[x][y];
    }
  }

  return(solution);
}



