#!/cygwin/bin/perl
#
# playlist-creator v1.0 Creates a M3U playlist from a dir of MP3's
# Copyright (C) 2005 Hagai Kariti
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General
# Public License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA 02111-1307, USA.

use strict;
use warnings;

my ($dir,$i);

sub go_through_dirs() {
	my ($curdir) = @_;
	my @dirs;
	opendir (DIR, $curdir) or warn "Couldn't open $curdir: $!\n", return 0;
	@dirs=readdir DIR;
	shift @dirs; shift @dirs;
	for my $file (@dirs) {
		if (-d "$curdir/$file") {&go_through_dirs("$curdir/$file");}
		elsif ($file =~ /\/?([^\/]+mp3)$/i) {
			print PL "#EXTINF:$i,$1\n$curdir/$file\n";
			$i++;
		}
		else {next;}
	}
}		
	
$dir=shift || '.';
$dir =~ s#\/+$##;
$i=0;

if ($dir =~ /^--?h(?:elp)?$/i) {
	my $VERSION='1.0';
	print "playlist-creator v$VERSION.\n".
	      "Copyright (C) 2005 Hagai Kariti.\n\n".
	      "Creates a M3U playlist from a dirs of MP3s.\n".
	      " Usage: $0 <dir>\n";
	exit;
}

open(PL, '>playlist.m3u') or die "open: $!\n";
print PL "#EXTM3U\n";

&go_through_dirs($dir);

close(PL) or die "close: $!\n";
