#!/cygwin/bin/perl
#
# html-playlist v1.1 Genetares an HTML page from a M3U file
# Copyright (C) 2005 Hagai Kariti
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General
# Public License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA 02111-1307, USA. 

use strict;
use warnings;
use MP3::Info;

my ($dir,$playlist,$title,$artist,$album,$hh,$mm,$ss,$totalmm,$totalss,$info,$class);
if (defined(@ARGV)) {
	if ($ARGV[0] =~ /^--?h(?:elp)?$/i) {
		my $VERSION='1.1';
		print "html playlist v$VERSION\n".
		      "Copyright (C) 2005 Hagai Kariti.\n\n".
		      "Generates an HTML page from a M3U playlist.\n".
	       	      " Usage: $0 <path>\n\n".
		      "<path> can be either a full path to a .m3u file, or a dir which containts the file playlist.m3u.\n";
		exit;
       }
       $ARGV[0] =~ /^(.+\/)(.+m3u)?$/i;
}

$dir=$1 || './';
$playlist=$2 || 'playlist.m3u';
$class='odd';

open (PL, $dir.$playlist) or die $dir.$playlist.": open: $!\n";
open (HTML, '>',$dir."playlist.html") or die $dir."playlist.html: open: $!\n";

print  HTML
'<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN">
<html>
 <head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <link rel="stylesheet" type="text/css" href="styles/common.css">
  <link rel="stylesheet" type="text/css" href="styles/default.css" title="Default">
  <link rel="alternate stylesheet" type="text/css" href="styles/terminal.css" title="Terminal">
  <link rel="alternate stylesheet" type="text/css" href="styles/default-notpositioned.css" title="Default - Times not positioned">
  <link rel="alternate stylesheet" type="text/css" href="styles/terminal-notpositioned.css" title="Terminal - Times not positioned">
  <title>'."Playlist - $playlist",$dir eq './' ? "" : " in ".substr($dir, 0, -1),'</title>
 </head>
 <body>
  <div id="headline">This page is best viewed with a standards compliant, modern browser (e.g. <a href="http://www.mozilla.org/firefoxa">Mozilla Firefox</a>)</div>
  <H1>File '.$playlist.':</H1>
  <form method="post" action="aaa.cgi">
  <ol>
';
$_=<PL>;
while (defined($_=<PL>) && chomp($_)) {
	if (/^#EXTINF:\d+,(.+)\.mp3$/i) {
		my @tags=split "-", $1;
		$title=$tags[$#tags];
		pop(@tags);
		$artist=join('-', @tags);
	}
	else {
		$info=get_mp3tag($_) or warn "$_: No TAGs available", next;
		$artist=$info->{ARTIST} || $artist ||  'Unknown artist';
		$title=$info->{TITLE} || $title || 'Unknown title';
		$album=$info->{ALBUM};
		s/"/\\"/g;
		$title =~ s/"/\\"/g;
		$artist =~ s/"/\\"/g;
		
		$info=get_mp3info($_);
		$mm=$info->{MM};
		$ss=$info->{SS};
		$totalmm+=$mm;
		$totalss+=$ss;
		$mm =~ s/^(\d)$/0$1/;
		$ss =~ s/^(\d)$/0$1/;
		print HTML "   <li class='$class'>\n".
			   "    <table><tr>\n".
			   "     <td><input type=\"checkbox\" name=\"Songs\" value=\"$title\">\n".
			   "     <td class='expand'><a href=\"$_\">$artist - $title" , 
			           defined($album) ? " (from album '$album')" : "" ,
				   "<span>[$mm:$ss]</span></a>\n".
			   "    </table>\n";
		$class=$class eq "odd" ? "even" : "odd";
	}
}

$ss=$totalss%60;
$mm=($totalss-$ss)/60;
$totalmm+=$mm;
$mm=$totalmm%60;
$hh=($totalmm-$mm)/60;


print HTML
'  </ol>
  <P><input type="submit" value="Play selected">
  </form>
  <DIV id="total">Total time: '."$hh:$mm:$ss".'</DIV>
  <p id="icons">
   <a href="http://validator.w3.org/check?uri=referer">
    <img src="styles/valid_html.jpg" alt="Valid HTML 4.01! Check for yourself!">
   </a>
   <a href="http://jigsaw.w3.org/css-validator/check/referer">
    <img src="styles/valid_css.jpg" alt="Valid CSS! Check for yourself!">
   </a>
  </p>
 </body>
</html>';

close (PL);
close (HTML);
