VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSystem"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'Private copies of the properties
Private mOS As String
Private mVersion As String
Private mCSD As String
Private mBuild As String
Private mWindowsPath As String
Private mWindowsSystemPath As String
Private mComputerName As String
Private mUserName As String

'API declarations
Private Declare Function GetWindowsDirectory _
        Lib "kernel32" Alias "GetWindowsDirectoryA" _
        (ByVal lpBuffer As String, _
        ByVal nSize As Long) As Long
Private Declare Function GetSystemDirectory _
        Lib "kernel32" Alias "GetSystemDirectoryA" _
        (ByVal lpBuffer As String, _
        ByVal nSize As Long) As Long
Private Declare Function GetVersionEx _
        Lib "kernel32" Alias "GetVersionExA" _
        (lpVersionInformation _
        As OSVERSIONINFO) As Long
Private Declare Function GetComputerName _
        Lib "kernel32" Alias "GetComputerNameA" _
        (ByVal lpBuffer As String, _
        nSize As Long) As Long
Private Declare Function GetUserName _
        Lib "advapi32.dll" Alias "GetUserNameA" _
        (ByVal lpBuffer As String, _
        nSize As Long) As Long
Private Declare Function ExitWindowsEx _
        Lib "user32" _
        (ByVal uFlags As Long, _
        ByVal dwReserved As Long) As Long
Private Declare Function GetCurrentProcess _
        Lib "kernel32" () As Long
Private Declare Function OpenProcessToken _
        Lib "advapi32" _
        (ByVal ProcessHandle As Long, _
        ByVal DesiredAccess As Long, _
        TokenHandle As Long) As Long
Private Declare Function LookupPrivilegeValue _
        Lib "advapi32" Alias "LookupPrivilegeValueA" _
        (ByVal lpSystemName As String, _
        ByVal lpName As String, _
        lpLuid As LUID) As Long
Private Declare Function AdjustTokenPrivileges _
        Lib "advapi32" _
        (ByVal TokenHandle As Long, _
        ByVal DisableAllPrivileges As Long, _
        NewState As TOKEN_PRIVILEGES, _
        ByVal BufferLength As Long, _
        PreviousState As TOKEN_PRIVILEGES, _
        ReturnLength As Long) As Long

'Token constants
Private Const TOKEN_ADJUST_PRIVILEGES = &H20
Private Const TOKEN_QUERY = &H8
Private Const SE_PRIVILEGE_ENABLED = &H2

'Shutdown constants
Private Const EWX_LOGOFF = 0
Private Const EWX_SHUTDOWN = 1
Private Const EWX_REBOOT = 2
Private Const EWX_FORCE = 4

'Platform constants
Private Const VER_PLATFORM_WIN32_WINDOWS = 1
Private Const VER_PLATFORM_WIN32_NT = 2

'OS version data structure
Private Type OSVERSIONINFO
    dwOSVersionInfoSize As Long
    dwMajorVersion As Long
    dwMinorVersion As Long
    dwBuildNumber As Long
    dwPlatformId As Long
    szCSDVersion As String * 128
End Type

'Security structures
Private Type LUID
    LowPart As Long
    HighPart As Long
End Type

Private Type TOKEN_PRIVILEGES
    PrivilegeCount As Long
    mLuid As LUID
    Attributes As Long
End Type

Private Sub AllowTokenShutdown()
    Dim hProcessHandle As Long
    Dim hTokenHandle As Long
    Dim tmpLuid As LUID
    Dim tkp As TOKEN_PRIVILEGES
    Dim tkpNewButIgnored As TOKEN_PRIVILEGES
    Dim lBuffer As Long
    
    'Get the handle to the current process
    hProcessHandle = GetCurrentProcess()
    
    'Get the process token
    OpenProcessToken hProcessHandle, _
           (TOKEN_ADJUST_PRIVILEGES Or TOKEN_QUERY), _
           hTokenHandle
    
    'Get the LUID for shutdown privilege
    LookupPrivilegeValue "", "SeShutdownPrivilege", tmpLuid
    tkp.PrivilegeCount = 1
    'tkp.TheLuid = tmpLuid
    tkp.Attributes = SE_PRIVILEGE_ENABLED
    
    'Enable shutdown access for this token
    AdjustTokenPrivileges hTokenHandle, _
            False, _
            tkp, _
            Len(tkpNewButIgnored), _
            tkpNewButIgnored, _
            lBuffer
End Sub


Public Property Get Build() As String
    Build = mBuild
End Property


Private Sub GetNetworkInfo()
    Dim rc As Long
    Dim lpBuffer As String
    Dim nSize As Long
    
    'Create a buffer large ennough to hold
    'the computer name
    nSize = 255
    lpBuffer = Space$(nSize)
    
    'Call the API
    rc = GetComputerName(lpBuffer, nSize)
    
    If rc <> 0 Then
        'Return the computer name
        mComputerName = Left$(lpBuffer, _
                InStr(lpBuffer, Chr$(0)) - 1)
    Else
        mComputerName = ""
    End If
    
    'Fill the buffer with spaces
    lpBuffer = Space$(nSize)
    
    'Call the API
    rc = GetUserName(lpBuffer, nSize)
    If rc <> 0 Then
        'Return the user name
        mUserName = Left$(lpBuffer, _
                InStr(lpBuffer, Chr$(0)) - 1)
    Else
        mUserName = ""
    End If
End Sub

Public Sub Logoff()
    Dim rc As Long
        
    'Call the API
    rc = ExitWindowsEx(EWX_LOGOFF, 0&)
End Sub

Public Property Get OperatingSystem() As String
    OperatingSystem = mOS
End Property

Public Sub Reboot()
    Dim rc As Long
    
    'Give this process token access to shutdown
    AllowTokenShutdown
    
    'Call the API
    rc = ExitWindowsEx(EWX_REBOOT, 0&)
End Sub

Public Property Get ServicePack() As String
    ServicePack = mCSD
End Property

Public Sub Shutdown()
    Dim rc As Long
    
    'Give this process token access to shutdown
    AllowTokenShutdown
    
    'Call the API
    rc = ExitWindowsEx(EWX_SHUTDOWN, 0&)
End Sub

Public Property Get Version() As String
    Version = mVersion
End Property


Private Sub GetWindowsInfo()
    Dim rc As Long
    Dim lpBuffer As String
    Dim nSize As Long
    
    'Create a buffer large ennough to hold
    'the Windows directory
    nSize = 255
    lpBuffer = Space$(nSize)
    
    'Call the API
    rc = GetWindowsDirectory(lpBuffer, nSize)
    
    If rc <> 0 Then
        'Return the Windows directory
        mWindowsPath = Left$(lpBuffer, _
                InStr(lpBuffer, Chr$(0)) - 1)
    Else
        mWindowsPath = ""
    End If

    'Reset the buffer
    lpBuffer = Space$(nSize)
    
    'Call the API
    rc = GetSystemDirectory(lpBuffer, nSize)
    
    If rc <> 0 Then
        'Return the System directory
        mWindowsSystemPath = Left$(lpBuffer, _
                InStr(lpBuffer, Chr$(0)) - 1)
    Else
        mWindowsSystemPath = ""
    End If
End Sub

Public Property Get WindowsPath() As String
    WindowsPath = mWindowsPath
End Property

Public Property Get WindowsSystemPath() As String
    WindowsSystemPath = mWindowsSystemPath
End Property


Public Property Get ComputerName() As String
    ComputerName = mComputerName
End Property

Public Property Get UserName() As String
    UserName = mUserName
End Property

Private Sub Class_Initialize()
    Dim osvi As OSVERSIONINFO
    
    'Get Windows information
    osvi.dwOSVersionInfoSize = Len(osvi)
    If GetVersionEx(osvi) <> 0 Then
        If osvi.dwPlatformId = VER_PLATFORM_WIN32_WINDOWS Then
            mOS = "Windows 95"
        End If
           
        If osvi.dwPlatformId = VER_PLATFORM_WIN32_NT Then
            mOS = "Windows NT"
        End If
        
        mVersion = Trim$(CStr(osvi.dwMajorVersion)) & _
                "." & Trim$(CStr(osvi.dwMinorVersion))
        mBuild = Trim$(CStr(osvi.dwBuildNumber And &HFFFF&))
        mCSD = Trim$(CStr(osvi.szCSDVersion))
    Else
        mOS = ""
        mVersion = ""
        mBuild = ""
        mCSD = ""
    End If

    'Get Windows information
    GetWindowsInfo
    
    'Get the UserID and Computer Name
    GetNetworkInfo
End Sub


